/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.dtd.grammar;

import java.awt.Component;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.api.model.HintContext;
import org.netbeans.modules.xml.dtd.grammar.ContentModel;
import org.netbeans.modules.xml.spi.dom.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.util.enum.QueueEnumeration;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.Text;

public class DTDGrammar
implements GrammarQuery {
    private Map elementDecls;
    private Map attrDecls;
    private Map contentModels;
    private Map attrEnumerations;
    private Map defaultAttributeValues;
    private Set entities;
    private Set notations;

    DTDGrammar(Map elementDecls, Map contentModels, Map attrDecls, Map attrDefs, Map enums, Set entities, Set notations) {
        this.elementDecls = elementDecls;
        this.attrDecls = attrDecls;
        this.entities = entities;
        this.notations = notations;
        this.attrEnumerations = enums;
        this.contentModels = contentModels;
        this.defaultAttributeValues = attrDefs;
    }

    public Enumeration queryEntities(String prefix) {
        if (this.entities == null) {
            return EmptyEnumeration.EMPTY;
        }
        QueueEnumeration list = new QueueEnumeration();
        Iterator it = this.entities.iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            if (!next.startsWith(prefix)) continue;
            list.put((Object)new MyEntityReference(next));
        }
        if ("lt".startsWith(prefix)) {
            list.put((Object)new MyEntityReference("lt"));
        }
        if ("gt".startsWith(prefix)) {
            list.put((Object)new MyEntityReference("gt"));
        }
        if ("apos".startsWith(prefix)) {
            list.put((Object)new MyEntityReference("apos"));
        }
        if ("quot".startsWith(prefix)) {
            list.put((Object)new MyEntityReference("quot"));
        }
        if ("amp".startsWith(prefix)) {
            list.put((Object)new MyEntityReference("amp"));
        }
        return list;
    }

    public Enumeration queryAttributes(HintContext ctx) {
        if (this.attrDecls == null) {
            return EmptyEnumeration.EMPTY;
        }
        Element el = null;
        if (ctx.getNodeType() == 2) {
            el = ((Attr)((Object)ctx)).getOwnerElement();
        } else if (ctx.getNodeType() == 1) {
            el = (Element)((Object)ctx);
        }
        if (el == null) {
            return EmptyEnumeration.EMPTY;
        }
        NamedNodeMap existingAttributes = el.getAttributes();
        Set possibleAttributes = (Set)this.attrDecls.get(el.getTagName());
        if (possibleAttributes == null) {
            return EmptyEnumeration.EMPTY;
        }
        String prefix = ctx.getCurrentPrefix();
        QueueEnumeration list = new QueueEnumeration();
        Iterator it = possibleAttributes.iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            if (!next.startsWith(prefix) || existingAttributes.getNamedItem(next) != null) continue;
            list.put((Object)new MyAttr(next));
        }
        return list;
    }

    public Enumeration queryElements(HintContext ctx) {
        if (this.elementDecls == null) {
            return EmptyEnumeration.EMPTY;
        }
        Node node = ctx.getParentNode();
        TreeSet<String> elements = null;
        if (node instanceof Element) {
            Element el = (Element)node;
            if (el == null) {
                return EmptyEnumeration.EMPTY;
            }
            Object model = null;
            String prefs = System.getProperty("netbeans.xml.completion", "default");
            model = "fast".equals(prefs) ? null : ("default".equals(prefs) || "accurate".equals(prefs) ? this.contentModels.get(el.getTagName()) : null);
            if (model instanceof String) {
                model = ContentModel.parseContentModel((String)model);
                this.contentModels.put(el.getTagName(), model);
            }
            if (model instanceof ContentModel) {
                Enumeration en = ((ContentModel)model).whatCanFollow(new PreviousEnumeration(el, ctx));
                if (en == null) {
                    return EmptyEnumeration.EMPTY;
                }
                String prefix = ctx.getCurrentPrefix();
                elements = new TreeSet<String>();
                while (en.hasMoreElements()) {
                    String next = (String)en.nextElement();
                    if (!next.startsWith(prefix)) continue;
                    elements.add(next);
                }
            }
            if (elements == null) {
                elements = (TreeSet<String>)this.elementDecls.get(el.getTagName());
            }
        } else if (node instanceof Document) {
            elements = this.elementDecls.keySet();
        } else {
            return EmptyEnumeration.EMPTY;
        }
        if (elements == null) {
            return EmptyEnumeration.EMPTY;
        }
        String prefix = ctx.getCurrentPrefix();
        QueueEnumeration list = new QueueEnumeration();
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            if (!next.startsWith(prefix)) continue;
            list.put((Object)new MyElement(next));
        }
        return list;
    }

    public Enumeration queryNotations(String prefix) {
        if (this.notations == null) {
            return EmptyEnumeration.EMPTY;
        }
        QueueEnumeration list = new QueueEnumeration();
        Iterator it = this.notations.iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            if (!next.startsWith(prefix)) continue;
            list.put((Object)new MyNotation(next));
        }
        return list;
    }

    public Enumeration queryValues(HintContext ctx) {
        if (this.attrEnumerations.isEmpty()) {
            return EmptyEnumeration.EMPTY;
        }
        if (ctx.getNodeType() == 2) {
            String attributeName = ctx.getNodeName();
            Element element = ((Attr)((Object)ctx)).getOwnerElement();
            if (element == null) {
                return EmptyEnumeration.EMPTY;
            }
            String elementName = element.getNodeName();
            String key = elementName + " " + attributeName;
            List values = (List)this.attrEnumerations.get(key);
            if (values == null) {
                return EmptyEnumeration.EMPTY;
            }
            String prefix = ctx.getCurrentPrefix();
            QueueEnumeration en = new QueueEnumeration();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                String next = (String)it.next();
                if (!next.startsWith(prefix)) continue;
                en.put((Object)new MyText(next));
            }
            return en;
        }
        return EmptyEnumeration.EMPTY;
    }

    public GrammarResult queryDefault(HintContext ctx) {
        Node node = ctx;
        if (ctx.getNodeType() == 3 && (node = ctx.getParentNode()) == null) {
            return null;
        }
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            Element element = attr.getOwnerElement();
            if (element == null) {
                return null;
            }
            String elementName = element.getNodeName();
            String attributeName = attr.getNodeName();
            String key = elementName + " " + attributeName;
            String def = (String)this.defaultAttributeValues.get(key);
            if (def == null) {
                return null;
            }
            return new MyText(def);
        }
        return null;
    }

    public boolean isAllowed(Enumeration en) {
        return true;
    }

    public Component getCustomizer(HintContext ctx) {
        return null;
    }

    public boolean hasCustomizer(HintContext ctx) {
        return false;
    }

    public Node.Property[] getProperties(HintContext ctx) {
        return null;
    }

    public String toString() {
        return "DTD grammar";
    }

    private static class MyText
    extends AbstractResultNode
    implements Text {
        private String data;

        MyText(String data) {
            this.data = data;
        }

        public short getNodeType() {
            return 3;
        }

        public String getNodeValue() {
            return this.getData();
        }

        public String getData() throws DOMException {
            return this.data;
        }

        public int getLength() {
            return this.data == null ? -1 : this.data.length();
        }
    }

    private static class MyNotation
    extends AbstractResultNode
    implements Notation {
        private String name;

        MyNotation(String name) {
            this.name = name;
        }

        public short getNodeType() {
            return 12;
        }

        public String getNodeName() {
            return this.name;
        }
    }

    private static class MyAttr
    extends AbstractResultNode
    implements Attr {
        private String name;

        MyAttr(String name) {
            this.name = name;
        }

        public short getNodeType() {
            return 2;
        }

        public String getNodeName() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return null;
        }
    }

    private static class MyElement
    extends AbstractResultNode
    implements Element {
        private String name;

        MyElement(String name) {
            this.name = name;
        }

        public short getNodeType() {
            return 1;
        }

        public String getNodeName() {
            return this.name;
        }

        public String getTagName() {
            return this.name;
        }
    }

    private static class MyEntityReference
    extends AbstractResultNode
    implements EntityReference {
        private String name;

        MyEntityReference(String name) {
            this.name = name;
        }

        public short getNodeType() {
            return 5;
        }

        public String getNodeName() {
            return this.name;
        }
    }

    private static abstract class AbstractResultNode
    extends AbstractNode
    implements GrammarResult {
        private AbstractResultNode() {
        }

        public Icon getIcon(int kind) {
            return null;
        }

        public String getDescription() {
            return this.getNodeName() + " desc";
        }

        public String getText() {
            return this.getNodeName();
        }

        public String getDisplayName() {
            return this.getNodeName() + " disp";
        }
    }

    private static class PreviousEnumeration
    implements Enumeration {
        private final Node parent;
        private final Element lastElement;
        private Node next;
        private boolean eoeSeen = false;

        PreviousEnumeration(Node parent, Node pointer) {
            this.parent = parent;
            Node last = pointer.getPreviousSibling();
            while (last != null) {
                if (last.getNodeType() == 1) break;
                last = last.getPreviousSibling();
            }
            this.lastElement = (Element)last;
            if (last != null) {
                this.fetchNext(parent.getFirstChild());
            } else {
                this.next = null;
            }
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        public Object nextElement() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            try {
                String string = this.next.getNodeName();
                Object var3_2 = null;
                this.fetchNext(this.next.getNextSibling());
                return string;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.fetchNext(this.next.getNextSibling());
                throw throwable;
            }
        }

        /*
         * Unable to fully structure code
         */
        private void fetchNext(Node candidate) {
            block2: {
                this.next = candidate;
                if (!this.eoeSeen) ** GOTO lbl7
                this.next = null;
                break block2;
                while (this.next.getNodeType() != 1) {
                    this.next = this.next.getNextSibling();
lbl7:
                    // 2 sources

                    if (this.next != null) continue;
                }
                if (this.lastElement.equals(this.next)) {
                    this.eoeSeen = true;
                }
            }
        }
    }
}

