/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.adaptors;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.lib.ddl.adaptors.DatabaseMetaDataAdaptor;
import org.openide.util.NbBundle;

public class DefaultAdaptor
implements DatabaseMetaDataAdaptor,
Serializable {
    private transient Connection con;
    private transient DatabaseMetaData dmd;
    protected Map properties;
    private transient PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private static ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle");
    public static final int NOT_SET = 0;
    public static final String NOT_SET_STRING = "";
    public static final int YES = 1;
    public static final int NO = 2;
    public static final int NULLSORT_HIGH = 1;
    public static final int NULLSORT_LOW = 2;
    public static final int NULLSORT_START = 3;
    public static final int NULLSORT_END = 4;
    public static final int STORE_LOWERCASE = 1;
    public static final int STORE_UPPERCASE = 2;
    public static final int STORE_MIXEDCASE = 3;
    public static final String PROP_PROCEDURES_ARE_CALLABLE = "proceduresAreCallable";
    public static final String PROP_TABLES_ARE_SELECTABLE = "tablesAreSelectable";
    public static final String PROP_READONLY = "readOnly";
    public static final String PROP_LOCAL_FILES = "localFiles";
    public static final String PROP_FILE_PER_TABLE = "localFilePerTable";
    public static final String PROP_MIXEDCASE_IDENTIFIERS = "mixedCaseIdentifiers";
    public static final String PROP_MIXEDCASE_QUOTED_IDENTIFIERS = "mixedCaseQuotedIdentifiers";
    public static final String PROP_ALTER_ADD = "alterTableWithAddColumn";
    public static final String PROP_ALTER_DROP = "alterTableWithDropColumn";
    public static final String PROP_COLUMN_ALIASING = "columnAliasing";
    public static final String PROP_NULL_PLUS_NULL_IS_NULL = "nullPlusNonNullIsNull";
    public static final String PROP_CONVERT = "convert";
    public static final String PROP_TABLE_CORRELATION_NAMES = "tableCorrelationNames";
    public static final String PROP_DIFF_TABLE_CORRELATION_NAMES = "differentTableCorrelationNames";
    public static final String PROP_EXPRESSIONS_IN_ORDERBY = "expressionsInOrderBy";
    public static final String PROP_ORDER_BY_UNRELATED = "orderByUnrelated";
    public static final String PROP_GROUP_BY = "groupBy";
    public static final String PROP_UNRELATED_GROUP_BY = "groupByUnrelated";
    public static final String PROP_BEYOND_GROUP_BY = "groupByBeyondSelect";
    public static final String PROP_ESCAPE_LIKE = "likeEscapeClause";
    public static final String PROP_MULTIPLE_RS = "multipleResultSets";
    public static final String PROP_MULTIPLE_TRANSACTIONS = "multipleTransactions";
    public static final String PROP_NON_NULL_COLUMNSS = "nonNullableColumns";
    public static final String PROP_MINUMUM_SQL_GRAMMAR = "minimumSQLGrammar";
    public static final String PROP_CORE_SQL_GRAMMAR = "coreSQLGrammar";
    public static final String PROP_EXTENDED_SQL_GRAMMAR = "extendedSQLGrammar";
    public static final String PROP_ANSI_SQL_GRAMMAR = "ANSI92EntryLevelSQL";
    public static final String PROP_INTERMEDIATE_SQL_GRAMMAR = "ANSI92IntermediateSQL";
    public static final String PROP_FULL_SQL_GRAMMAR = "ANSI92FullSQL";
    public static final String PROP_INTEGRITY_ENHANCEMENT = "IntegrityEnhancementFacility";
    public static final String PROP_OUTER_JOINS = "outerJoins";
    public static final String PROP_FULL_OUTER_JOINS = "fullOuterJoins";
    public static final String PROP_LIMITED_OUTER_JOINS = "limitedOuterJoins";
    public static final String PROP_CATALOG_AT_START = "catalogAtStart";
    public static final String PROP_SCHEMAS_IN_DML = "schemasInDataManipulation";
    public static final String PROP_SCHEMAS_IN_PROCEDURE_CALL = "schemasInProcedureCalls";
    public static final String PROP_SCHEMAS_IN_TABLE_DEFINITION = "schemasInTableDefinitions";
    public static final String PROP_SCHEMAS_IN_INDEX = "schemasInIndexDefinitions";
    public static final String PROP_SCHEMAS_IN_PRIVILEGE_DEFINITION = "schemasInPrivilegeDefinitions";
    public static final String PROP_CATALOGS_IN_DML = "catalogsInDataManipulation";
    public static final String PROP_CATALOGS_IN_PROCEDURE_CALL = "catalogsInProcedureCalls";
    public static final String PROP_CATALOGS_IN_TABLE_DEFINITION = "catalogsInTableDefinitions";
    public static final String PROP_CATALOGS_IN_INDEX = "catalogsInIndexDefinitions";
    public static final String PROP_CATALOGS_IN_PRIVILEGE_DEFINITION = "catalogsInPrivilegeDefinitions";
    public static final String PROP_POSITIONED_DELETE = "positionedDelete";
    public static final String PROP_POSITIONED_UPDATE = "positionedUpdate";
    public static final String PROP_SELECT_FOR_UPDATE = "selectForUpdate";
    public static final String PROP_STORED_PROCEDURES = "storedProcedures";
    public static final String PROP_SUBQUERY_IN_COMPARSIONS = "subqueriesInComparisons";
    public static final String PROP_SUBQUERY_IN_EXISTS = "subqueriesInExists";
    public static final String PROP_SUBQUERY_IN_INS = "subqueriesInIns";
    public static final String PROP_SUBQUERY_IN_QUANTIFIEDS = "subqueriesInQuantifieds";
    public static final String PROP_CORRELATED_SUBQUERIES = "correlatedSubqueries";
    public static final String PROP_UNION = "union";
    public static final String PROP_UNION_ALL = "unionAll";
    public static final String PROP_OPEN_CURSORS_ACROSS_COMMIT = "openCursorsAcrossCommit";
    public static final String PROP_OPEN_CURSORS_ACROSS_ROLLBACK = "openCursorsAcrossRollback";
    public static final String PROP_OPEN_STATEMENTS_ACROSS_COMMIT = "openStatementsAcrossCommit";
    public static final String PROP_OPEN_STATEMENTS_ACROSS_ROLLBACK = "openStatementsAcrossRollback";
    public static final String PROP_ROWSIZE_INCLUDING_BLOBS = "maxRowSizeIncludeBlobs";
    public static final String PROP_TRANSACTIONS = "transactions";
    public static final String PROP_DDL_AND_DML_TRANSACTIONS = "dataDefinitionAndDataManipulationTransactions";
    public static final String PROP_DML_TRANSACTIONS_ONLY = "dataManipulationTransactionsOnly";
    public static final String PROP_DDL_CAUSES_COMMIT = "dataDefinitionCausesTransactionCommit";
    public static final String PROP_DDL_IGNORED_IN_TRANSACTIONS = "dataDefinitionIgnoredInTransactions";
    public static final String PROP_BATCH_UPDATES = "batchUpdates";
    public static final String PROP_NULL_SORT = "nullSort";
    public static final String PROP_IDENTIFIER_STORE = "identifierStore";
    public static final String PROP_QUOTED_IDENTS = "quotedIdentifierStore";
    public static final String PROP_MAX_BINARY_LITERAL_LENGTH = "maxBinaryLiteralLength";
    public static final String PROP_MAX_CHAR_LITERAL_LENGTH = "maxCharLiteralLength";
    public static final String PROP_MAX_COLUMN_NAME_LENGTH = "maxColumnNameLength";
    public static final String PROP_MAX_COLUMNS_IN_GROUPBY = "maxColumnsInGroupBy";
    public static final String PROP_MAX_COLUMNS_IN_INDEX = "maxColumnsInIndex";
    public static final String PROP_MAX_COLUMNS_IN_ORDERBY = "maxColumnsInOrderBy";
    public static final String PROP_MAX_COLUMNS_IN_SELECT = "maxColumnsInSelect";
    public static final String PROP_MAX_COLUMNS_IN_TABLE = "maxColumnsInTable";
    public static final String PROP_MAX_CONNECTIONS = "maxConnections";
    public static final String PROP_MAX_CURSORNAME_LENGTH = "maxCursorNameLength";
    public static final String PROP_MAX_INDEX_LENGTH = "maxIndexLength";
    public static final String PROP_MAX_SCHEMA_NAME = "maxSchemaNameLength";
    public static final String PROP_MAX_PROCEDURE_NAME = "maxProcedureNameLength";
    public static final String PROP_MAX_CATALOG_NAME = "maxCatalogNameLength";
    public static final String PROP_MAX_ROW_SIZE = "maxRowSize";
    public static final String PROP_MAX_STATEMENT_LENGTH = "maxStatementLength";
    public static final String PROP_MAX_STATEMENTS = "maxStatements";
    public static final String PROP_MAX_TABLENAME_LENGTH = "maxTableNameLength";
    public static final String PROP_MAX_TABLES_IN_SELECT = "maxTablesInSelect";
    public static final String PROP_MAX_USERNAME = "maxUserNameLength";
    public static final String PROP_DEFAULT_ISOLATION = "defaultTransactionIsolation";
    public static final String PROP_URL = "URL";
    public static final String PROP_USERNAME = "userName";
    public static final String PROP_PRODUCTNAME = "databaseProductName";
    public static final String PROP_PRODUCTVERSION = "databaseProductVersion";
    public static final String PROP_DRIVERNAME = "driverName";
    public static final String PROP_DRIVER_VERSION = "driverVersion";
    public static final String PROP_DRIVER_MAJOR_VERSION = "driverMajorVersion";
    public static final String PROP_DRIVER_MINOR_VERSION = "driverMinorVersion";
    public static final String PROP_IDENTIFIER_QUOTE = "identifierQuoteString";
    public static final String PROP_SQL_KEYWORDS = "SQLKeywords";
    public static final String PROP_NUMERIC_FUNCTIONS = "numericFunctions";
    public static final String PROP_STRING_FUNCTIONS = "stringFunctions";
    public static final String PROP_SYSTEM_FUNCTIONS = "systemFunctions";
    public static final String PROP_TIME_FUNCTIONS = "timeDateFunctions";
    public static final String PROP_STRING_ESCAPE = "searchStringEscape";
    public static final String PROP_EXTRA_CHARACTERS = "extraNameCharacters";
    public static final String PROP_SCHEMA_TERM = "schemaTerm";
    public static final String PROP_PROCEDURE_TERM = "procedureTerm";
    public static final String PROP_CATALOG_TERM = "catalogTerm";
    public static final String PROP_CATALOGS_SEPARATOR = "catalogSeparator";
    public static final String PROP_PROCEDURES_QUERY = "proceduresQuery";
    public static final String PROP_PROCEDURE_COLUMNS_QUERY = "procedureColumnsQuery";
    public static final String PROP_SCHEMAS_QUERY = "schemasQuery";
    public static final String PROP_CATALOGS_QUERY = "catalogsQuery";
    public static final String PROP_TABLES_QUERY = "tablesQuery";
    public static final String PROP_TABLE_TYPES_QUERY = "tableTypesQuery";
    public static final String PROP_COLUMNS_QUERY = "columnsQuery";
    public static final String PROP_COLUMNS_PRIVILEGES_QUERY = "columnPrivilegesQuery";
    public static final String PROP_TABLE_PRIVILEGES_QUERY = "tablePrivilegesQuery";
    public static final String PROP_BEST_ROW_IDENTIFIER = "bestRowIdentifierQuery";
    public static final String PROP_VERSION_COLUMNS = "versionColumnsQuery";
    public static final String PROP_PK_QUERY = "primaryKeysQuery";
    public static final String PROP_IK_QUERY = "importedKeysQuery";
    public static final String PROP_EK_QUERY = "exportedKeysQuery";
    public static final String PROP_CROSSREF_QUERY = "crossReferenceQuery";
    public static final String PROP_TYPE_INFO_QUERY = "typeInfoQuery";
    public static final String PROP_INDEX_INFO_QUERY = "indexInfoQuery";
    public static final String PROP_UDT_QUERY = "UDTsQuery";
    public static final String PROP_CAPITALIZE_USERNAME = "capitializeUsername";
    static final long serialVersionUID = 2490518619095829944L;

    public DefaultAdaptor() {
        this.properties = new HashMap();
    }

    public DefaultAdaptor(Connection conn) throws SQLException {
        this.properties = new HashMap();
        this.con = conn;
        this.dmd = this.con != null ? this.con.getMetaData() : null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public DatabaseMetaData getMetaData() {
        return this;
    }

    public Connection getConnection() throws SQLException {
        return this.con;
    }

    public void setConnection(Connection conn) throws SQLException {
        this.con = conn;
        this.dmd = this.con != null ? this.con.getMetaData() : null;
    }

    private int getBoolean(String key) {
        Boolean val = (Boolean)this.properties.get(key);
        if (val != null) {
            return val != false ? 1 : 2;
        }
        return 0;
    }

    private void setBoolean(String key, int value) {
        Boolean newValue;
        Boolean oldValue = (Boolean)this.properties.get(key);
        if (value != 0) {
            newValue = value == 1 ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(key, newValue);
        } else {
            newValue = null;
            this.properties.remove(key);
        }
        this.propertySupport.firePropertyChange(key, oldValue, newValue);
    }

    private int getInt(String key) {
        Integer val = (Integer)this.properties.get(key);
        if (val == null) {
            return 0;
        }
        return val;
    }

    private void setInt(String key, int value) {
        Integer newValue;
        Integer oldValue = (Integer)this.properties.get(key);
        if (value != 0) {
            newValue = new Integer(value);
            this.properties.put(key, newValue);
        } else {
            newValue = null;
            this.properties.remove(key);
        }
        this.propertySupport.firePropertyChange(key, oldValue, newValue);
    }

    private String getString(String key) {
        String val = (String)this.properties.get(key);
        if (val == null) {
            return NOT_SET_STRING;
        }
        return val;
    }

    private void setString(String key, String value) {
        String newValue;
        String oldValue = (String)this.properties.get(key);
        if (value.length() > 0) {
            newValue = value;
            this.properties.put(key, newValue);
        } else {
            newValue = null;
            this.properties.remove(key);
        }
        this.propertySupport.firePropertyChange(key, oldValue, newValue);
    }

    public boolean allProceduresAreCallable() throws SQLException {
        Boolean proceduresAreCallable = (Boolean)this.properties.get(PROP_PROCEDURES_ARE_CALLABLE);
        if (proceduresAreCallable == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            proceduresAreCallable = this.dmd.allProceduresAreCallable() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_PROCEDURES_ARE_CALLABLE, proceduresAreCallable);
        }
        return proceduresAreCallable;
    }

    public int getProceduresAreCallable() {
        return this.getBoolean(PROP_PROCEDURES_ARE_CALLABLE);
    }

    public void setProceduresAreCallable(int value) throws SQLException {
        this.setBoolean(PROP_PROCEDURES_ARE_CALLABLE, value);
    }

    public boolean allTablesAreSelectable() throws SQLException {
        Boolean tablesAreSelectable = (Boolean)this.properties.get(PROP_TABLES_ARE_SELECTABLE);
        if (tablesAreSelectable == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            tablesAreSelectable = this.dmd.allTablesAreSelectable() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_TABLES_ARE_SELECTABLE, tablesAreSelectable);
        }
        return tablesAreSelectable;
    }

    public int getTablesAreSelectable() {
        return this.getBoolean(PROP_TABLES_ARE_SELECTABLE);
    }

    public void setTablesAreSelectable(int value) {
        this.setBoolean(PROP_TABLES_ARE_SELECTABLE, value);
    }

    public String getURL() throws SQLException {
        String url = (String)this.properties.get(PROP_URL);
        if (url == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            url = this.dmd.getURL();
            this.properties.put(PROP_URL, url);
        }
        return url;
    }

    public void setURL(String value) {
        this.setString(PROP_URL, value);
    }

    public String getUserName() throws SQLException {
        String username = (String)this.properties.get(PROP_USERNAME);
        if (username == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            username = this.dmd.getUserName();
            this.properties.put(PROP_USERNAME, username);
        }
        return username;
    }

    public void setUserName(String value) {
        this.setString(PROP_USERNAME, value);
    }

    public boolean isReadOnly() throws SQLException {
        Boolean readonly = (Boolean)this.properties.get(PROP_READONLY);
        if (readonly == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            readonly = this.dmd.isReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_READONLY, readonly);
        }
        return readonly;
    }

    public int getreadOnly() {
        return this.getBoolean(PROP_READONLY);
    }

    public void setreadOnly(int flag) {
        this.setBoolean(PROP_READONLY, flag);
    }

    public int getNullSort() {
        return this.getInt(PROP_NULL_SORT);
    }

    public void setNullSort(int value) {
        this.setInt(PROP_NULL_SORT, value);
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        Integer nullSort = (Integer)this.properties.get(PROP_NULL_SORT);
        if (nullSort != null) {
            return nullSort == 1;
        }
        if (this.dmd != null) {
            return this.dmd.nullsAreSortedAtStart();
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean nullsAreSortedLow() throws SQLException {
        Integer nullSort = (Integer)this.properties.get(PROP_NULL_SORT);
        if (nullSort != null) {
            return nullSort == 2;
        }
        if (this.dmd != null) {
            return this.dmd.nullsAreSortedLow();
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        Integer nullSort = (Integer)this.properties.get(PROP_NULL_SORT);
        if (nullSort != null) {
            return nullSort == 3;
        }
        if (this.dmd != null) {
            return this.dmd.nullsAreSortedAtStart();
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        Integer nullSort = (Integer)this.properties.get(PROP_NULL_SORT);
        if (nullSort != null) {
            return nullSort == 4;
        }
        if (this.dmd != null) {
            return this.dmd.nullsAreSortedAtEnd();
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public String getDatabaseProductName() throws SQLException {
        String product = (String)this.properties.get(PROP_PRODUCTNAME);
        if (product == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            product = this.dmd.getDatabaseProductName().trim();
            this.properties.put(PROP_PRODUCTNAME, product);
        }
        return product;
    }

    public void setDatabaseProductName(String value) {
        this.setString(PROP_PRODUCTNAME, value);
    }

    public String getDatabaseProductVersion() throws SQLException {
        String version = (String)this.properties.get(PROP_PRODUCTVERSION);
        if (version == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            version = this.dmd.getDatabaseProductVersion();
            this.properties.put(PROP_PRODUCTVERSION, version);
        }
        return version;
    }

    public void setDatabaseProductVersion(String value) {
        this.setString(PROP_PRODUCTVERSION, value);
    }

    public String getDriverName() throws SQLException {
        String driverName = (String)this.properties.get(PROP_DRIVERNAME);
        if (driverName == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            driverName = this.dmd.getDriverName();
            this.properties.put(PROP_DRIVERNAME, driverName);
        }
        return driverName;
    }

    public void setDriverName(String value) {
        this.setString(PROP_DRIVERNAME, value);
    }

    public String getDriverVersion() throws SQLException {
        String driverVersion = (String)this.properties.get(PROP_DRIVER_VERSION);
        if (driverVersion == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            driverVersion = this.dmd.getDriverVersion();
            this.properties.put(PROP_DRIVER_VERSION, driverVersion);
        }
        return driverVersion;
    }

    public void setDriverVersion(String value) {
        this.setString(PROP_DRIVER_VERSION, value);
    }

    public int getDriverMajorVersion() {
        Integer driverMajorVersion = (Integer)this.properties.get(PROP_DRIVER_MAJOR_VERSION);
        if (driverMajorVersion == null) {
            driverMajorVersion = this.dmd != null ? new Integer(this.dmd.getDriverMajorVersion()) : new Integer(0);
            this.properties.put(PROP_DRIVER_MAJOR_VERSION, driverMajorVersion);
        }
        return driverMajorVersion;
    }

    public void setDriverMajorVersion(int value) {
        this.setInt(PROP_DRIVER_MAJOR_VERSION, value);
    }

    public int getDriverMinorVersion() {
        Integer driverMinorVersion = (Integer)this.properties.get(PROP_DRIVER_MINOR_VERSION);
        if (driverMinorVersion == null) {
            driverMinorVersion = this.dmd != null ? new Integer(this.dmd.getDriverMinorVersion()) : new Integer(0);
            this.properties.put(PROP_DRIVER_MINOR_VERSION, driverMinorVersion);
        }
        return driverMinorVersion;
    }

    public void setDriverMinorVersion(int value) {
        this.setInt(PROP_DRIVER_MINOR_VERSION, value);
    }

    public boolean usesLocalFiles() throws SQLException {
        Boolean localFiles = (Boolean)this.properties.get(PROP_LOCAL_FILES);
        if (localFiles == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            localFiles = this.dmd.usesLocalFiles() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_LOCAL_FILES, localFiles);
        }
        return localFiles;
    }

    public int getLocalFiles() {
        return this.getBoolean(PROP_LOCAL_FILES);
    }

    public void setLocalFiles(int value) {
        this.setBoolean(PROP_LOCAL_FILES, value);
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        Boolean filePerTable = (Boolean)this.properties.get(PROP_FILE_PER_TABLE);
        if (filePerTable == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            filePerTable = this.dmd.usesLocalFilePerTable() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_FILE_PER_TABLE, filePerTable);
        }
        return filePerTable;
    }

    public int getLocalFilePerTable() {
        return this.getBoolean(PROP_FILE_PER_TABLE);
    }

    public void setLocalFilePerTable(int value) {
        this.setBoolean(PROP_FILE_PER_TABLE, value);
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        Boolean mixedCaseIdentifiers = (Boolean)this.properties.get(PROP_MIXEDCASE_IDENTIFIERS);
        if (mixedCaseIdentifiers == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            mixedCaseIdentifiers = this.dmd.supportsMixedCaseIdentifiers() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_MIXEDCASE_IDENTIFIERS, mixedCaseIdentifiers);
        }
        return mixedCaseIdentifiers;
    }

    public int getMixedCaseIdentifiers() {
        return this.getBoolean(PROP_MIXEDCASE_IDENTIFIERS);
    }

    public void setMixedCaseIdentifiers(int value) {
        this.setBoolean(PROP_MIXEDCASE_IDENTIFIERS, value);
    }

    public int getIdentifierStore() {
        return this.getInt(PROP_IDENTIFIER_STORE);
    }

    public void setIdentifierStore(int value) {
        this.setInt(PROP_IDENTIFIER_STORE, value);
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        Integer identStore = (Integer)this.properties.get(PROP_IDENTIFIER_STORE);
        if (identStore != null) {
            return identStore == 2;
        }
        if (this.dmd != null) {
            return this.dmd.storesUpperCaseIdentifiers();
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        Integer identStore = (Integer)this.properties.get(PROP_IDENTIFIER_STORE);
        if (identStore != null) {
            return identStore == 1;
        }
        if (this.dmd != null) {
            return this.dmd.storesLowerCaseIdentifiers();
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        Integer identStore = (Integer)this.properties.get(PROP_IDENTIFIER_STORE);
        if (identStore != null) {
            return identStore == 3;
        }
        if (this.dmd != null) {
            return this.dmd.storesLowerCaseIdentifiers();
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        Boolean mixedCaseQuotedIdentifiers = (Boolean)this.properties.get(PROP_MIXEDCASE_QUOTED_IDENTIFIERS);
        if (mixedCaseQuotedIdentifiers == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            mixedCaseQuotedIdentifiers = this.dmd.supportsMixedCaseQuotedIdentifiers() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_MIXEDCASE_QUOTED_IDENTIFIERS, mixedCaseQuotedIdentifiers);
        }
        return mixedCaseQuotedIdentifiers;
    }

    public int getMixedCaseQuotedIdentifiers() {
        return this.getBoolean(PROP_MIXEDCASE_QUOTED_IDENTIFIERS);
    }

    public void setMixedCaseQuotedIdentifiers(int value) {
        this.setBoolean(PROP_MIXEDCASE_QUOTED_IDENTIFIERS, value);
    }

    public int getQuotedIdentifierStore() {
        return this.getInt(PROP_QUOTED_IDENTS);
    }

    public void setQuotedIdentifierStore(int value) {
        this.setInt(PROP_QUOTED_IDENTS, value);
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        Integer identQuotedStore = (Integer)this.properties.get(PROP_QUOTED_IDENTS);
        if (identQuotedStore != null) {
            return identQuotedStore == 2;
        }
        if (this.dmd != null) {
            return this.dmd.storesUpperCaseQuotedIdentifiers();
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        Integer identQuotedStore = (Integer)this.properties.get(PROP_QUOTED_IDENTS);
        if (identQuotedStore != null) {
            return identQuotedStore == 1;
        }
        if (this.dmd != null) {
            return this.dmd.storesLowerCaseQuotedIdentifiers();
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        Integer identQuotedStore = (Integer)this.properties.get(PROP_QUOTED_IDENTS);
        if (identQuotedStore != null) {
            return identQuotedStore == 3;
        }
        if (this.dmd != null) {
            return this.dmd.storesMixedCaseQuotedIdentifiers();
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public String getIdentifierQuoteString() throws SQLException {
        String identifierQuoteString = (String)this.properties.get(PROP_IDENTIFIER_QUOTE);
        if (identifierQuoteString == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            identifierQuoteString = this.dmd.getIdentifierQuoteString();
            this.properties.put(PROP_IDENTIFIER_QUOTE, identifierQuoteString);
        }
        return identifierQuoteString;
    }

    public void setIdentifierQuoteString(String value) {
        this.setString(PROP_IDENTIFIER_QUOTE, value);
    }

    public String getSQLKeywords() throws SQLException {
        String sqlKeywords = (String)this.properties.get(PROP_SQL_KEYWORDS);
        if (sqlKeywords == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            sqlKeywords = this.dmd.getSQLKeywords();
            this.properties.put(PROP_SQL_KEYWORDS, sqlKeywords);
        }
        return sqlKeywords;
    }

    public void setSQLKeywords(String value) {
        this.setString(PROP_SQL_KEYWORDS, value);
    }

    public String getNumericFunctions() throws SQLException {
        String numericFunctions = (String)this.properties.get(PROP_NUMERIC_FUNCTIONS);
        if (numericFunctions == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            numericFunctions = this.dmd.getNumericFunctions();
            this.properties.put(PROP_NUMERIC_FUNCTIONS, numericFunctions);
        }
        return numericFunctions;
    }

    public void setNumericFunctions(String value) {
        this.setString(PROP_NUMERIC_FUNCTIONS, value);
    }

    public String getStringFunctions() throws SQLException {
        String stringFunctions = (String)this.properties.get(PROP_STRING_FUNCTIONS);
        if (stringFunctions == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            stringFunctions = this.dmd.getStringFunctions();
            this.properties.put(PROP_STRING_FUNCTIONS, stringFunctions);
        }
        return stringFunctions;
    }

    public void setStringFunctions(String value) {
        this.setString(PROP_STRING_FUNCTIONS, value);
    }

    public String getSystemFunctions() throws SQLException {
        String systemFunctions = (String)this.properties.get(PROP_SYSTEM_FUNCTIONS);
        if (systemFunctions == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            systemFunctions = this.dmd.getSystemFunctions();
            this.properties.put(PROP_SYSTEM_FUNCTIONS, systemFunctions);
        }
        return systemFunctions;
    }

    public void setSystemFunctions(String value) {
        this.setString(PROP_SYSTEM_FUNCTIONS, value);
    }

    public String getTimeDateFunctions() throws SQLException {
        String timeFunctions = (String)this.properties.get(PROP_TIME_FUNCTIONS);
        if (timeFunctions == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            timeFunctions = this.dmd.getTimeDateFunctions();
            this.properties.put(PROP_TIME_FUNCTIONS, timeFunctions);
        }
        return timeFunctions;
    }

    public void setTimeDateFunctions(String value) {
        this.setString(PROP_TIME_FUNCTIONS, value);
    }

    public String getSearchStringEscape() throws SQLException {
        String stringEscape = (String)this.properties.get(PROP_STRING_ESCAPE);
        if (stringEscape == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            stringEscape = this.dmd.getSearchStringEscape();
            this.properties.put(PROP_STRING_ESCAPE, stringEscape);
        }
        return stringEscape;
    }

    public void setSearchStringEscape(String value) {
        this.setString(PROP_STRING_ESCAPE, value);
    }

    public String getExtraNameCharacters() throws SQLException {
        String extraCharacters = (String)this.properties.get(PROP_EXTRA_CHARACTERS);
        if (extraCharacters == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            extraCharacters = this.dmd.getExtraNameCharacters();
            this.properties.put(PROP_EXTRA_CHARACTERS, extraCharacters);
        }
        return extraCharacters;
    }

    public void setExtraNameCharacters(String value) {
        this.setString(PROP_EXTRA_CHARACTERS, value);
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        Boolean alterAdd = (Boolean)this.properties.get(PROP_ALTER_ADD);
        if (alterAdd == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            alterAdd = this.dmd.supportsAlterTableWithAddColumn() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_ALTER_ADD, alterAdd);
        }
        return alterAdd;
    }

    public int getAlterTableWithAddColumn() {
        return this.getBoolean(PROP_ALTER_ADD);
    }

    public void setAlterTableWithAddColumn(int value) {
        this.setBoolean(PROP_ALTER_ADD, value);
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        Boolean alterDrop = (Boolean)this.properties.get(PROP_ALTER_DROP);
        if (alterDrop == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            alterDrop = this.dmd.supportsAlterTableWithDropColumn() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_ALTER_DROP, alterDrop);
        }
        return alterDrop;
    }

    public int getAlterTableWithDropColumn() {
        return this.getBoolean(PROP_ALTER_DROP);
    }

    public void setAlterTableWithDropColumn(int value) {
        this.setBoolean(PROP_ALTER_DROP, value);
    }

    public boolean supportsColumnAliasing() throws SQLException {
        Boolean columnAliasing = (Boolean)this.properties.get(PROP_COLUMN_ALIASING);
        if (columnAliasing == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            columnAliasing = this.dmd.supportsColumnAliasing() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_COLUMN_ALIASING, columnAliasing);
        }
        return columnAliasing;
    }

    public int getColumnAliasing() {
        return this.getBoolean(PROP_COLUMN_ALIASING);
    }

    public void setColumnAliasing(int value) {
        this.setBoolean(PROP_COLUMN_ALIASING, value);
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        Boolean nullPlusNull = (Boolean)this.properties.get(PROP_NULL_PLUS_NULL_IS_NULL);
        if (nullPlusNull == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            nullPlusNull = this.dmd.nullPlusNonNullIsNull() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_NULL_PLUS_NULL_IS_NULL, nullPlusNull);
        }
        return nullPlusNull;
    }

    public int getNullPlusNonNullIsNull() {
        return this.getBoolean(PROP_NULL_PLUS_NULL_IS_NULL);
    }

    public void setNullPlusNonNullIsNull(int value) {
        this.setBoolean(PROP_NULL_PLUS_NULL_IS_NULL, value);
    }

    public boolean supportsConvert() throws SQLException {
        Boolean supportsConvert = (Boolean)this.properties.get(PROP_CONVERT);
        if (supportsConvert == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            supportsConvert = this.dmd.supportsConvert() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_CONVERT, supportsConvert);
        }
        return supportsConvert;
    }

    public int getConvert() {
        return this.getBoolean(PROP_CONVERT);
    }

    public void setConvert(int value) {
        this.setBoolean(PROP_CONVERT, value);
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.supportsConvert(fromType, toType);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        Boolean nameCorrelation = (Boolean)this.properties.get(PROP_TABLE_CORRELATION_NAMES);
        if (nameCorrelation == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            nameCorrelation = this.dmd.supportsTableCorrelationNames() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_TABLE_CORRELATION_NAMES, nameCorrelation);
        }
        return nameCorrelation;
    }

    public int getTableCorrelationNames() {
        return this.getBoolean(PROP_TABLE_CORRELATION_NAMES);
    }

    public void setTableCorrelationNames(int value) {
        this.setBoolean(PROP_TABLE_CORRELATION_NAMES, value);
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        Boolean tableCorrelation = (Boolean)this.properties.get(PROP_DIFF_TABLE_CORRELATION_NAMES);
        if (tableCorrelation == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            tableCorrelation = this.dmd.supportsDifferentTableCorrelationNames() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_DIFF_TABLE_CORRELATION_NAMES, tableCorrelation);
        }
        return tableCorrelation;
    }

    public int getDifferentTableCorrelationNames() {
        return this.getBoolean(PROP_DIFF_TABLE_CORRELATION_NAMES);
    }

    public void setDifferentTableCorrelationNames(int value) {
        this.setBoolean(PROP_DIFF_TABLE_CORRELATION_NAMES, value);
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        Boolean ordering = (Boolean)this.properties.get(PROP_EXPRESSIONS_IN_ORDERBY);
        if (ordering == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            ordering = this.dmd.supportsExpressionsInOrderBy() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_EXPRESSIONS_IN_ORDERBY, ordering);
        }
        return ordering;
    }

    public int getExpressionsInOrderBy() {
        return this.getBoolean(PROP_EXPRESSIONS_IN_ORDERBY);
    }

    public void setExpressionsInOrderBy(int value) {
        this.setBoolean(PROP_EXPRESSIONS_IN_ORDERBY, value);
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        Boolean unrelatedOrdering = (Boolean)this.properties.get(PROP_ORDER_BY_UNRELATED);
        if (unrelatedOrdering == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            unrelatedOrdering = this.dmd.supportsOrderByUnrelated() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_ORDER_BY_UNRELATED, unrelatedOrdering);
        }
        return unrelatedOrdering;
    }

    public int getOrderByUnrelated() {
        return this.getBoolean(PROP_ORDER_BY_UNRELATED);
    }

    public void setOrderByUnrelated(int value) {
        this.setBoolean(PROP_ORDER_BY_UNRELATED, value);
    }

    public boolean supportsGroupBy() throws SQLException {
        Boolean groupBy = (Boolean)this.properties.get(PROP_GROUP_BY);
        if (groupBy == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            groupBy = this.dmd.supportsGroupBy() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_GROUP_BY, groupBy);
        }
        return groupBy;
    }

    public int getGroupBy() {
        return this.getBoolean(PROP_GROUP_BY);
    }

    public void setGroupBy(int value) {
        this.setBoolean(PROP_GROUP_BY, value);
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        Boolean unrelatedGroupBy = (Boolean)this.properties.get(PROP_UNRELATED_GROUP_BY);
        if (unrelatedGroupBy == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            unrelatedGroupBy = this.dmd.supportsGroupByUnrelated() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_UNRELATED_GROUP_BY, unrelatedGroupBy);
        }
        return unrelatedGroupBy;
    }

    public int getGroupByUnrelated() {
        return this.getBoolean(PROP_UNRELATED_GROUP_BY);
    }

    public void setGroupByUnrelated(int value) {
        this.setBoolean(PROP_UNRELATED_GROUP_BY, value);
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        Boolean beyondGroupBy = (Boolean)this.properties.get(PROP_BEYOND_GROUP_BY);
        if (beyondGroupBy == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            beyondGroupBy = this.dmd.supportsGroupByBeyondSelect() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_BEYOND_GROUP_BY, beyondGroupBy);
        }
        return beyondGroupBy;
    }

    public int getGroupByBeyondSelect() {
        return this.getBoolean(PROP_BEYOND_GROUP_BY);
    }

    public void setGroupByBeyondSelect(int value) {
        this.setBoolean(PROP_BEYOND_GROUP_BY, value);
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        Boolean escapeLike = (Boolean)this.properties.get(PROP_ESCAPE_LIKE);
        if (escapeLike == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            escapeLike = this.dmd.supportsLikeEscapeClause() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_ESCAPE_LIKE, escapeLike);
        }
        return escapeLike;
    }

    public int getLikeEscapeClause() {
        return this.getBoolean(PROP_ESCAPE_LIKE);
    }

    public void setLikeEscapeClause(int value) {
        this.setBoolean(PROP_ESCAPE_LIKE, value);
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        Boolean multipleResultSets = (Boolean)this.properties.get(PROP_MULTIPLE_RS);
        if (multipleResultSets == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            multipleResultSets = this.dmd.supportsMultipleResultSets() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_MULTIPLE_RS, multipleResultSets);
        }
        return multipleResultSets;
    }

    public int getMultipleResultSets() {
        return this.getBoolean(PROP_MULTIPLE_RS);
    }

    public void setMultipleResultSets(int value) {
        this.setBoolean(PROP_MULTIPLE_RS, value);
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        Boolean multipleTransactions = (Boolean)this.properties.get(PROP_MULTIPLE_TRANSACTIONS);
        if (multipleTransactions == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            multipleTransactions = this.dmd.supportsMultipleTransactions() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_MULTIPLE_TRANSACTIONS, multipleTransactions);
        }
        return multipleTransactions;
    }

    public int getMultipleTransactions() {
        return this.getBoolean(PROP_MULTIPLE_TRANSACTIONS);
    }

    public void setMultipleTransactions(int value) {
        this.setBoolean(PROP_MULTIPLE_TRANSACTIONS, value);
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        Boolean nunNullableColumns = (Boolean)this.properties.get(PROP_NON_NULL_COLUMNSS);
        if (nunNullableColumns == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            nunNullableColumns = this.dmd.supportsNonNullableColumns() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_NON_NULL_COLUMNSS, nunNullableColumns);
        }
        return nunNullableColumns;
    }

    public int getNonNullableColumns() {
        return this.getBoolean(PROP_NON_NULL_COLUMNSS);
    }

    public void setNonNullableColumns(int value) {
        this.setBoolean(PROP_NON_NULL_COLUMNSS, value);
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        Boolean minimumSQLGrammar = (Boolean)this.properties.get(PROP_MINUMUM_SQL_GRAMMAR);
        if (minimumSQLGrammar == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            minimumSQLGrammar = this.dmd.supportsMinimumSQLGrammar() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_MINUMUM_SQL_GRAMMAR, minimumSQLGrammar);
        }
        return minimumSQLGrammar;
    }

    public int getMinimumSQLGrammar() {
        return this.getBoolean(PROP_MINUMUM_SQL_GRAMMAR);
    }

    public void setMinimumSQLGrammar(int value) {
        this.setBoolean(PROP_MINUMUM_SQL_GRAMMAR, value);
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        Boolean coreSQLGrammar = (Boolean)this.properties.get(PROP_CORE_SQL_GRAMMAR);
        if (coreSQLGrammar == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            coreSQLGrammar = this.dmd.supportsCoreSQLGrammar() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_CORE_SQL_GRAMMAR, coreSQLGrammar);
        }
        return coreSQLGrammar;
    }

    public int getCoreSQLGrammar() {
        return this.getBoolean(PROP_CORE_SQL_GRAMMAR);
    }

    public void setCoreSQLGrammar(int value) {
        this.setBoolean(PROP_CORE_SQL_GRAMMAR, value);
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        Boolean extendedSQLGrammar = (Boolean)this.properties.get(PROP_EXTENDED_SQL_GRAMMAR);
        if (extendedSQLGrammar == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            extendedSQLGrammar = this.dmd.supportsExtendedSQLGrammar() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_EXTENDED_SQL_GRAMMAR, extendedSQLGrammar);
        }
        return extendedSQLGrammar;
    }

    public int getExtendedSQLGrammar() {
        return this.getBoolean(PROP_EXTENDED_SQL_GRAMMAR);
    }

    public void setExtendedSQLGrammar(int value) {
        this.setBoolean(PROP_EXTENDED_SQL_GRAMMAR, value);
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        Boolean ansiSQLGrammar = (Boolean)this.properties.get(PROP_ANSI_SQL_GRAMMAR);
        if (ansiSQLGrammar == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            ansiSQLGrammar = this.dmd.supportsANSI92EntryLevelSQL() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_ANSI_SQL_GRAMMAR, ansiSQLGrammar);
        }
        return ansiSQLGrammar;
    }

    public int getANSI92EntryLevelSQL() {
        return this.getBoolean(PROP_ANSI_SQL_GRAMMAR);
    }

    public void setANSI92EntryLevelSQL(int value) {
        this.setBoolean(PROP_ANSI_SQL_GRAMMAR, value);
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        Boolean ansiInterSQLGrammar = (Boolean)this.properties.get(PROP_INTERMEDIATE_SQL_GRAMMAR);
        if (ansiInterSQLGrammar == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            ansiInterSQLGrammar = this.dmd.supportsANSI92IntermediateSQL() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_INTERMEDIATE_SQL_GRAMMAR, ansiInterSQLGrammar);
        }
        return ansiInterSQLGrammar;
    }

    public int getANSI92IntermediateSQL() {
        return this.getBoolean(PROP_INTERMEDIATE_SQL_GRAMMAR);
    }

    public void setANSI92IntermediateSQL(int value) {
        this.setBoolean(PROP_INTERMEDIATE_SQL_GRAMMAR, value);
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        Boolean ansiFullSQLGrammar = (Boolean)this.properties.get(PROP_FULL_SQL_GRAMMAR);
        if (ansiFullSQLGrammar == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            ansiFullSQLGrammar = this.dmd.supportsANSI92FullSQL() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_FULL_SQL_GRAMMAR, ansiFullSQLGrammar);
        }
        return ansiFullSQLGrammar;
    }

    public int getANSI92FullSQL() {
        return this.getBoolean(PROP_FULL_SQL_GRAMMAR);
    }

    public void setANSI92FullSQL(int value) {
        this.setBoolean(PROP_FULL_SQL_GRAMMAR, value);
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        Boolean integrityEnh = (Boolean)this.properties.get(PROP_INTEGRITY_ENHANCEMENT);
        if (integrityEnh == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            integrityEnh = this.dmd.supportsIntegrityEnhancementFacility() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_INTEGRITY_ENHANCEMENT, integrityEnh);
        }
        return integrityEnh;
    }

    public int getIntegrityEnhancementFacility() {
        return this.getBoolean(PROP_INTEGRITY_ENHANCEMENT);
    }

    public void setIntegrityEnhancementFacility(int value) {
        this.setBoolean(PROP_INTEGRITY_ENHANCEMENT, value);
    }

    public boolean supportsOuterJoins() throws SQLException {
        Boolean outerJoins = (Boolean)this.properties.get(PROP_OUTER_JOINS);
        if (outerJoins == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            outerJoins = this.dmd.supportsOuterJoins() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_OUTER_JOINS, outerJoins);
        }
        return outerJoins;
    }

    public int getOuterJoins() {
        return this.getBoolean(PROP_OUTER_JOINS);
    }

    public void setOuterJoins(int value) {
        this.setBoolean(PROP_OUTER_JOINS, value);
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        Boolean fullOuterJoins = (Boolean)this.properties.get(PROP_FULL_OUTER_JOINS);
        if (fullOuterJoins == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            fullOuterJoins = this.dmd.supportsFullOuterJoins() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_FULL_OUTER_JOINS, fullOuterJoins);
        }
        return fullOuterJoins;
    }

    public int getFullOuterJoins() {
        return this.getBoolean(PROP_FULL_OUTER_JOINS);
    }

    public void setFullOuterJoins(int value) {
        this.setBoolean(PROP_FULL_OUTER_JOINS, value);
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        Boolean limiterOuterJoins = (Boolean)this.properties.get(PROP_LIMITED_OUTER_JOINS);
        if (limiterOuterJoins == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            limiterOuterJoins = this.dmd.supportsLimitedOuterJoins() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_LIMITED_OUTER_JOINS, limiterOuterJoins);
        }
        return limiterOuterJoins;
    }

    public int getLimitedOuterJoins() {
        return this.getBoolean(PROP_LIMITED_OUTER_JOINS);
    }

    public void setLimitedOuterJoins(int value) {
        this.setBoolean(PROP_LIMITED_OUTER_JOINS, value);
    }

    public String getSchemaTerm() throws SQLException {
        String schemaTerm = (String)this.properties.get(PROP_SCHEMA_TERM);
        if (schemaTerm == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            schemaTerm = this.dmd.getSchemaTerm();
            this.properties.put(PROP_SCHEMA_TERM, schemaTerm);
        }
        return schemaTerm;
    }

    public void setSchemaTerm(String value) {
        this.setString(PROP_SCHEMA_TERM, value);
    }

    public String getProcedureTerm() throws SQLException {
        String procedureTerm = (String)this.properties.get(PROP_PROCEDURE_TERM);
        if (procedureTerm == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            procedureTerm = this.dmd.getProcedureTerm();
            this.properties.put(PROP_PROCEDURE_TERM, procedureTerm);
        }
        return procedureTerm;
    }

    public void setProcedureTerm(String value) {
        this.setString(PROP_PROCEDURE_TERM, value);
    }

    public String getCatalogTerm() throws SQLException {
        String catalogTerm = (String)this.properties.get(PROP_CATALOG_TERM);
        if (catalogTerm == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            catalogTerm = this.dmd.getCatalogTerm();
            this.properties.put(PROP_CATALOG_TERM, catalogTerm);
        }
        return catalogTerm;
    }

    public void setCatalogTerm(String value) {
        this.setString(PROP_CATALOG_TERM, value);
    }

    public boolean isCatalogAtStart() throws SQLException {
        Boolean catalogAtStart = (Boolean)this.properties.get(PROP_CATALOG_AT_START);
        if (catalogAtStart == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            catalogAtStart = this.dmd.isCatalogAtStart() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_CATALOG_AT_START, catalogAtStart);
        }
        return catalogAtStart;
    }

    public int getcatalogAtStart() {
        return this.getBoolean(PROP_CATALOG_AT_START);
    }

    public void setcatalogAtStart(int value) {
        this.setBoolean(PROP_CATALOG_AT_START, value);
    }

    public String getCatalogSeparator() throws SQLException {
        String catalogSeparator = (String)this.properties.get(PROP_CATALOGS_SEPARATOR);
        if (catalogSeparator == null) {
            if (this.dmd == null) {
                return NOT_SET_STRING;
            }
            catalogSeparator = this.dmd.getCatalogSeparator();
            this.properties.put(PROP_CATALOGS_SEPARATOR, catalogSeparator);
        }
        return catalogSeparator;
    }

    public void setCatalogSeparator(String value) {
        this.setString(PROP_CATALOGS_SEPARATOR, value);
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        Boolean schemasInDM = (Boolean)this.properties.get(PROP_SCHEMAS_IN_DML);
        if (schemasInDM == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            schemasInDM = this.dmd.supportsSchemasInDataManipulation() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_SCHEMAS_IN_DML, schemasInDM);
        }
        return schemasInDM;
    }

    public int getSchemasInDataManipulation() {
        return this.getBoolean(PROP_SCHEMAS_IN_DML);
    }

    public void setSchemasInDataManipulation(int value) {
        this.setBoolean(PROP_SCHEMAS_IN_DML, value);
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        Boolean schemasInProcedureCalls = (Boolean)this.properties.get(PROP_SCHEMAS_IN_PROCEDURE_CALL);
        if (schemasInProcedureCalls == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            schemasInProcedureCalls = this.dmd.supportsSchemasInProcedureCalls() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_SCHEMAS_IN_PROCEDURE_CALL, schemasInProcedureCalls);
        }
        return schemasInProcedureCalls;
    }

    public int getSchemasInProcedureCalls() {
        return this.getBoolean(PROP_SCHEMAS_IN_PROCEDURE_CALL);
    }

    public void setSchemasInProcedureCalls(int value) {
        this.setBoolean(PROP_SCHEMAS_IN_PROCEDURE_CALL, value);
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        Boolean schemasInTable = (Boolean)this.properties.get(PROP_SCHEMAS_IN_TABLE_DEFINITION);
        if (schemasInTable == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            schemasInTable = this.dmd.supportsSchemasInTableDefinitions() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_SCHEMAS_IN_TABLE_DEFINITION, schemasInTable);
        }
        return schemasInTable;
    }

    public int getSchemasInTableDefinitions() {
        return this.getBoolean(PROP_SCHEMAS_IN_TABLE_DEFINITION);
    }

    public void setSchemasInTableDefinitions(int value) {
        this.setBoolean(PROP_SCHEMAS_IN_TABLE_DEFINITION, value);
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        Boolean schemasInIndex = (Boolean)this.properties.get(PROP_SCHEMAS_IN_INDEX);
        if (schemasInIndex == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            schemasInIndex = this.dmd.supportsSchemasInIndexDefinitions() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_SCHEMAS_IN_INDEX, schemasInIndex);
        }
        return schemasInIndex;
    }

    public int getSchemasInIndexDefinitions() {
        return this.getBoolean(PROP_SCHEMAS_IN_INDEX);
    }

    public void setSchemasInIndexDefinitions(int value) {
        this.setBoolean(PROP_SCHEMAS_IN_INDEX, value);
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        Boolean schemasInPriv = (Boolean)this.properties.get(PROP_SCHEMAS_IN_PRIVILEGE_DEFINITION);
        if (schemasInPriv == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            schemasInPriv = this.dmd.supportsSchemasInPrivilegeDefinitions() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_SCHEMAS_IN_PRIVILEGE_DEFINITION, schemasInPriv);
        }
        return schemasInPriv;
    }

    public int getSchemasInPrivilegeDefinitions() {
        return this.getBoolean(PROP_SCHEMAS_IN_PRIVILEGE_DEFINITION);
    }

    public void setSchemasInPrivilegeDefinitions(int value) {
        this.setBoolean(PROP_SCHEMAS_IN_PRIVILEGE_DEFINITION, value);
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        Boolean catalogInDM = (Boolean)this.properties.get(PROP_CATALOGS_IN_DML);
        if (catalogInDM == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            catalogInDM = this.dmd.supportsCatalogsInDataManipulation() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_CATALOGS_IN_DML, catalogInDM);
        }
        return catalogInDM;
    }

    public int getCatalogsInDataManipulation() {
        return this.getBoolean(PROP_CATALOGS_IN_DML);
    }

    public void setCatalogsInDataManipulation(int value) {
        this.setBoolean(PROP_CATALOGS_IN_DML, value);
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        Boolean catalogInProc = (Boolean)this.properties.get(PROP_CATALOGS_IN_PROCEDURE_CALL);
        if (catalogInProc == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            catalogInProc = this.dmd.supportsCatalogsInProcedureCalls() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_CATALOGS_IN_PROCEDURE_CALL, catalogInProc);
        }
        return catalogInProc;
    }

    public int getCatalogsInProcedureCalls() {
        return this.getBoolean(PROP_CATALOGS_IN_PROCEDURE_CALL);
    }

    public void setCatalogsInProcedureCalls(int value) {
        this.setBoolean(PROP_CATALOGS_IN_PROCEDURE_CALL, value);
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        Boolean catalogInTable = (Boolean)this.properties.get(PROP_CATALOGS_IN_TABLE_DEFINITION);
        if (catalogInTable == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            catalogInTable = this.dmd.supportsCatalogsInTableDefinitions() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_CATALOGS_IN_TABLE_DEFINITION, catalogInTable);
        }
        return catalogInTable;
    }

    public int getCatalogsInTableDefinitions() {
        return this.getBoolean(PROP_CATALOGS_IN_TABLE_DEFINITION);
    }

    public void setCatalogsInTableDefinitions(int value) {
        this.setBoolean(PROP_CATALOGS_IN_TABLE_DEFINITION, value);
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        Boolean catalogInIndex = (Boolean)this.properties.get(PROP_CATALOGS_IN_INDEX);
        if (catalogInIndex == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            catalogInIndex = this.dmd.supportsCatalogsInIndexDefinitions() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_CATALOGS_IN_INDEX, catalogInIndex);
        }
        return catalogInIndex;
    }

    public int getCatalogsInIndexDefinitions() {
        return this.getBoolean(PROP_CATALOGS_IN_INDEX);
    }

    public void setCatalogsInIndexDefinitions(int value) {
        this.setBoolean(PROP_CATALOGS_IN_INDEX, value);
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        Boolean catalogInPriv = (Boolean)this.properties.get(PROP_CATALOGS_IN_PRIVILEGE_DEFINITION);
        if (catalogInPriv == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            catalogInPriv = this.dmd.supportsCatalogsInPrivilegeDefinitions() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_CATALOGS_IN_PRIVILEGE_DEFINITION, catalogInPriv);
        }
        return catalogInPriv;
    }

    public int getCatalogsInPrivilegeDefinitions() {
        return this.getBoolean(PROP_CATALOGS_IN_PRIVILEGE_DEFINITION);
    }

    public void setCatalogsInPrivilegeDefinitions(int value) {
        this.setBoolean(PROP_CATALOGS_IN_PRIVILEGE_DEFINITION, value);
    }

    public boolean supportsPositionedDelete() throws SQLException {
        Boolean posDelete = (Boolean)this.properties.get(PROP_POSITIONED_DELETE);
        if (posDelete == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            posDelete = this.dmd.supportsPositionedDelete() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_POSITIONED_DELETE, posDelete);
        }
        return posDelete;
    }

    public int getPositionedDelete() {
        return this.getBoolean(PROP_POSITIONED_DELETE);
    }

    public void setPositionedDelete(int value) {
        this.setBoolean(PROP_POSITIONED_DELETE, value);
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        Boolean posUpdate = (Boolean)this.properties.get(PROP_POSITIONED_UPDATE);
        if (posUpdate == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            posUpdate = this.dmd.supportsPositionedUpdate() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_POSITIONED_UPDATE, posUpdate);
        }
        return posUpdate;
    }

    public int getPositionedUpdate() {
        return this.getBoolean(PROP_POSITIONED_UPDATE);
    }

    public void setPositionedUpdate(int value) {
        this.setBoolean(PROP_POSITIONED_UPDATE, value);
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        Boolean selectForUpdate = (Boolean)this.properties.get(PROP_SELECT_FOR_UPDATE);
        if (selectForUpdate == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            selectForUpdate = this.dmd.supportsSelectForUpdate() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_SELECT_FOR_UPDATE, selectForUpdate);
        }
        return selectForUpdate;
    }

    public int getSelectForUpdate() {
        return this.getBoolean(PROP_SELECT_FOR_UPDATE);
    }

    public void setSelectForUpdate(int value) {
        this.setBoolean(PROP_SELECT_FOR_UPDATE, value);
    }

    public boolean supportsStoredProcedures() throws SQLException {
        Boolean storedProcedures = (Boolean)this.properties.get(PROP_STORED_PROCEDURES);
        if (storedProcedures == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            storedProcedures = this.dmd.supportsStoredProcedures() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_STORED_PROCEDURES, storedProcedures);
        }
        return storedProcedures;
    }

    public int getStoredProcedures() {
        return this.getBoolean(PROP_STORED_PROCEDURES);
    }

    public void setStoredProcedures(int value) {
        this.setBoolean(PROP_STORED_PROCEDURES, value);
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        Boolean subqueryComp = (Boolean)this.properties.get(PROP_SUBQUERY_IN_COMPARSIONS);
        if (subqueryComp == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            subqueryComp = this.dmd.supportsSubqueriesInComparisons() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_SUBQUERY_IN_COMPARSIONS, subqueryComp);
        }
        return subqueryComp;
    }

    public int getSubqueriesInComparisons() {
        return this.getBoolean(PROP_SUBQUERY_IN_COMPARSIONS);
    }

    public void setSubqueriesInComparisons(int value) {
        this.setBoolean(PROP_SUBQUERY_IN_COMPARSIONS, value);
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        Boolean subqueryExist = (Boolean)this.properties.get(PROP_SUBQUERY_IN_EXISTS);
        if (subqueryExist == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            subqueryExist = this.dmd.supportsSubqueriesInExists() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_SUBQUERY_IN_EXISTS, subqueryExist);
        }
        return subqueryExist;
    }

    public int getSubqueriesInExists() {
        return this.getBoolean(PROP_SUBQUERY_IN_EXISTS);
    }

    public void setSubqueriesInExists(int value) {
        this.setBoolean(PROP_SUBQUERY_IN_EXISTS, value);
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        Boolean subqueryIns = (Boolean)this.properties.get(PROP_SUBQUERY_IN_INS);
        if (subqueryIns == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            subqueryIns = this.dmd.supportsSubqueriesInIns() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_SUBQUERY_IN_INS, subqueryIns);
        }
        return subqueryIns;
    }

    public int getSubqueriesInIns() {
        return this.getBoolean(PROP_SUBQUERY_IN_INS);
    }

    public void setSubqueriesInIns(int value) {
        this.setBoolean(PROP_SUBQUERY_IN_INS, value);
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        Boolean subqueryQuant = (Boolean)this.properties.get(PROP_SUBQUERY_IN_QUANTIFIEDS);
        if (subqueryQuant == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            subqueryQuant = this.dmd.supportsSubqueriesInQuantifieds() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_SUBQUERY_IN_QUANTIFIEDS, subqueryQuant);
        }
        return subqueryQuant;
    }

    public int getSubqueriesInQuantifieds() {
        return this.getBoolean(PROP_SUBQUERY_IN_QUANTIFIEDS);
    }

    public void setSubqueriesInQuantifieds(int value) {
        this.setBoolean(PROP_SUBQUERY_IN_QUANTIFIEDS, value);
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        Boolean subqueryCorr = (Boolean)this.properties.get(PROP_CORRELATED_SUBQUERIES);
        if (subqueryCorr == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            subqueryCorr = this.dmd.supportsCorrelatedSubqueries() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_CORRELATED_SUBQUERIES, subqueryCorr);
        }
        return subqueryCorr;
    }

    public int getCorrelatedSubqueries() {
        return this.getBoolean(PROP_CORRELATED_SUBQUERIES);
    }

    public void setCorrelatedSubqueries(int value) {
        this.setBoolean(PROP_CORRELATED_SUBQUERIES, value);
    }

    public boolean supportsUnion() throws SQLException {
        Boolean union = (Boolean)this.properties.get(PROP_UNION);
        if (union == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            union = this.dmd.supportsUnion() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_UNION, union);
        }
        return union;
    }

    public int getUnion() {
        return this.getBoolean(PROP_UNION);
    }

    public void setUnion(int value) {
        this.setBoolean(PROP_UNION, value);
    }

    public boolean supportsUnionAll() throws SQLException {
        Boolean unionAll = (Boolean)this.properties.get(PROP_UNION_ALL);
        if (unionAll == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            unionAll = this.dmd.supportsUnionAll() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_UNION_ALL, unionAll);
        }
        return unionAll;
    }

    public int getUnionAll() {
        return this.getBoolean(PROP_UNION_ALL);
    }

    public void setUnionAll(int value) {
        this.setBoolean(PROP_UNION_ALL, value);
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        Boolean cursorInCommit = (Boolean)this.properties.get(PROP_OPEN_CURSORS_ACROSS_COMMIT);
        if (cursorInCommit == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            cursorInCommit = this.dmd.supportsOpenCursorsAcrossCommit() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_OPEN_CURSORS_ACROSS_COMMIT, cursorInCommit);
        }
        return cursorInCommit;
    }

    public int getOpenCursorsAcrossCommit() {
        return this.getBoolean(PROP_OPEN_CURSORS_ACROSS_COMMIT);
    }

    public void setOpenCursorsAcrossCommit(int value) {
        this.setBoolean(PROP_OPEN_CURSORS_ACROSS_COMMIT, value);
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        Boolean cursorInRollback = (Boolean)this.properties.get(PROP_OPEN_CURSORS_ACROSS_ROLLBACK);
        if (cursorInRollback == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            cursorInRollback = this.dmd.supportsOpenCursorsAcrossRollback() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_OPEN_CURSORS_ACROSS_ROLLBACK, cursorInRollback);
        }
        return cursorInRollback;
    }

    public int getOpenCursorsAcrossRollback() {
        return this.getBoolean(PROP_OPEN_CURSORS_ACROSS_ROLLBACK);
    }

    public void setOpenCursorsAcrossRollback(int value) {
        this.setBoolean(PROP_OPEN_CURSORS_ACROSS_ROLLBACK, value);
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        Boolean statementInCommit = (Boolean)this.properties.get(PROP_OPEN_STATEMENTS_ACROSS_COMMIT);
        if (statementInCommit == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            statementInCommit = this.dmd.supportsOpenStatementsAcrossCommit() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_OPEN_STATEMENTS_ACROSS_COMMIT, statementInCommit);
        }
        return statementInCommit;
    }

    public int getOpenStatementsAcrossCommit() {
        return this.getBoolean(PROP_OPEN_STATEMENTS_ACROSS_COMMIT);
    }

    public void setOpenStatementsAcrossCommit(int value) {
        this.setBoolean(PROP_OPEN_STATEMENTS_ACROSS_COMMIT, value);
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        Boolean statementInRollback = (Boolean)this.properties.get(PROP_OPEN_STATEMENTS_ACROSS_ROLLBACK);
        if (statementInRollback == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            statementInRollback = this.dmd.supportsOpenStatementsAcrossRollback() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_OPEN_STATEMENTS_ACROSS_ROLLBACK, statementInRollback);
        }
        return statementInRollback;
    }

    public int getOpenStatementsAcrossRollback() {
        return this.getBoolean(PROP_OPEN_STATEMENTS_ACROSS_ROLLBACK);
    }

    public void setOpenStatementsAcrossRollback(int value) {
        this.setBoolean(PROP_OPEN_STATEMENTS_ACROSS_ROLLBACK, value);
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        Integer binaryLiteral = (Integer)this.properties.get(PROP_MAX_BINARY_LITERAL_LENGTH);
        if (binaryLiteral == null && this.dmd != null) {
            binaryLiteral = new Integer(this.dmd.getMaxBinaryLiteralLength());
            this.properties.put(PROP_MAX_BINARY_LITERAL_LENGTH, binaryLiteral);
        }
        if (binaryLiteral != null) {
            return binaryLiteral;
        }
        return 0;
    }

    public void setMaxBinaryLiteralLength(int value) {
        this.setInt(PROP_MAX_BINARY_LITERAL_LENGTH, value);
    }

    public int getMaxCharLiteralLength() throws SQLException {
        Integer maxCharLiteral = (Integer)this.properties.get(PROP_MAX_CHAR_LITERAL_LENGTH);
        if (maxCharLiteral == null && this.dmd != null) {
            maxCharLiteral = new Integer(this.dmd.getMaxCharLiteralLength());
            this.properties.put(PROP_MAX_CHAR_LITERAL_LENGTH, maxCharLiteral);
        }
        if (maxCharLiteral != null) {
            return maxCharLiteral;
        }
        return 0;
    }

    public void setMaxCharLiteralLength(int value) {
        this.setInt(PROP_MAX_CHAR_LITERAL_LENGTH, value);
    }

    public int getMaxColumnNameLength() throws SQLException {
        Integer maxColumnName = (Integer)this.properties.get(PROP_MAX_COLUMN_NAME_LENGTH);
        if (maxColumnName == null && this.dmd != null) {
            maxColumnName = new Integer(this.dmd.getMaxColumnNameLength());
            this.properties.put(PROP_MAX_COLUMN_NAME_LENGTH, maxColumnName);
        }
        if (maxColumnName != null) {
            return maxColumnName;
        }
        return 0;
    }

    public void setMaxColumnNameLength(int value) {
        this.setInt(PROP_MAX_COLUMN_NAME_LENGTH, value);
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        Integer maxColumnGroup = (Integer)this.properties.get(PROP_MAX_COLUMNS_IN_GROUPBY);
        if (maxColumnGroup == null && this.dmd != null) {
            maxColumnGroup = new Integer(this.dmd.getMaxColumnsInGroupBy());
            this.properties.put(PROP_MAX_COLUMNS_IN_GROUPBY, maxColumnGroup);
        }
        if (maxColumnGroup != null) {
            return maxColumnGroup;
        }
        return 0;
    }

    public void setMaxColumnsInGroupBy(int value) {
        this.setInt(PROP_MAX_COLUMNS_IN_GROUPBY, value);
    }

    public int getMaxColumnsInIndex() throws SQLException {
        Integer maxColumnIndex = (Integer)this.properties.get(PROP_MAX_COLUMNS_IN_INDEX);
        if (maxColumnIndex == null && this.dmd != null) {
            maxColumnIndex = new Integer(this.dmd.getMaxColumnsInIndex());
            this.properties.put(PROP_MAX_COLUMNS_IN_INDEX, maxColumnIndex);
        }
        if (maxColumnIndex != null) {
            return maxColumnIndex;
        }
        return 0;
    }

    public void setMaxColumnsInIndex(int value) {
        this.setInt(PROP_MAX_COLUMNS_IN_INDEX, value);
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        Integer maxColumnOrderBy = (Integer)this.properties.get(PROP_MAX_COLUMNS_IN_ORDERBY);
        if (maxColumnOrderBy == null && this.dmd != null) {
            maxColumnOrderBy = new Integer(this.dmd.getMaxColumnsInOrderBy());
            this.properties.put(PROP_MAX_COLUMNS_IN_ORDERBY, maxColumnOrderBy);
        }
        if (maxColumnOrderBy != null) {
            return maxColumnOrderBy;
        }
        return 0;
    }

    public void setMaxColumnsInOrderBy(int value) {
        this.setInt(PROP_MAX_COLUMNS_IN_ORDERBY, value);
    }

    public int getMaxColumnsInSelect() throws SQLException {
        Integer maxColumnSelect = (Integer)this.properties.get(PROP_MAX_COLUMNS_IN_SELECT);
        if (maxColumnSelect == null && this.dmd != null) {
            maxColumnSelect = new Integer(this.dmd.getMaxColumnsInSelect());
            this.properties.put(PROP_MAX_COLUMNS_IN_SELECT, maxColumnSelect);
        }
        if (maxColumnSelect != null) {
            return maxColumnSelect;
        }
        return 0;
    }

    public void setMaxColumnsInSelect(int value) {
        this.setInt(PROP_MAX_COLUMNS_IN_SELECT, value);
    }

    public int getMaxColumnsInTable() throws SQLException {
        Integer maxColumnTable = (Integer)this.properties.get(PROP_MAX_COLUMNS_IN_TABLE);
        if (maxColumnTable == null && this.dmd != null) {
            maxColumnTable = new Integer(this.dmd.getMaxColumnsInTable());
            this.properties.put(PROP_MAX_COLUMNS_IN_TABLE, maxColumnTable);
        }
        if (maxColumnTable != null) {
            return maxColumnTable;
        }
        return 0;
    }

    public void setMaxColumnsInTable(int value) {
        this.setInt(PROP_MAX_COLUMNS_IN_TABLE, value);
    }

    public int getMaxConnections() throws SQLException {
        Integer maxConnections = (Integer)this.properties.get(PROP_MAX_CONNECTIONS);
        if (maxConnections == null && this.dmd != null) {
            maxConnections = new Integer(this.dmd.getMaxConnections());
            this.properties.put(PROP_MAX_CONNECTIONS, maxConnections);
        }
        if (maxConnections != null) {
            return maxConnections;
        }
        return 0;
    }

    public void setMaxConnections(int value) {
        this.setInt(PROP_MAX_CONNECTIONS, value);
    }

    public int getMaxCursorNameLength() throws SQLException {
        Integer maxCursorName = (Integer)this.properties.get(PROP_MAX_CURSORNAME_LENGTH);
        if (maxCursorName == null && this.dmd != null) {
            maxCursorName = new Integer(this.dmd.getMaxCursorNameLength());
            this.properties.put(PROP_MAX_CURSORNAME_LENGTH, maxCursorName);
        }
        if (maxCursorName != null) {
            return maxCursorName;
        }
        return 0;
    }

    public void setMaxCursorNameLength(int value) {
        this.setInt(PROP_MAX_CURSORNAME_LENGTH, value);
    }

    public int getMaxIndexLength() throws SQLException {
        Integer maxIndex = (Integer)this.properties.get(PROP_MAX_INDEX_LENGTH);
        if (maxIndex == null && this.dmd != null) {
            maxIndex = new Integer(this.dmd.getMaxIndexLength());
            this.properties.put(PROP_MAX_INDEX_LENGTH, maxIndex);
        }
        if (maxIndex != null) {
            return maxIndex;
        }
        return 0;
    }

    public void setMaxIndexLength(int value) {
        this.setInt(PROP_MAX_INDEX_LENGTH, value);
    }

    public int getMaxSchemaNameLength() throws SQLException {
        Integer maxSchemaName = (Integer)this.properties.get(PROP_MAX_SCHEMA_NAME);
        if (maxSchemaName == null && this.dmd != null) {
            maxSchemaName = new Integer(this.dmd.getMaxSchemaNameLength());
            this.properties.put(PROP_MAX_SCHEMA_NAME, maxSchemaName);
        }
        if (maxSchemaName != null) {
            return maxSchemaName;
        }
        return 0;
    }

    public void setMaxSchemaNameLength(int value) {
        this.setInt(PROP_MAX_SCHEMA_NAME, value);
    }

    public int getMaxProcedureNameLength() throws SQLException {
        Integer maxProcName = (Integer)this.properties.get(PROP_MAX_PROCEDURE_NAME);
        if (maxProcName == null && this.dmd != null) {
            maxProcName = new Integer(this.dmd.getMaxProcedureNameLength());
            this.properties.put(PROP_MAX_PROCEDURE_NAME, maxProcName);
        }
        if (maxProcName != null) {
            return maxProcName;
        }
        return 0;
    }

    public void setMaxProcedureNameLength(int value) {
        this.setInt(PROP_MAX_PROCEDURE_NAME, value);
    }

    public int getMaxCatalogNameLength() throws SQLException {
        Integer maxCatalogName = (Integer)this.properties.get(PROP_MAX_CATALOG_NAME);
        if (maxCatalogName == null && this.dmd != null) {
            maxCatalogName = new Integer(this.dmd.getMaxProcedureNameLength());
            this.properties.put(PROP_MAX_CATALOG_NAME, maxCatalogName);
        }
        if (maxCatalogName != null) {
            return maxCatalogName;
        }
        return 0;
    }

    public void setMaxCatalogNameLength(int value) {
        this.setInt(PROP_MAX_CATALOG_NAME, value);
    }

    public int getMaxRowSize() throws SQLException {
        Integer maxRowSize = (Integer)this.properties.get(PROP_MAX_ROW_SIZE);
        if (maxRowSize == null && this.dmd != null) {
            maxRowSize = new Integer(this.dmd.getMaxProcedureNameLength());
            this.properties.put(PROP_MAX_ROW_SIZE, maxRowSize);
        }
        if (maxRowSize != null) {
            return maxRowSize;
        }
        return 0;
    }

    public void setMaxRowSize(int value) {
        this.setInt(PROP_MAX_ROW_SIZE, value);
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        Boolean rowSizeBlobs = (Boolean)this.properties.get(PROP_ROWSIZE_INCLUDING_BLOBS);
        if (rowSizeBlobs == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            rowSizeBlobs = this.dmd.doesMaxRowSizeIncludeBlobs() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_ROWSIZE_INCLUDING_BLOBS, rowSizeBlobs);
        }
        return rowSizeBlobs;
    }

    public int getMaxRowSizeIncludeBlobs() {
        return this.getBoolean(PROP_ROWSIZE_INCLUDING_BLOBS);
    }

    public void setMaxRowSizeIncludeBlobs(int value) {
        this.setBoolean(PROP_ROWSIZE_INCLUDING_BLOBS, value);
    }

    public int getMaxStatementLength() throws SQLException {
        Integer maxStatement = (Integer)this.properties.get(PROP_MAX_STATEMENT_LENGTH);
        if (maxStatement == null && this.dmd != null) {
            maxStatement = new Integer(this.dmd.getMaxStatementLength());
            this.properties.put(PROP_MAX_STATEMENT_LENGTH, maxStatement);
        }
        if (maxStatement != null) {
            return maxStatement;
        }
        return 0;
    }

    public void setMaxStatementLength(int value) {
        this.setInt(PROP_MAX_STATEMENT_LENGTH, value);
    }

    public int getMaxStatements() throws SQLException {
        Integer maxStatements = (Integer)this.properties.get(PROP_MAX_STATEMENTS);
        if (maxStatements == null && this.dmd != null) {
            maxStatements = new Integer(this.dmd.getMaxStatementLength());
            this.properties.put(PROP_MAX_STATEMENTS, maxStatements);
        }
        if (maxStatements != null) {
            return maxStatements;
        }
        return 0;
    }

    public void setMaxStatements(int value) {
        this.setInt(PROP_MAX_STATEMENTS, value);
    }

    public int getMaxTableNameLength() throws SQLException {
        Integer maxTable = (Integer)this.properties.get(PROP_MAX_TABLENAME_LENGTH);
        if (maxTable == null && this.dmd != null) {
            maxTable = new Integer(this.dmd.getMaxStatementLength());
            this.properties.put(PROP_MAX_TABLENAME_LENGTH, maxTable);
        }
        if (maxTable != null) {
            return maxTable;
        }
        return 0;
    }

    public void setMaxTableNameLength(int value) {
        this.setInt(PROP_MAX_TABLENAME_LENGTH, value);
    }

    public int getMaxTablesInSelect() throws SQLException {
        Integer maxTable = (Integer)this.properties.get(PROP_MAX_TABLES_IN_SELECT);
        if (maxTable == null && this.dmd != null) {
            maxTable = new Integer(this.dmd.getMaxStatementLength());
            this.properties.put(PROP_MAX_TABLES_IN_SELECT, maxTable);
        }
        if (maxTable != null) {
            return maxTable;
        }
        return 0;
    }

    public void setMaxTablesInSelect(int value) {
        this.setInt(PROP_MAX_TABLES_IN_SELECT, value);
    }

    public int getMaxUserNameLength() throws SQLException {
        Integer maxUserName = (Integer)this.properties.get(PROP_MAX_USERNAME);
        if (maxUserName == null && this.dmd != null) {
            maxUserName = new Integer(this.dmd.getMaxUserNameLength());
            this.properties.put(PROP_MAX_USERNAME, maxUserName);
        }
        if (maxUserName != null) {
            return maxUserName;
        }
        return 0;
    }

    public void setMaxUserNameLength(int value) {
        this.setInt(PROP_MAX_USERNAME, value);
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        Integer maxTransaction = (Integer)this.properties.get(PROP_DEFAULT_ISOLATION);
        if (maxTransaction == null && this.dmd != null) {
            maxTransaction = new Integer(this.dmd.getDefaultTransactionIsolation());
            this.properties.put(PROP_DEFAULT_ISOLATION, maxTransaction);
        }
        if (maxTransaction != null) {
            return maxTransaction;
        }
        return 0;
    }

    public void setDefaultTransactionIsolation(int value) {
        this.setInt(PROP_DEFAULT_ISOLATION, value);
    }

    public boolean supportsTransactions() throws SQLException {
        Boolean trans = (Boolean)this.properties.get(PROP_TRANSACTIONS);
        if (trans == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            trans = this.dmd.doesMaxRowSizeIncludeBlobs() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_TRANSACTIONS, trans);
        }
        return trans;
    }

    public int getTransactions() {
        return this.getBoolean(PROP_TRANSACTIONS);
    }

    public void setTransactions(int value) {
        this.setBoolean(PROP_TRANSACTIONS, value);
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.supportsTransactionIsolationLevel(level);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        Boolean flag = (Boolean)this.properties.get(PROP_DDL_AND_DML_TRANSACTIONS);
        if (flag == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            flag = this.dmd.doesMaxRowSizeIncludeBlobs() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_DDL_AND_DML_TRANSACTIONS, flag);
        }
        return flag;
    }

    public int getDataDefinitionAndDataManipulationTransactions() {
        return this.getBoolean(PROP_DDL_AND_DML_TRANSACTIONS);
    }

    public void setDataDefinitionAndDataManipulationTransactions(int value) {
        this.setBoolean(PROP_DDL_AND_DML_TRANSACTIONS, value);
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        Boolean flag = (Boolean)this.properties.get(PROP_DML_TRANSACTIONS_ONLY);
        if (flag == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            flag = this.dmd.supportsDataManipulationTransactionsOnly() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_DML_TRANSACTIONS_ONLY, flag);
        }
        return flag;
    }

    public int getDataManipulationTransactionsOnly() {
        return this.getBoolean(PROP_DML_TRANSACTIONS_ONLY);
    }

    public void setDataManipulationTransactionsOnly(int value) {
        this.setBoolean(PROP_DML_TRANSACTIONS_ONLY, value);
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        Boolean flag = (Boolean)this.properties.get(PROP_DDL_CAUSES_COMMIT);
        if (flag == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            flag = this.dmd.dataDefinitionCausesTransactionCommit() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_DDL_CAUSES_COMMIT, flag);
        }
        return flag;
    }

    public int getDataDefinitionCausesTransactionCommit() {
        return this.getBoolean(PROP_DDL_CAUSES_COMMIT);
    }

    public void setDataDefinitionCausesTransactionCommit(int value) {
        this.setBoolean(PROP_DDL_CAUSES_COMMIT, value);
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        Boolean flag = (Boolean)this.properties.get(PROP_DDL_IGNORED_IN_TRANSACTIONS);
        if (flag == null) {
            if (this.dmd == null) {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            flag = this.dmd.dataDefinitionIgnoredInTransactions() ? Boolean.TRUE : Boolean.FALSE;
            this.properties.put(PROP_DDL_IGNORED_IN_TRANSACTIONS, flag);
        }
        return flag;
    }

    public int getDataDefinitionIgnoredInTransactions() {
        return this.getBoolean(PROP_DDL_IGNORED_IN_TRANSACTIONS);
    }

    public void setDataDefinitionIgnoredInTransactions(int value) {
        this.setBoolean(PROP_DDL_IGNORED_IN_TRANSACTIONS, value);
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String query;
        if (this.getCapitializeUsername() && schemaPattern != null) {
            schemaPattern = schemaPattern.toUpperCase();
        }
        if ((query = (String)this.properties.get(PROP_PROCEDURES_QUERY)) != null) {
            if (this.con != null) {
                PreparedStatement stmt = this.con.prepareStatement(query);
                stmt.setString(1, catalog);
                stmt.setString(2, schemaPattern);
                stmt.setString(3, procedureNamePattern);
                return stmt.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getProcedures(catalog, schemaPattern, procedureNamePattern);
    }

    public String getProceduresQuery() {
        return this.getString(PROP_PROCEDURES_QUERY);
    }

    public void setProceduresQuery(String value) {
        this.setString(PROP_PROCEDURES_QUERY, value);
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        String query;
        if (this.getCapitializeUsername() && schemaPattern != null) {
            schemaPattern = schemaPattern.toUpperCase();
        }
        if ((query = (String)this.properties.get(PROP_PROCEDURE_COLUMNS_QUERY)) != null) {
            if (this.con != null) {
                PreparedStatement stmt = this.con.prepareStatement(query);
                stmt.setString(1, catalog);
                stmt.setString(2, schemaPattern);
                stmt.setString(3, procedureNamePattern);
                stmt.setString(4, columnNamePattern);
                return stmt.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
    }

    public String getProcedureColumnsQuery() {
        return this.getString(PROP_PROCEDURE_COLUMNS_QUERY);
    }

    public void setProcedureColumnsQuery(String value) {
        this.setString(PROP_PROCEDURE_COLUMNS_QUERY, value);
    }

    public ResultSet getSchemas() throws SQLException {
        String query = (String)this.properties.get(PROP_PROCEDURE_COLUMNS_QUERY);
        if (query != null) {
            if (this.con != null) {
                return this.con.createStatement().executeQuery(query);
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getSchemas();
    }

    public String getSchemasQuery() {
        return this.getString(PROP_SCHEMAS_QUERY);
    }

    public void setSchemasQuery(String value) {
        this.setString(PROP_SCHEMAS_QUERY, value);
    }

    public ResultSet getCatalogs() throws SQLException {
        String query = (String)this.properties.get(PROP_CATALOGS_QUERY);
        if (query != null) {
            if (this.con != null) {
                return this.con.createStatement().executeQuery(query);
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getCatalogs();
    }

    public String getCatalogsQuery() {
        return this.getString(PROP_CATALOGS_QUERY);
    }

    public void setCatalogsQuery(String value) {
        this.setString(PROP_CATALOGS_QUERY, value);
    }

    public ResultSet getTableTypes() throws SQLException {
        String query = (String)this.properties.get(PROP_TABLE_TYPES_QUERY);
        if (query != null) {
            if (this.con != null) {
                return this.con.createStatement().executeQuery(query);
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getCatalogs();
    }

    public String getTableTypesQuery() {
        return this.getString(PROP_TABLE_TYPES_QUERY);
    }

    public void setTableTypesQuery(String value) {
        this.setString(PROP_TABLE_TYPES_QUERY, value);
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String query;
        if (this.getCapitializeUsername() && schemaPattern != null) {
            schemaPattern = schemaPattern.toUpperCase();
        }
        if ((query = (String)this.properties.get(PROP_COLUMNS_QUERY)) != null) {
            if (this.con != null) {
                PreparedStatement stmt = this.con.prepareStatement(query);
                stmt.setString(1, catalog);
                stmt.setString(2, schemaPattern);
                stmt.setString(3, tableNamePattern);
                stmt.setString(4, columnNamePattern);
                return stmt.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    public String getColumnsQuery() {
        return this.getString(PROP_COLUMNS_QUERY);
    }

    public void setColumnsQuery(String value) {
        this.setString(PROP_COLUMNS_QUERY, value);
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        String query;
        if (this.getCapitializeUsername() && schema != null) {
            schema = schema.toUpperCase();
        }
        if ((query = (String)this.properties.get(PROP_COLUMNS_PRIVILEGES_QUERY)) != null) {
            if (this.con != null) {
                PreparedStatement stmt = this.con.prepareStatement(query);
                stmt.setString(1, catalog);
                stmt.setString(2, schema);
                stmt.setString(3, table);
                stmt.setString(4, columnNamePattern);
                return stmt.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getColumnPrivileges(catalog, schema, table, columnNamePattern);
    }

    public String getColumnPrivilegesQuery() {
        return this.getString(PROP_COLUMNS_PRIVILEGES_QUERY);
    }

    public void setColumnPrivilegesQuery(String value) {
        this.setString(PROP_COLUMNS_PRIVILEGES_QUERY, value);
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String query;
        if (this.getCapitializeUsername() && schemaPattern != null) {
            schemaPattern = schemaPattern.toUpperCase();
        }
        if ((query = (String)this.properties.get(PROP_TABLES_QUERY)) != null) {
            if (this.con != null) {
                StringBuffer typebuff = new StringBuffer();
                PreparedStatement stmt = this.con.prepareStatement(query);
                stmt.setString(1, catalog);
                stmt.setString(2, schemaPattern);
                stmt.setString(3, tableNamePattern);
                int i = 0;
                while (i < types.length) {
                    if (i > 0) {
                        typebuff.append(", ");
                    }
                    typebuff.append("'");
                    typebuff.append(types[i]);
                    typebuff.append("'");
                    ++i;
                }
                stmt.setString(4, typebuff.toString());
                return stmt.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getTables(catalog, schemaPattern, tableNamePattern, types);
    }

    public String getTablesQuery() {
        return this.getString(PROP_TABLES_QUERY);
    }

    public void setTablesQuery(String value) {
        this.setString(PROP_TABLES_QUERY, value);
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String query;
        if (this.getCapitializeUsername() && schemaPattern != null) {
            schemaPattern = schemaPattern.toUpperCase();
        }
        if ((query = (String)this.properties.get(PROP_TABLE_PRIVILEGES_QUERY)) != null) {
            if (this.con != null) {
                PreparedStatement stmt = this.con.prepareStatement(query);
                stmt.setString(1, catalog);
                stmt.setString(2, schemaPattern);
                stmt.setString(3, tableNamePattern);
                return stmt.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getTablePrivileges(catalog, schemaPattern, tableNamePattern);
    }

    public String getTablePrivilegesQuery() {
        return this.getString(PROP_TABLE_PRIVILEGES_QUERY);
    }

    public void setTablePrivilegesQuery(String value) {
        this.setString(PROP_TABLE_PRIVILEGES_QUERY, value);
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        String query;
        if (this.getCapitializeUsername() && schema != null) {
            schema = schema.toUpperCase();
        }
        if ((query = (String)this.properties.get(PROP_BEST_ROW_IDENTIFIER)) != null) {
            if (this.con != null) {
                PreparedStatement stmt = this.con.prepareStatement(query);
                stmt.setString(1, catalog);
                stmt.setString(2, schema);
                stmt.setString(3, table);
                stmt.setInt(4, scope);
                stmt.setBoolean(5, nullable);
                return stmt.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getBestRowIdentifier(catalog, schema, table, scope, nullable);
    }

    public String getBestRowIdentifierQuery() {
        return this.getString(PROP_BEST_ROW_IDENTIFIER);
    }

    public void setBestRowIdentifierQuery(String value) {
        this.setString(PROP_BEST_ROW_IDENTIFIER, value);
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        String query;
        if (this.getCapitializeUsername() && schema != null) {
            schema = schema.toUpperCase();
        }
        if ((query = (String)this.properties.get(PROP_VERSION_COLUMNS)) != null) {
            if (this.con != null) {
                PreparedStatement stmt = this.con.prepareStatement(query);
                stmt.setString(1, catalog);
                stmt.setString(2, schema);
                stmt.setString(3, table);
                return stmt.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getVersionColumns(catalog, schema, table);
    }

    public String getVersionColumnsQuery() {
        return this.getString(PROP_VERSION_COLUMNS);
    }

    public void setVersionColumnsQuery(String value) {
        this.setString(PROP_VERSION_COLUMNS, value);
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String query;
        if (this.getCapitializeUsername() && schema != null) {
            schema = schema.toUpperCase();
        }
        if ((query = (String)this.properties.get(PROP_PK_QUERY)) != null) {
            if (this.con != null) {
                PreparedStatement stmt = this.con.prepareStatement(query);
                stmt.setString(1, catalog);
                stmt.setString(2, schema);
                stmt.setString(3, table);
                return stmt.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getPrimaryKeys(catalog, schema, table);
    }

    public String getPrimaryKeysQuery() {
        return this.getString(PROP_PK_QUERY);
    }

    public void setPrimaryKeysQuery(String value) {
        this.setString(PROP_PK_QUERY, value);
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        String query;
        if (this.getCapitializeUsername() && schema != null) {
            schema = schema.toUpperCase();
        }
        if ((query = (String)this.properties.get(PROP_IK_QUERY)) != null) {
            if (this.con != null) {
                PreparedStatement stmt = this.con.prepareStatement(query);
                stmt.setString(1, catalog);
                stmt.setString(2, schema);
                stmt.setString(3, table);
                return stmt.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getImportedKeys(catalog, schema, table);
    }

    public String getImportedKeysQuery() {
        return this.getString(PROP_IK_QUERY);
    }

    public void setImportedKeysQuery(String value) {
        this.setString(PROP_IK_QUERY, value);
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        String query;
        if (this.getCapitializeUsername() && schema != null) {
            schema = schema.toUpperCase();
        }
        if ((query = (String)this.properties.get(PROP_EK_QUERY)) != null) {
            if (this.con != null) {
                PreparedStatement stmt = this.con.prepareStatement(query);
                stmt.setString(1, catalog);
                stmt.setString(2, schema);
                stmt.setString(3, table);
                return stmt.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getExportedKeys(catalog, schema, table);
    }

    public String getExportedKeysQuery() {
        return this.getString(PROP_EK_QUERY);
    }

    public void setExportedKeysQuery(String value) {
        this.setString(PROP_EK_QUERY, value);
    }

    public ResultSet getCrossReference(String catalog, String schema, String table, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        String query;
        if (this.getCapitializeUsername() && schema != null) {
            schema = schema.toUpperCase();
        }
        if ((query = (String)this.properties.get(PROP_CROSSREF_QUERY)) != null) {
            if (this.con != null) {
                PreparedStatement stmt = this.con.prepareStatement(query);
                stmt.setString(1, catalog);
                stmt.setString(2, schema);
                stmt.setString(3, table);
                stmt.setString(4, foreignCatalog);
                stmt.setString(5, foreignSchema);
                stmt.setString(6, foreignTable);
                return stmt.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getCrossReference(catalog, schema, table, foreignCatalog, foreignSchema, foreignTable);
    }

    public String getCrossReferenceQuery() {
        return this.getString(PROP_CROSSREF_QUERY);
    }

    public void setCrossReferenceQuery(String value) {
        this.setString(PROP_CROSSREF_QUERY, value);
    }

    public ResultSet getTypeInfo() throws SQLException {
        String query = (String)this.properties.get(PROP_TYPE_INFO_QUERY);
        if (query != null) {
            if (this.con != null) {
                return this.con.createStatement().executeQuery(query);
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getTypeInfo();
    }

    public String getTypeInfoQuery() {
        return this.getString(PROP_TYPE_INFO_QUERY);
    }

    public void setTypeInfoQuery(String value) {
        this.setString(PROP_TYPE_INFO_QUERY, value);
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        String query;
        if (this.getCapitializeUsername() && schema != null) {
            schema = schema.toUpperCase();
        }
        if ((query = (String)this.properties.get(PROP_INDEX_INFO_QUERY)) != null) {
            if (this.con != null) {
                PreparedStatement stmt = this.con.prepareStatement(query);
                stmt.setString(1, catalog);
                stmt.setString(2, schema);
                stmt.setString(3, table);
                stmt.setBoolean(4, unique);
                stmt.setBoolean(5, approximate);
                return stmt.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getIndexInfo(catalog, schema, table, unique, approximate);
    }

    public String getIndexInfoQuery() {
        return this.getString(PROP_INDEX_INFO_QUERY);
    }

    public void setIndexInfoQuery(String value) {
        this.setString(PROP_INDEX_INFO_QUERY, value);
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.supportsResultSetType(type);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.supportsResultSetConcurrency(type, concurrency);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.ownUpdatesAreVisible(type);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.ownDeletesAreVisible(type);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.ownInsertsAreVisible(type);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.othersUpdatesAreVisible(type);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.othersDeletesAreVisible(type);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.othersInsertsAreVisible(type);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.updatesAreDetected(type);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.deletesAreDetected(type);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        if (this.dmd != null) {
            return this.dmd.insertsAreDetected(type);
        }
        throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
    }

    public boolean supportsBatchUpdates() throws SQLException {
        Boolean flag = (Boolean)this.properties.get(PROP_BATCH_UPDATES);
        if (flag == null) {
            if (this.dmd != null) {
                try {
                    flag = this.dmd.supportsBatchUpdates() ? Boolean.TRUE : Boolean.FALSE;
                }
                catch (AbstractMethodError abstractMethodError) {}
            } else {
                throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
            }
            this.properties.put(PROP_BATCH_UPDATES, flag);
        }
        return flag;
    }

    public int getBatchUpdates() {
        return this.getBoolean(PROP_BATCH_UPDATES);
    }

    public void setBatchUpdates(int value) {
        this.setBoolean(PROP_BATCH_UPDATES, value);
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String query;
        if (this.getCapitializeUsername() && schemaPattern != null) {
            schemaPattern = schemaPattern.toUpperCase();
        }
        if ((query = (String)this.properties.get(PROP_UDT_QUERY)) != null) {
            if (this.con != null) {
                StringBuffer typebuff = new StringBuffer();
                PreparedStatement stmt = this.con.prepareStatement(query);
                stmt.setString(1, catalog);
                stmt.setString(2, schemaPattern);
                stmt.setString(3, typeNamePattern);
                int i = 0;
                while (i < types.length) {
                    if (i > 0) {
                        typebuff.append(", ");
                    }
                    typebuff.append(types[i]);
                    ++i;
                }
                stmt.setString(4, typebuff.toString());
                return stmt.executeQuery();
            }
            throw new SQLException(bundle.getString("EXC_NoConnection"));
        }
        if (this.dmd == null) {
            throw new SQLException(bundle.getString("EXC_NoDBMetadata"));
        }
        return this.dmd.getUDTs(catalog, schemaPattern, typeNamePattern, types);
    }

    public String getUDTsQuery() {
        return this.getString(PROP_UDT_QUERY);
    }

    public void setUDTsQuery(String value) {
        this.setString(PROP_UDT_QUERY, value);
    }

    public boolean getCapitializeUsername() {
        Boolean flag = (Boolean)this.properties.get(PROP_CAPITALIZE_USERNAME);
        if (flag == null) {
            flag = Boolean.TRUE;
            this.properties.put(PROP_CAPITALIZE_USERNAME, flag);
        }
        return flag;
    }

    public void setCapitializeUsername(boolean value) {
        Boolean oldValue = (Boolean)this.properties.get(PROP_CAPITALIZE_USERNAME);
        Boolean newValue = value ? Boolean.TRUE : Boolean.FALSE;
        this.properties.put(PROP_CAPITALIZE_USERNAME, newValue);
        this.propertySupport.firePropertyChange(PROP_CAPITALIZE_USERNAME, oldValue, newValue);
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return null;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return -1;
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return -1;
    }

    public int getJDBCMajorVersion() throws SQLException {
        return -1;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return -1;
    }

    public int getResultSetHoldability() throws SQLException {
        return -1;
    }

    public int getSQLStateType() throws SQLException {
        return -1;
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return null;
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return null;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }
}

