/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.lib.ddl.DDLCommand;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.DatabaseSpecification;
import org.netbeans.lib.ddl.util.CommandFormatter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.OutputWriter;

public class AbstractCommand
implements Serializable,
DDLCommand {
    private DatabaseSpecification spec;
    boolean executionWithException;
    private String format;
    private String owner;
    private String name;
    private Map addprops;
    private static ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle");
    static final long serialVersionUID = -560515030304320086L;
    private String quoteStr;

    public DatabaseSpecification getSpecification() {
        return this.spec;
    }

    public void setSpecification(DatabaseSpecification specification) {
        this.spec = specification;
    }

    public void setFormat(String fmt) {
        this.format = fmt;
    }

    public String getObjectName() {
        return this.name;
    }

    public void setObjectName(String nam) {
        this.name = nam;
    }

    public String getObjectOwner() {
        if (this.owner != null && this.owner.trim().equals("")) {
            this.setObjectOwner(null);
        }
        return this.owner;
    }

    public void setObjectOwner(String objectowner) {
        this.owner = objectowner;
    }

    public Object getProperty(String pname) {
        return this.addprops.get(pname);
    }

    public void setProperty(String pname, Object pval) {
        if (this.addprops == null) {
            this.addprops = new HashMap();
        }
        this.addprops.put(pname, pval);
    }

    public Map getCommandProperties() throws DDLException {
        String oname;
        HashMap<String, String> args = new HashMap<String, String>();
        if (this.addprops != null) {
            args.putAll(this.addprops);
        }
        if ((oname = this.getObjectName()) == null) {
            throw new DDLException(bundle.getString("EXC_Unknown"));
        }
        args.put("object.name", this.quote(this.getObjectName()));
        args.put("object.owner", this.quote(this.getObjectOwner()));
        return args;
    }

    public void execute() throws DDLException {
        String fcmd;
        boolean opened;
        Connection fcon;
        block13: {
            fcon = null;
            opened = false;
            this.executionWithException = false;
            try {
                fcmd = this.getCommand();
            }
            catch (Exception e) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    e.printStackTrace();
                }
                this.executionWithException = true;
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(bundle.getString("EXC_UnableToFormat") + "\n" + this.format + "\n" + e.getMessage()), 0));
                return;
            }
            if (this.spec.getSpecificationFactory().isDebugMode()) {
                try {
                    OutputWriter ow = IOProvider.getDefault().getStdOut();
                    if (ow == null) {
                        throw new Exception();
                    }
                    ow.println(fcmd);
                }
                catch (Exception e) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block13;
                    e.printStackTrace();
                    System.out.println(fcmd);
                }
            }
        }
        try {
            fcon = this.spec.getJDBCConnection();
            if (fcon == null) {
                fcon = this.spec.openJDBCConnection();
                opened = true;
            }
            Statement stat = fcon.createStatement();
            stat.execute(fcmd);
            stat.close();
        }
        catch (Exception e) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                e.printStackTrace();
            }
            this.executionWithException = true;
            if (opened && fcon != null) {
                this.spec.closeJDBCConnection();
            }
            throw new DDLException(bundle.getString("EXC_UnableToExecute") + "\n" + fcmd + "\n" + e.getMessage());
        }
        if (opened) {
            this.spec.closeJDBCConnection();
        }
    }

    public String getCommand() throws DDLException {
        if (this.format == null) {
            throw new DDLException(bundle.getString("EXC_NoFormatSpec"));
        }
        try {
            Map props = this.getCommandProperties();
            return CommandFormatter.format(this.format, props);
        }
        catch (Exception e) {
            throw new DDLException(e.getMessage());
        }
    }

    public boolean wasException() {
        return this.executionWithException;
    }

    private String getQuoteString() {
        try {
            this.quoteStr = this.getSpecification().getJDBCConnection().getMetaData().getIdentifierQuoteString();
            if (this.getSpecification().getJDBCConnection().getMetaData().getDatabaseProductName().indexOf("Firebird") != -1) {
                this.quoteStr = "";
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.quoteStr == null) {
            this.quoteStr = "";
        } else {
            this.quoteStr.trim();
        }
        return this.quoteStr;
    }

    protected String quote(String name) {
        if (name == null || name.equals("")) {
            return name;
        }
        if (this.quoteStr == null) {
            this.quoteStr = this.getQuoteString();
        }
        return this.quoteStr + name + this.quoteStr;
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.format = (String)in.readObject();
        this.owner = (String)in.readObject();
        this.name = (String)in.readObject();
        this.addprops = (Map)in.readObject();
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.format);
        out.writeObject(this.owner);
        out.writeObject(this.name);
        out.writeObject(this.addprops);
    }
}

