/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.impl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import org.netbeans.lib.ddl.DriverSpecificationFactory;
import org.netbeans.lib.ddl.impl.SpecificationFactory;

public class DriverSpecification {
    private HashMap desc;
    private String catalog;
    private String schema;
    private DatabaseMetaData dmd;
    private ResultSet rs;
    private String quoteString;
    SpecificationFactory factory;

    public DriverSpecification(HashMap description) {
        this.desc = description;
        this.quoteString = null;
    }

    public DriverSpecificationFactory getDriverSpecificationFactory() {
        return this.factory;
    }

    public void setDriverSpecificationFactory(DriverSpecificationFactory fac) {
        this.factory = (SpecificationFactory)fac;
    }

    public void setCatalog(String catalog) {
        if (catalog == null || this.dmd == null) {
            this.catalog = catalog;
            return;
        }
        catalog.trim();
        LinkedList<String> list = new LinkedList<String>();
        try {
            ResultSet rs = this.dmd.getCatalogs();
            while (rs.next()) {
                list.add(rs.getString(1).trim());
            }
            rs.close();
        }
        catch (SQLException exc) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                exc.printStackTrace();
            }
            this.catalog = null;
            Object rs = null;
            return;
        }
        this.catalog = list.contains(catalog) ? catalog : null;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setMetaData(DatabaseMetaData dmd) {
        this.dmd = dmd;
    }

    public void getTables(String tableNamePattern, String[] types) {
        try {
            tableNamePattern = this.quoteString(tableNamePattern);
            this.rs = this.dmd.getTables(this.catalog, this.schema, tableNamePattern, types);
        }
        catch (SQLException exc) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                exc.printStackTrace();
            }
            this.rs = null;
        }
    }

    public void getProcedures(String procedureNamePattern) {
        try {
            procedureNamePattern = this.quoteString(procedureNamePattern);
            this.rs = this.dmd.getProcedures(this.catalog, this.schema, procedureNamePattern);
        }
        catch (SQLException exc) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                exc.printStackTrace();
            }
            this.rs = null;
        }
    }

    public void getPrimaryKeys(String table) {
        try {
            table = this.quoteString(table);
            this.rs = this.dmd.getPrimaryKeys(this.catalog, this.schema, table);
        }
        catch (SQLException exc) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                exc.printStackTrace();
            }
            this.rs = null;
        }
    }

    public void getIndexInfo(String table, boolean unique, boolean approximate) {
        try {
            table = this.quoteString(table);
            this.rs = this.dmd.getIndexInfo(this.catalog, this.schema, table, unique, approximate);
        }
        catch (SQLException exc) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                exc.printStackTrace();
            }
            this.rs = null;
        }
    }

    public void getColumns(String tableNamePattern, String columnNamePattern) {
        try {
            tableNamePattern = this.quoteString(tableNamePattern);
            columnNamePattern = this.quoteString(columnNamePattern);
            this.rs = this.dmd.getColumns(this.catalog, this.schema, tableNamePattern, columnNamePattern);
        }
        catch (SQLException exc) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                exc.printStackTrace();
            }
            this.rs = null;
        }
    }

    public void getProcedureColumns(String procedureNamePattern, String columnNamePattern) {
        try {
            procedureNamePattern = this.quoteString(procedureNamePattern);
            columnNamePattern = this.quoteString(columnNamePattern);
            this.rs = this.dmd.getProcedureColumns(this.catalog, this.schema, procedureNamePattern, columnNamePattern);
        }
        catch (SQLException exc) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                exc.printStackTrace();
            }
            this.rs = null;
        }
    }

    public void getExportedKeys(String table) {
        try {
            table = this.quoteString(table);
            this.rs = this.dmd.getExportedKeys(this.catalog, this.schema, table);
        }
        catch (SQLException exc) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                exc.printStackTrace();
            }
            this.rs = null;
        }
    }

    public void getImportedKeys(String table) {
        try {
            table = this.quoteString(table);
            this.rs = this.dmd.getImportedKeys(this.catalog, this.schema, table);
        }
        catch (SQLException exc) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                exc.printStackTrace();
            }
            this.rs = null;
        }
    }

    public ResultSet getResultSet() {
        return this.rs;
    }

    public HashMap getRow() {
        HashMap<Integer, String> rset = new HashMap<Integer, String>();
        try {
            int count = this.rs.getMetaData().getColumnCount();
            int i = 1;
            while (i <= count) {
                String value = null;
                try {
                    value = this.rs.getString(i);
                }
                catch (SQLException exc) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        exc.printStackTrace();
                    }
                    rset = null;
                    break;
                }
                rset.put(new Integer(i), value);
                ++i;
            }
        }
        catch (SQLException exc) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                exc.printStackTrace();
            }
            rset = null;
        }
        return rset;
    }

    public boolean areViewsSupported() {
        LinkedList<String> list = new LinkedList<String>();
        list.add("PointBase");
        list.add("MySQL");
        list.add("HypersonicSQL");
        try {
            String productName = this.dmd.getDatabaseProductName().trim();
            if (list.contains(productName)) {
                if (productName.equalsIgnoreCase("PointBase")) {
                    return this.dmd.getDriverMajorVersion() == 4 && this.dmd.getDriverMinorVersion() >= 1 || this.dmd.getDriverMajorVersion() > 4;
                }
                return false;
            }
            return true;
        }
        catch (SQLException exc) {
            return true;
        }
    }

    private String getQuoteString() {
        if (this.quoteString == null) {
            try {
                this.quoteString = this.dmd.getIdentifierQuoteString();
                if (this.quoteString == null || this.quoteString.equals(" ")) {
                    this.quoteString = "";
                } else {
                    this.quoteString.trim();
                }
            }
            catch (SQLException exc) {
                this.quoteString = "";
            }
        }
        return this.quoteString;
    }

    private String quoteString(String str) {
        try {
            if (this.dmd.getDatabaseProductName().trim().equals("PointBase")) {
                String quoteStr = this.getQuoteString();
                if (str != null && !str.equals("%") && !quoteStr.equals("")) {
                    str = quoteStr + str + quoteStr;
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return str;
    }

    public String getDBName() {
        try {
            return this.dmd.getDatabaseProductName().trim();
        }
        catch (SQLException exc) {
            return null;
        }
    }
}

