/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.lib.ddl.Argument;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.DatabaseSpecification;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.CreateProcedure;
import org.netbeans.lib.ddl.util.CommandFormatter;
import org.openide.util.NbBundle;

public class ProcedureArgument
implements Argument {
    private String name;
    private int type;
    private int dtype;
    private String format;
    private Map addprops;
    private static ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle");

    public static String getArgumentTypeName(int type) {
        String typename = null;
        switch (type) {
            case 1: {
                typename = "IN";
                break;
            }
            case 4: {
                typename = "OUT";
                break;
            }
            case 2: {
                typename = "INOUT";
            }
        }
        return typename;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aname) {
        this.name = aname;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String fmt) {
        this.format = fmt;
    }

    public Object getProperty(String pname) {
        return this.addprops.get(pname);
    }

    public void setProperty(String pname, Object pval) {
        if (this.addprops == null) {
            this.addprops = new HashMap();
        }
        this.addprops.put(pname, pval);
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return ProcedureArgument.getArgumentTypeName(this.type);
    }

    public void setType(int atype) {
        this.type = atype;
    }

    public int getDataType() {
        return this.dtype;
    }

    public void setDataType(int atype) {
        this.dtype = atype;
    }

    public Map getColumnProperties(AbstractCommand cmd) throws DDLException {
        HashMap<String, String> args = new HashMap<String, String>();
        DatabaseSpecification spec = cmd.getSpecification();
        Map typemap = (Map)spec.getProperties().get("ProcedureArgumentMap");
        String typename = (String)typemap.get(ProcedureArgument.getArgumentTypeName(this.type));
        args.put("argument.name", cmd.quote(this.name));
        args.put("argument.type", typename);
        args.put("argument.datatype", spec.getType(this.dtype));
        return args;
    }

    public String getCommand(CreateProcedure cmd) throws DDLException {
        if (this.format == null) {
            throw new DDLException(bundle.getString("EXC_NoFormatSpec"));
        }
        try {
            Map cprops = this.getColumnProperties(cmd);
            return CommandFormatter.format(this.format, cprops);
        }
        catch (Exception e) {
            throw new DDLException(e.getMessage());
        }
    }
}

