/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.impl;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.DatabaseProductNotFoundException;
import org.netbeans.lib.ddl.DatabaseSpecification;
import org.netbeans.lib.ddl.DatabaseSpecificationFactory;
import org.netbeans.lib.ddl.DriverSpecificationFactory;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.impl.SpecificationParser;
import org.openide.util.NbBundle;

public class SpecificationFactory
implements DatabaseSpecificationFactory,
DriverSpecificationFactory {
    private final String dbFile = "org/netbeans/lib/ddl/resources/dbspec.plist";
    private final String drvFile = "org/netbeans/lib/ddl/resources/driverspec.plist";
    private HashMap dbSpecs;
    private HashMap drvSpecs;
    private boolean debug = false;
    private static ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle");

    public SpecificationFactory() throws DDLException {
        SpecificationParser parser;
        InputStream stream;
        ClassLoader cl;
        String fileDB = System.getProperty("db.specifications.file");
        String fileDrv = System.getProperty("driver.specifications.file");
        try {
            if (fileDB == null) {
                cl = this.getClass().getClassLoader();
                stream = cl.getResourceAsStream("org/netbeans/lib/ddl/resources/dbspec.plist");
                if (stream == null) {
                    String message = MessageFormat.format(bundle.getString("EXC_UnableToOpenStream"), "org/netbeans/lib/ddl/resources/dbspec.plist");
                    throw new Exception(message);
                }
                parser = new SpecificationParser(stream);
                this.dbSpecs = parser.getData();
                stream.close();
            } else {
                parser = new SpecificationParser(fileDB);
                this.dbSpecs = parser.getData();
            }
        }
        catch (Exception e) {
            if (fileDB != null) {
                throw new DDLException("unable to read specifications file " + fileDB + ", " + e.getMessage());
            }
            throw new DDLException("unable to read default specifications file, " + e.getMessage());
        }
        try {
            if (fileDrv == null) {
                cl = this.getClass().getClassLoader();
                stream = cl.getResourceAsStream("org/netbeans/lib/ddl/resources/driverspec.plist");
                if (stream == null) {
                    String message = MessageFormat.format(bundle.getString("EXC_UnableToOpenStream"), "org/netbeans/lib/ddl/resources/driverspec.plist");
                    throw new Exception(message);
                }
                parser = new SpecificationParser(stream);
                this.drvSpecs = parser.getData();
                stream.close();
            } else {
                parser = new SpecificationParser(fileDrv);
                this.drvSpecs = parser.getData();
            }
        }
        catch (Exception e) {
            if (fileDrv != null) {
                throw new DDLException("unable to read specifications file " + fileDrv + ", " + e.getMessage());
            }
            throw new DDLException("unable to read default specifications file, " + e.getMessage());
        }
    }

    public Set supportedDatabases() {
        return this.dbSpecs.keySet();
    }

    public boolean isDatabaseSupported(String databaseProductName) {
        return this.dbSpecs.containsKey(databaseProductName);
    }

    public DatabaseSpecification createSpecification(DBConnection dbcon) throws DatabaseProductNotFoundException, DDLException {
        Connection con = dbcon.createJDBCConnection();
        DatabaseSpecification spec = this.createSpecification(dbcon, con);
        try {
            con.close();
        }
        catch (SQLException ex) {
            throw new DDLException(ex.getMessage());
        }
        return spec;
    }

    public DatabaseSpecification createSpecification(DBConnection dbcon, Connection jdbccon) throws DatabaseProductNotFoundException, DDLException {
        String pn = null;
        try {
            boolean close = jdbccon == null;
            Connection con = jdbccon != null ? jdbccon : dbcon.createJDBCConnection();
            DatabaseMetaData dmd = con.getMetaData();
            pn = dmd.getDatabaseProductName().trim();
            DatabaseSpecification spec = this.createSpecification(dbcon, pn, con);
            if (close) {
                con.close();
            }
            return spec;
        }
        catch (SQLException e) {
            throw new DDLException("unable to connect to server");
        }
        catch (Exception e) {
            throw new DatabaseProductNotFoundException(pn, "unable to create specification, " + e.getMessage());
        }
    }

    public DatabaseSpecification createSpecification(DBConnection connection, String databaseProductName, Connection c) throws DatabaseProductNotFoundException {
        HashMap product;
        if (databaseProductName.toUpperCase().startsWith("DB2/")) {
            databaseProductName = "DB2/";
        }
        if ((product = (HashMap)this.dbSpecs.get(databaseProductName)) == null) {
            throw new DatabaseProductNotFoundException(databaseProductName);
        }
        HashMap specmap = this.deepUnion(product, (HashMap)this.dbSpecs.get("GenericDatabaseSystem"), true);
        specmap.put("connection", connection);
        Specification spec = new Specification(specmap, c);
        specmap.put("dbproduct", databaseProductName);
        spec.setSpecificationFactory(this);
        return spec;
    }

    public DatabaseSpecification createSpecification(String databaseProductName, Connection c) throws DatabaseProductNotFoundException {
        HashMap product;
        if (databaseProductName.toUpperCase().startsWith("DB2/")) {
            databaseProductName = "DB2/";
        }
        if ((product = (HashMap)this.dbSpecs.get(databaseProductName)) == null) {
            throw new DatabaseProductNotFoundException(databaseProductName);
        }
        HashMap specmap = this.deepUnion(product, (HashMap)this.dbSpecs.get("GenericDatabaseSystem"), true);
        specmap.put("dbproduct", databaseProductName);
        return new Specification(specmap, c);
    }

    public DatabaseSpecification createSpecification(Connection c) throws DatabaseProductNotFoundException, SQLException {
        return this.createSpecification(c, c.getMetaData().getDatabaseProductName().trim());
    }

    public DatabaseSpecification createSpecification(Connection c, String databaseProductName) throws DatabaseProductNotFoundException {
        HashMap product;
        if (databaseProductName.toUpperCase().startsWith("DB2/")) {
            databaseProductName = "DB2/";
        }
        if ((product = (HashMap)this.dbSpecs.get(databaseProductName)) == null) {
            throw new DatabaseProductNotFoundException(databaseProductName);
        }
        HashMap specmap = this.deepUnion(product, (HashMap)this.dbSpecs.get("GenericDatabaseSystem"), true);
        Specification spec = new Specification(specmap, c);
        spec.setSpecificationFactory(this);
        return spec;
    }

    public boolean isDebugMode() {
        return this.debug;
    }

    public void setDebugMode(boolean mode) {
        this.debug = mode;
    }

    public Set supportedDrivers() {
        return this.drvSpecs.keySet();
    }

    public boolean isDriverSupported(String driverName) {
        return this.drvSpecs.containsKey(driverName);
    }

    public DriverSpecification createDriverSpecification(String driverName) {
        HashMap product = (HashMap)this.drvSpecs.get(driverName);
        if (product == null) {
            product = (HashMap)this.drvSpecs.get("DefaultDriver");
        }
        HashMap specmap = this.deepUnion(product, (HashMap)this.drvSpecs.get("DefaultDriver"), true);
        DriverSpecification spec = new DriverSpecification(specmap);
        spec.setDriverSpecificationFactory(this);
        return spec;
    }

    private HashMap deepClone(HashMap map) {
        HashMap newone = (HashMap)map.clone();
        Iterator it = newone.keySet().iterator();
        while (it.hasNext()) {
            Object newkey = it.next();
            Object deepobj = null;
            Object newobj = newone.get(newkey);
            if (newobj instanceof HashMap) {
                deepobj = this.deepClone((HashMap)newobj);
            } else if (newobj instanceof String) {
                deepobj = new String((String)newobj);
            } else if (newobj instanceof Vector) {
                deepobj = ((Vector)newobj).clone();
            }
            newone.put(newkey, deepobj);
        }
        return newone;
    }

    private HashMap deepUnion(HashMap base, HashMap additional, boolean deep) {
        Iterator it = additional.keySet().iterator();
        while (it.hasNext()) {
            Object addkey = it.next();
            Object addobj = additional.get(addkey);
            if (addkey.equals("TypeMap")) continue;
            if (base.containsKey(addkey)) {
                Object baseobj = base.get(addkey);
                if (!deep || !(baseobj instanceof HashMap) || !(addobj instanceof HashMap)) continue;
                this.deepUnion((HashMap)baseobj, (HashMap)addobj, deep);
                continue;
            }
            if (addobj instanceof HashMap) {
                addobj = this.deepClone((HashMap)addobj);
            } else if (addobj instanceof String) {
                addobj = new String((String)addobj);
            } else if (addobj instanceof Vector) {
                addobj = ((Vector)addobj).clone();
            }
            base.put(addkey, addobj);
        }
        return base;
    }
}

