/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.net.Socket;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.ServerSocketFactory;

public abstract class SSLImplementation {
    private static final String PureTLSImplementationClass = "org.apache.tomcat.util.net.puretls.PureTLSImplementation";
    private static final String JSSEImplementationClass = "org.apache.tomcat.util.net.jsse.JSSEImplementation";
    private static final String[] implementations = new String[]{"org.apache.tomcat.util.net.puretls.PureTLSImplementation", "org.apache.tomcat.util.net.jsse.JSSEImplementation"};

    public static SSLImplementation getInstance() throws ClassNotFoundException {
        int i = 0;
        while (i < implementations.length) {
            try {
                SSLImplementation impl = SSLImplementation.getInstance(implementations[i]);
                return impl;
            }
            catch (Exception e) {
                ++i;
            }
        }
        throw new ClassNotFoundException("Can't find any SSL implementation");
    }

    public static SSLImplementation getInstance(String className) throws ClassNotFoundException {
        if (className == null) {
            return SSLImplementation.getInstance();
        }
        try {
            Class<?> clazz = Class.forName(className);
            return (SSLImplementation)clazz.newInstance();
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Error loading SSL Implementation " + className + " :" + e.toString());
        }
    }

    public abstract String getImplementationName();

    public abstract ServerSocketFactory getServerSocketFactory();

    public abstract SSLSupport getSSLSupport(Socket var1);
}

