/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.puretls;

import COM.claymoresystems.ptls.SSLContext;
import COM.claymoresystems.ptls.SSLException;
import COM.claymoresystems.ptls.SSLServerSocket;
import COM.claymoresystems.ptls.SSLSocket;
import COM.claymoresystems.sslg.SSLPolicyInt;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.tomcat.util.net.ServerSocketFactory;

public class PureTLSSocketFactory
extends ServerSocketFactory {
    static String defaultProtocol = "TLS";
    static boolean defaultClientAuth = false;
    static String defaultKeyStoreFile = "server.pem";
    static String defaultKeyPass = "password";
    static String defaultRootFile = "root.pem";
    static String defaultRandomFile = "random.pem";
    private SSLContext context = null;

    public ServerSocket createSocket(int port) throws IOException {
        this.init();
        return new SSLServerSocket(this.context, port);
    }

    public ServerSocket createSocket(int port, int backlog) throws IOException {
        this.init();
        SSLServerSocket tmp = new SSLServerSocket(this.context, port, backlog);
        return tmp;
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        this.init();
        return new SSLServerSocket(this.context, port, backlog, ifAddress);
    }

    private void init() throws IOException {
        if (this.context != null) {
            return;
        }
        boolean clientAuth = defaultClientAuth;
        try {
            String clientAuthStr;
            String protocol;
            String randomFile;
            String rootFile;
            String keyPass;
            String keyStoreFile = (String)this.attributes.get("keystore");
            if (keyStoreFile == null) {
                keyStoreFile = defaultKeyStoreFile;
            }
            if ((keyPass = (String)this.attributes.get("keypass")) == null) {
                keyPass = defaultKeyPass;
            }
            if ((rootFile = (String)this.attributes.get("rootfile")) == null) {
                rootFile = defaultRootFile;
            }
            if ((randomFile = (String)this.attributes.get("randomfile")) == null) {
                randomFile = defaultRandomFile;
            }
            if ((protocol = (String)this.attributes.get("protocol")) == null) {
                protocol = defaultProtocol;
            }
            if ((clientAuthStr = (String)this.attributes.get("clientauth")) != null) {
                if (clientAuthStr.equals("true")) {
                    clientAuth = true;
                } else if (clientAuthStr.equals("false")) {
                    clientAuth = false;
                } else {
                    throw new IOException("Invalid value '" + clientAuthStr + "' for 'clientauth' parameter:");
                }
            }
            SSLContext tmpContext = new SSLContext();
            if (clientAuth) {
                tmpContext.loadRootCertificates(rootFile);
            }
            tmpContext.loadEAYKeyFile(keyStoreFile, keyPass);
            tmpContext.useRandomnessFile(randomFile, keyPass);
            SSLPolicyInt policy = new SSLPolicyInt();
            policy.requireClientAuth(clientAuth);
            policy.handshakeOnConnect(false);
            policy.waitOnClose(false);
            tmpContext.setPolicy(policy);
            this.context = tmpContext;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public Socket acceptSocket(ServerSocket socket) throws IOException {
        try {
            Socket sock = socket.accept();
            return sock;
        }
        catch (SSLException e) {
            throw new SocketException("SSL handshake error" + e.toString());
        }
    }

    public void handshake(Socket sock) throws IOException {
        ((SSLSocket)sock).handshake();
    }
}

