/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cvsclient.actions;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.cvsclient.FsCommandFactory;
import org.netbeans.modules.cvsclient.NbJavaCvsFileSystem;
import org.netbeans.modules.cvsclient.actions.CallBackCommandAction;
import org.netbeans.modules.cvsclient.actions.JavaCvsActionSupporter;
import org.netbeans.modules.cvsclient.commands.CommandLineParamInput;
import org.netbeans.modules.javacvs.commands.FileSystemCommand;
import org.openide.filesystems.FileObject;

public abstract class DefaultCallBackCommandAction
extends CallBackCommandAction {
    protected int usedUiMode;
    private LinkedList commandList;
    private LinkedList displList;

    public void initCallBack(JavaCvsActionSupporter supporter) {
        super.initCallBack(supporter);
        this.usedUiMode = 0;
        this.commandList = new LinkedList();
        this.displList = new LinkedList();
    }

    public void performCallBack(NbJavaCvsFileSystem fs, FileObject[] fos) {
        if (fs.checkOffLine()) {
            return;
        }
        if (fs.getUiMode() == 1) {
            this.usedUiMode = fs.getUiMode();
        } else if (fs.getUiMode() == 2 && this.usedUiMode == 0) {
            this.usedUiMode = fs.getUiMode();
        }
        if (this.usedUiMode == 0 && this.isSwitched()) {
            this.usedUiMode = 1;
        }
        boolean skipDisplayers = !FsCommandFactory.getFsInstance().showDisplayerWhenLimited(this.getCommandClass()) && fs.getDisplayType() == 2;
        FileSystemCommand comm = FsCommandFactory.getFsInstance().createCommand(this.getCommandClass(), true, fos, fs.createClientProvider());
        fs.prepareCommand(comm);
        this.commandList.add(comm);
        this.displList.add(skipDisplayers ? Boolean.TRUE : Boolean.FALSE);
    }

    protected FileSystemCommand getLastCommandInstance() {
        if (this.commandList != null && this.commandList.size() > 0) {
            return (FileSystemCommand)this.commandList.getLast();
        }
        return null;
    }

    protected List getCommandList() {
        return this.commandList;
    }

    protected List getDisplList() {
        return this.displList;
    }

    public void finishCallBack() {
        if (this.commandList.size() != 0) {
            if (this.usedUiMode == 2) {
                FsCommandFactory.getFsInstance().doShowCustomizerAndRun(this.commandList, new CommandLineParamInput(), this.displList);
                return;
            }
            boolean skipParams = false;
            if (this.usedUiMode == 0) {
                skipParams = true;
            }
            FsCommandFactory.getFsInstance().showCustomizerAndRun(this.commandList, this.displList, skipParams);
        }
        this.clearReferences();
    }

    protected void clearReferences() {
        this.commandList = null;
        this.displList = null;
    }

    protected abstract Class getCommandClass();

    public boolean isSwitchable() {
        return true;
    }
}

