/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cvsclient.caching;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Vector;
import org.netbeans.modules.cvsclient.JavaCvsRuntimeCommandsProvider;
import org.netbeans.modules.cvsclient.JavaCvsSettings;
import org.netbeans.modules.cvsclient.NbJavaCvsFileSystem;
import org.netbeans.modules.cvsclient.NbJavaCvsStatusManager;
import org.netbeans.modules.cvsclient.caching.OfflineRefreshCommand;
import org.netbeans.modules.cvsclient.commands.ErrorLogPanel;
import org.netbeans.modules.cvsclient.commands.JavaCvsRuntimeCommand;
import org.netbeans.modules.javacvs.caching.CvsCacheDir;
import org.netbeans.modules.javacvs.caching.CvsFsCache;
import org.netbeans.modules.javacvs.commands.CvsStatus;
import org.netbeans.modules.javacvs.commands.JavaCvsStatusManager;
import org.netbeans.modules.vcscore.annotation.AnnotationProvider;
import org.netbeans.modules.vcscore.annotation.AnnotationSupport;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.CachedFileSystem;
import org.netbeans.modules.vcscore.runtime.RuntimeCommandsProvider;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public class NbCvsFsCache
extends CvsFsCache {
    private final String MEGABYTE_STRING;
    private final String KILOBYTE_STRING;
    private final String BYTE_STRING;
    static /* synthetic */ Class class$org$netbeans$modules$cvsclient$JavaCvsSettings;
    static /* synthetic */ Class class$org$netbeans$modules$cvsclient$caching$NbCvsFsCache;

    public NbCvsFsCache(AbstractFileSystem fs, File homeDirectory) {
        super(fs, homeDirectory);
        AnnotationSupport.PatternType patternType = AnnotationSupport.getInstance().registerPatternType("JavaCvs");
        if (patternType.getPatternsAsArray().length == 0) {
            JavaCvsSettings settings = (JavaCvsSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$cvsclient$JavaCvsSettings == null ? (class$org$netbeans$modules$cvsclient$JavaCvsSettings = NbCvsFsCache.class$("org.netbeans.modules.cvsclient.JavaCvsSettings")) : class$org$netbeans$modules$cvsclient$JavaCvsSettings), (boolean)true);
            patternType.setStringPattern(settings.getAnnotationPattern());
            patternType.addMultiSynchPattern("fileName", "NotInSynch");
            patternType.addMultiListPattern("status", ",");
            patternType.addMultiEmptyPattern("revision");
            patternType.addMultiEmptyPattern("locker");
            patternType.addMultiEmptyPattern("sticky");
            patternType.addMultiEmptyPattern("attribute");
            patternType.addMultiEmptyPattern("size");
            patternType.addMultiEmptyPattern("date");
            patternType.addMultiEmptyPattern("time");
        }
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$caching$NbCvsFsCache == null ? (class$org$netbeans$modules$cvsclient$caching$NbCvsFsCache = NbCvsFsCache.class$("org.netbeans.modules.cvsclient.caching.NbCvsFsCache")) : class$org$netbeans$modules$cvsclient$caching$NbCvsFsCache));
        this.MEGABYTE_STRING = bundle.getString("LBL_Megabyte_Sign");
        this.KILOBYTE_STRING = bundle.getString("LBL_Kilobyte_Sign");
        this.BYTE_STRING = bundle.getString("LBL_Byte_Sign");
    }

    protected JavaCvsStatusManager getStatusManager() {
        return NbJavaCvsStatusManager.getInstance();
    }

    public String getStatus(String nodeName, Vector importantFiles) {
        File fl;
        String name;
        int currentStrategy = 3;
        String status = "";
        int len = importantFiles.size();
        CacheFile file = null;
        if (len < 1) {
            return this.getStatusManager().getStatus("Unknown");
        }
        if (this.autoRefresh == 1) {
            name = (String)importantFiles.elementAt(0);
            fl = new File(this.fsRootFile.getPath(), name);
            if (fl.getParentFile() != null) {
                fl = fl.getParentFile();
                this.checkDirectoryAutorefresh(fl, false);
            }
        }
        if (len == 1) {
            String stat;
            name = (String)importantFiles.elementAt(0);
            fl = new File(this.fsRootFile.getPath(), name);
            if (fl != null) {
                file = CacheHandler.getInstance().getCacheFile(fl, this.adjustStrategy(currentStrategy), (CachedFileSystem)this);
            }
            if (file != null) {
                AnnotationSupport support = AnnotationSupport.getInstance();
                JavaCvsAnnProvider annProvider = new JavaCvsAnnProvider(file, name);
                stat = support.getStatusAnnotation(nodeName, name, (AnnotationProvider)annProvider, "JavaCvs");
            } else {
                stat = nodeName;
            }
            return stat;
        }
        HashMap<String, CacheFile> cacheFileMap = new HashMap<String, CacheFile>(len);
        ArrayList<String> fileList = new ArrayList<String>(len);
        int i = 0;
        while (i < len) {
            String name1 = (String)importantFiles.elementAt(i);
            File fl2 = new File(this.fsRootFile.getPath(), name1);
            if (fl2 != null) {
                file = CacheHandler.getInstance().getCacheFile(fl2, this.adjustStrategy(currentStrategy), (CachedFileSystem)this);
            }
            if (file != null) {
                cacheFileMap.put(name1, file);
                fileList.add(name1);
            }
            ++i;
        }
        AnnotationSupport support = AnnotationSupport.getInstance();
        JavaCvsAnnProvider annProvider = new JavaCvsAnnProvider(cacheFileMap);
        String stat = support.getStatusAnnotation(nodeName, fileList, (AnnotationProvider)annProvider, "JavaCvs");
        return stat;
    }

    public void doOfflineRefresh(FileObject[] fos, boolean recursive) {
        if (this.cvsfs == null) {
            return;
        }
        NbJavaCvsFileSystem fs = (NbJavaCvsFileSystem)this.cvsfs;
        OfflineRefreshCommand comm = new OfflineRefreshCommand();
        comm.setFileObjects(fos);
        comm.setClientProvider(fs.createClientProvider());
        comm.setRecursive(recursive);
        ErrorLogPanel panel = new ErrorLogPanel(comm, true);
        panel.setCommandDisplayName(comm.getName());
        comm.addDisplayerListener(panel);
        comm.startCommand();
    }

    public void addRefreshDisplayers(CvsStatus comm) {
        if (this.cvsfs == null) {
            return;
        }
        NbJavaCvsFileSystem fs = (NbJavaCvsFileSystem)this.cvsfs;
        ErrorLogPanel panel = new ErrorLogPanel(comm, true);
        if (comm.isRecursive()) {
            panel.setCommandDisplayName(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$caching$NbCvsFsCache == null ? (class$org$netbeans$modules$cvsclient$caching$NbCvsFsCache = NbCvsFsCache.class$("org.netbeans.modules.cvsclient.caching.NbCvsFsCache")) : class$org$netbeans$modules$cvsclient$caching$NbCvsFsCache)).getString("RefreshCommand.label.recursive"));
        } else {
            panel.setCommandDisplayName(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$caching$NbCvsFsCache == null ? (class$org$netbeans$modules$cvsclient$caching$NbCvsFsCache = NbCvsFsCache.class$("org.netbeans.modules.cvsclient.caching.NbCvsFsCache")) : class$org$netbeans$modules$cvsclient$caching$NbCvsFsCache)).getString("RefreshCommand.label.simple"));
        }
        comm.addDisplayerListener(panel);
        JavaCvsRuntimeCommand rCom = fs.prepareCommand(comm);
        rCom.setState(10);
        JavaCvsRuntimeCommandsProvider provider = (JavaCvsRuntimeCommandsProvider)RuntimeCommandsProvider.findProvider((FileSystem)fs);
        if (provider != null) {
            provider.updateCommand(rCom);
        }
    }

    public AnnotationProvider getAnnotationProvider(String path) {
        File fl = new File(this.fsRootFile.getPath(), path);
        CacheFile file = null;
        if (fl != null) {
            file = CacheHandler.getInstance().getCacheFile(fl, 3, (CachedFileSystem)this);
        }
        if (file != null) {
            JavaCvsAnnProvider annProvider = new JavaCvsAnnProvider(file, path);
            return annProvider;
        }
        return null;
    }

    private String formatSize(long size) {
        double megs = (double)size / 1048576.0;
        if (megs > 1.0) {
            long megsLong = Math.round(megs * 100.0);
            double flMegs = (double)megsLong / 100.0;
            return Double.toString(flMegs) + this.MEGABYTE_STRING;
        }
        double kbytes = (double)size / 1024.0;
        if (kbytes > 1.0) {
            long kbytesLong = Math.round(kbytes * 100.0);
            double flKbytes = (double)kbytesLong / 100.0;
            return Double.toString(flKbytes) + this.KILOBYTE_STRING;
        }
        return Long.toString(size, 0) + this.BYTE_STRING;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class JavaCvsAnnProvider
    implements AnnotationProvider {
        private HashMap cacheFilesMap;
        private ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$caching$NbCvsFsCache == null ? (class$org$netbeans$modules$cvsclient$caching$NbCvsFsCache = JavaCvsAnnProvider.class$("org.netbeans.modules.cvsclient.caching.NbCvsFsCache")) : class$org$netbeans$modules$cvsclient$caching$NbCvsFsCache));
        static /* synthetic */ Class class$org$netbeans$modules$cvsclient$caching$NbCvsFsCache;

        public JavaCvsAnnProvider(CacheFile cacheFile, String name) {
            this.cacheFilesMap = new HashMap();
            this.cacheFilesMap.put(name, cacheFile);
        }

        public JavaCvsAnnProvider(HashMap filesMap) {
            this.cacheFilesMap = filesMap;
        }

        public String getAttributeValue(String fileName, String attributeName) {
            CacheFile file = (CacheFile)this.cacheFilesMap.get(fileName);
            boolean isDir = false;
            if (file instanceof CvsCacheDir) {
                isDir = true;
            }
            if (file != null) {
                if (attributeName.equals("status")) {
                    String status = NbCvsFsCache.this.getStatusManager().getStatus(file.getStatus());
                    if (status.trim().length() == 0) {
                        return null;
                    }
                    return status;
                }
                if (attributeName.equals("revision")) {
                    return file.getRevision();
                }
                if (attributeName.equals("fileName")) {
                    return file.getName();
                }
                if (attributeName.equals("sticky")) {
                    if (isDir) {
                        CvsCacheDir dir = (CvsCacheDir)file;
                        File tagFile = new File(dir.getAbsolutePath(), "CVS/Tag");
                        if (tagFile.exists()) {
                            String tag;
                            try {
                                BufferedReader read = new BufferedReader(new FileReader(tagFile));
                                tag = read.readLine();
                                tag = tag.substring(1);
                                read.close();
                            }
                            catch (Exception e) {
                                tag = null;
                            }
                            dir.setSticky(tag);
                            return tag;
                        }
                        dir.setSticky(null);
                        return null;
                    }
                    return file.getSticky();
                }
                if (attributeName.equals("date")) {
                    return file.getDate();
                }
                if (attributeName.equals("attribute")) {
                    return file.getAttr();
                }
                if (attributeName.equals("locker")) {
                    return file.getLocker();
                }
                if (attributeName.equals("size")) {
                    if (!isDir) {
                        File fil = new File(file.getParent().getAbsolutePath(), file.getName());
                        if (fil.exists()) {
                            return NbCvsFsCache.this.formatSize(fil.length());
                        }
                        return this.bundle.getString("NbCvsFsCache.isOfVirtualSize");
                    }
                    return "";
                }
                if (attributeName.equals("time")) {
                    return file.getTime();
                }
            }
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

