/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cvsclient.commands;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.modules.javacvs.util.Debug;
import org.netbeans.modules.vcscore.util.table.ColumnSortListener;
import org.netbeans.modules.vcscore.util.table.FileComparator;
import org.netbeans.modules.vcscore.util.table.TableInfoComparator;
import org.netbeans.modules.vcscore.util.table.TableInfoModel;
import org.openide.awt.SplittedPanel;
import org.openide.util.NbBundle;

public abstract class AbstractTreeInfoPanel
extends JPanel
implements TreeCellRenderer {
    private Debug E;
    private Debug D;
    protected String DEFAULT_FOLDER;
    protected String DEFAULT_OPEN_FOLDER;
    protected String DEFAULT_FILE;
    protected File topDirectory;
    private ArrayList files;
    private ArrayList filesBackup;
    protected TreeCellRenderer insideTreeRenderer;
    private boolean treeDisabled;
    private JPanel pnlStatus;
    private JPanel pnlTree;
    private JPanel pnlButtons;
    private JTabbedPane jTabbedPane1;
    private JScrollPane jScrollPane1;
    private JTree trDirStructure;
    private JScrollPane jScrollPane2;
    private SplittedPanel split;
    protected JTable tblTable;
    static /* synthetic */ Class class$org$netbeans$modules$cvsclient$commands$AbstractTreeInfoPanel;
    static /* synthetic */ Class class$org$netbeans$lib$cvsclient$command$FileInfoContainer;

    public AbstractTreeInfoPanel(File topDir) {
        this();
        this.topDirectory = topDir;
        this.insideTreeRenderer = new DefaultTreeCellRenderer();
        this.trDirStructure.setCellRenderer(this);
        this.trDirStructure.putClientProperty("JTree.lineStyle", "Angled");
        this.treeDisabled = false;
    }

    public void postInit() {
        this.pnlStatus.add((Component)this.initPanel(), "Center");
        this.split.setSplitDragable(true);
        this.split.setSplitAbsolute(false);
        this.split.setSplitTypeChangeEnabled(true);
        this.split.setSplitPosition(30);
    }

    public AbstractTreeInfoPanel() {
        this.D = this.E = new Debug("AbstractTreeInfoPanel", true);
        this.DEFAULT_FOLDER = "/org/openide/resources/defaultFolder.gif";
        this.DEFAULT_OPEN_FOLDER = "/org/openide/resources/defaultFolderOpen.gif";
        this.DEFAULT_FILE = "/org/openide/resources/defaultNode.gif";
        this.initComponents();
        this.split = new SplittedPanel();
        this.split.add((Component)this.initTree(), SplittedPanel.ADD_LEFT);
        this.split.add((Component)this.initRightPanel(), SplittedPanel.ADD_RIGHT);
        this.add((Component)this.split, "Center");
        this.tblTable.setSelectionMode(0);
        this.tblTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                AbstractTreeInfoPanel.this.tblTableValueChanged(e);
            }
        });
        this.treeDisabled = true;
    }

    private JComponent initTree() {
        this.pnlTree = new JPanel();
        this.pnlButtons = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.trDirStructure = new JTree();
        this.jScrollPane2 = new JScrollPane();
        this.tblTable = new JTable();
        this.pnlTree.setLayout(new BorderLayout());
        this.pnlTree.setPreferredSize(new Dimension(200, 300));
        this.pnlTree.setMinimumSize(new Dimension(200, 300));
        this.pnlButtons.setLayout(new BoxLayout(this.pnlButtons, 0));
        this.pnlTree.add((Component)this.pnlButtons, "North");
        this.jTabbedPane1.setTabPlacement(3);
        this.jTabbedPane1.setPreferredSize(new Dimension(500, 400));
        this.jScrollPane1.setMinimumSize(new Dimension(100, 70));
        this.jScrollPane1.setVerticalScrollBar(new JScrollBar(1));
        this.jScrollPane1.setHorizontalScrollBar(new JScrollBar(0));
        this.trDirStructure.setShowsRootHandles(true);
        this.trDirStructure.setMinimumSize(new Dimension(80, 60));
        this.trDirStructure.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                AbstractTreeInfoPanel.this.trDirStructureValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.trDirStructure);
        String treeTitle = NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$AbstractTreeInfoPanel == null ? (class$org$netbeans$modules$cvsclient$commands$AbstractTreeInfoPanel = AbstractTreeInfoPanel.class$("org.netbeans.modules.cvsclient.commands.AbstractTreeInfoPanel")) : class$org$netbeans$modules$cvsclient$commands$AbstractTreeInfoPanel)).getString("AbstractTreeInfoPanel.treeTitle");
        this.jTabbedPane1.addTab(treeTitle, this.jScrollPane1);
        this.tblTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}){
            Class[] types = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = 3.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = 3.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = 3.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = 3.class$("java.lang.Object")) : class$java$lang$Object};
            static /* synthetic */ Class class$java$lang$Object;

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        this.jScrollPane2.setViewportView(this.tblTable);
        String tableTitle = NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$AbstractTreeInfoPanel == null ? (class$org$netbeans$modules$cvsclient$commands$AbstractTreeInfoPanel = AbstractTreeInfoPanel.class$("org.netbeans.modules.cvsclient.commands.AbstractTreeInfoPanel")) : class$org$netbeans$modules$cvsclient$commands$AbstractTreeInfoPanel)).getString("AbstractTreeInfoPanel.tableTitle");
        this.jTabbedPane1.addTab(tableTitle, this.jScrollPane2);
        this.pnlTree.add((Component)this.jTabbedPane1, "Center");
        return this.pnlTree;
    }

    public JComponent initRightPanel() {
        this.pnlStatus = new JPanel();
        this.pnlStatus.setLayout(new BorderLayout());
        return this.pnlStatus;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private void lstTableValueChanged(ListSelectionEvent evt) {
    }

    private void tblTableValueChanged(ListSelectionEvent evt) {
        int index = this.tblTable.getSelectedRow();
        TableInfoModel model = (TableInfoModel)this.tblTable.getModel();
        FileInfoContainer info = (FileInfoContainer)model.getElementAt(index);
        if (info != null) {
            this.setPanel(info);
        } else {
            this.setClearPanel();
        }
    }

    private void trDirStructureValueChanged(TreeSelectionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)evt.getPath().getLastPathComponent();
        Object userObj = node.getUserObject();
        if (userObj instanceof File) {
            this.setClearPanel();
        } else {
            this.setPanel(userObj);
        }
    }

    private void dirStructureValueChanged(TreeSelectionEvent evt) {
    }

    protected void disableTree() {
        this.treeDisabled = true;
        this.jTabbedPane1.remove(this.jScrollPane1);
        this.repaint();
    }

    protected boolean isTreeDisabled() {
        return this.treeDisabled;
    }

    protected JPanel getButtonPanel() {
        return this.pnlButtons;
    }

    protected void recreateModel() {
        this.files = new ArrayList(this.filesBackup);
        this.tblTable.clearSelection();
        TableInfoModel model = (TableInfoModel)this.createTable();
        this.tblTable.setModel((TableModel)model);
        if (!this.isTreeDisabled()) {
            this.trDirStructure.setModel(new DefaultTreeModel(this.createTree(this.topDirectory)));
        }
    }

    protected abstract void setPanel(Object var1);

    protected abstract void setClearPanel();

    protected abstract JComponent initPanel();

    protected TableInfoModel createTableModel() {
        TableInfoModel model = new TableInfoModel();
        Class classa = class$org$netbeans$lib$cvsclient$command$FileInfoContainer == null ? (class$org$netbeans$lib$cvsclient$command$FileInfoContainer = AbstractTreeInfoPanel.class$("org.netbeans.lib.cvsclient.command.FileInfoContainer")) : class$org$netbeans$lib$cvsclient$command$FileInfoContainer;
        String column1 = NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$AbstractTreeInfoPanel == null ? (class$org$netbeans$modules$cvsclient$commands$AbstractTreeInfoPanel = AbstractTreeInfoPanel.class$("org.netbeans.modules.cvsclient.commands.AbstractTreeInfoPanel")) : class$org$netbeans$modules$cvsclient$commands$AbstractTreeInfoPanel)).getString("TableInfoModel.fileName");
        try {
            Method method1 = classa.getMethod("getFile", null);
            model.setColumnDefinition(0, column1, method1, true, (TableInfoComparator)new FileComparator());
        }
        catch (NoSuchMethodException exc) {
            Thread.dumpStack();
        }
        catch (SecurityException exc2) {
            Thread.dumpStack();
        }
        return model;
    }

    private DefaultMutableTreeNode createTree(File root) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(root);
        this.recursiveTreeNodes(rootNode);
        this.addFiles(rootNode);
        return rootNode;
    }

    private TableModel createTable() {
        TableInfoModel model = this.createTableModel();
        Iterator it = ((AbstractList)this.files).iterator();
        while (it.hasNext()) {
            FileInfoContainer info = (FileInfoContainer)it.next();
            if (!this.addToList(info)) continue;
            model.addElement((Object)info);
        }
        return model;
    }

    private void recursiveTreeNodes(DefaultMutableTreeNode parent) {
        File parentFile = (File)parent.getUserObject();
        boolean hasChild = false;
        File[] list = parentFile.listFiles();
        int index = 0;
        while (index < list.length) {
            File childFile;
            if (list[index].isDirectory() && list[index].exists() && !(childFile = list[index]).getName().equals("CVS")) {
                hasChild = true;
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(new File(childFile.getAbsolutePath()));
                parent.add(child);
                this.recursiveTreeNodes(child);
            }
            ++index;
        }
    }

    private void addFiles(DefaultMutableTreeNode parent) {
        if (parent.getChildCount() > 0) {
            Enumeration<TreeNode> enumeration = parent.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode childDir = (DefaultMutableTreeNode)enumeration.nextElement();
                this.addFiles(childDir);
            }
        }
        if (this.files == null) {
            return;
        }
        Iterator it = ((AbstractList)this.files).iterator();
        File parFile = (File)parent.getUserObject();
        String parPath = parFile.getAbsolutePath();
        while (it.hasNext()) {
            FileInfoContainer info = (FileInfoContainer)it.next();
            String path = info.getFile().getParentFile().getAbsolutePath();
            if (!path.equals(parPath)) continue;
            this.addFileNode(info, parent);
            it.remove();
        }
    }

    protected void addFileNode(FileInfoContainer info, DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(info);
        parent.add(child);
    }

    protected boolean addToList(FileInfoContainer info) {
        return true;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component comp = this.insideTreeRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (comp instanceof JLabel) {
            Object userObj;
            JLabel label = (JLabel)comp;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node != null && (userObj = node.getUserObject()) != null) {
                if (userObj instanceof File) {
                    label.setText(((File)userObj).getName());
                    if (!expanded) {
                        URL url1 = this.getClass().getResource(this.DEFAULT_FOLDER);
                        label.setIcon(new ImageIcon(url1));
                    } else {
                        URL url2 = this.getClass().getResource(this.DEFAULT_OPEN_FOLDER);
                        label.setIcon(new ImageIcon(url2));
                    }
                } else if (userObj instanceof FileInfoContainer) {
                    FileInfoContainer info = (FileInfoContainer)userObj;
                    label.setText(info.getFile().getName());
                    URL url3 = this.getClass().getResource(this.DEFAULT_FILE);
                    label.setIcon(new ImageIcon(url3));
                }
            }
        }
        return comp;
    }

    public void setDataToDisplay(Collection resultList) {
        this.filesBackup = new ArrayList(resultList);
        this.recreateModel();
        JTableHeader head = this.tblTable.getTableHeader();
        head.setUpdateTableInRealTime(true);
        ColumnSortListener listen = new ColumnSortListener(this.tblTable);
        head.addMouseListener((MouseListener)listen);
    }

    public void displayOutputData(int moment, Object data) {
    }

    public void closeNotify() {
        this.files = null;
        this.filesBackup = null;
        if (this.tblTable.getModel() instanceof TableInfoModel) {
            TableInfoModel model = (TableInfoModel)this.tblTable.getModel();
            model.clear();
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.trDirStructure.getModel().getRoot();
        root.setUserObject(null);
        Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            node.setUserObject(null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

