/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cvsclient.commands;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import org.netbeans.lib.cvsclient.command.BuildableCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.event.CVSAdapter;
import org.netbeans.lib.cvsclient.event.EnhancedMessageEvent;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.modules.cvsclient.IndependantClient;
import org.netbeans.modules.cvsclient.JavaCvsRuntimeCommandsProvider;
import org.netbeans.modules.cvsclient.commands.CommandLineInfoPanel;
import org.netbeans.modules.cvsclient.commands.DisplayerOutputViewAction;
import org.netbeans.modules.cvsclient.commands.RuntimeCommandDisplayer;
import org.netbeans.modules.javacvs.commands.FileSystemCommand;
import org.netbeans.modules.javacvs.commands.FsGlobalOptionsImpl;
import org.netbeans.modules.javacvs.events.CommandDisplayerListener;
import org.netbeans.modules.javacvs.events.CommandErrorEvent;
import org.netbeans.modules.javacvs.events.CommandErrorListener;
import org.netbeans.modules.javacvs.events.ServerErrorException;
import org.netbeans.modules.vcscore.runtime.CommandOutputViewAction;
import org.netbeans.modules.vcscore.runtime.KillRunningCommandAction;
import org.netbeans.modules.vcscore.runtime.RuntimeCommand;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class JavaCvsRuntimeCommand
extends RuntimeCommand
implements CommandDisplayerListener,
CommandErrorListener {
    private FileSystemCommand command;
    private JavaCvsRuntimeCommandsProvider provider;
    private boolean isError;
    private File outputTempFile;
    private PrintWriter writer;
    private boolean isRefresh;
    private LinkedList commandList;
    private int state;
    private boolean started;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$caching$RefreshCommand;
    static /* synthetic */ Class class$org$netbeans$modules$cvsclient$commands$JavaCvsRuntimeCommand;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$netbeans$lib$cvsclient$event$EnhancedMessageEvent;
    static /* synthetic */ Class class$org$netbeans$modules$cvsclient$FsCommandFactory;

    public JavaCvsRuntimeCommand(FileSystemCommand comm, JavaCvsRuntimeCommandsProvider provider) {
        this.command = comm;
        this.state = 12;
        this.provider = provider;
        this.isError = false;
        this.started = false;
        this.isRefresh = comm.getClass().equals(class$org$netbeans$modules$javacvs$caching$RefreshCommand == null ? (class$org$netbeans$modules$javacvs$caching$RefreshCommand = JavaCvsRuntimeCommand.class$("org.netbeans.modules.javacvs.caching.RefreshCommand")) : class$org$netbeans$modules$javacvs$caching$RefreshCommand);
    }

    public String getName() {
        return this.command.getName();
    }

    public String getDisplayName() {
        return this.createDisplayName(this.command.getCVSCommand());
    }

    public int getExitStatus() {
        if (this.command.isStopped()) {
            return 2;
        }
        if (this.isError) {
            return 1;
        }
        return 0;
    }

    public void openCommandOutputDisplay() {
        if (this.outputTempFile != null && !this.command.isRunning()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JavaCvsRuntimeCommand.this.showOutputPanel();
                }
            });
        }
    }

    private void showOutputPanel() {
        BufferedReader reader;
        try {
            reader = new BufferedReader(new FileReader(this.outputTempFile));
        }
        catch (FileNotFoundException fnfex) {
            ErrorManager.getDefault().notify((Throwable)fnfex);
            return;
        }
        final CommandLineInfoPanel panel = new CommandLineInfoPanel(this.command);
        panel.showStartCommand();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                boolean finishedOK = true;
                try {
                    try {
                        String line = reader.readLine();
                        while (line != null) {
                            if (line.startsWith("W")) {
                                finishedOK = false;
                                break;
                            }
                            boolean isKError = false;
                            if (line.length() < 2 || line.startsWith("C") || line.startsWith("X")) {
                                line = reader.readLine();
                                continue;
                            }
                            if (line.startsWith("E")) {
                                isKError = true;
                            }
                            MessageEvent event = new MessageEvent(this, line.substring(2), isKError);
                            if (line.startsWith("T")) {
                                event.setTagged(true);
                            }
                            panel.messageGenerated(event);
                            line = reader.readLine();
                        }
                    }
                    catch (IOException exc) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Exception exception) {
                            }
                        }
                        Object var6_8 = null;
                        if (panel == null) return;
                        if (finishedOK) {
                            panel.showFinishedCommand();
                            return;
                        }
                        panel.showExecutionFailed(new ServerErrorException());
                        return;
                    }
                    Object var6_7 = null;
                    if (panel == null) return;
                    if (finishedOK) {
                        panel.showFinishedCommand();
                        return;
                    }
                    panel.showExecutionFailed(new ServerErrorException());
                    return;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    if (panel == null) throw throwable;
                    if (finishedOK) {
                        panel.showFinishedCommand();
                        throw throwable;
                    }
                    panel.showExecutionFailed(new ServerErrorException());
                    throw throwable;
                }
            }
        });
    }

    public Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        sheet.put(set);
        set.setValue("helpID", (class$org$netbeans$modules$cvsclient$commands$JavaCvsRuntimeCommand == null ? (class$org$netbeans$modules$cvsclient$commands$JavaCvsRuntimeCommand = JavaCvsRuntimeCommand.class$("org.netbeans.modules.cvsclient.commands.JavaCvsRuntimeCommand")) : class$org$netbeans$modules$cvsclient$commands$JavaCvsRuntimeCommand).getName() + "_properties");
        Sheet.Set switchesSet = Sheet.createPropertiesSet();
        switchesSet.setName(this.g("CTL_SwitchesSheet"));
        switchesSet.setDisplayName(this.g("CTL_SwitchesSheet"));
        switchesSet.setValue("helpID", (class$org$netbeans$modules$cvsclient$commands$JavaCvsRuntimeCommand == null ? (class$org$netbeans$modules$cvsclient$commands$JavaCvsRuntimeCommand = JavaCvsRuntimeCommand.class$("org.netbeans.modules.cvsclient.commands.JavaCvsRuntimeCommand")) : class$org$netbeans$modules$cvsclient$commands$JavaCvsRuntimeCommand).getName() + "_switches");
        Sheet.Set globalSet = Sheet.createPropertiesSet();
        globalSet.setName(this.g("CTL_GlobalSwitchesSheet"));
        globalSet.setDisplayName(this.g("CTL_GlobalSwitchesSheet"));
        globalSet.setValue("helpID", (class$org$netbeans$modules$cvsclient$commands$JavaCvsRuntimeCommand == null ? (class$org$netbeans$modules$cvsclient$commands$JavaCvsRuntimeCommand = JavaCvsRuntimeCommand.class$("org.netbeans.modules.cvsclient.commands.JavaCvsRuntimeCommand")) : class$org$netbeans$modules$cvsclient$commands$JavaCvsRuntimeCommand).getName() + "_global");
        this.createSwitchProperties(this.command.getImpl(), switchesSet);
        this.createSwitchProperties(new FsGlobalOptionsImpl(this.command.getGlobalOptions()), globalSet);
        sheet.put(switchesSet);
        sheet.put(globalSet);
        this.createProperties(set);
        return sheet;
    }

    private void createProperties(Sheet.Set set) {
        set.put((Node.Property)new PropertySupport.ReadOnly("name", class$java$lang$String == null ? (class$java$lang$String = JavaCvsRuntimeCommand.class$("java.lang.String")) : class$java$lang$String, this.g("CTL_Name"), ""){

            public Object getValue() {
                return JavaCvsRuntimeCommand.this.command.getName();
            }
        });
        set.put((Node.Property)new PropertySupport.ReadOnly("files", class$java$lang$String == null ? (class$java$lang$String = JavaCvsRuntimeCommand.class$("java.lang.String")) : class$java$lang$String, this.g("CTL_Files"), ""){

            public Object getValue() {
                String localPath = JavaCvsRuntimeCommand.this.command.getClientProvider().getLocalPath();
                File[] flz = JavaCvsRuntimeCommand.this.command.getFiles();
                if (flz == null) {
                    return "";
                }
                String[] files = new String[flz.length];
                int i = 0;
                while (i < files.length) {
                    files[i] = flz[i].length() == (long)localPath.length() ? "." : flz[i].getName();
                    ++i;
                }
                return VcsUtilities.array2stringNl((String[])files);
            }
        });
        set.put((Node.Property)new PropertySupport.ReadOnly("status", class$java$lang$String == null ? (class$java$lang$String = JavaCvsRuntimeCommand.class$("java.lang.String")) : class$java$lang$String, this.g("CTL_Status"), ""){

            public Object getValue() {
                if (JavaCvsRuntimeCommand.this.command.isRunning()) {
                    return JavaCvsRuntimeCommand.this.g("CTL_Status_Running");
                }
                if (JavaCvsRuntimeCommand.this.isError) {
                    return JavaCvsRuntimeCommand.this.g("CTL_Status_Error");
                }
                return JavaCvsRuntimeCommand.this.g("CTL_Status_Done");
            }
        });
    }

    private void createSwitchProperties(Object bean, Sheet.Set set) {
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException exc) {
            return;
        }
        PropertyDescriptor[] descs = info.getPropertyDescriptors();
        Node.Property[] props = new Node.Property[descs.length];
        int i = 0;
        while (i < descs.length) {
            props[i] = new SwitchReadOnlyProperty(descs[i], bean);
            ++i;
        }
        set.put(props);
    }

    private String g(String name) {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$JavaCvsRuntimeCommand == null ? (class$org$netbeans$modules$cvsclient$commands$JavaCvsRuntimeCommand = JavaCvsRuntimeCommand.class$("org.netbeans.modules.cvsclient.commands.JavaCvsRuntimeCommand")) : class$org$netbeans$modules$cvsclient$commands$JavaCvsRuntimeCommand)).getString(name);
    }

    public SystemAction[] getActions() {
        if (this.started) {
            if (!this.isRefresh && !this.command.isRunning()) {
                return new SystemAction[]{CommandOutputViewAction.getInstance(), DisplayerOutputViewAction.getInstance(), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = JavaCvsRuntimeCommand.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
            }
            if (this.isRefresh && !this.command.isRunning()) {
                return new SystemAction[]{CommandOutputViewAction.getInstance(), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = JavaCvsRuntimeCommand.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
            }
            if (this.command.isRunning() && !this.command.isStopped()) {
                return new SystemAction[]{KillRunningCommandAction.getInstance(), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = JavaCvsRuntimeCommand.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
            }
        }
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = JavaCvsRuntimeCommand.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    public void killCommand() {
        this.command.hardCommandStop();
    }

    public String getId() {
        return Integer.toString(this.hashCode());
    }

    public void showBeforeEachExecute(Command currentCommand) {
        if (this.writer != null) {
            this.writer.println("C " + currentCommand.getCVSCommand());
            this.commandList.add(currentCommand);
        }
    }

    public void showFinishedCommand() {
        this.finishCommand();
    }

    private void finishCommand() {
        this.setState(12);
        this.provider.updateCommand(this);
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
        }
    }

    public void showStartCommand() {
        this.started = true;
        this.setState(11);
        this.provider.updateCommand(this);
        try {
            this.outputTempFile = this.createTempFile();
            this.commandList = new LinkedList();
            this.writer = new PrintWriter(new FileOutputStream(this.outputTempFile));
        }
        catch (IOException exc) {
            this.writer = null;
            this.outputTempFile = null;
        }
    }

    public void showAfterEachExecute() {
    }

    public void messageGenerated(MessageEvent message) {
        if (this.writer != null) {
            if (message.getClass().equals(class$org$netbeans$lib$cvsclient$event$EnhancedMessageEvent == null ? (class$org$netbeans$lib$cvsclient$event$EnhancedMessageEvent = JavaCvsRuntimeCommand.class$("org.netbeans.lib.cvsclient.event.EnhancedMessageEvent")) : class$org$netbeans$lib$cvsclient$event$EnhancedMessageEvent)) {
                EnhancedMessageEvent enhMessage = (EnhancedMessageEvent)message;
                if (enhMessage.getKey().equals("Merged_Response_File_Path")) {
                    this.writer.println("X " + enhMessage.getValue().toString());
                }
                return;
            }
            if (message.isTagged()) {
                this.writer.println("T " + message.getMessage());
                return;
            }
            if (message.isError()) {
                this.writer.println("E " + message.getMessage());
            } else {
                this.writer.println("M " + message.getMessage());
            }
        }
    }

    public void showExecutionFailed(Exception exception) {
        this.isError = true;
        if (this.writer != null) {
            this.writer.println("W");
        }
        this.finishCommand();
    }

    public void errorGenerated(CommandErrorEvent event) {
        this.isError = event.endedWithError();
    }

    public void showFileInfoGenerated(FileInfoContainer info) {
    }

    private String createDisplayName(String newVal) {
        newVal = newVal.replace('\n', ' ');
        int firstOcc = newVal.indexOf(34);
        int lastOcc = newVal.lastIndexOf(34);
        if (lastOcc > firstOcc && lastOcc - firstOcc > 10) {
            String fin = newVal.substring(0, firstOcc + 6);
            String fin2 = newVal.substring(lastOcc, newVal.length());
            newVal = fin + "..." + fin2;
        }
        return newVal;
    }

    private File createTempFile() {
        File tempFile;
        long tmpId;
        String TMP_ROOT = System.getProperty("netbeans.user") + File.separator + "system" + File.separator + "javacvs" + File.separator + "tmp";
        File tmpDir = new File(TMP_ROOT);
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        do {
            tmpId = 10000L * (1L + Math.round(Math.random() * 8.0)) + Math.round(Math.random() * 1000.0);
        } while (new File(TMP_ROOT + File.separator + "tmp" + tmpId).exists());
        String tempFileName = TMP_ROOT + File.separator + "tmp" + tmpId;
        try {
            tempFile = File.createTempFile("tmp" + tmpId, "", tmpDir);
        }
        catch (IOException exc) {
            tempFile = new File(tempFileName);
        }
        tempFile.deleteOnExit();
        return tempFile;
    }

    public void displayInGraphics() {
        CommandDisplayerListener disp = null;
        String methodName = this.command.getClass().getName();
        int ind = methodName.lastIndexOf(46);
        methodName = "add" + methodName.substring(ind + 1) + "Displayer";
        IndependantClient client = (IndependantClient)this.command.getClientProvider();
        int dispType = client.getDisplayType();
        try {
            Object var8_8;
            try {
                Method metoda = (class$org$netbeans$modules$cvsclient$FsCommandFactory == null ? (class$org$netbeans$modules$cvsclient$FsCommandFactory = JavaCvsRuntimeCommand.class$("org.netbeans.modules.cvsclient.FsCommandFactory")) : class$org$netbeans$modules$cvsclient$FsCommandFactory).getDeclaredMethod(methodName, this.command.getClass());
                client.setDisplayType(1);
                disp = (CommandDisplayerListener)metoda.invoke((Object)(class$org$netbeans$modules$cvsclient$FsCommandFactory == null ? (class$org$netbeans$modules$cvsclient$FsCommandFactory = JavaCvsRuntimeCommand.class$("org.netbeans.modules.cvsclient.FsCommandFactory")) : class$org$netbeans$modules$cvsclient$FsCommandFactory), this.command);
            }
            catch (Exception exc) {
                Thread.dumpStack();
                var8_8 = null;
                client.setDisplayType(dispType);
            }
            var8_8 = null;
            client.setDisplayType(dispType);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            client.setDisplayType(dispType);
            throw throwable;
        }
        if (disp != null) {
            if (disp instanceof RuntimeCommandDisplayer) {
                RuntimeCommandDisplayer rDisp = (RuntimeCommandDisplayer)((Object)disp);
                rDisp.setRunInRuntime(true);
            }
            BufferedReader reader = null;
            Iterator it = this.commandList.iterator();
            StringBuffer taggedBuffer = new StringBuffer();
            final CommandDisplayerListener panel = disp;
            Builder build = null;
            try {
                try {
                    reader = new BufferedReader(new FileReader(this.outputTempFile));
                    String line = reader.readLine();
                    panel.showStartCommand();
                    EventManager eventManager = new EventManager();
                    eventManager.addCVSListener(new CVSAdapter(){

                        public void fileInfoGenerated(FileInfoEvent e) {
                            panel.showFileInfoGenerated(e.getInfoContainer());
                        }
                    });
                    boolean starting = true;
                    while (line != null) {
                        boolean isKError = false;
                        if (line.length() < 2) {
                            line = reader.readLine();
                            continue;
                        }
                        if (line.startsWith("C")) {
                            if (!starting) {
                                build.outputDone();
                                disp.showAfterEachExecute();
                            }
                            if (it.hasNext()) {
                                BuildableCommand cm = (BuildableCommand)it.next();
                                disp.showBeforeEachExecute(cm);
                                build = cm.createBuilder(eventManager);
                            }
                            starting = false;
                        } else if (line.startsWith("X")) {
                            if (build != null) {
                                build.parseEnhancedMessage("Merged_Response_File_Path", line.substring(2));
                            }
                        } else {
                            if (line.startsWith("E")) {
                                isKError = true;
                            }
                            MessageEvent event = new MessageEvent(this, line.substring(2), isKError);
                            String buildLine = null;
                            if (line.startsWith("T")) {
                                event.setTagged(true);
                                buildLine = MessageEvent.parseTaggedMessage(taggedBuffer, line.substring(2));
                            } else if (!line.startsWith("W")) {
                                buildLine = line.substring(2);
                            }
                            panel.messageGenerated(event);
                            if (buildLine != null) {
                                build.parseLine(buildLine, isKError);
                                taggedBuffer = new StringBuffer("");
                            }
                        }
                        line = reader.readLine();
                    }
                }
                catch (Exception exc) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {
                        }
                    }
                    Object var18_23 = null;
                    if (panel != null) {
                        if (build != null) {
                            build.outputDone();
                        }
                        panel.showAfterEachExecute();
                        panel.showFinishedCommand();
                    }
                }
                Object var18_22 = null;
                if (panel != null) {
                    if (build != null) {
                        build.outputDone();
                    }
                    panel.showAfterEachExecute();
                    panel.showFinishedCommand();
                }
            }
            catch (Throwable throwable) {
                Object var18_24 = null;
                if (panel != null) {
                    if (build != null) {
                        build.outputDone();
                    }
                    panel.showAfterEachExecute();
                    panel.showFinishedCommand();
                }
                throw throwable;
            }
        }
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
        this.firePropertyChange("state", null, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SwitchReadOnlyProperty
    extends PropertySupport.ReadOnly {
        private Object value;
        private Class editorClass;

        public SwitchReadOnlyProperty(PropertyDescriptor desc, Object obj) {
            super(desc.getName(), desc.getPropertyType(), desc.getDisplayName(), desc.getShortDescription());
            this.editorClass = desc.getPropertyEditorClass();
            try {
                Method meth = desc.getReadMethod();
                this.value = meth.invoke(obj, null);
            }
            catch (Exception exc) {
                this.value = null;
            }
            if (this.value == null && this.getValueType().isArray()) {
                this.value = Array.newInstance(this.getValueType().getComponentType(), 0);
            }
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editorClass != null) {
                try {
                    return (PropertyEditor)this.editorClass.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return super.getPropertyEditor();
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.value;
        }
    }
}

