/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cvsclient.commands.diff;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.command.PipedFileInformation;
import org.netbeans.lib.cvsclient.command.diff.DiffCommand;
import org.netbeans.lib.cvsclient.command.diff.DiffInformation;
import org.netbeans.lib.cvsclient.command.status.StatusCommand;
import org.netbeans.lib.cvsclient.command.status.StatusInformation;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.cvsclient.IndependantClient;
import org.netbeans.modules.cvsclient.commands.diff.BinaryFilesWarning;
import org.netbeans.modules.cvsclient.commands.diff.DiffDisplayer;
import org.netbeans.modules.javacvs.commands.CvsDiff;
import org.netbeans.modules.javacvs.events.CommandDisplayerAdapter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class DiffCommandDisplayer
extends CommandDisplayerAdapter {
    private static final String BINARY = "-kb";
    private CvsDiff command;
    private DiffCommand diffCommand;
    private boolean isDir = false;
    private File[] files;
    private HashMap standaloneFiles;
    private LinkedList resultList;
    private LinkedList updInfoList;
    private Command currentCommand;
    private boolean includeUpdateCommand = false;
    private boolean binaryFilesWarningShown;
    private boolean noDiffFilesWarningShown;
    private HashMap binaryFiles;
    private Set noDiffFiles;

    public DiffCommandDisplayer(CvsDiff comm) {
        this.command = comm;
    }

    public DiffCommandDisplayer(CvsDiff comm, boolean includeUpdateInfo) {
        this.command = comm;
        this.setIncludeUpdateCommand(includeUpdateInfo);
    }

    public void showAfterEachExecute() {
        if (this.currentCommand instanceof UpdateCommand) {
            return;
        }
        if (this.currentCommand instanceof StatusCommand) {
            return;
        }
        if (!this.isDir && this.files.length != this.standaloneFiles.size()) {
            int i = 0;
            while (i < this.files.length) {
                if (this.standaloneFiles.get(this.files[i]) == null) {
                    this.noDiffFiles.add(this.files[i]);
                }
                ++i;
            }
        }
    }

    public void showBeforeEachExecute(Command currentCommand) {
        this.currentCommand = currentCommand;
        if (currentCommand instanceof UpdateCommand) {
            return;
        }
        if (currentCommand instanceof StatusCommand) {
            return;
        }
        this.resultList = new LinkedList();
        this.diffCommand = (DiffCommand)currentCommand;
        this.files = this.command.getFiles();
        if (this.files[0].isDirectory()) {
            this.isDir = true;
        } else {
            this.isDir = false;
            this.standaloneFiles = new HashMap();
        }
    }

    public void showExecutionFailed(Exception exception) {
    }

    public void showFileInfoGenerated(FileInfoContainer info) {
        if (info == null) {
            return;
        }
        if (info instanceof PipedFileInformation) {
            this.updInfoList.add(info);
            return;
        }
        if (info instanceof StatusInformation) {
            StatusInformation statusInfo = (StatusInformation)info;
            String stickyTag = statusInfo.getStickyOptions();
            if (stickyTag != null && BINARY.equals(stickyTag)) {
                this.binaryFiles.put(statusInfo.getFile(), statusInfo.getFile());
            }
            return;
        }
        if (this.isDir) {
            this.resultList.add(info);
        } else {
            DiffInformation dInfo;
            File fl = info.getFile();
            if (this.binaryFiles.get(fl) == null && (dInfo = (DiffInformation)info).getFirstChange() != null) {
                DiffDisplayer panel = new DiffDisplayer(this.diffCommand);
                panel.setFileSystemCommand(this.command);
                PipedFileInformation pInfo = this.getUpdInfo(dInfo);
                panel.setData(dInfo, this.diffCommand, pInfo);
                panel.displayOutputData();
                this.standaloneFiles.put(dInfo.getFile(), dInfo.getFile());
            }
        }
    }

    public void showFinishedCommand() {
        Iterator it = this.binaryFiles.keySet().iterator();
        while (it.hasNext()) {
            this.noDiffFiles.remove(it.next());
        }
        int binLength = this.binaryFiles.size();
        int noDiffLength = this.noDiffFiles.size();
        if (binLength == 0 && noDiffLength == 0) {
            return;
        }
        try {
            Thread.sleep(3000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (binLength == 1 && noDiffLength == 0) {
            SwingUtilities.invokeLater(new Runnable(){
                static /* synthetic */ Class class$org$netbeans$modules$cvsclient$commands$diff$DiffCommandDisplayer;

                public void run() {
                    DialogDisplayer dialDisp = DialogDisplayer.getDefault();
                    String message = null;
                    File fl = (File)DiffCommandDisplayer.this.binaryFiles.keySet().iterator().next();
                    message = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$diff$DiffCommandDisplayer == null ? (class$org$netbeans$modules$cvsclient$commands$diff$DiffCommandDisplayer = 1.class$("org.netbeans.modules.cvsclient.commands.diff.DiffCommandDisplayer")) : class$org$netbeans$modules$cvsclient$commands$diff$DiffCommandDisplayer)).getString("MSG_BinaryFile"), fl.getAbsolutePath());
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 1);
                    dialDisp.notify((NotifyDescriptor)nd);
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            });
            return;
        }
        if (binLength == 0 && noDiffLength == 1) {
            SwingUtilities.invokeLater(new Runnable(){
                static /* synthetic */ Class class$org$netbeans$modules$cvsclient$commands$diff$DiffCommandDisplayer;

                public void run() {
                    DialogDisplayer dialDisp = DialogDisplayer.getDefault();
                    String message = null;
                    File fl = (File)DiffCommandDisplayer.this.noDiffFiles.iterator().next();
                    message = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$diff$DiffCommandDisplayer == null ? (class$org$netbeans$modules$cvsclient$commands$diff$DiffCommandDisplayer = 2.class$("org.netbeans.modules.cvsclient.commands.diff.DiffCommandDisplayer")) : class$org$netbeans$modules$cvsclient$commands$diff$DiffCommandDisplayer)).getString("MSG_NoDiffFile"), fl.getAbsolutePath());
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 1);
                    dialDisp.notify((NotifyDescriptor)nd);
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            });
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DialogDisplayer dialDisp = DialogDisplayer.getDefault();
                BinaryFilesWarning message = null;
                message = new BinaryFilesWarning(DiffCommandDisplayer.this.binaryFiles.keySet(), DiffCommandDisplayer.this.noDiffFiles);
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 1);
                dialDisp.notify((NotifyDescriptor)nd);
            }
        });
    }

    public void showStartCommand() {
        this.updInfoList = new LinkedList();
        this.resultList = new LinkedList();
        if (this.binaryFiles == null) {
            this.binaryFiles = new HashMap();
        } else {
            this.binaryFiles.clear();
        }
        this.binaryFilesWarningShown = false;
        this.noDiffFilesWarningShown = false;
        this.noDiffFiles = new HashSet();
        IndependantClient provider = (IndependantClient)this.command.getClientProvider();
        if (provider.getDisplayType() != 0 || this.isIncludeUpdateCommand()) {
            this.command.addCheckoutCommands();
        }
    }

    private PipedFileInformation getUpdInfo(DiffInformation info) {
        Iterator it = this.updInfoList.iterator();
        PipedFileInformation toReturn = null;
        while (it.hasNext()) {
            PipedFileInformation pInfo = (PipedFileInformation)it.next();
            if (!pInfo.getFile().equals(info.getFile())) continue;
            toReturn = pInfo;
            break;
        }
        return toReturn;
    }

    public void setIncludeUpdateCommand(boolean include) {
        this.includeUpdateCommand = include;
    }

    public boolean isIncludeUpdateCommand() {
        return this.includeUpdateCommand;
    }
}

