/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cvsclient.commands.diff;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import org.netbeans.api.diff.Difference;
import org.netbeans.lib.cvsclient.command.PipedFileInformation;
import org.netbeans.lib.cvsclient.command.diff.DiffCommand;
import org.netbeans.lib.cvsclient.command.diff.DiffInformation;
import org.netbeans.modules.javacvs.commands.FileSystemCommand;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.spi.diff.DiffVisualizer;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DiffDisplayer {
    private Debug E;
    private Debug D;
    DiffCommand command;
    FileSystemCommand fsCommand;
    DiffInformation diffInfo;
    private Difference[] differences;
    boolean finishedOk;
    ArrayList resultList;
    private File startFile;
    private StringBuffer bufLeft;
    private StringBuffer bufRight;
    private int fileLineCount;
    private int leftLineCount;
    private int rightLineCount;
    private File file1;
    private File file2;
    static /* synthetic */ Class class$org$netbeans$spi$diff$DiffVisualizer;
    static /* synthetic */ Class class$org$netbeans$modules$cvsclient$commands$diff$DiffDisplayer;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsDiff;

    public DiffDisplayer(DiffCommand diffComm) {
        this.D = this.E = new Debug("DiffDisplayer", true);
        this.D.deb("Constructor");
        this.command = diffComm;
    }

    private PipedFileInformation findUpdInfo(LinkedList list, String name) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            PipedFileInformation info = (PipedFileInformation)it.next();
            if (!info.getRepositoryFileName().equals(name)) continue;
            return info;
        }
        return null;
    }

    public void displayOutputData() {
        DiffVisualizer visual = (DiffVisualizer)Lookup.getDefault().lookup(class$org$netbeans$spi$diff$DiffVisualizer == null ? (class$org$netbeans$spi$diff$DiffVisualizer = DiffDisplayer.class$("org.netbeans.spi.diff.DiffVisualizer")) : class$org$netbeans$spi$diff$DiffVisualizer);
        if (this.differences != null && visual != null) {
            try {
                String workingFile = NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$diff$DiffDisplayer == null ? (class$org$netbeans$modules$cvsclient$commands$diff$DiffDisplayer = DiffDisplayer.class$("org.netbeans.modules.cvsclient.commands.diff.DiffDisplayer")) : class$org$netbeans$modules$cvsclient$commands$diff$DiffDisplayer)).getString("LBL_WorkingFile");
                String rightTit = this.diffInfo.getRightRevision() != null ? this.diffInfo.getRightRevision() : workingFile;
                String leftTit = this.diffInfo.getLeftRevision() != null ? this.diffInfo.getLeftRevision() : workingFile;
                TopComponent myTC = new TopComponent();
                myTC.putClientProperty("PersistenceType", "Never");
                myTC.setLayout(new BorderLayout());
                BufferedReader reader1 = new BufferedReader(new FileReader(this.file1));
                BufferedReader reader2 = new BufferedReader(new FileReader(this.file2));
                Component comp = visual.createView(this.differences, leftTit, leftTit, (Reader)reader1, rightTit, rightTit, (Reader)reader2, this.getMIMEType(this.diffInfo));
                myTC.add(comp, "Center");
                Mode editorMode = WindowManager.getDefault().getCurrentWorkspace().findMode("editor");
                if (editorMode != null) {
                    editorMode.dockInto(myTC);
                }
                AccessibleContext context = myTC.getAccessibleContext();
                AccessibleContext compContext = comp.getAccessibleContext();
                context.setAccessibleDescription(compContext.getAccessibleDescription());
                myTC.setName(this.getName() + " " + this.diffInfo.getFile().getName());
                myTC.open();
            }
            catch (IOException exc) {
                Thread.dumpStack();
            }
        }
    }

    protected String getName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$javacvs$commands$CvsDiff == null ? (class$org$netbeans$modules$javacvs$commands$CvsDiff = DiffDisplayer.class$("org.netbeans.modules.javacvs.commands.CvsDiff")) : class$org$netbeans$modules$javacvs$commands$CvsDiff)).getString("CvsDiff.name");
    }

    public void setData(DiffInformation info, DiffCommand command, PipedFileInformation updInfo) {
        this.D.deb("setData() beginning");
        File startFile = info.getFile();
        if (updInfo != null) {
            if (!startFile.exists()) {
                startFile = updInfo.getTempFile();
            }
            if (command.getBeforeDate1() != null || command.getRevision2() != null) {
                startFile = updInfo.getTempFile();
            }
        }
        if (startFile == null) {
            return;
        }
        this.diffInfo = info;
        this.processDocuments(this.diffInfo, startFile);
        this.file1 = this.saveToFile(this.bufLeft);
        this.D.deb("file left=" + this.file1.getAbsolutePath());
        this.file2 = this.saveToFile(this.bufRight);
        this.D.deb("file right=" + this.file2.getAbsolutePath());
        DiffInformation.DiffChange change = this.diffInfo.getFirstChange();
        LinkedList<Difference> diffList = new LinkedList<Difference>();
        while (change != null) {
            int type = 0;
            if (change.getType() == 0) {
                type = 1;
            } else if (change.getType() == 2) {
                type = 2;
            } else if (change.getType() == 1) {
                type = 0;
            } else {
                change = this.diffInfo.getNextChange();
            }
            diffList.add(new Difference(type, change.getLeftMin(), change.getLeftMax(), change.getRightMin(), change.getRightMax()));
            change = this.diffInfo.getNextChange();
        }
        if (diffList.size() > 0) {
            this.differences = new Difference[diffList.size()];
            this.differences = diffList.toArray(this.differences);
        }
    }

    private String getMIMEType(DiffInformation info) {
        String type;
        File infoFile = info.getFile();
        if (infoFile == null) {
            return "text/plain";
        }
        String tempStr = infoFile.getName();
        String extension = null;
        this.D.deb("tempStr=" + tempStr);
        int ind = tempStr.indexOf(46);
        if (ind > 0) {
            extension = tempStr.substring(ind + 1);
        }
        this.D.deb("extension=" + extension);
        if (extension == null) {
            extension = "text/plain";
        }
        if ((type = FileUtil.getMIMEType((String)extension)) == null) {
            type = "text/plain";
        }
        return type;
    }

    private File saveToFile(StringBuffer buff) {
        long tmpId;
        String TMP_ROOT = System.getProperty("netbeans.user") + File.separator + "system" + File.separator + "javacvs" + File.separator + "tmp";
        File tmpDir = new File(TMP_ROOT);
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        do {
            tmpId = 10000L * (1L + Math.round(Math.random() * 8.0)) + Math.round(Math.random() * 1000.0);
        } while (new File(TMP_ROOT + File.separator + "tmp" + tmpId).exists());
        String tempFileName = TMP_ROOT + File.separator + "tmp" + tmpId;
        File tempFile = new File(tempFileName);
        try {
            PrintWriter bw = new PrintWriter(new FileOutputStream(tempFile), true);
            bw.print(buff);
            bw.close();
        }
        catch (IOException exc) {
            // empty catch block
        }
        return tempFile;
    }

    private void processDocuments(DiffInformation diffInfo, File startFile) {
        BufferedReader buf = null;
        this.leftLineCount = 0;
        this.rightLineCount = 0;
        try {
            buf = new BufferedReader(new FileReader(startFile));
        }
        catch (FileNotFoundException exc) {
            return;
        }
        this.bufLeft = new StringBuffer();
        this.bufRight = new StringBuffer();
        try {
            int gap;
            this.fileLineCount = 0;
            DiffInformation.DiffChange change = diffInfo.getFirstChange();
            while (change != null) {
                int start;
                boolean isDelete = change.getType() == 1;
                int n = start = isDelete ? change.getMainBeginning() : change.getMainBeginning() - 1;
                if (change.getMainBeginning() >= this.fileLineCount) {
                    gap = this.fillFromFile(start, buf);
                    this.D.deb("filled = " + gap);
                }
                if (change.getType() == 0) {
                    this.D.deb("we got ADD change here!");
                    gap = this.parseAddChange(change, true);
                    this.skipGap(gap, buf);
                }
                if (change.getType() == 1) {
                    this.D.deb("we got DELETE change here!");
                    gap = this.parseDeleteChange(change, true);
                }
                if (change.getType() == 2) {
                    this.D.deb("we got CHANGE change here!");
                    gap = this.parseChangedChange(change);
                    this.skipGap(gap, buf);
                }
                change = diffInfo.getNextChange();
            }
            gap = this.fillFromFile(-1, buf);
        }
        catch (IOException ioExc) {
            Thread.dumpStack();
        }
    }

    private void skipGap(int gap, BufferedReader buf) throws IOException {
        int ind = 0;
        while (ind < gap) {
            String line = buf.readLine();
            ++this.fileLineCount;
            this.D.deb("skipped one line=" + line);
            ++ind;
        }
    }

    private int fillFromFile(int start, BufferedReader buf) throws IOException {
        this.D.deb("fillingGap...");
        int readCount = 0;
        int max = start;
        while (this.fileLineCount < max || max == -1) {
            String line = buf.readLine();
            if (line == null) break;
            ++this.fileLineCount;
            this.D.deb("reading linenum=" + ++readCount + "  line=" + line);
            ++this.leftLineCount;
            this.bufLeft.append(line + "\n");
            ++this.rightLineCount;
            this.bufRight.append(line + "\n");
        }
        return readCount;
    }

    private int parseAddChange(DiffInformation.DiffChange change, boolean add) {
        int ind = change.getRightMin();
        while (ind <= change.getRightMax()) {
            this.bufRight.append(change.getLine(ind, false) + "\n");
            ++this.rightLineCount;
            this.D.deb("adding to main=" + change.getLine(ind, false));
            ++ind;
        }
        int gap = ind - change.getRightMin();
        this.D.deb("final ADDED gap =" + gap);
        return gap;
    }

    private int parseDeleteChange(DiffInformation.DiffChange change, boolean delete) {
        int ind = change.getLeftMin();
        while (ind <= change.getLeftMax()) {
            ++this.leftLineCount;
            this.bufLeft.append(change.getLine(ind, true) + "\n");
            this.D.deb("addding to diff=" + change.getLine(ind, true));
            ++ind;
        }
        int gap = ind - change.getLeftMin();
        this.D.deb("final DELETE gap =" + gap);
        return gap;
    }

    private int parseChangedChange(DiffInformation.DiffChange change) {
        int gap;
        int toReturn = gap = this.parseAddChange(change, false);
        int gap2 = this.parseDeleteChange(change, false);
        return toReturn;
    }

    public void setCommand(DiffCommand comm) {
        this.command = comm;
    }

    public void setFileSystemCommand(FileSystemCommand fsCom) {
        this.fsCommand = fsCom;
    }

    public File getFileDisplayed() {
        if (this.diffInfo == null) {
            return null;
        }
        return this.diffInfo.getFile();
    }

    public Object getComparisonData() {
        return this.diffInfo;
    }

    public JComponent getComponent() {
        return null;
    }

    public boolean equalDisplayedData(File file, Class type, Object comparisonData) {
        if (!this.getClass().equals(type)) {
            return false;
        }
        return this.diffInfo != null && this.diffInfo.getFile() != null && this.diffInfo.getFile().equals(file);
    }

    public FileSystemCommand getFileSystemCommand() {
        return this.fsCommand;
    }

    public String getCommandSwitches() {
        return this.command.getCVSArguments();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

