/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cvsclient.commands.grouping;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.command.status.StatusInformation;
import org.netbeans.lib.cvsclient.file.FileStatus;
import org.netbeans.modules.cvsclient.FsCommandFactory;
import org.netbeans.modules.cvsclient.NbJavaCvsFileSystem;
import org.netbeans.modules.cvsclient.NbJavaCvsStatusManager;
import org.netbeans.modules.javacvs.commands.FileSystemCommand;
import org.netbeans.modules.javacvs.events.CommandDisplayerAdapter;
import org.netbeans.modules.vcscore.actions.AddCommandAction;
import org.netbeans.modules.vcscore.actions.CommandActionSupporter;
import org.netbeans.modules.vcscore.actions.GeneralCommandAction;
import org.netbeans.modules.vcscore.actions.UpdateCommandAction;
import org.netbeans.modules.vcscore.grouping.GroupUtils;
import org.netbeans.modules.vcscore.ui.NotChangedFilesPanel;
import org.netbeans.modules.vcscore.ui.ToAddFilesPanel;
import org.netbeans.modules.vcscore.ui.ToUpdateFilesPanel;
import org.netbeans.modules.vcscore.ui.VerifyGroupPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public class VerifyGroupDisplayer
extends CommandDisplayerAdapter {
    private int commandCount = 0;
    private int finishedCommandCount = 0;
    private boolean errorsOccured = false;
    private LinkedList localFiles = new LinkedList();
    private LinkedList outOfDateFiles = new LinkedList();
    private LinkedList uptoDateFiles = new LinkedList();
    private NotChangedFilesPanel ncfPanel;
    private ToAddFilesPanel taPanel;
    private ToUpdateFilesPanel tuPanel;
    private Map fileObjectMap = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$org$netbeans$lib$cvsclient$command$status$StatusInformation;
    static /* synthetic */ Class class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$ui$VerifyGroupPanel;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$UpdateCommandAction;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$AddCommandAction;

    public synchronized void addFileObjects(FileObject[] fos) {
        int i = 0;
        while (i < fos.length) {
            File file = FileSystemCommand.toFile(fos[i]);
            this.fileObjectMap.put(file, fos[i]);
            ++i;
        }
    }

    public synchronized void increaseNumberOfCommands() {
        ++this.commandCount;
    }

    public int getNumberOfCommand() {
        return this.commandCount;
    }

    public synchronized void showFinishedCommand() {
        ++this.finishedCommandCount;
        if (this.finishedCommandCount == this.commandCount) {
            this.showDialog();
        }
    }

    public synchronized void showExecutionFailed(Exception exception) {
        this.errorsOccured = true;
        ++this.finishedCommandCount;
        if (this.finishedCommandCount == this.commandCount) {
            this.showDialog();
        }
    }

    public synchronized void showFileInfoGenerated(FileInfoContainer info) {
        if (info.getClass().equals(class$org$netbeans$lib$cvsclient$command$status$StatusInformation == null ? (class$org$netbeans$lib$cvsclient$command$status$StatusInformation = VerifyGroupDisplayer.class$("org.netbeans.lib.cvsclient.command.status.StatusInformation")) : class$org$netbeans$lib$cvsclient$command$status$StatusInformation)) {
            StatusInformation statusInfo = (StatusInformation)info;
            FileStatus status = statusInfo.getStatus();
            if (status.equals(FileStatus.UNKNOWN)) {
                this.localFiles.add(statusInfo);
            }
            if (status.equals(FileStatus.UP_TO_DATE)) {
                this.uptoDateFiles.add(statusInfo);
            }
            if (status.equals(FileStatus.NEEDS_CHECKOUT) || status.equals(FileStatus.NEEDS_MERGE) || status.equals(FileStatus.NEEDS_PATCH)) {
                this.outOfDateFiles.add(statusInfo);
            }
        }
    }

    private void showDialog() {
        List dobjList;
        VerifyGroupPanel panel = new VerifyGroupPanel();
        boolean nothing = true;
        if (this.localFiles.size() > 0) {
            this.taPanel = new ToAddFilesPanel(this.findFOsForFiles(this.localFiles));
            panel.addPanel((JPanel)this.taPanel, NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer == null ? (class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer = VerifyGroupDisplayer.class$("org.netbeans.modules.cvsclient.commands.grouping.VerifyGroupDisplayer")) : class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer)).getString("VerifyGroupDisplayer.ToAdd"));
            nothing = false;
        }
        if (this.outOfDateFiles.size() > 0) {
            this.tuPanel = new ToUpdateFilesPanel(this.findFOsForFiles(this.outOfDateFiles));
            panel.addPanel((JPanel)this.tuPanel, NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer == null ? (class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer = VerifyGroupDisplayer.class$("org.netbeans.modules.cvsclient.commands.grouping.VerifyGroupDisplayer")) : class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer)).getString("VerifyGroupDisplayer.ToUpdate"));
            nothing = false;
        }
        if (this.uptoDateFiles.size() > 0 && (dobjList = this.getDOForNotChanged(this.findFOsForFiles(this.uptoDateFiles))).size() > 0) {
            this.ncfPanel = new NotChangedFilesPanel(dobjList);
            panel.addPanel((JPanel)this.ncfPanel, NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer == null ? (class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer = VerifyGroupDisplayer.class$("org.netbeans.modules.cvsclient.commands.grouping.VerifyGroupDisplayer")) : class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer)).getString("VerifyGroupDisplayer.NotChanged"));
            nothing = false;
        }
        String title = NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer == null ? (class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer = VerifyGroupDisplayer.class$("org.netbeans.modules.cvsclient.commands.grouping.VerifyGroupDisplayer")) : class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer)).getString("VerifyGroupDisplayer.title");
        DialogDescriptor dd = new DialogDescriptor((Object)panel, title);
        dd.setHelpCtx(new HelpCtx(class$org$netbeans$modules$vcscore$ui$VerifyGroupPanel == null ? (class$org$netbeans$modules$vcscore$ui$VerifyGroupPanel = VerifyGroupDisplayer.class$("org.netbeans.modules.vcscore.ui.VerifyGroupPanel")) : class$org$netbeans$modules$vcscore$ui$VerifyGroupPanel));
        dd.setModal(false);
        if (nothing) {
            panel.setDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer == null ? (class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer = VerifyGroupDisplayer.class$("org.netbeans.modules.cvsclient.commands.grouping.VerifyGroupDisplayer")) : class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer)).getString("VerifyGroupDisplayer.NoProblem"));
            JButton btnClose = new JButton(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer == null ? (class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer = VerifyGroupDisplayer.class$("org.netbeans.modules.cvsclient.commands.grouping.VerifyGroupDisplayer")) : class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer)).getString("VerifyGroupDisplayer.closeButton"));
            Object[] options = new Object[]{btnClose};
            dd.setOptions(options);
            dd.setClosingOptions(options);
        } else {
            panel.setDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer == null ? (class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer = VerifyGroupDisplayer.class$("org.netbeans.modules.cvsclient.commands.grouping.VerifyGroupDisplayer")) : class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer)).getString("VerifyGroupDisplayer.ProblemsFound"));
            final JButton btnCorrect = new JButton(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer == null ? (class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer = VerifyGroupDisplayer.class$("org.netbeans.modules.cvsclient.commands.grouping.VerifyGroupDisplayer")) : class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer)).getString("VerifyGroupDisplayer.correctButton"));
            btnCorrect.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer == null ? (class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer = VerifyGroupDisplayer.class$("org.netbeans.modules.cvsclient.commands.grouping.VerifyGroupDisplayer")) : class$org$netbeans$modules$cvsclient$commands$grouping$VerifyGroupDisplayer)).getString("ACSD_VerifyGroupDisplayer.correctButton"));
            Object[] options = new Object[]{btnCorrect, NotifyDescriptor.CANCEL_OPTION};
            dd.setOptions(options);
            dd.setClosingOptions(options);
            dd.setButtonListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (event.getSource().equals(btnCorrect)) {
                        VerifyGroupDisplayer.this.correctGroup();
                        return;
                    }
                }
            });
        }
        final Dialog dial = DialogDisplayer.getDefault().createDialog(dd);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                dial.show();
            }
        });
    }

    private List findFOsForFiles(List fileList) {
        Iterator it = fileList.iterator();
        LinkedList<FileObject> foList = new LinkedList<FileObject>();
        while (it.hasNext()) {
            StatusInformation info = (StatusInformation)it.next();
            FileObject fo = (FileObject)this.fileObjectMap.get(info.getFile());
            foList.add(fo);
        }
        return foList;
    }

    private void correctGroup() {
        if (this.ncfPanel != null) {
            this.performNCFCorrection();
        }
        if (this.tuPanel != null) {
            this.performTUCorrection();
        }
        if (this.taPanel != null) {
            this.performTACorrection();
        }
    }

    private List getDOForNotChanged(List list) {
        Iterator it = list.iterator();
        HashSet<DataObject> dobjStat = new HashSet<DataObject>();
        while (it.hasNext()) {
            FileObject fo = (FileObject)it.next();
            DataObject dobj = null;
            try {
                dobj = DataObject.find((FileObject)fo);
                String stat = ((NbJavaCvsFileSystem)dobj.getPrimaryFile().getFileSystem()).getStatus(dobj);
                if (!stat.equals(NbJavaCvsStatusManager.getInstance().getStatus("Upd"))) continue;
                dobjStat.add(dobj);
            }
            catch (DataObjectNotFoundException exc) {
            }
            catch (FileStateInvalidException exc2) {
                // empty catch block
            }
        }
        Iterator it2 = dobjStat.iterator();
        LinkedList toReturn = new LinkedList();
        while (it2.hasNext()) {
            toReturn.add(it2.next());
        }
        return toReturn;
    }

    public void performTUCorrection() {
        List list = this.tuPanel.getFileObjects();
        if (list != null && list.size() != 0) {
            CommandActionSupporter supp = FsCommandFactory.getFsInstance().getSupporter();
            UpdateCommandAction act = (UpdateCommandAction)SharedClassObject.findObject((Class)(class$org$netbeans$modules$vcscore$actions$UpdateCommandAction == null ? (class$org$netbeans$modules$vcscore$actions$UpdateCommandAction = VerifyGroupDisplayer.class$("org.netbeans.modules.vcscore.actions.UpdateCommandAction")) : class$org$netbeans$modules$vcscore$actions$UpdateCommandAction), (boolean)true);
            FileObject[] fos = new FileObject[list.size()];
            fos = list.toArray(fos);
            supp.performAction((GeneralCommandAction)act, fos);
        }
    }

    public void performNCFCorrection() {
        List list = this.ncfPanel.getSelectedDataObjects();
        if (list != null && list.size() > 0) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                DataObject obj = (DataObject)it.next();
                DataShadow shadow = GroupUtils.findDOInGroups((DataObject)obj);
                if (shadow == null) continue;
                try {
                    shadow.delete();
                }
                catch (IOException exc) {
                    // empty catch block
                }
            }
        }
    }

    public void performTACorrection() {
        List foList = this.taPanel.getFileObjects();
        if (foList != null && foList.size() != 0) {
            CommandActionSupporter supp = FsCommandFactory.getFsInstance().getSupporter();
            AddCommandAction act = (AddCommandAction)SharedClassObject.findObject((Class)(class$org$netbeans$modules$vcscore$actions$AddCommandAction == null ? (class$org$netbeans$modules$vcscore$actions$AddCommandAction = VerifyGroupDisplayer.class$("org.netbeans.modules.vcscore.actions.AddCommandAction")) : class$org$netbeans$modules$vcscore$actions$AddCommandAction), (boolean)true);
            FileObject[] fos = new FileObject[foList.size()];
            fos = foList.toArray(fos);
            supp.performAction((GeneralCommandAction)act, fos);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

