/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cvsclient.commands.status;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.command.status.StatusInformation;
import org.netbeans.lib.cvsclient.file.FileStatus;
import org.netbeans.modules.cvsclient.FsCommandFactory;
import org.netbeans.modules.cvsclient.NbJavaCvsStatusManager;
import org.netbeans.modules.cvsclient.commands.AbstractTreeInfoPanel;
import org.netbeans.modules.cvsclient.commands.PersistentCommandDisplayer;
import org.netbeans.modules.cvsclient.commands.status.StatusComparator;
import org.netbeans.modules.cvsclient.commands.status.StatusInfoPanel;
import org.netbeans.modules.javacvs.commands.CvsStatus;
import org.netbeans.modules.javacvs.commands.FileSystemCommand;
import org.netbeans.modules.javacvs.commands.JavaCvsStatusManager;
import org.netbeans.modules.vcscore.util.table.FileComparator;
import org.netbeans.modules.vcscore.util.table.TableInfoComparator;
import org.netbeans.modules.vcscore.util.table.TableInfoModel;
import org.openide.util.NbBundle;

public class StatusTreeInfoPanel
extends AbstractTreeInfoPanel
implements PersistentCommandDisplayer {
    private StatusInfoPanel statPanel;
    private StatusInformation clearStatusInfo;
    private CvsStatus command;
    private Class fsCommand;
    private JCheckBox cbUptodate;
    private JCheckBox cbModified;
    private JCheckBox cbNeedsPatch;
    private JCheckBox cbNeedsMerge;
    private JCheckBox cbHasConflict;
    private JCheckBox cbLocAdded;
    private JCheckBox cbLocRemoved;
    private JCheckBox cbNeedsCheckout;
    private JCheckBox cbUnknown;
    private JLabel lblCount;
    private JLabel lblTitle;
    private int totalCount;
    private int selectedCount;
    private JRadioButton btnAll;
    private String btnAll_Title;
    private String btnJustModified_Title;
    private JRadioButton btnJustModified;
    private int currentFilter = 0;
    private static final int FILTER_ALL = 0;
    private static final int FILTER_MODIFIED = 1;
    private JavaCvsStatusManager statusManager;
    static /* synthetic */ Class class$org$netbeans$modules$cvsclient$commands$status$StatusTreeInfoPanel;
    static /* synthetic */ Class class$org$netbeans$lib$cvsclient$command$status$StatusInformation;

    public StatusTreeInfoPanel(File topDir, CvsStatus statusComm) {
        super(topDir);
        this.command = statusComm;
        this.initButtons();
        this.statusManager = NbJavaCvsStatusManager.getInstance();
        this.postInit();
    }

    public void setCommand(CvsStatus comm) {
        this.command = comm;
    }

    private void initPanelComponents() {
    }

    private void initClearInfo() {
        this.clearStatusInfo = new StatusInformation();
        this.clearStatusInfo.setFile(new File(""));
        this.clearStatusInfo.setRepositoryFileName("");
        this.clearStatusInfo.setRepositoryRevision("");
        this.clearStatusInfo.setWorkingRevision("");
        this.clearStatusInfo.setStatus(FileStatus.UNKNOWN);
        this.clearStatusInfo.setStickyDate("");
        this.clearStatusInfo.setStickyOptions("");
        this.clearStatusInfo.setStickyTag("");
    }

    protected void setPanel(Object infoData) {
        StatusInformation statData = (StatusInformation)infoData;
        this.statPanel.setData(statData);
    }

    protected JComponent initPanel() {
        this.initClearInfo();
        this.statPanel = new StatusInfoPanel(this.command);
        this.setClearPanel();
        return this.statPanel;
    }

    protected void setClearPanel() {
        this.statPanel.setData(this.clearStatusInfo);
    }

    protected boolean canBeAdded(StatusInformation sInfo) {
        if (sInfo.getStatus() == FileStatus.UP_TO_DATE && this.cbUptodate.isSelected()) {
            return true;
        }
        if (sInfo.getStatus() == FileStatus.MODIFIED && this.cbModified.isSelected()) {
            return true;
        }
        if (sInfo.getStatus() == FileStatus.ADDED && this.cbLocAdded.isSelected()) {
            return true;
        }
        if (sInfo.getStatus() == FileStatus.REMOVED && this.cbLocRemoved.isSelected()) {
            return true;
        }
        if (sInfo.getStatus() == FileStatus.NEEDS_CHECKOUT && this.cbNeedsCheckout.isSelected()) {
            return true;
        }
        if (sInfo.getStatus() == FileStatus.NEEDS_MERGE && this.cbNeedsMerge.isSelected()) {
            return true;
        }
        if (sInfo.getStatus() == FileStatus.NEEDS_PATCH && this.cbNeedsPatch.isSelected()) {
            return true;
        }
        if (sInfo.getStatus() == FileStatus.HAS_CONFLICTS && this.cbHasConflict.isSelected()) {
            return true;
        }
        return sInfo.getStatus() == FileStatus.UNKNOWN && this.cbUnknown.isSelected();
    }

    protected boolean addToList(FileInfoContainer info) {
        StatusInformation sInfo = (StatusInformation)info;
        return this.canBeAdded(sInfo);
    }

    protected void addFileNode(FileInfoContainer info, DefaultMutableTreeNode parent) {
        StatusInformation sInfo = (StatusInformation)info;
        ++this.totalCount;
        if (this.canBeAdded(sInfo)) {
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(info);
            parent.add(child);
            ++this.selectedCount;
        }
    }

    private void checkBoxChanged() {
        this.totalCount = 0;
        this.selectedCount = 0;
        this.recreateModel();
        Integer selCount = new Integer(this.selectedCount);
        Integer totCount = new Integer(this.totalCount);
        String txt = NbBundle.getMessage((Class)(class$org$netbeans$modules$cvsclient$commands$status$StatusTreeInfoPanel == null ? (class$org$netbeans$modules$cvsclient$commands$status$StatusTreeInfoPanel = StatusTreeInfoPanel.class$("org.netbeans.modules.cvsclient.commands.status.StatusTreeInfoPanel")) : class$org$netbeans$modules$cvsclient$commands$status$StatusTreeInfoPanel), (String)"StatusTreeInfoPanel.lblCount", (Object)selCount.toString(), (Object)totCount.toString());
        this.lblCount.setText(txt);
    }

    private void initButtons() {
        JPanel panel = this.getButtonPanel();
        this.cbUptodate = new JCheckBox();
        this.cbModified = new JCheckBox();
        this.cbLocAdded = new JCheckBox();
        this.cbLocRemoved = new JCheckBox();
        this.cbNeedsCheckout = new JCheckBox();
        this.cbNeedsMerge = new JCheckBox();
        this.lblTitle = new JLabel();
        this.lblCount = new JLabel();
        this.cbNeedsPatch = new JCheckBox();
        this.cbHasConflict = new JCheckBox();
        this.cbUnknown = new JCheckBox();
        panel.setLayout(new GridBagLayout());
        this.lblTitle.setText(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/commands/status/Bundle").getString("StatusTreeInfoPanel.lblTitle.text"));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(12, 12, 0, 11);
        panel.add((Component)this.lblTitle, gridBagConstraints1);
        this.cbUptodate.setText(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/commands/status/Bundle").getString("StatusTreeInfoPanel.cbUptodate.text"));
        this.cbUptodate.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/commands/status/Bundle").getString("StatusTreeInfoPanel.cbUptodate.mnemonic").charAt(0));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(5, 24, 0, 0);
        panel.add((Component)this.cbUptodate, gridBagConstraints1);
        this.cbModified.setText(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/commands/status/Bundle").getString("StatusTreeInfoPanel.cbModified.text"));
        this.cbModified.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/commands/status/Bundle").getString("StatusTreeInfoPanel.cbModified.mnemonic").charAt(0));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(5, 12, 0, 11);
        panel.add((Component)this.cbModified, gridBagConstraints1);
        this.cbLocAdded.setText(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/commands/status/Bundle").getString("StatusTreeInfoPanel.cbLocAdded.text"));
        this.cbLocAdded.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/commands/status/Bundle").getString("StatusTreeInfoPanel.cbLocAdded.mnemonic").charAt(0));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(0, 24, 0, 0);
        panel.add((Component)this.cbLocAdded, gridBagConstraints1);
        this.cbLocRemoved.setText(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/commands/status/Bundle").getString("StatusTreeInfoPanel.cbLocRemoved.text"));
        this.cbLocRemoved.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/commands/status/Bundle").getString("StatusTreeInfoPanel.cbLocRemoved.mnemonic").charAt(0));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(0, 12, 0, 11);
        panel.add((Component)this.cbLocRemoved, gridBagConstraints1);
        this.cbNeedsMerge.setText(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/commands/status/Bundle").getString("StatusTreeInfoPanel.cbNeedsMerge.text"));
        this.cbNeedsMerge.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/commands/status/Bundle").getString("StatusTreeInfoPanel.cbNeedsMerge.mnemonic").charAt(0));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(0, 24, 0, 0);
        panel.add((Component)this.cbNeedsMerge, gridBagConstraints1);
        this.cbNeedsPatch.setText(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/commands/status/Bundle").getString("StatusTreeInfoPanel.cbNeedsPatch.text"));
        this.cbNeedsPatch.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/commands/status/Bundle").getString("StatusTreeInfoPanel.cbNeedsPatch.mnemonic").charAt(0));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(0, 12, 0, 11);
        panel.add((Component)this.cbNeedsPatch, gridBagConstraints1);
        this.cbNeedsCheckout.setText(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/commands/status/Bundle").getString("StatusTreeInfoPanel.cbNeedsCheckout.text"));
        this.cbNeedsCheckout.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/commands/status/Bundle").getString("StatusTreeInfoPanel.cbNeedsCheckout.mnemonic").charAt(0));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(0, 24, 0, 0);
        panel.add((Component)this.cbNeedsCheckout, gridBagConstraints1);
        this.cbHasConflict.setText(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/commands/status/Bundle").getString("StatusTreeInfoPanel.cbHasConflicts.text"));
        this.cbHasConflict.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/commands/status/Bundle").getString("StatusTreeInfoPanel.cbHasConflicts.mnemonic").charAt(0));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(0, 12, 0, 11);
        panel.add((Component)this.cbHasConflict, gridBagConstraints1);
        this.cbUnknown.setText(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/commands/status/Bundle").getString("StatusTreeInfoPanel.cbUnknown.text"));
        this.cbUnknown.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/commands/status/Bundle").getString("StatusTreeInfoPanel.cbUnknown.mnemonic").charAt(0));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.insets = new Insets(0, 24, 0, 0);
        panel.add((Component)this.cbUnknown, gridBagConstraints1);
        this.lblCount.setText(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/commands/status/Bundle").getString("StatusTreeInfoPanel.lblCount"));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 6;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.insets = new Insets(12, 12, 2, 11);
        panel.add((Component)this.lblCount, gridBagConstraints1);
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StatusTreeInfoPanel.this.checkBoxChanged();
            }
        };
        this.cbUptodate.addActionListener(listener);
        this.cbModified.addActionListener(listener);
        this.cbNeedsPatch.addActionListener(listener);
        this.cbNeedsMerge.addActionListener(listener);
        this.cbHasConflict.addActionListener(listener);
        this.cbLocAdded.addActionListener(listener);
        this.cbLocRemoved.addActionListener(listener);
        this.cbNeedsCheckout.addActionListener(listener);
        this.cbUnknown.addActionListener(listener);
        this.cbUptodate.setSelected(true);
        this.cbModified.setSelected(true);
        this.cbNeedsPatch.setSelected(true);
        this.cbNeedsMerge.setSelected(true);
        this.cbHasConflict.setSelected(true);
        this.cbLocAdded.setSelected(true);
        this.cbLocRemoved.setSelected(true);
        this.cbNeedsCheckout.setSelected(true);
        this.cbUnknown.setSelected(true);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (comp instanceof JLabel) {
            Object userObj;
            JLabel label = (JLabel)comp;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node != null && (userObj = node.getUserObject()) != null && userObj instanceof StatusInformation) {
                StatusInformation info = (StatusInformation)userObj;
                String status = this.statusManager.getStatus(JavaCvsStatusManager.convertStatus(info.getStatus()));
                label.setText(info.getFile().getName() + "  [" + status + "]");
            }
        }
        return comp;
    }

    public void displayOutputData() {
        String title = NbBundle.getMessage((Class)(class$org$netbeans$modules$cvsclient$commands$status$StatusTreeInfoPanel == null ? (class$org$netbeans$modules$cvsclient$commands$status$StatusTreeInfoPanel = StatusTreeInfoPanel.class$("org.netbeans.modules.cvsclient.commands.status.StatusTreeInfoPanel")) : class$org$netbeans$modules$cvsclient$commands$status$StatusTreeInfoPanel), (String)"CvsStatus.dialogTitle", (Object)this.topDirectory.getName());
        FsCommandFactory.displayOutputPanel(title, this);
    }

    public void setDataToDisplay(Collection resultList) {
        this.totalCount = 0;
        this.selectedCount = 0;
        super.setDataToDisplay(resultList);
        Integer selCount = new Integer(this.selectedCount);
        Integer totCount = new Integer(this.totalCount);
        String txt = NbBundle.getMessage((Class)(class$org$netbeans$modules$cvsclient$commands$status$StatusTreeInfoPanel == null ? (class$org$netbeans$modules$cvsclient$commands$status$StatusTreeInfoPanel = StatusTreeInfoPanel.class$("org.netbeans.modules.cvsclient.commands.status.StatusTreeInfoPanel")) : class$org$netbeans$modules$cvsclient$commands$status$StatusTreeInfoPanel), (String)"StatusTreeInfoPanel.lblCount", (Object)selCount.toString(), (Object)totCount.toString());
        this.lblCount.setText(txt);
    }

    protected TableInfoModel createTableModel() {
        TableInfoModel model = new TableInfoModel();
        Class classa = class$org$netbeans$lib$cvsclient$command$status$StatusInformation == null ? (class$org$netbeans$lib$cvsclient$command$status$StatusInformation = StatusTreeInfoPanel.class$("org.netbeans.lib.cvsclient.command.status.StatusInformation")) : class$org$netbeans$lib$cvsclient$command$status$StatusInformation;
        String column1 = NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$status$StatusTreeInfoPanel == null ? (class$org$netbeans$modules$cvsclient$commands$status$StatusTreeInfoPanel = StatusTreeInfoPanel.class$("org.netbeans.modules.cvsclient.commands.status.StatusTreeInfoPanel")) : class$org$netbeans$modules$cvsclient$commands$status$StatusTreeInfoPanel)).getString("StatusTableInfoModel.status");
        String column2 = NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$status$StatusTreeInfoPanel == null ? (class$org$netbeans$modules$cvsclient$commands$status$StatusTreeInfoPanel = StatusTreeInfoPanel.class$("org.netbeans.modules.cvsclient.commands.status.StatusTreeInfoPanel")) : class$org$netbeans$modules$cvsclient$commands$status$StatusTreeInfoPanel)).getString("StatusTableInfoModel.fileName");
        try {
            Method method1 = classa.getMethod("getStatus", null);
            Method method2 = classa.getMethod("getFile", null);
            model.setColumnDefinition(0, column1, method1, true, (TableInfoComparator)new StatusComparator());
            model.setColumnDefinition(1, column2, method2, true, (TableInfoComparator)new FileComparator());
        }
        catch (NoSuchMethodException exc) {
            Thread.dumpStack();
        }
        catch (SecurityException exc2) {
            Thread.dumpStack();
        }
        return model;
    }

    public JComponent getComponent() {
        return this;
    }

    public Object getComparisonData() {
        return this.topDirectory;
    }

    public boolean equalDisplayedData(File file, Class type, Object comparisonData) {
        if (!this.getClass().equals(type)) {
            return false;
        }
        return this.topDirectory != null && this.topDirectory.equals(file);
    }

    public File getFileDisplayed() {
        return this.topDirectory;
    }

    public String getCommandSwitches() {
        return this.command.getCVSArguments();
    }

    public FileSystemCommand getFileSystemCommand() {
        return this.command;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

