/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cvsclient.customizer;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.modules.cvsclient.customizer.LoginDialog;
import org.netbeans.modules.javacvs.commands.ClientCreationException;
import org.netbeans.modules.javacvs.passwd.CVSPasswd;
import org.netbeans.modules.javacvs.passwd.PasswdEntry;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class LoginDialog
extends JDialog {
    public final Object STATUS_CONNECTING = new Integer(0);
    public final Object STATUS_FAILED = new Integer(1);
    private static ArrayList lastSuccessfullLoggings = new ArrayList();
    private String connectStr = "";
    private PasswdEntry entry = null;
    private boolean loggedIn = false;
    private boolean offline = false;
    private Thread loginThread = null;
    private CVSPasswd passwd = null;
    private int port;
    private JPanel buttonPanel;
    private JPanel loginPanel;
    private JPanel statusPanel;
    private JButton btnLogin;
    private JLabel lblLogin;
    private JLabel lblPasswd;
    private JLabel statusLabel;
    private JButton btnCancel;
    private JPasswordField txPasswd;
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$customizer$LoginDialog == null ? (class$org$netbeans$modules$cvsclient$customizer$LoginDialog = LoginDialog.class$("org.netbeans.modules.cvsclient.customizer.LoginDialog")) : class$org$netbeans$modules$cvsclient$customizer$LoginDialog));
    static /* synthetic */ Class class$org$netbeans$modules$cvsclient$customizer$LoginDialog;

    public LoginDialog(Frame parent, boolean modal, String cvsRoot, CVSPasswd pass, int port) {
        super(parent, modal);
        this.initComponents();
        this.initAccessibility();
        this.connectStr = cvsRoot;
        this.passwd = pass;
        this.port = port;
        this.setTitle(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/customizer/Bundle").getString("LoginDialog.title"));
        this.lblLogin.setText(MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$customizer$LoginDialog == null ? (class$org$netbeans$modules$cvsclient$customizer$LoginDialog = LoginDialog.class$("org.netbeans.modules.cvsclient.customizer.LoginDialog")) : class$org$netbeans$modules$cvsclient$customizer$LoginDialog)).getString("LoginDialog.lblLogin.text"), cvsRoot));
        this.lblPasswd.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/customizer/Bundle").getString("LoginDialog.lblPasswd.mnemonic").charAt(0));
        this.lblPasswd.setLabelFor(this.txPasswd);
        this.btnLogin.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/customizer/Bundle").getString("LoginDialog.btnLogin.mnemonic").charAt(0));
        this.btnCancel.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/customizer/Bundle").getString("LoginDialog.btnCancel.mnemonic").charAt(0));
        this.pack();
        this.txPasswd.requestFocus();
        this.getRootPane().setDefaultButton(this.btnLogin);
    }

    private void initComponents() {
        this.loginPanel = new JPanel();
        this.lblLogin = new JLabel();
        this.lblPasswd = new JLabel();
        this.txPasswd = new JPasswordField();
        this.buttonPanel = new JPanel();
        this.btnLogin = new JButton();
        this.btnCancel = new JButton();
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LoginDialog.this.closeDialog(evt);
            }
        });
        this.loginPanel.setLayout(new GridBagLayout());
        this.lblLogin.setText(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/customizer/Bundle").getString("LoginDialog.lblLogin.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.loginPanel.add((Component)this.lblLogin, gridBagConstraints);
        this.lblPasswd.setText(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/customizer/Bundle").getString("LoginDialog.lblPasswd.text"));
        this.lblPasswd.setLabelFor(this.txPasswd);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.loginPanel.add((Component)this.lblPasswd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.loginPanel.add((Component)this.txPasswd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 11);
        this.getContentPane().add((Component)this.loginPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.btnLogin.setText(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/customizer/Bundle").getString("LoginDialog.btnLogin.text"));
        this.btnLogin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.loginButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.buttonPanel.add((Component)this.btnLogin, gridBagConstraints);
        this.btnCancel.setText(ResourceBundle.getBundle("org/netbeans/modules/cvsclient/customizer/Bundle").getString("LoginDialog.btnCancel.text"));
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.offlineButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.buttonPanel.add((Component)this.btnCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 11);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.statusPanel.setLayout(new GridBagLayout());
        this.statusPanel.setBorder(new BevelBorder(1));
        this.statusLabel.setText(" ");
        this.statusLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.statusPanel.add((Component)this.statusLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 17, 11);
        this.getContentPane().add((Component)this.statusPanel, gridBagConstraints);
    }

    private void offlineButtonActionPerformed(ActionEvent evt) {
        this.loggedIn = false;
        if (this.loginThread != null && this.loginThread.isAlive()) {
            this.loginThread.interrupt();
        }
        this.offline = true;
        this.closeDialog(null);
    }

    private void loginButtonActionPerformed(ActionEvent evt) {
        this.loginThread = new Thread("CVS_AUTHORIZING_THREAD"){

            public void run() {
                LoginDialog.this.checkLogin();
            }
        };
        this.loginThread.start();
    }

    private void closeDialog(WindowEvent evt) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void showLogging() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Runnable login = new Runnable(this){
                            private final /* synthetic */ 6 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void run() {
                                LoginDialog.access$300(5.access$500(6.access$400(this.this$2)));
                            }
                        };
                        new Thread(login, "CVS_AUTHORIZING_THREAD").start();
                    }

                    static /* synthetic */ 5 access$400(6 x0) {
                        return x0.this$1;
                    }
                });
            }

            static /* synthetic */ LoginDialog access$500(5 x0) {
                return x0.LoginDialog.this;
            }
        });
        this.show();
    }

    private void checkLogin() {
        ((AbstractCollection)lastSuccessfullLoggings).remove(this.connectStr);
        this.txPasswd.setEnabled(false);
        this.btnLogin.setEnabled(false);
        this.setStatus(this.STATUS_CONNECTING, null);
        StringBuffer message = new StringBuffer();
        String password = null;
        this.loggedIn = false;
        try {
            try {
                PasswdEntry entry = new PasswdEntry();
                password = new String(this.txPasswd.getPassword());
                entry.setEntry(this.connectStr + " " + CVSPasswd.scramble(password));
                this.loggedIn = this.passwd.checkServer(entry, this.port);
            }
            catch (AuthenticationException exc1) {
                if (exc1.getUnderlyingThrowable() instanceof UnknownHostException) {
                    this.setStatus(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$customizer$LoginDialog == null ? (class$org$netbeans$modules$cvsclient$customizer$LoginDialog = LoginDialog.class$("org.netbeans.modules.cvsclient.customizer.LoginDialog")) : class$org$netbeans$modules$cvsclient$customizer$LoginDialog)).getString("LoginDialog.unknownHost"));
                    Object var5_7 = null;
                    this.txPasswd.setEnabled(true);
                    this.btnLogin.setEnabled(true);
                    return;
                }
                if (exc1.getUnderlyingThrowable() instanceof IOException) {
                    this.setStatus(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$customizer$LoginDialog == null ? (class$org$netbeans$modules$cvsclient$customizer$LoginDialog = LoginDialog.class$("org.netbeans.modules.cvsclient.customizer.LoginDialog")) : class$org$netbeans$modules$cvsclient$customizer$LoginDialog)).getString("LoginDialog.connectionIOError"));
                    Object var5_8 = null;
                    this.txPasswd.setEnabled(true);
                    this.btnLogin.setEnabled(true);
                    return;
                }
                Object var5_9 = null;
                this.txPasswd.setEnabled(true);
                this.btnLogin.setEnabled(true);
            }
            Object var5_6 = null;
            this.txPasswd.setEnabled(true);
            this.btnLogin.setEnabled(true);
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            this.txPasswd.setEnabled(true);
            this.btnLogin.setEnabled(true);
            throw throwable;
        }
        if (!this.loggedIn) {
            this.setStatus(this.STATUS_FAILED, message.toString());
            this.txPasswd.requestFocus();
            this.txPasswd.setSelectionStart(0);
            this.txPasswd.setSelectionEnd(this.txPasswd.getText().length());
        } else {
            this.setStatus(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$customizer$LoginDialog == null ? (class$org$netbeans$modules$cvsclient$customizer$LoginDialog = LoginDialog.class$("org.netbeans.modules.cvsclient.customizer.LoginDialog")) : class$org$netbeans$modules$cvsclient$customizer$LoginDialog)).getString("LoginDialog.status.succeeded"));
            this.passwd.add(this.connectStr, new String(this.txPasswd.getPassword()));
            try {
                this.passwd.savePassFile();
            }
            catch (ClientCreationException exc) {
                NotifyDescriptor.Message mess = new NotifyDescriptor.Message((Object)exc.getLocalizedMessage(), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)mess);
            }
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    public void setConnectString(String connectStr) {
        this.connectStr = connectStr;
    }

    public void setPserverName(String pserverName) {
        this.lblLogin.setText(MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$customizer$LoginDialog == null ? (class$org$netbeans$modules$cvsclient$customizer$LoginDialog = LoginDialog.class$("org.netbeans.modules.cvsclient.customizer.LoginDialog")) : class$org$netbeans$modules$cvsclient$customizer$LoginDialog)).getString("LoginDialog.loginLabel.text"), pserverName));
        this.pack();
    }

    public void setStatus(Object status) {
        this.setStatus(status, null);
    }

    public void setStatus(Object status, String message) {
        if (status.equals(this.STATUS_FAILED)) {
            this.statusLabel.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$customizer$LoginDialog == null ? (class$org$netbeans$modules$cvsclient$customizer$LoginDialog = LoginDialog.class$("org.netbeans.modules.cvsclient.customizer.LoginDialog")) : class$org$netbeans$modules$cvsclient$customizer$LoginDialog)).getString("LoginDialog.status.failed"));
            if (message != null) {
                this.statusLabel.setToolTipText(message);
            }
        } else if (status.equals(this.STATUS_CONNECTING)) {
            this.statusLabel.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$customizer$LoginDialog == null ? (class$org$netbeans$modules$cvsclient$customizer$LoginDialog = LoginDialog.class$("org.netbeans.modules.cvsclient.customizer.LoginDialog")) : class$org$netbeans$modules$cvsclient$customizer$LoginDialog)).getString("LoginDialog.status.connecting"));
        } else if (status instanceof String) {
            this.statusLabel.setText((String)status);
        }
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public String getPassword() {
        return new String(this.txPasswd.getPassword());
    }

    public static LoginDialog createDialog(String cvsRoot, CVSPasswd pass, int port) {
        LoginDialog dialog = new LoginDialog(new JFrame(), true, cvsRoot, pass, port);
        return dialog;
    }

    private void initAccessibility() {
        AccessibleContext context = this.getAccessibleContext();
        context.setAccessibleDescription(bundle.getString("ACSD_LoginDialog"));
        context = this.statusLabel.getAccessibleContext();
        context.setAccessibleDescription(bundle.getString("ACSD_LoginDialog.statusLabel"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

