/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cvsclient.versioning;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.lib.cvsclient.command.PipedFileInformation;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.modules.cvsclient.FsCommandFactory;
import org.netbeans.modules.cvsclient.JavaCvsSettings;
import org.netbeans.modules.cvsclient.NbJavaCvsFileSystem;
import org.netbeans.modules.cvsclient.NbJavaCvsStatusManager;
import org.netbeans.modules.cvsclient.caching.NbCvsFsCache;
import org.netbeans.modules.cvsclient.commands.ErrorLogPanel;
import org.netbeans.modules.cvsclient.commands.JavaCvsRuntimeCommand;
import org.netbeans.modules.cvsclient.versioning.JavaCvsVersioningAction;
import org.netbeans.modules.javacvs.caching.CvsFsCache;
import org.netbeans.modules.javacvs.commands.AbstractWaitForResultsDisplayer;
import org.netbeans.modules.javacvs.commands.CvsLog;
import org.netbeans.modules.javacvs.commands.CvsUpdate;
import org.netbeans.modules.vcscore.annotation.AnnotationProvider;
import org.netbeans.modules.vcscore.annotation.AnnotationSupport;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheHandlerEvent;
import org.netbeans.modules.vcscore.cache.CacheHandlerListener;
import org.netbeans.modules.vcscore.versioning.RevisionItem;
import org.netbeans.modules.vcscore.versioning.RevisionList;
import org.netbeans.modules.vcscore.versioning.VcsFileStatusEvent;
import org.netbeans.modules.vcscore.versioning.VersioningFileSystem;
import org.netbeans.modules.vcscore.versioning.impl.NumDotRevisionItem;
import org.netbeans.modules.vcscore.versioning.impl.NumDotRevisionList;
import org.netbeans.modules.vcscore.versioning.impl.VersioningDataNode;
import org.openide.ErrorManager;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

public class JavaCvsVersioningSystem
extends VersioningFileSystem
implements CacheHandlerListener {
    private NbJavaCvsFileSystem fileSystem;
    private CvsFsCache fsCache;
    private VersioningFileSystem.Versions versions;
    private FileStatusListener fileStatus;
    private PropertyChangeListener propChange;
    private Hashtable revisionListsByName;
    private boolean showMessages = true;
    private int messageLength = 50;
    private String ignoreFiles = "~$|^\\.#";
    public static final String PROP_SHOW_DEAD_FILES = "showDeadFiles";
    public static final String PROP_SHOW_MESSAGES = "showMessages";
    public static final String PROP_MESSAGE_LENGTH = "messageLength";
    public static final String PROP_SHOW_UNIMPORTANT_FILES = "showUnimporantFiles";
    public static final String PROP_IGNORE_FILES = "ignoredFiles";
    private static final int BADGE_ICON_SHIFT_X = 16;
    private static final int BADGE_ICON_SHIFT_Y = 8;
    private VersStatus status;
    private File rootFile;
    private transient RE ignoredRE = null;
    private static final long serialVersionUID = 0L;
    private static Object vsActionAccessLock = new Object();
    private boolean showUnimportantFiles;
    static /* synthetic */ Class class$org$netbeans$modules$cvsclient$JavaCvsSettings;
    static /* synthetic */ Class class$org$netbeans$modules$cvsclient$versioning$JavaCvsVersioningAction;

    public JavaCvsVersioningSystem(NbJavaCvsFileSystem fileSystem, CvsFsCache fscache) {
        super((AbstractFileSystem)fileSystem);
        this.fileSystem = fileSystem;
        this.fsCache = fscache;
        try {
            this.setSystemName(fileSystem.getSystemName());
        }
        catch (PropertyVetoException vExc) {
            // empty catch block
        }
        ((AbstractFileSystem)this).list = new VersioningList();
        ((AbstractFileSystem)this).info = fileSystem.getVcsInfo();
        ((AbstractFileSystem)this).change = new VersioningFileSystem.VersioningFSChange((VersioningFileSystem)this);
        ((AbstractFileSystem)this).attr = new JCvsVersAttributes();
        this.versions = new VersioningVersions();
        this.status = new VersStatus();
        this.revisionListsByName = new Hashtable();
        this.initListeners();
        this.setCapability(null);
        this.rootFile = fileSystem.getRootDirectory();
        try {
            this.ignoredRE = new RE(this.ignoreFiles);
        }
        catch (RESyntaxException rese) {
            this.ignoredRE = null;
        }
    }

    private void initListeners() {
        this.fileStatus = new FileStatusListener(){

            public void annotationChanged(FileStatusEvent ev) {
                JavaCvsVersioningSystem.this.fireMyFileStatusChanged(ev);
            }
        };
        this.propChange = new FSPropertyChangeListener();
        this.fileSystem.addFileStatusListener(WeakListener.fileStatus((FileStatusListener)this.fileStatus, (Object)((Object)this.fileSystem)));
        this.fileSystem.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.propChange, (Object)((Object)this.fileSystem)));
        JavaCvsSettings settings = (JavaCvsSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$cvsclient$JavaCvsSettings == null ? (class$org$netbeans$modules$cvsclient$JavaCvsSettings = JavaCvsVersioningSystem.class$("org.netbeans.modules.cvsclient.JavaCvsSettings")) : class$org$netbeans$modules$cvsclient$JavaCvsSettings), (boolean)true);
        settings.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.propChange, (Object)((Object)settings)));
        this.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.propChange, (Object)((Object)this)));
    }

    public void addNotify() {
        super.addNotify();
        this.propagatePropertyChange(new String[]{PROP_MESSAGE_LENGTH, PROP_SHOW_MESSAGES, PROP_IGNORE_FILES});
    }

    public void removeNotify() {
        super.removeNotify();
        this.fileSystem = null;
        this.fsCache = null;
    }

    private void fireMyFileStatusChanged(FileStatusEvent ev) {
        JavaCvsVersioningSystem javaCvsVersioningSystem = this;
        synchronized (javaCvsVersioningSystem) {
            Enumeration it = this.revisionListsByName.keys();
            while (it.hasMoreElements()) {
                FileObject fo;
                String pathName = (String)it.nextElement();
                NbJavaCvsFileSystem fs = this.fileSystem;
                if (fs == null || (fo = fs.findResource(pathName)) == null || !ev.hasChanged(fo)) continue;
                RevisionList list = (RevisionList)this.revisionListsByName.get(pathName);
                AnnotationProvider prov = (AnnotationProvider)fo.getAttribute("AnnotationProviderObject");
                this.updateRevisionList(list, prov, fo);
            }
        }
        this.fireFileStatusChanged(ev);
    }

    protected File getFile(String name) {
        if (name.length() > 0) {
            return new File(this.rootFile, name);
        }
        return new File(this.rootFile.getAbsolutePath());
    }

    private void updateRevisionList(RevisionList list, AnnotationProvider provider, FileObject fo) {
        Iterator it = list.iterator();
        String actRev = provider.getAttributeValue(fo.getPackageNameExt('/', '.'), "revision");
        boolean wasSet = false;
        while (it.hasNext()) {
            RevisionItem item = (RevisionItem)it.next();
            if (item.isCurrent()) {
                if (!item.getRevision().equals(actRev)) {
                    item.setCurrent(false);
                    continue;
                }
                wasSet = true;
                continue;
            }
            if (!item.getRevision().equals(actRev)) continue;
            item.setCurrent(true);
            wasSet = true;
        }
        if (!wasSet) {
            final RevisionList oldList = list;
            final String packNameExt = fo.getPackageNameExt('/', '.');
            VersioningDataNode.getVersioningRequestProcessor().post(new Runnable(){

                public void run() {
                    VersioningVersions vers = (VersioningVersions)JavaCvsVersioningSystem.this.getVersions();
                    RevisionList newList = vers.createRevisionList(packNameExt);
                    if (oldList != null) {
                        ArrayList workNew = new ArrayList(newList);
                        RevisionList revisionList = oldList;
                        synchronized (revisionList) {
                            ArrayList workOld = new ArrayList(oldList);
                            ((AbstractCollection)workNew).removeAll((Collection<?>)oldList);
                            oldList.addAll(workNew);
                            ((AbstractCollection)workOld).removeAll((Collection<?>)newList);
                            oldList.removeAll(workOld);
                        }
                    }
                }
            });
        }
    }

    public FileSystem.Status getStatus() {
        return this.status;
    }

    public VersioningFileSystem.Versions getVersions() {
        return this.versions;
    }

    public String[] getStates(DataObject dObj) {
        return this.fileSystem.getStates(dObj);
    }

    public boolean isShowDeadFiles() {
        return false;
    }

    public void setShowDeadFiles(boolean showDeadFiles) {
        this.firePropertyChange(PROP_SHOW_DEAD_FILES, !showDeadFiles ? Boolean.TRUE : Boolean.FALSE, showDeadFiles ? Boolean.TRUE : Boolean.FALSE);
    }

    public String getIgnoredFiles() {
        return this.ignoreFiles;
    }

    public synchronized void setIgnoredFiles(String nue) throws IllegalArgumentException {
        if (!nue.equals(this.ignoreFiles)) {
            if (nue.length() > 0) {
                try {
                    this.ignoredRE = new RE(nue);
                }
                catch (RESyntaxException rese) {
                    IllegalArgumentException iae = new IllegalArgumentException();
                    ErrorManager.getDefault().annotate((Throwable)iae, (Throwable)rese);
                    throw iae;
                }
            } else {
                this.ignoredRE = null;
            }
            this.ignoreFiles = nue;
            this.firePropertyChange(PROP_IGNORE_FILES, null, nue);
            this.refreshExistingFolders();
        }
    }

    public boolean isReadOnly() {
        return false;
    }

    public SystemAction[] getRevisionActions(FileObject fo, Set revisionItems) {
        JavaCvsVersioningAction action = (JavaCvsVersioningAction)SharedClassObject.findObject((Class)(class$org$netbeans$modules$cvsclient$versioning$JavaCvsVersioningAction == null ? (class$org$netbeans$modules$cvsclient$versioning$JavaCvsVersioningAction = JavaCvsVersioningSystem.class$("org.netbeans.modules.cvsclient.versioning.JavaCvsVersioningAction")) : class$org$netbeans$modules$cvsclient$versioning$JavaCvsVersioningAction), (boolean)true);
        Object object = vsActionAccessLock;
        synchronized (object) {
            action.setFileSystem(this.fileSystem);
            action.setFileObject(this.fileSystem.findResource(fo.getPackageNameExt('/', '.')));
            action.setSelectedRevisionItems(revisionItems);
        }
        return new SystemAction[]{action};
    }

    private void vcsStatusChanged(String path, boolean recursively) {
        FileObject fo = this.findExistingResource(path);
        if (fo == null) {
            return;
        }
        Enumeration enumeration = fo.getChildren(recursively);
        HashSet<FileObject> hs = new HashSet<FileObject>();
        while (enumeration.hasMoreElements()) {
            fo = (FileObject)enumeration.nextElement();
            hs.add(fo);
        }
        Set s = Collections.synchronizedSet(hs);
        this.fireVcsFileStatusChanged(new VcsFileStatusEvent((VersioningFileSystem)this, s));
    }

    public void vcsStatusChanged(String name) {
        FileObject fo = this.findExistingResource(name);
        if (fo == null) {
            return;
        }
        this.fireVcsFileStatusChanged(new VcsFileStatusEvent((VersioningFileSystem)this, Collections.singleton(fo)));
    }

    public void statusChanged(CacheHandlerEvent event) {
        NbJavaCvsFileSystem fs = this.fileSystem;
        if (fs == null) {
            return;
        }
        String root = fs.getRootDirectory().getAbsolutePath();
        String absPath = event.getCacheFile().getAbsolutePath();
        if (absPath.startsWith(root)) {
            String path = root.length() == absPath.length() ? "" : absPath.substring(root.length() + 1, absPath.length());
            path = path.replace(File.separatorChar, '/');
            if (event.getCacheFile() instanceof CacheDir) {
                this.vcsStatusChanged(path, event.isRecursive());
            } else {
                this.vcsStatusChanged(path);
            }
        }
    }

    public void cacheRemoved(CacheHandlerEvent event) {
    }

    public void cacheAdded(CacheHandlerEvent event) {
    }

    public boolean isShowMessages() {
        return this.showMessages;
    }

    public void setShowMessages(boolean showMessages) {
        if (this.showMessages != showMessages) {
            this.showMessages = showMessages;
            this.firePropertyChange(PROP_SHOW_MESSAGES, !showMessages ? Boolean.TRUE : Boolean.FALSE, showMessages ? Boolean.TRUE : Boolean.FALSE);
            this.redisplayRevisions();
        }
    }

    private void redisplayRevisions() {
        Iterator it = this.revisionListsByName.values().iterator();
        while (it.hasNext()) {
            RevisionList list = (RevisionList)it.next();
            Iterator it2 = list.iterator();
            while (it2.hasNext()) {
                RevisionItem item = (RevisionItem)it2.next();
                if (this.isShowMessages()) {
                    if (item.getMessage() == null) continue;
                    item.setDisplayName(item.getRevision() + "  " + this.cutMessageString(item.getMessage()));
                    continue;
                }
                item.setDisplayName(item.getRevision());
            }
        }
    }

    private String cutMessageString(String message) {
        String toReturn = message;
        if (message != null && message.length() > this.getMessageLength() + 3) {
            toReturn = message.substring(0, this.getMessageLength()) + "...";
        }
        if (toReturn != null) {
            toReturn = toReturn.replace('\n', ' ');
        }
        return toReturn;
    }

    public int getMessageLength() {
        return this.messageLength;
    }

    public void setMessageLength(int messageLength) {
        int oldLength = this.messageLength;
        this.messageLength = messageLength;
        if (messageLength < 0) {
            this.messageLength = 0;
        }
        this.firePropertyChange(PROP_MESSAGE_LENGTH, new Integer(oldLength), new Integer(messageLength));
        this.redisplayRevisions();
    }

    public boolean isShowUnimportantFiles() {
        return this.showUnimportantFiles;
    }

    public void setShowUnimportantFiles(boolean showUnimportantFiles) {
        if (this.showUnimportantFiles != showUnimportantFiles) {
            this.showUnimportantFiles = showUnimportantFiles;
            this.firePropertyChange(PROP_SHOW_UNIMPORTANT_FILES, !showUnimportantFiles ? Boolean.TRUE : Boolean.FALSE, showUnimportantFiles ? Boolean.TRUE : Boolean.FALSE);
            this.refreshExistingFolders();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class VersStatus
    implements FileSystem.Status {
        private VersStatus() {
        }

        public String annotateName(String str, Set set) {
            Iterator it = set.iterator();
            AnnotationProvider provider = null;
            FileObject fo = null;
            if (it.hasNext()) {
                fo = (FileObject)it.next();
                if (fo == null || fo.isRoot()) {
                    fo = null;
                } else {
                    provider = (AnnotationProvider)fo.getAttribute("AnnotationProviderObject");
                }
            }
            String status = str;
            if (provider != null && fo != null) {
                status = AnnotationSupport.getInstance().getStatusAnnotation(fo.getNameExt(), fo.getPackageNameExt('/', '.'), provider, "JavaCvs");
            }
            return status;
        }

        public Image annotateIcon(Image icon, int param, Set set) {
            Image img;
            String status;
            FileObject fo;
            int len = set.size();
            Vector<String> important = new Vector<String>();
            Iterator it = set.iterator();
            if (it.hasNext() && (fo = (FileObject)it.next()) != null) {
                important.add(fo.getPackageNameExt('/', '.'));
            }
            if (important.size() == 0) {
                return icon;
            }
            CvsFsCache cache = JavaCvsVersioningSystem.this.fsCache;
            if (cache != null && (status = cache.getFileStatusOnly(important)) != null && (img = NbJavaCvsStatusManager.getInstance().getIcon(status)) != null) {
                icon = Utilities.mergeImages((Image)icon, (Image)img, (int)16, (int)8);
            }
            return icon;
        }
    }

    private class JCvsVersAttributes
    extends VersioningFileSystem.VersioningAttrs {
        public JCvsVersAttributes() {
            super(((AbstractFileSystem)JavaCvsVersioningSystem.this).info);
        }

        public Object readAttribute(String name, String attrName) {
            NbJavaCvsFileSystem fs;
            if ("AnnotationProviderObject".equals(attrName)) {
                CvsFsCache cache = JavaCvsVersioningSystem.this.fsCache;
                if (cache != null) {
                    return ((NbCvsFsCache)cache).getAnnotationProvider(name);
                }
                return null;
            }
            Object retValue = super.readAttribute(name, attrName);
            if (retValue == null && (fs = JavaCvsVersioningSystem.this.fileSystem) != null) {
                retValue = fs.getVcsAttributes().readAttribute(name, attrName);
            }
            return retValue;
        }
    }

    private class FSPropertyChangeListener
    implements PropertyChangeListener {
        private FSPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String propName = event.getPropertyName();
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            if ("annotationPattern".equals(propName)) {
                FileObject root = JavaCvsVersioningSystem.this.findResource("");
                HashSet foSet = new HashSet();
                Enumeration enumeration = JavaCvsVersioningSystem.super.existingFileObjects(root);
                while (enumeration.hasMoreElements()) {
                    foSet.add(enumeration.nextElement());
                }
                JavaCvsVersioningSystem.super.fireFileStatusChanged(new FileStatusEvent((FileSystem)JavaCvsVersioningSystem.this, foSet, true, true));
                return;
            }
            if ("root".equals(propName) && !event.getSource().equals((Object)JavaCvsVersioningSystem.this)) {
                JavaCvsVersioningSystem.this.rootFile = JavaCvsVersioningSystem.this.fileSystem.getRootDirectory();
                try {
                    String oldSystName = JavaCvsVersioningSystem.this.getSystemName();
                    JavaCvsVersioningSystem.super.setSystemName(JavaCvsVersioningSystem.this.fileSystem.getSystemName());
                    JavaCvsVersioningSystem.super.firePropertyChange("systemName", oldSystName, JavaCvsVersioningSystem.this.getSystemName());
                }
                catch (PropertyVetoException vExc) {
                    ErrorManager.getDefault().notify(16, (Throwable)vExc);
                }
                FileObject fo = JavaCvsVersioningSystem.super.refreshRoot();
                JavaCvsVersioningSystem.super.firePropertyChange("root", null, fo);
                return;
            }
            if ("systemName".equals(propName) && !event.getSource().equals((Object)JavaCvsVersioningSystem.this)) {
                String oldSystName = JavaCvsVersioningSystem.this.getSystemName();
                try {
                    JavaCvsVersioningSystem.super.setSystemName(JavaCvsVersioningSystem.this.fileSystem.getSystemName());
                }
                catch (PropertyVetoException vExc) {
                    ErrorManager.getDefault().notify(16, (Throwable)vExc);
                }
                FileObject fo = JavaCvsVersioningSystem.super.refreshRoot();
                JavaCvsVersioningSystem.super.firePropertyChange("systemName", oldSystName, JavaCvsVersioningSystem.this.getSystemName());
                return;
            }
        }

        private void heyDoRefreshFolderRecursive(FileObject fo) {
            fo.refresh();
            Enumeration enumeration = fo.getFolders(true);
            while (enumeration.hasMoreElements()) {
                ((FileObject)enumeration.nextElement()).refresh();
            }
        }
    }

    private class VersioningVersions
    implements VersioningFileSystem.Versions {
        static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsLog;
        static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsUpdate;

        public RevisionList getRevisions(String name, boolean refresh) {
            RevisionList list = null;
            VersioningVersions versioningVersions = this;
            synchronized (versioningVersions) {
                list = (RevisionList)JavaCvsVersioningSystem.this.revisionListsByName.get(name);
                if ((list == null || refresh) && (list = this.createRevisionList(name)) != null) {
                    JavaCvsVersioningSystem.this.revisionListsByName.put(name, list);
                }
            }
            return list;
        }

        public RevisionList createRevisionList(String name) {
            FsCommandFactory factory = FsCommandFactory.getFsInstance();
            NbJavaCvsFileSystem fs = JavaCvsVersioningSystem.this.fileSystem;
            if (fs == null) {
                return null;
            }
            FileObject fo = fs.findResource(name);
            if (fo != null) {
                CvsLog comm = (CvsLog)factory.createCommand(class$org$netbeans$modules$javacvs$commands$CvsLog == null ? (class$org$netbeans$modules$javacvs$commands$CvsLog = VersioningVersions.class$("org.netbeans.modules.javacvs.commands.CvsLog")) : class$org$netbeans$modules$javacvs$commands$CvsLog, false, new FileObject[]{fo}, fs.createClientProvider());
                comm.setRecursive(false);
                JavaCvsRuntimeCommand rCom = fs.prepareCommand(comm);
                rCom.setState(10);
                comm.addDisplayerListener(new ErrorLogPanel(comm, true));
                AbstractWaitForResultsDisplayer disp = new AbstractWaitForResultsDisplayer(comm.getImpl());
                boolean error = disp.runAndWaitForFinish();
                if (error) {
                    return null;
                }
                Object obj = fo.getAttribute("AnnotationProviderObject");
                String currentRev = "";
                if (obj != null) {
                    AnnotationProvider provider = (AnnotationProvider)obj;
                    currentRev = provider.getAttributeValue(name, "revision");
                }
                NumDotRevisionList list = new NumDotRevisionList();
                Iterator it = disp.getResultList().iterator();
                while (it.hasNext()) {
                    LogInformation info = (LogInformation)it.next();
                    Iterator revIt = info.getRevisionList().iterator();
                    while (revIt.hasNext()) {
                        LogInformation.Revision rev = (LogInformation.Revision)revIt.next();
                        NumDotRevisionItem item = new NumDotRevisionItem(rev.getNumber());
                        if (rev.getNumber().equals(currentRev)) {
                            item.setCurrent(true);
                        }
                        item.setAuthor(rev.getAuthor());
                        item.setDate(rev.getDateString());
                        item.setMessage(rev.getMessage());
                        if (JavaCvsVersioningSystem.this.isShowMessages()) {
                            item.setDisplayName(rev.getNumber() + "  " + JavaCvsVersioningSystem.this.cutMessageString(rev.getMessage()));
                        } else {
                            item.setDisplayName(rev.getNumber());
                        }
                        item.setTagNames(this.processTags(info.getAllSymbolicNames(), rev.getNumber()));
                        list.add((Object)item);
                        this.createBranchItems((RevisionList)list, info, rev);
                    }
                }
                return list;
            }
            return null;
        }

        private void createBranchItems(RevisionList addToList, LogInformation info, LogInformation.Revision revInfo) {
            String pattern = revInfo.getNumber() + ".0.";
            Iterator it = info.getAllSymbolicNames().iterator();
            while (it.hasNext()) {
                String remains;
                LogInformation.SymName name = (LogInformation.SymName)it.next();
                if (name.getRevision().startsWith(pattern)) {
                    String idName = name.getRevision();
                    int lastInd = idName.lastIndexOf(".0.");
                    idName = idName.substring(0, lastInd) + idName.substring(lastInd + 2, idName.length());
                    NumDotRevisionItem rev = new NumDotRevisionItem(idName);
                    rev.setDisplayName(rev.getRevision() + " (" + name.getName() + ")");
                    String[] tagNames = new String[]{name.getName()};
                    rev.setTagNames(tagNames);
                    addToList.add((Object)rev);
                    continue;
                }
                String number = revInfo.getNumber();
                String revString = name.getRevision();
                if (!revString.startsWith(number) || number.length() >= revString.length() || (remains = revString.substring(number.length())).lastIndexOf(46) != 0) continue;
                NumDotRevisionItem rev = new NumDotRevisionItem(revString);
                rev.setDisplayName(rev.getRevision() + " (" + name.getName() + ")");
                String[] tagNames = new String[]{name.getName()};
                rev.setTagNames(tagNames);
                addToList.add((Object)rev);
            }
        }

        private String[] processTags(List lst, String revision) {
            LinkedList<String> tags = new LinkedList<String>();
            Iterator it = lst.iterator();
            while (it.hasNext()) {
                LogInformation.SymName tag = (LogInformation.SymName)it.next();
                if (!tag.getRevision().equals(revision)) continue;
                tags.add(tag.getName());
            }
            String[] toReturn = new String[tags.size()];
            toReturn = tags.toArray(toReturn);
            return toReturn;
        }

        public InputStream inputStream(String name, String revision) throws FileNotFoundException {
            NbJavaCvsFileSystem fs = JavaCvsVersioningSystem.this.fileSystem;
            if (fs == null) {
                return null;
            }
            FsCommandFactory factory = FsCommandFactory.getFsInstance();
            FileObject fo = fs.findResource(name);
            if (fo != null) {
                CvsUpdate comm = (CvsUpdate)factory.createCommand(class$org$netbeans$modules$javacvs$commands$CvsUpdate == null ? (class$org$netbeans$modules$javacvs$commands$CvsUpdate = VersioningVersions.class$("org.netbeans.modules.javacvs.commands.CvsUpdate")) : class$org$netbeans$modules$javacvs$commands$CvsUpdate, false, new FileObject[]{fo}, fs.createClientProvider());
                comm.setRecursive(false);
                comm.setPipeToOutput(true);
                comm.setUpdateByRevision(revision);
                fs.prepareCommand(comm);
                comm.addDisplayerListener(new ErrorLogPanel(comm, false));
                AbstractWaitForResultsDisplayer disp = new AbstractWaitForResultsDisplayer(comm.getImpl());
                boolean error = disp.runAndWaitForFinish();
                if (error) {
                    return null;
                }
                Iterator it = disp.getResultList().iterator();
                if (it.hasNext()) {
                    PipedFileInformation info = (PipedFileInformation)it.next();
                    try {
                        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(info.getTempFile()));
                        return stream;
                    }
                    catch (FileNotFoundException exc) {
                        return null;
                    }
                }
            }
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class VersioningList
    implements AbstractFileSystem.List {
        private VersioningList() {
        }

        public String[] children(String name) {
            CvsFsCache cach;
            File f = JavaCvsVersioningSystem.this.getFile(name);
            String[] toReturn = null;
            if (f != null && f.isDirectory() && (cach = JavaCvsVersioningSystem.this.fsCache) != null) {
                toReturn = cach.getDirContent(f);
            }
            if (toReturn == null) {
                toReturn = new String[]{};
            }
            int i = 0;
            while (i < toReturn.length) {
                if (JavaCvsVersioningSystem.this.ignoredRE != null && JavaCvsVersioningSystem.this.ignoredRE.match(toReturn[i]) || toReturn[i].equals(".nbattrs") || !JavaCvsVersioningSystem.this.isShowUnimportantFiles() && !JavaCvsVersioningSystem.this.fileSystem.isImportant(name.length() == 0 ? toReturn[i] : name + "/" + toReturn[i])) {
                    toReturn[i] = null;
                }
                ++i;
            }
            return toReturn;
        }
    }

    private class VersioningFolderListener
    extends FileChangeAdapter {
        private VersioningFolderListener() {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            FileObject orig = (FileObject)fileRenameEvent.getSource();
            orig.refresh();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            FileObject orig = (FileObject)fileEvent.getSource();
            orig.refresh();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            FileObject orig = (FileObject)fileEvent.getSource();
            orig.refresh();
        }

        public void fileChanged(FileEvent fileEvent) {
            FileObject orig = (FileObject)fileEvent.getSource();
            orig.refresh();
        }

        public void fileDeleted(FileEvent fileEvent) {
            FileObject orig = (FileObject)fileEvent.getSource();
            orig.refresh();
        }
    }
}

