/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacvs;

import java.awt.Image;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.util.DefaultIgnoreFileFilter;
import org.netbeans.modules.javacvs.CvsCommand;
import org.netbeans.modules.javacvs.FsAdd;
import org.netbeans.modules.javacvs.FsAnnotate;
import org.netbeans.modules.javacvs.FsCheckout;
import org.netbeans.modules.javacvs.FsCommit;
import org.netbeans.modules.javacvs.FsDiff;
import org.netbeans.modules.javacvs.FsExport;
import org.netbeans.modules.javacvs.FsGlobalOptions;
import org.netbeans.modules.javacvs.FsHistory;
import org.netbeans.modules.javacvs.FsImport;
import org.netbeans.modules.javacvs.FsLog;
import org.netbeans.modules.javacvs.FsRemove;
import org.netbeans.modules.javacvs.FsStatus;
import org.netbeans.modules.javacvs.FsTag;
import org.netbeans.modules.javacvs.FsUpdate;
import org.netbeans.modules.javacvs.FsWatchers;
import org.netbeans.modules.javacvs.JavaCvsFileSystem;
import org.netbeans.modules.javacvs.JavaCvsFileSystemException;
import org.netbeans.modules.javacvs.caching.CvsCacheFile;
import org.netbeans.modules.javacvs.caching.CvsFsCache;
import org.netbeans.modules.javacvs.caching.JavaCvsCache;
import org.netbeans.modules.javacvs.caching.RefreshCommand;
import org.netbeans.modules.javacvs.commands.ClientProvider;
import org.netbeans.modules.javacvs.commands.CvsAdd;
import org.netbeans.modules.javacvs.commands.CvsAnnotate;
import org.netbeans.modules.javacvs.commands.CvsCheckout;
import org.netbeans.modules.javacvs.commands.CvsCommit;
import org.netbeans.modules.javacvs.commands.CvsDiff;
import org.netbeans.modules.javacvs.commands.CvsExport;
import org.netbeans.modules.javacvs.commands.CvsHistory;
import org.netbeans.modules.javacvs.commands.CvsImport;
import org.netbeans.modules.javacvs.commands.CvsLog;
import org.netbeans.modules.javacvs.commands.CvsRemove;
import org.netbeans.modules.javacvs.commands.CvsStatus;
import org.netbeans.modules.javacvs.commands.CvsTag;
import org.netbeans.modules.javacvs.commands.CvsUpdate;
import org.netbeans.modules.javacvs.commands.CvsWatchers;
import org.netbeans.modules.javacvs.commands.FileSystemCommand;
import org.netbeans.modules.javacvs.commands.FileSystemCommandImpl;
import org.netbeans.modules.javacvs.commands.FsGlobalOptionsImpl;
import org.netbeans.modules.javacvs.commands.JavaCvsCommandFactory;
import org.netbeans.modules.javacvs.commands.JavaCvsStatusManager;
import org.netbeans.modules.javacvs.commands.StandardClientProvider;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.CacheHandlerEvent;
import org.netbeans.modules.vcscore.cache.CacheHandlerListener;
import org.netbeans.modules.vcscore.cache.CacheReference;
import org.netbeans.modules.vcscore.cache.CachedFileSystem;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.openide.ErrorManager;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.DefaultAttributes;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

public class JavaCvsFileSystem
extends AbstractFileSystem {
    static final long serialVersionUID = -5990750897426301780L;
    public static final String PROP_REL_MOUNT = "relMount";
    public static final String PROP_WORKING_DIR = "workingDir";
    public static final String PROP_OFF_LINE = "offLine";
    public static final String PROP_AUTO_REFRESH = "autoRefresh";
    public static final String PROP_ZIPPED_TRANSFER = "ZippedTransfer";
    public static final String PROP_HIDE_SHADOW_FILES = "hideShadowFiles";
    public static final String PROP_CVS_IGNORE_LIST = "cvsIgnoreList";
    public static final String PROP_FS_INGORED_FILES = "fsIgnoredFiles";
    public static final String PROP_CREATE_BACKUPS = "createBackups";
    public static final String PROP_CVS_SERVER_TYPE = "cvsServerType";
    public static final String PROP_CVS_SERVER_NAME = "cvsServerName";
    public static final String PROP_CVS_USER_NAME = "cvsUserName";
    public static final String PROP_CVS_REPOSITORY = "cvsRepository";
    public static final String PROP_CVS_PORT = "cvsPort";
    public static final int STANDARD_PORT = 2401;
    public static final int AUTO_NONE = 0;
    public static final int AUTO_SIMPLE = 1;
    public static final int AUTO_RECURS_ONCE = 2;
    public static final int AUTO_RECURS_EVERYTIME = 3;
    public static final int AUTO_MOUNT_AND_RESTART = 4;
    public static final int TYPE_SERVER = 0;
    public static final int TYPE_PSERVER = 1;
    private static final String[] TYPE_NAMES = new String[]{"server", "pserver"};
    protected static final int REFRESH_TIME = 0;
    private static final int BADGE_ICON_SHIFT_X = 16;
    private static final int BADGE_ICON_SHIFT_Y = 8;
    protected int refreshTimeToSet = 0;
    private File rootFile = null;
    private boolean readOnly;
    protected transient CvsFsCache cache = null;
    private boolean isRootSet;
    private long cacheId = 0L;
    private File workingDir = null;
    private String relMount = "";
    private boolean offLine = false;
    private int autoRefresh = 0;
    private boolean zippedTransfer = true;
    private boolean hideShadowFiles = false;
    protected String fsIgnoredFiles = "~$|^\\.#";
    protected transient RE ignoredRE = null;
    private String repository = "";
    private String serverName = "";
    private int serverType = 1;
    private String userName = "";
    protected FileSystem.Status status;
    private File homeDirectory = new File(System.getProperty("user.home"));
    private ErrorManager errorManager;
    private int cvsPort = 2401;
    private boolean createBackups = true;
    private transient CacheHandlerListener cacheListener;
    private transient RepositoryListener addRemoveFSListener;
    private transient boolean freshlyMounted = false;
    protected transient WeakReference ignoreListReference;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$cache$CacheHandlerListener;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$JavaCvsFileSystem;
    static /* synthetic */ Class class$org$openide$ErrorManager;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsStatus;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsLog;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsUpdate;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsTag;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsRemove;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsDiff;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsCommit;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsCheckout;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsAdd;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsAnnotate;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsImport;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsExport;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsHistory;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsWatchers;

    public JavaCvsFileSystem() {
        this.initImpls();
        DefaultAttributes defattr = new DefaultAttributes(this.info, this.change, (AbstractFileSystem.List)new ListImpl());
        this.attr = defattr;
        this.list = defattr;
        this.isRootSet = false;
        this.setRefreshTime(0);
        this.setWorkingDir(new File(System.getProperty("user.home")));
        this.setOffLine(false);
        this.setAutoRefresh(0);
        this.setHideShadowFiles(false);
        try {
            this.ignoredRE = new RE(this.fsIgnoredFiles);
        }
        catch (RESyntaxException rese) {
            this.ignoredRE = null;
        }
        this.freshlyMounted = true;
        this.initCache();
        this.independantInit();
        this.addRemoveFSListener = new FSRepositoryListener();
        Repository.getDefault().addRepositoryListener(WeakListener.repository((RepositoryListener)this.addRemoveFSListener, (Object)((Object)this)));
    }

    protected void initImpls() {
        this.info = new InfoImpl();
        this.change = new ChangeImpl();
        this.status = new MyStatus();
    }

    public JavaCvsFileSystem(FileSystemCapability cap) {
        this();
        this.setCapability(cap);
    }

    protected void initCache() {
        CacheHandler handler = CacheHandler.getInstance();
        JavaCvsCache cache = (JavaCvsCache)handler.getCache("javacvs");
        if (cache == null) {
            cache = new JavaCvsCache();
            handler.registerCacheType("javacvs", (FileSystemCache)cache);
        }
        cache.registerFileSystem((FileSystem)this);
        this.cacheListener = new CacheHandlerListenerImpl();
        cache.addCacheHandlerListener((CacheHandlerListener)WeakListener.create((Class)(class$org$netbeans$modules$vcscore$cache$CacheHandlerListener == null ? (class$org$netbeans$modules$vcscore$cache$CacheHandlerListener = JavaCvsFileSystem.class$("org.netbeans.modules.vcscore.cache.CacheHandlerListener")) : class$org$netbeans$modules$vcscore$cache$CacheHandlerListener), (EventListener)this.cacheListener, (Object)((Object)cache)));
    }

    protected void independantInit() {
        if (((Object)((Object)this)).getClass().equals(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem)) {
            Lookup l = Lookup.getDefault();
            this.errorManager = (ErrorManager)l.lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = JavaCvsFileSystem.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
            this.cache = new CvsFsCache(this, this.getHomeDirectory());
            this.cache.setAutoRefresh(this.getAutoRefresh());
            this.cache.setOffLine(this.isOffLine());
            this.cache.setHideShadowFiles(this.isHideShadowFiles());
            this.cache.setFsRootFile(new File(this.constructRootDirectory()));
        }
    }

    protected String computeSystemName(File rootFile, int seed) {
        if (seed == 0) {
            return "org.netbeans.modules.javacvs.JavaCvsFileSystem " + rootFile.toString();
        }
        return "org.netbeans.modules.javacvs.JavaCvsFileSystem " + rootFile.toString() + seed;
    }

    public String getDisplayName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem), (String)"JavaCvsFileSystem.validFilesystemLabel", (Object)this.rootFile.toString());
    }

    public void setHomeDirectory(File homeDir) {
        this.homeDirectory = homeDir;
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    public File getRootDirectory() {
        return this.rootFile;
    }

    public JavaCvsCommandFactory getCommandFactory() {
        return JavaCvsCommandFactory.getInstance();
    }

    private synchronized void setRootDirectory(File r) throws PropertyVetoException, IOException {
        if (!r.exists() || r.isFile()) {
            throw new JavaCvsFileSystemException(r.toString() + " does not exist", NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem), (String)"JavaCvsFileSystem.EXC_root_dir_does_not_exist", (Object)r.toString()));
        }
        boolean ok = false;
        int seed = 0;
        while (!ok) {
            try {
                this.setSystemName(this.computeSystemName(r, seed));
                ok = true;
            }
            catch (PropertyVetoException exc) {
                ok = false;
                ++seed;
            }
        }
        this.rootFile = r;
        FileObject fo = this.refreshRoot();
        this.firePropertyChange("root", null, fo);
        this.firePropertyChange("name", null, this.getDisplayName());
        fo = this.findResource("");
        this.isRootSet = true;
    }

    public String constructRootDirectory() {
        StringBuffer root = new StringBuffer();
        if (this.workingDir != null) {
            root.append(this.workingDir.getAbsolutePath());
        }
        if (root.charAt(root.length() - 1) != File.separatorChar) {
            root.append(File.separatorChar);
        }
        if (this.relMount.startsWith(File.separator)) {
            root.append(this.relMount.substring(1));
        } else {
            root.append(this.relMount);
        }
        if (root.charAt(root.length() - 1) == File.separatorChar) {
            root = root.deleteCharAt(root.length() - 1);
        }
        String toReturn = root.toString().replace('/', File.separatorChar);
        toReturn = toReturn.replace('\\', File.separatorChar);
        return toReturn;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean flag) {
        if (flag != this.readOnly) {
            this.readOnly = flag;
            this.firePropertyChange("readOnly", !flag ? Boolean.TRUE : Boolean.FALSE, flag ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void setWorkingDir(File newWorking) {
        if (!newWorking.equals(this.workingDir)) {
            File oldWorking = this.workingDir;
            this.workingDir = newWorking;
            String oldRelMount = this.relMount;
            this.firePropertyChange(PROP_WORKING_DIR, oldWorking, newWorking);
            this.setRelMount("");
            try {
                this.setRootDirectory(new File(this.constructRootDirectory()));
            }
            catch (PropertyVetoException prop) {
                this.workingDir = oldWorking;
                this.firePropertyChange(PROP_WORKING_DIR, newWorking, oldWorking);
                this.firePropertyChange(PROP_REL_MOUNT, "", oldRelMount);
                return;
            }
            catch (IOException io) {
                this.workingDir = oldWorking;
                this.firePropertyChange(PROP_WORKING_DIR, newWorking, oldWorking);
                this.firePropertyChange(PROP_REL_MOUNT, "", oldRelMount);
                return;
            }
        }
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setRelMount(String newMount) {
        if (!newMount.equals(this.relMount)) {
            String oldMount = this.relMount;
            this.relMount = newMount;
            try {
                this.setRootDirectory(new File(this.constructRootDirectory()));
            }
            catch (PropertyVetoException prop) {
                this.relMount = oldMount;
                return;
            }
            catch (IOException io) {
                this.relMount = oldMount;
                return;
            }
            this.firePropertyChange(PROP_REL_MOUNT, oldMount, newMount);
        }
    }

    public String getRelMount() {
        if (this.relMount == null) {
            return "";
        }
        return this.relMount;
    }

    public boolean isOffLine() {
        return this.offLine;
    }

    public void setOffLine(boolean off) {
        if (off != this.offLine) {
            this.offLine = off;
            this.firePropertyChange(PROP_OFF_LINE, !this.offLine ? Boolean.TRUE : Boolean.FALSE, off ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean checkOffLine() {
        return this.isOffLine();
    }

    public int getAutoRefresh() {
        return this.autoRefresh;
    }

    public void setAutoRefresh(int newAuto) {
        if (newAuto != this.autoRefresh) {
            int oldAuto = this.autoRefresh;
            this.autoRefresh = newAuto;
            this.firePropertyChange(PROP_AUTO_REFRESH, new Integer(oldAuto), new Integer(this.autoRefresh));
        }
    }

    public boolean isZippedTransfer() {
        return this.zippedTransfer;
    }

    public void setZippedTransfer(boolean zipped) {
        if (this.zippedTransfer != zipped) {
            this.firePropertyChange(PROP_ZIPPED_TRANSFER, !zipped ? Boolean.TRUE : Boolean.FALSE, zipped ? Boolean.TRUE : Boolean.FALSE);
            this.zippedTransfer = zipped;
        }
    }

    public String getFsIgnoredFiles() {
        return this.fsIgnoredFiles;
    }

    public synchronized void setFsIgnoredFiles(String nue) throws IllegalArgumentException {
        if (!nue.equals(this.fsIgnoredFiles)) {
            if (nue.length() > 0) {
                try {
                    this.ignoredRE = new RE(nue);
                }
                catch (RESyntaxException rese) {
                    IllegalArgumentException iae = new IllegalArgumentException();
                    throw iae;
                }
            } else {
                this.ignoredRE = null;
            }
            this.fsIgnoredFiles = nue;
            this.firePropertyChange(PROP_FS_INGORED_FILES, null, null);
            Enumeration en = this.existingFileObjects(this.findResource(""));
            while (en.hasMoreElements()) {
                FileObject fo2 = (FileObject)en.nextElement();
                if (fo2 == null || !fo2.isFolder()) continue;
                fo2.refresh(true);
            }
        }
    }

    public void setHideShadowFiles(boolean hide) {
    }

    public boolean isHideShadowFiles() {
        return false;
    }

    public void setCvsRepository(String repos) {
        if (!repos.equals(this.repository)) {
            String oldRepos = this.repository;
            this.repository = repos;
            this.firePropertyChange(PROP_CVS_REPOSITORY, oldRepos, repos);
        }
    }

    public String getCvsRepository() {
        return this.repository;
    }

    public void setCvsServerType(int type) {
        if (this.serverType != type) {
            int old = this.serverType;
            this.serverType = type;
            this.firePropertyChange(PROP_CVS_SERVER_TYPE, new Integer(old), new Integer(type));
        }
    }

    public int getCvsServerType() {
        return this.serverType;
    }

    public int getCvsServerType(String typeName) {
        int index = 0;
        while (index < TYPE_NAMES.length) {
            if (TYPE_NAMES[index].equalsIgnoreCase(typeName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public String[] getCvsServerTypes() {
        return TYPE_NAMES;
    }

    public String getCvsServerTypeName() {
        if (this.serverType >= 0 && this.serverType < TYPE_NAMES.length) {
            return TYPE_NAMES[this.serverType];
        }
        return "";
    }

    public String getCvsServerTypeName(int type) {
        if (type >= 0 && type < TYPE_NAMES.length) {
            return TYPE_NAMES[type];
        }
        return "";
    }

    public void setCvsServerName(String name) {
        if (!name.equals(this.serverName)) {
            String oldName = this.serverName;
            this.serverName = name;
            this.firePropertyChange(PROP_CVS_SERVER_NAME, oldName, name);
        }
    }

    public String getCvsServerName() {
        return this.serverName;
    }

    public void setCvsUserName(String name) {
        if (!name.equals(this.userName)) {
            String oldName = this.userName;
            this.userName = name;
            this.firePropertyChange(PROP_CVS_USER_NAME, oldName, name);
        }
    }

    public String getCvsUserName() {
        return this.userName;
    }

    public int getCvsPort() {
        return this.cvsPort;
    }

    public void setCvsPort(int cvsPort) {
        if (cvsPort != this.cvsPort) {
            int old = this.cvsPort;
            this.cvsPort = cvsPort;
            this.firePropertyChange(PROP_CVS_PORT, new Integer(old), new Integer(cvsPort));
        }
    }

    public String getCvsRootString() {
        StringBuffer toReturn = new StringBuffer(":");
        toReturn.append(this.getCvsServerTypeName());
        toReturn.append(':');
        toReturn.append(this.getCvsUserName());
        toReturn.append('@');
        toReturn.append(this.getCvsServerName());
        toReturn.append(':');
        if (this.getCvsPort() != 2401) {
            toReturn.append("" + this.getCvsPort());
        }
        toReturn.append(this.getCvsRepository());
        return toReturn.toString();
    }

    protected JavaCvsStatusManager getStatusManager() {
        return JavaCvsStatusManager.getInstance();
    }

    public void prepareEnvironment(FileSystem.Environment environment) {
        environment.addClassPath(this.rootFile.toString());
    }

    public FileSystem.Status getStatus() {
        return this.status;
    }

    public SystemAction[] getActions() {
        return null;
    }

    public SystemAction[] getActions(Set fos) {
        return null;
    }

    protected void handleDelete(String name) {
    }

    protected void handleRename(String oldName, String newName) {
    }

    protected CacheReference getCacheReference(String name) {
        Reference ref = this.findReference(name);
        if (ref != null && ref instanceof CacheReference) {
            CacheReference cref = (CacheReference)ref;
            return cref;
        }
        return null;
    }

    protected File getFile(String name) {
        if (name.length() > 0) {
            return new File(this.rootFile, name);
        }
        return new File(this.rootFile.getAbsolutePath());
    }

    protected File[] getFiles(FileObject[] fos) {
        File[] files = new File[fos.length];
        int index = 0;
        while (index < fos.length) {
            if (fos[index] != null) {
                String name = fos[index].getPackageNameExt('/', '.');
                files[index] = this.getFile(name);
            }
            ++index;
        }
        return files;
    }

    public FileObject getFileObjectForFile(File file) {
        String root = this.constructRootDirectory();
        String absPath = file.getAbsolutePath();
        if (absPath.startsWith(root)) {
            String path;
            if (absPath.equals(root)) {
                path = "";
            } else {
                path = absPath.substring(root.length() + 1, absPath.length());
                if (path.length() > 0 && path.charAt(0) == File.separatorChar) {
                    path = path.substring(1);
                }
            }
            path = path.replace('\\', '/');
            FileObject fo = this.findResource(path);
            return fo;
        }
        return null;
    }

    private Set getRecursFileObjectSet(File file) {
        FileObject fo = this.getFileObjectForFile(file);
        if (fo != null) {
            HashSet toReturn = new HashSet();
            Enumeration enumeration = fo.getChildren(true);
            while (enumeration.hasMoreElements()) {
                toReturn.add(enumeration.nextElement());
            }
            return toReturn;
        }
        return null;
    }

    public void setRefreshTimeToSet() {
        this.setRefreshTime(this.refreshTimeToSet);
    }

    public boolean isImportant(String name) {
        CacheReference rf = this.getCacheReference(name);
        if (rf != null) {
            return rf.isImportant();
        }
        return true;
    }

    protected Vector getImportantFiles(Object[] oo) {
        Vector<String> result = new Vector<String>(3);
        int len = oo.length;
        int i = 0;
        while (i < len) {
            FileObject ff = (FileObject)oo[i];
            if (ff != null) {
                String fullName;
                boolean isFromThisFs = true;
                try {
                    isFromThisFs = ff.getFileSystem().equals((Object)this);
                }
                catch (FileStateInvalidException exc) {
                    isFromThisFs = true;
                }
                if (isFromThisFs && this.isImportant(fullName = ff.getPackageNameExt('/', '.'))) {
                    result.addElement(fullName);
                }
            }
            ++i;
        }
        return result;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException, NotActiveException {
        in.defaultReadObject();
        this.initCache();
        this.independantInit();
        if (this.cvsPort == 0) {
            this.setCvsPort(2401);
        }
        if (this.fsIgnoredFiles == null) {
            this.fsIgnoredFiles = "";
        } else if (this.fsIgnoredFiles.length() > 0) {
            try {
                this.ignoredRE = new RE(this.fsIgnoredFiles);
            }
            catch (RESyntaxException rESyntaxException) {
                // empty catch block
            }
        }
        this.freshlyMounted = false;
        this.addRemoveFSListener = new FSRepositoryListener();
        Repository.getDefault().addRepositoryListener(WeakListener.repository((RepositoryListener)this.addRemoveFSListener, (Object)((Object)this)));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    protected ClientProvider createClientProvider() {
        StandardClientProvider client = new StandardClientProvider(this.getHomeDirectory());
        client.setCvsRootString(this.getCvsRootString());
        client.setCvsPort(this.getCvsPort());
        client.setLocalPath(this.getRootDirectory().getAbsolutePath());
        List ignoreList = JavaCvsFileSystem.constructIgnoreList(this.getHomeDirectory(), new File(this.getWorkingDir(), "CVSROOT"));
        DefaultIgnoreFileFilter ignoreFilter = new DefaultIgnoreFileFilter(ignoreList);
        client.setIgnoreFilter(ignoreFilter);
        FsGlobalOptionsImpl glOptions = (FsGlobalOptionsImpl)this.getCommandFactory().getGlobalOptions();
        client.setGlobalOptions(glOptions.getLibraryGlobalOptions());
        return client;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] getCvsIgnoreList() {
        Object obj = null;
        if (this.ignoreListReference != null) {
            Object t = this.ignoreListReference.get();
            obj = t;
            if (t != null) return obj;
        }
        List ignoreList = JavaCvsFileSystem.constructIgnoreList(this.getHomeDirectory(), new File(this.getWorkingDir(), "CVSROOT"));
        String[] array = new String[ignoreList.size()];
        array = ignoreList.toArray(array);
        this.ignoreListReference = new WeakReference<String[]>(array);
        return array;
    }

    public static List constructIgnoreList(File home, File cvsRootDir) {
        List<String> ignoreList = null;
        File ignoreFile = new File(cvsRootDir, "cvsignore");
        try {
            ignoreList = DefaultIgnoreFileFilter.parseCvsIgnoreFile(ignoreFile);
        }
        catch (IOException exc) {
            // empty catch block
        }
        if (ignoreList == null) {
            ignoreList = new LinkedList();
        }
        ignoreFile = new File(home, ".cvsignore");
        try {
            ignoreList = DefaultIgnoreFileFilter.parseCvsIgnoreFile(ignoreFile);
        }
        catch (IOException exc) {
            // empty catch block
        }
        String envIgnore = System.getProperty("env-cvsignore");
        if (envIgnore != null) {
            StringTokenizer token = new StringTokenizer(envIgnore, " ", false);
            while (token.hasMoreTokens()) {
                String tok = token.nextToken();
                ignoreList.add(tok);
            }
        }
        return ignoreList;
    }

    public void doRefresh(FileObject[] fileNames, boolean recursive) {
        File[] fos;
        if (this.isOffLine()) {
            return;
        }
        File[] files = this.getFiles(fileNames);
        LinkedList<File> dirs = new LinkedList<File>();
        LinkedList<File> fls = new LinkedList<File>();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                dirs.add(files[i]);
            } else {
                fls.add(files[i]);
            }
            ++i;
        }
        if (dirs.size() > 0) {
            fos = new File[dirs.size()];
            fos = dirs.toArray(fos);
            this.cache.doRefresh(fos, recursive);
        }
        if (fls.size() > 0) {
            fos = new File[fls.size()];
            fos = fls.toArray(fos);
            this.cache.doRefresh(fos, recursive);
        }
    }

    protected void notifyFSAdded() {
        this.cache.addNotify(this);
        this.initCache();
        FileObject[] root = new FileObject[]{this.findResource("")};
        if (this.getAutoRefresh() == 2 && this.freshlyMounted || this.getAutoRefresh() == 3 && !this.freshlyMounted || this.getAutoRefresh() == 4) {
            this.doRefresh(root, true);
        }
    }

    protected void notifyFSRemoved() {
        if (this.cache != null) {
            this.cache.removeNotify();
        }
    }

    protected void fireRecursiveFileStatus(FileObject fo) {
        HashSet<FileObject> foSet = new HashSet<FileObject>();
        Enumeration enumeration = fo.getChildren(true);
        while (enumeration.hasMoreElements()) {
            FileObject suFO = (FileObject)enumeration.nextElement();
            foSet.add(suFO);
            suFO.refresh(true);
        }
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, foSet, true, true));
    }

    protected void fireFileStatusForExisting(FileObject fo) {
        HashSet<FileObject> foSet = new HashSet<FileObject>();
        Enumeration enumeration = this.existingFileObjects(fo);
        while (enumeration.hasMoreElements()) {
            FileObject exFo = (FileObject)enumeration.nextElement();
            boolean reload = this.setVirtualDataLoader(exFo);
            foSet.add(exFo);
        }
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, foSet, true, true));
    }

    protected void reloadChangedDataObjects(Set reloadSet) {
    }

    protected void refreshExisting(FileObject fo) {
        Enumeration enumeration = this.existingFileObjects(fo);
        while (enumeration.hasMoreElements()) {
            FileObject exFo = (FileObject)enumeration.nextElement();
            if (exFo.isFolder()) {
                exFo.refresh();
                continue;
            }
            exFo.refresh(true);
        }
    }

    protected boolean setVirtualDataLoader(FileObject fo) {
        return false;
    }

    protected Reference createReference(FileObject fo) {
        return this.cache.createReference(fo);
    }

    public FsStatus createStatus() {
        CvsStatus stat = (CvsStatus)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsStatus == null ? (class$org$netbeans$modules$javacvs$commands$CvsStatus = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsStatus")) : class$org$netbeans$modules$javacvs$commands$CvsStatus, false);
        ClientProvider prov = this.createClientProvider();
        stat.setClientProvider(prov);
        return stat.getStatusImpl();
    }

    public FsStatus createRefresh() {
        RefreshCommand stat = new RefreshCommand();
        ClientProvider prov = this.createClientProvider();
        stat.setClientProvider(prov);
        return stat.getStatusImpl();
    }

    public FsLog createLog() {
        CvsLog stat = (CvsLog)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsLog == null ? (class$org$netbeans$modules$javacvs$commands$CvsLog = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsLog")) : class$org$netbeans$modules$javacvs$commands$CvsLog, false);
        ClientProvider prov = this.createClientProvider();
        stat.setClientProvider(prov);
        return stat.getLogImpl();
    }

    public FsUpdate createUpdate() {
        CvsUpdate stat = (CvsUpdate)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsUpdate == null ? (class$org$netbeans$modules$javacvs$commands$CvsUpdate = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsUpdate")) : class$org$netbeans$modules$javacvs$commands$CvsUpdate, false);
        ClientProvider prov = this.createClientProvider();
        stat.setClientProvider(prov);
        return stat.getUpdateImpl();
    }

    public FsTag createTag() {
        CvsTag stat = (CvsTag)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsTag == null ? (class$org$netbeans$modules$javacvs$commands$CvsTag = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsTag")) : class$org$netbeans$modules$javacvs$commands$CvsTag, false);
        ClientProvider prov = this.createClientProvider();
        stat.setClientProvider(prov);
        return stat.getTagImpl();
    }

    public FsRemove createRemove() {
        CvsRemove stat = (CvsRemove)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsRemove == null ? (class$org$netbeans$modules$javacvs$commands$CvsRemove = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsRemove")) : class$org$netbeans$modules$javacvs$commands$CvsRemove, false);
        ClientProvider prov = this.createClientProvider();
        stat.setClientProvider(prov);
        return stat.getRemoveImpl();
    }

    public FsDiff createDiff() {
        CvsDiff stat = (CvsDiff)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsDiff == null ? (class$org$netbeans$modules$javacvs$commands$CvsDiff = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsDiff")) : class$org$netbeans$modules$javacvs$commands$CvsDiff, false);
        ClientProvider prov = this.createClientProvider();
        stat.setClientProvider(prov);
        return stat.getDiffImpl();
    }

    public FsCommit createCommit() {
        CvsCommit stat = (CvsCommit)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsCommit == null ? (class$org$netbeans$modules$javacvs$commands$CvsCommit = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsCommit")) : class$org$netbeans$modules$javacvs$commands$CvsCommit, false);
        ClientProvider prov = this.createClientProvider();
        stat.setClientProvider(prov);
        return stat.getCommitImpl();
    }

    public FsCheckout createCheckout() {
        CvsCheckout stat = (CvsCheckout)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsCheckout == null ? (class$org$netbeans$modules$javacvs$commands$CvsCheckout = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsCheckout")) : class$org$netbeans$modules$javacvs$commands$CvsCheckout, false);
        ClientProvider prov = this.createClientProvider();
        stat.setLocalPath(this.getWorkingDir().getAbsolutePath());
        stat.setClientProvider(prov);
        return stat.getCheckoutImpl();
    }

    public FsAdd createAdd() {
        CvsAdd stat = (CvsAdd)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsAdd == null ? (class$org$netbeans$modules$javacvs$commands$CvsAdd = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsAdd")) : class$org$netbeans$modules$javacvs$commands$CvsAdd, false);
        ClientProvider prov = this.createClientProvider();
        stat.setClientProvider(prov);
        return stat.getAddImpl();
    }

    public FsAnnotate createAnnotate() {
        CvsAnnotate stat = (CvsAnnotate)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsAnnotate == null ? (class$org$netbeans$modules$javacvs$commands$CvsAnnotate = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsAnnotate")) : class$org$netbeans$modules$javacvs$commands$CvsAnnotate, false);
        ClientProvider prov = this.createClientProvider();
        stat.setClientProvider(prov);
        return stat.getAnnotateImpl();
    }

    public FsImport createImport() {
        CvsImport stat = (CvsImport)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsImport == null ? (class$org$netbeans$modules$javacvs$commands$CvsImport = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsImport")) : class$org$netbeans$modules$javacvs$commands$CvsImport, false);
        ClientProvider prov = this.createClientProvider();
        stat.setClientProvider(prov);
        return stat.getImportImpl();
    }

    public FsExport createExport() {
        CvsExport stat = (CvsExport)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsExport == null ? (class$org$netbeans$modules$javacvs$commands$CvsExport = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsExport")) : class$org$netbeans$modules$javacvs$commands$CvsExport, false);
        ClientProvider prov = this.createClientProvider();
        stat.setClientProvider(prov);
        return stat.getExportImpl();
    }

    public FsHistory createHistory() {
        CvsHistory stat = (CvsHistory)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsHistory == null ? (class$org$netbeans$modules$javacvs$commands$CvsHistory = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsHistory")) : class$org$netbeans$modules$javacvs$commands$CvsHistory, false);
        ClientProvider prov = this.createClientProvider();
        stat.setClientProvider(prov);
        return stat.getHistoryImpl();
    }

    public FsWatchers createWatchers() {
        CvsWatchers stat = (CvsWatchers)this.getCommandFactory().getCommand(class$org$netbeans$modules$javacvs$commands$CvsWatchers == null ? (class$org$netbeans$modules$javacvs$commands$CvsWatchers = JavaCvsFileSystem.class$("org.netbeans.modules.javacvs.commands.CvsWatchers")) : class$org$netbeans$modules$javacvs$commands$CvsWatchers, false);
        ClientProvider prov = this.createClientProvider();
        stat.setClientProvider(prov);
        return stat.getWatchersImpl();
    }

    public FsGlobalOptions getGlobalOptionsFor(CvsCommand command) {
        FileSystemCommandImpl impl = (FileSystemCommandImpl)((Object)command);
        FileSystemCommand comm = impl.getOuterClassInstance();
        return new FsGlobalOptionsImpl(comm.getGlobalOptions());
    }

    protected boolean checkVirtual(String name) {
        File file = this.getFile(name);
        return !file.exists();
    }

    public boolean isCreateBackups() {
        return this.createBackups;
    }

    public void setCreateBackups(boolean createBacks) {
        if (this.createBackups != createBacks) {
            this.createBackups = createBacks;
            this.firePropertyChange(PROP_CREATE_BACKUPS, !createBacks ? Boolean.TRUE : Boolean.FALSE, createBacks ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    protected void markImportant(String name, boolean important) {
        CacheReference ref;
        super.markImportant(name, important);
        if (important && (ref = this.getCacheReference(name)) != null) {
            ref.markImportant();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FSRepositoryListener
    implements RepositoryListener {
        private FSRepositoryListener() {
        }

        public void fileSystemAdded(RepositoryEvent repositoryEvent) {
            if (((Object)((Object)JavaCvsFileSystem.this)).equals(repositoryEvent.getFileSystem())) {
                JavaCvsFileSystem.this.notifyFSAdded();
            }
        }

        public void fileSystemPoolReordered(RepositoryReorderedEvent repositoryReorderedEvent) {
        }

        public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
            if (((Object)((Object)JavaCvsFileSystem.this)).equals(repositoryEvent.getFileSystem())) {
                JavaCvsFileSystem.this.notifyFSRemoved();
            }
        }
    }

    private class CacheHandlerListenerImpl
    implements CacheHandlerListener {
        private CacheHandlerListenerImpl() {
        }

        public void cacheRemoved(CacheHandlerEvent event) {
            this.cacheAdded(event);
        }

        public void statusChanged(CacheHandlerEvent event) {
            FileObject fo = JavaCvsFileSystem.this.getFileObjectForFile(new File(event.getCacheFile().getAbsolutePath()));
            if (fo == null) {
                return;
            }
            if (!event.isRecursive()) {
                if (fo.isFolder()) {
                    HashSet foSet = new HashSet();
                    Enumeration enumeration = fo.getChildren(false);
                    while (enumeration.hasMoreElements()) {
                        foSet.add(enumeration.nextElement());
                    }
                    JavaCvsFileSystem.super.fireFileStatusChanged(new FileStatusEvent((FileSystem)JavaCvsFileSystem.this, foSet, true, true));
                } else {
                    JavaCvsFileSystem.super.fireFileStatusChanged(new FileStatusEvent((FileSystem)JavaCvsFileSystem.this, fo, true, true));
                }
            } else {
                this.cacheAdded(event);
            }
        }

        public void cacheAdded(CacheHandlerEvent event) {
            String root;
            CacheFile file = event.getCacheFile();
            String fileString = file.getAbsolutePath();
            if (fileString.startsWith(root = JavaCvsFileSystem.this.constructRootDirectory())) {
                FileObject fo;
                if (fileString.length() > root.length()) {
                    fileString = fileString.substring(root.length() + 1, fileString.length());
                }
                if ((fo = JavaCvsFileSystem.this.findResource(fileString = fileString.replace('\\', '/'))) == null) {
                    fo = JavaCvsFileSystem.this.findResource("");
                }
                JavaCvsFileSystem.this.refreshExisting(fo);
                JavaCvsFileSystem.this.fireFileStatusForExisting(fo);
            } else if (root.startsWith(fileString)) {
                FileObject fo = JavaCvsFileSystem.this.findResource("");
                JavaCvsFileSystem.this.refreshExisting(fo);
                JavaCvsFileSystem.this.fireFileStatusForExisting(fo);
            }
        }
    }

    private class JavaCvsFOStream
    extends FileOutputStream {
        private File changingFile;
        private boolean closed = false;

        public JavaCvsFOStream(File file) throws IOException {
            super(file);
            this.changingFile = file;
        }

        public void close() throws IOException {
            super.close();
            if (!this.closed) {
                JavaCvsFileSystem.this.cache.fileModified(this.changingFile, true);
                this.closed = true;
            }
        }
    }

    public class ListImpl
    implements AbstractFileSystem.List {
        static final long serialVersionUID = -102893327017356802L;

        public String[] children(String name) {
            if (!JavaCvsFileSystem.this.isRootSet) {
                return null;
            }
            File f = JavaCvsFileSystem.this.getFile(name);
            String[] toReturn = null;
            if (f != null && f.isDirectory() && JavaCvsFileSystem.this.cache != null) {
                toReturn = JavaCvsFileSystem.this.cache.getDirContent(f);
            }
            if (toReturn == null) {
                toReturn = new String[]{};
            }
            int i = 0;
            while (i < toReturn.length) {
                if (JavaCvsFileSystem.this.ignoredRE != null && JavaCvsFileSystem.this.ignoredRE.match(toReturn[i])) {
                    toReturn[i] = null;
                }
                ++i;
            }
            return toReturn;
        }
    }

    public class ChangeImpl
    implements AbstractFileSystem.Change {
        static final long serialVersionUID = 1647280700071658302L;
        private transient File lastFolderWhoseFileWasDeleted = null;
        private transient Map entriesByFilesOfLastFolderWhoseFileWasDeleted = null;
        private transient long lastTimeFileWasDeletedInLastFolder = 0L;
        private static final long ENTRIES_EXPIRE_TIME = 200L;
        private transient Object lastFolderLock = new Object();
        static /* synthetic */ Class class$org$netbeans$modules$javacvs$JavaCvsFileSystem;

        public void createFolder(String name) throws IOException {
            File f = JavaCvsFileSystem.this.getFile(name);
            Object[] errorParams = new Object[]{f.getName(), JavaCvsFileSystem.this.getDisplayName(), f.getPath()};
            if (name.equals("")) {
                throw new JavaCvsFileSystemException("cannot create empty name", NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = ChangeImpl.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem), (String)"EXC_create_empty_name", (Object[])errorParams));
            }
            if (f.exists()) {
                throw new JavaCvsFileSystemException("folder " + f + " already exists", NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = ChangeImpl.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem), (String)"EXC_folder_already_exists", (Object[])errorParams));
            }
            boolean b = this.createRecursiveFolder(f);
            if (!b) {
                throw new JavaCvsFileSystemException("folder " + f + " could not be created", NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = ChangeImpl.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem), (String)"EXC_folder_could_not_be_created", (Object[])errorParams));
            }
            name = name.replace('\\', '/');
        }

        private boolean createRecursiveFolder(File f) {
            String par;
            if (f.exists()) {
                return true;
            }
            if (!f.isAbsolute()) {
                f = f.getAbsoluteFile();
            }
            if ((par = f.getParent()) == null) {
                return false;
            }
            if (!this.createRecursiveFolder(new File(par))) {
                return false;
            }
            f.mkdir();
            if (f.exists()) {
                JavaCvsFileSystem.this.cache.addToCache(f);
                return true;
            }
            return false;
        }

        public void createData(String name) throws IOException {
            File f = JavaCvsFileSystem.this.getFile(name);
            if (!f.createNewFile()) {
                throw new JavaCvsFileSystemException("file " + f + " could not be created", NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = ChangeImpl.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem), (String)"EXC_file_could_not_be_created", (Object)f.getName(), (Object)JavaCvsFileSystem.this.getDisplayName(), (Object)f.getPath()));
            }
            if (f.exists()) {
                name = name.replace('\\', '/');
            }
            File folder = f.getParentFile();
            CacheFile cfolder = CacheHandler.getInstance().getCacheFile(folder, 3, (CachedFileSystem)JavaCvsFileSystem.this.cache);
            if (cfolder instanceof CacheDir) {
                String fileName = f.getName();
                ((CacheDir)cfolder).addFile((CacheFile)new CvsCacheFile("javacvs", fileName), true);
            }
        }

        public void rename(String oldName, String newName) throws IOException {
            File of = JavaCvsFileSystem.this.getFile(oldName);
            File nf = JavaCvsFileSystem.this.getFile(newName);
            String name = oldName.replace('\\', '/');
            boolean fails = nf.exists() && !nf.equals(of);
            boolean renamed = false;
            if (!fails) {
                renamed = of.renameTo(nf);
                JavaCvsFileSystem.this.handleRename(oldName, newName);
            }
            if (!renamed || fails) {
                throw new JavaCvsFileSystemException("file " + of + " could not be renamed to " + nf, NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = ChangeImpl.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem), (String)"EXC_file_could_not_be_renamed", (Object[])new Object[]{of.getName(), nf.getName(), JavaCvsFileSystem.this.getDisplayName(), of.getPath(), nf.getPath()}));
            }
        }

        public void delete(String name) throws IOException {
            File file = JavaCvsFileSystem.this.getFile(name);
            name = name.replace('\\', '/');
            boolean deleted = this.deleteFile(file);
            if (deleted) {
                File folder = file.getParentFile();
                if (folder != null) {
                    Map entriesMap;
                    Object object = this.lastFolderLock;
                    synchronized (object) {
                        if (!folder.equals(this.lastFolderWhoseFileWasDeleted) || System.currentTimeMillis() - this.lastTimeFileWasDeletedInLastFolder > 200L) {
                            Entry[] entries = null;
                            try {
                                entries = new StandardAdminHandler().getEntriesAsArray(folder);
                            }
                            catch (IOException ioex) {
                                // empty catch block
                            }
                            this.entriesByFilesOfLastFolderWhoseFileWasDeleted = new HashMap();
                            if (entries != null) {
                                int i = 0;
                                while (i < entries.length) {
                                    this.entriesByFilesOfLastFolderWhoseFileWasDeleted.put(entries[i].getName(), entries[i]);
                                    ++i;
                                }
                            }
                            this.lastFolderWhoseFileWasDeleted = folder;
                            this.lastTimeFileWasDeletedInLastFolder = System.currentTimeMillis();
                        }
                        entriesMap = this.entriesByFilesOfLastFolderWhoseFileWasDeleted;
                    }
                    Entry ent = (Entry)entriesMap.get(file.getName());
                    if (ent != null && ent.getRevision() != null && ent.getRevision().equals("0")) {
                        new StandardAdminHandler().removeEntry(file);
                    }
                }
                JavaCvsFileSystem.this.handleDelete(name);
            }
            if (file.exists() && !deleted) {
                throw new JavaCvsFileSystemException("file " + file + " could not be deleted", NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = ChangeImpl.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem), (String)"EXC_file_could_not_be_deleted", (Object)file.getName(), (Object)JavaCvsFileSystem.this.getDisplayName(), (Object)file.getPath()));
            }
        }

        private boolean deleteFile(File file) {
            if (file.isDirectory()) {
                File[] arr = file.listFiles();
                int i = 0;
                while (i < arr.length) {
                    if (!this.deleteFile(arr[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            boolean isDone = file.delete();
            return isDone;
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            in.defaultReadObject();
            this.lastFolderLock = new Object();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    protected class InfoImpl
    implements AbstractFileSystem.Info {
        static final long serialVersionUID = -627867218820299311L;
        static /* synthetic */ Class class$org$netbeans$modules$javacvs$JavaCvsFileSystem;

        public boolean folder(String name) {
            return JavaCvsFileSystem.this.getFile(name).isDirectory();
        }

        public Date lastModified(String name) {
            File file = JavaCvsFileSystem.this.getFile(name);
            if (!file.exists()) {
                return new Date(System.currentTimeMillis());
            }
            return new Date(file.lastModified());
        }

        public boolean readOnly(String name) {
            File f = JavaCvsFileSystem.this.getFile(name);
            return f.exists() && !f.canWrite();
        }

        public String mimeType(String name) {
            FileObject fo = JavaCvsFileSystem.this.findResource(name);
            String mimeType = fo != null ? FileUtil.getMIMEType((FileObject)fo) : "content/unknown";
            return mimeType;
        }

        public long size(String name) {
            return JavaCvsFileSystem.this.getFile(name).length();
        }

        public InputStream inputStream(String name) throws FileNotFoundException {
            FileInputStream in = null;
            try {
                in = new FileInputStream(JavaCvsFileSystem.this.getFile(name));
            }
            catch (FileNotFoundException exc) {
                final String fname = name;
                if (JavaCvsFileSystem.this.errorManager != null) {
                    throw (FileNotFoundException)JavaCvsFileSystem.this.errorManager.annotate((Throwable)new FileNotFoundException(){
                        static /* synthetic */ Class class$org$netbeans$modules$javacvs$JavaCvsFileSystem;

                        public String getLocalizedMessage() {
                            return MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = 1.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem)).getString("MSG_FileNotExist"), fname);
                        }

                        static /* synthetic */ Class class$(String x0) {
                            try {
                                return Class.forName(x0);
                            }
                            catch (ClassNotFoundException x1) {
                                throw new NoClassDefFoundError(x1.getMessage());
                            }
                        }
                    }, MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = InfoImpl.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem)).getString("MSG_FileNotExist"), fname));
                }
                throw new FileNotFoundException(this, fname){
                    static /* synthetic */ Class class$org$netbeans$modules$javacvs$JavaCvsFileSystem;
                    private final /* synthetic */ String val$fname;
                    private final /* synthetic */ InfoImpl this$1;
                    {
                        this.this$1 = this$1;
                        this.val$fname = val$fname;
                    }

                    public String getLocalizedMessage() {
                        return MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = 2.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem)).getString("MSG_FileNotExist"), this.val$fname);
                    }

                    static /* synthetic */ Class class$(String x0) {
                        try {
                            return Class.forName(x0);
                        }
                        catch (ClassNotFoundException x1) {
                            throw new NoClassDefFoundError(x1.getMessage());
                        }
                    }
                };
            }
            return in;
        }

        public OutputStream outputStream(String name) throws IOException {
            File file;
            if (JavaCvsFileSystem.this.isCreateBackups() && JavaCvsFileSystem.this.isImportant(name) && (file = JavaCvsFileSystem.this.getFile(name)) != null && !JavaCvsFileSystem.this.checkVirtual(name) && !name.endsWith("~") && file.length() > 0L) {
                File back = JavaCvsFileSystem.this.getFile(name + "~");
                if (!back.exists()) {
                    back.createNewFile();
                }
                BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(back));
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
                FileUtil.copy((InputStream)input, (OutputStream)stream);
                ((OutputStream)stream).flush();
                ((OutputStream)stream).close();
                ((InputStream)input).close();
            }
            return new JavaCvsFOStream(JavaCvsFileSystem.this.getFile(name));
        }

        public void lock(String name) throws IOException {
            File file = JavaCvsFileSystem.this.getFile(name);
            if (file.exists() && !file.canWrite()) {
                throw new JavaCvsFileSystemException("file " + file + " could not be locked", NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$JavaCvsFileSystem == null ? (class$org$netbeans$modules$javacvs$JavaCvsFileSystem = InfoImpl.class$("org.netbeans.modules.javacvs.JavaCvsFileSystem")) : class$org$netbeans$modules$javacvs$JavaCvsFileSystem), (String)"EXC_file_could_not_be_locked", (Object)file.getName()));
            }
        }

        public void unlock(String name) {
        }

        public void markUnimportant(String name) {
            CacheReference ref = JavaCvsFileSystem.this.getCacheReference(name);
            if (ref != null) {
                ref.markUnimportant();
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public class MyStatus
    implements FileSystem.Status,
    Serializable {
        static final long serialVersionUID = 7525827069203814770L;

        public Image annotateIcon(Image icon, int iconType, Set files) {
            Image img;
            Object[] oo = files.toArray();
            int len = oo.length;
            if (len == 0) {
                return icon;
            }
            String status = null;
            Vector<String> important = len == 1 ? JavaCvsFileSystem.this.getImportantFiles(oo) : JavaCvsFileSystem.this.getImportantFiles(oo);
            if (important.size() == 0) {
                important = new Vector<String>();
                int i = 0;
                while (i < oo.length) {
                    FileObject ff = (FileObject)oo[i];
                    important.add(ff.getPackageNameExt('/', '.'));
                    ++i;
                }
            }
            if ((status = JavaCvsFileSystem.this.cache.getFileStatusOnly(important)) != null && (img = JavaCvsFileSystem.this.getStatusManager().getIcon(status)) != null) {
                icon = Utilities.mergeImages((Image)icon, (Image)img, (int)16, (int)8);
            }
            return icon;
        }

        public String annotateName(String name, Set files) {
            String status;
            String result = name;
            String fullName = "";
            Object[] oo = files.toArray();
            int len = oo.length;
            if (len == 0 || name.indexOf(JavaCvsFileSystem.this.getRootDirectory().toString()) >= 0) {
                return result;
            }
            Vector<String> important = len == 1 ? JavaCvsFileSystem.this.getImportantFiles(oo) : JavaCvsFileSystem.this.getImportantFiles(oo);
            if (important.size() == 0) {
                important = new Vector<String>();
                int i = 0;
                while (i < oo.length) {
                    FileObject ff = (FileObject)oo[i];
                    important.add(ff.getPackageNameExt('/', '.'));
                    ++i;
                }
            }
            result = status = JavaCvsFileSystem.this.cache.getStatus(name, important).trim();
            return result;
        }
    }
}

