/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacvs.caching;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import org.netbeans.modules.javacvs.caching.CvsCacheFile;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;

public class CvsCacheDir
extends CacheDir {
    private static final String CACHE_FILENAME = File.separator + "CVS" + File.separator + "netbeans.cache";
    private static final String CACHE_NEW_FILENAME = File.separator + "CVS" + File.separator + "javacvs.cache";
    private static final String CACHE_VIRTUAL_FILENAME = File.separator + "CVS" + File.separator + "javacvs.virtuals";
    private static FileFilter cvsFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.isDirectory() && f.getName().equalsIgnoreCase("CVS");
        }
    };

    public CvsCacheDir(String cacheName, File dirFile) {
        this(cacheName, dirFile, new CvsCacheFile.CvsPersistentData(true));
    }

    CvsCacheDir(String cacheName, File dirFile, CacheFile.PersistentData data) {
        super(cacheName, dirFile, data);
        File cvsSubDir = new File(dirFile, "CVS");
        if (!cvsSubDir.exists()) {
            this.setLocal(true);
            this.setStatus("Local");
        } else {
            this.setLocal(false);
            this.setStatus(" ");
        }
    }

    protected CacheFile createChildFromData(CacheFile.PersistentData data) {
        Object file = data.isDirectory() ? new CvsCacheDir(this.getCacheName(), new File(this.dirFile, data.getName()), data) : new CvsCacheFile(this.getCacheName(), data);
        return file;
    }

    public synchronized void populateWithLocal(Object locker) {
        if (this.getAppliedLevel() >= 0) {
            this.repopulate();
        } else {
            File[] subFiles = this.dirFile.listFiles();
            if (subFiles == null) {
                return;
            }
            CacheHandler handler = CacheHandler.getInstance();
            int index = 0;
            while (index < subFiles.length) {
                File oneFile = subFiles[index];
                if (oneFile != null) {
                    Object file;
                    if (oneFile.isDirectory()) {
                        if (this.getSubDir(oneFile.getName()) == null) {
                            file = new CvsCacheDir(this.getCacheObject().getId(), oneFile);
                            this.addChildDir((CacheDir)file, false);
                            handler.addCacheLocker(locker, (CacheFile)file);
                        }
                    } else if (this.getFile(oneFile.getName()) == null) {
                        file = new CvsCacheFile(this.getCacheObject().getId(), oneFile.getName());
                        this.addFile((CacheFile)file, false);
                        handler.addCacheLocker(locker, (CacheFile)file);
                    }
                }
                ++index;
            }
            this.setAppliedLevel(0);
        }
        this.readVirtualsFromDisk();
    }

    public synchronized void repopulate() {
        if (!this.dirFile.exists()) {
            this.removeAll(true);
            if (this.getParent() != null) {
                this.getParent().removeChildDir(this.getName(), true);
            }
            return;
        }
        File[] cvsDir = this.dirFile.listFiles(cvsFilter);
        this.setLocal(cvsDir.length == 0);
        File[] subFiles = this.dirFile.listFiles();
        CacheDir[] cacheDirs = this.getSubDirs();
        int index = 0;
        while (index < cacheDirs.length) {
            CacheDir dir = cacheDirs[index];
            if (dir != null) {
                File found = null;
                int ind2 = 0;
                while (ind2 < subFiles.length) {
                    if (subFiles[ind2] != null && subFiles[ind2].getName().equals(dir.getName())) {
                        found = subFiles[ind2];
                        subFiles[ind2] = null;
                        break;
                    }
                    ++ind2;
                }
                if (found == null) {
                    this.removeChildDir(dir.getName(), false);
                } else if (!found.isDirectory()) {
                    this.removeChildDir(dir.getName(), false);
                }
            }
            ++index;
        }
        CacheFile[] cacheFiles = this.getFiles();
        int index2 = 0;
        while (index2 < cacheFiles.length) {
            CacheFile cfile = cacheFiles[index2];
            if (cfile != null) {
                File found = null;
                int ind2 = 0;
                while (ind2 < subFiles.length) {
                    if (subFiles[ind2] != null && subFiles[ind2].getName().equals(cfile.getName())) {
                        found = subFiles[ind2];
                        subFiles[ind2] = null;
                        break;
                    }
                    ++ind2;
                }
                if (found == null) {
                    if (this.isLocal()) {
                        this.removeFile(cfile.getName(), false);
                    } else {
                        String status = cfile.getStatus();
                        if (status != null && !status.equals("LRemoved")) {
                            if (status.equals("Local") || status.equals("Unknown") || status.equals("LAdded")) {
                                this.removeFile(cfile.getName(), false);
                            } else {
                                cfile.setStatus("NCheckout");
                            }
                        }
                    }
                } else if (this.isLocal() && !cfile.getStatus().equals("Local")) {
                    this.removeFile(cfile.getName(), false);
                }
            }
            ++index2;
        }
        int ind3 = 0;
        while (ind3 < subFiles.length) {
            File file;
            if (subFiles[ind3] != null && (file = subFiles[ind3]).exists()) {
                if (file.isDirectory()) {
                    this.addChildDir(new CvsCacheDir("javacvs", file), false);
                } else {
                    this.addFile(new CvsCacheFile("javacvs", file.getName()), false);
                }
            }
            ++ind3;
        }
    }

    public String getName() {
        if (this.dirFile.getParentFile() == null) {
            return this.dirFile.getAbsolutePath();
        }
        return this.dirFile.getName();
    }

    /*
     * Loose catch block
     */
    public void simpleWriteToDisk() {
        block21: {
            BufferedWriter out = null;
            BufferedWriter virtOut = null;
            virtOut = new BufferedWriter(new FileWriter(this.getCacheVirtualsFileName()));
            CacheFile[] files = this.getFiles();
            int i = 0;
            while (i < files.length) {
                File virtCheck;
                CvsCacheFile file = (CvsCacheFile)files[i];
                if (file != null && !(virtCheck = new File(file.getAbsolutePath())).exists()) {
                    virtOut.write(file.getName());
                    virtOut.newLine();
                }
                ++i;
            }
            virtOut.flush();
            out = new BufferedWriter(new FileWriter(this.getCacheNewFileName()));
            int i2 = 0;
            while (i2 < files.length) {
                CvsCacheFile file = (CvsCacheFile)files[i2];
                if (file != null && !file.getStatus().equals("Local")) {
                    out.write(((CvsCacheFile.CvsPersistentData)file.getPersistentData()).writeLineToDisk());
                    out.newLine();
                }
                ++i2;
            }
            out.flush();
            this.setModifiedContent(false);
            Object var8_9 = null;
            try {
                File oldContent;
                if (out != null) {
                    out.close();
                }
                if (virtOut != null) {
                    virtOut.close();
                }
                if ((oldContent = new File(this.getCacheFileName())).exists()) {
                    oldContent.delete();
                }
                break block21;
            }
            catch (IOException e2) {}
            break block21;
            {
                catch (IOException e) {
                    Object var8_10 = null;
                    try {
                        File oldContent;
                        if (out != null) {
                            out.close();
                        }
                        if (virtOut != null) {
                            virtOut.close();
                        }
                        if ((oldContent = new File(this.getCacheFileName())).exists()) {
                            oldContent.delete();
                        }
                        break block21;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    File oldContent;
                    if (out != null) {
                        out.close();
                    }
                    if (virtOut != null) {
                        virtOut.close();
                    }
                    if ((oldContent = new File(this.getCacheFileName())).exists()) {
                        oldContent.delete();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public synchronized void writeToDisk() {
        File[] cvsDir = this.dirFile.listFiles(cvsFilter);
        if (cvsDir == null || cvsDir.length == 0) {
            return;
        }
        File netbeansFile = new File(this.getCacheNewFileName());
        if (!netbeansFile.exists() && this.getAppliedLevel() < 3 || this.getAppliedLevel() < 3) {
            return;
        }
        this.simpleWriteToDisk();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readFromDisk_Old() {
        block17: {
            block14: {
                isOk = false;
                cacheFile = new File(this.getCacheFileName());
                if (!cacheFile.exists() || !cacheFile.canRead()) break block14;
                in = null;
                try {
                    try {
                        in = new BufferedReader(new FileReader(cacheFile));
                        line = null;
                        processedList = new LinkedList<CacheFile>();
                        while (true) {
                            block15: {
                                if ((line = in.readLine()) != null) break block15;
                                in.close();
                                isOk = true;
                                files = this.getFiles();
                                toBeRemoved = new LinkedList<CvsCacheFile>();
                                i = 0;
                                if (true) ** GOTO lbl56
                            }
                            file = CvsCacheFile.readFileCache(line, this);
                            if (file == null || !(file instanceof CvsCacheFile)) continue;
                            processedList.add(file);
                        }
                    }
                    catch (IOException e) {
                        var12_14 = null;
                        if (in == null) return isOk;
                        try {
                            in.close();
                        }
                        catch (IOException exc) {
                            // empty catch block
                        }
                        in = null;
                        return isOk;
                    }
                }
                catch (Throwable var11_19) {
                    block16: {
                        var12_15 = null;
                        if (in == null) throw var11_19;
                        ** try [egrp 2[TRYBLOCK] [2 : 270->277)] { 
lbl41:
                        // 1 sources

                        in.close();
                        break block16;
lbl43:
                        // 1 sources

                        catch (IOException exc) {
                            // empty catch block
                        }
                    }
                    in = null;
                    throw var11_19;
                }
            }
            this.setAppliedLevel(3);
            return isOk;
            do {
                if (!processedList.contains((Object)(fil = (CvsCacheFile)files[i])) && !(f = new File(fil.getAbsolutePath())).exists()) {
                    toBeRemoved.add(fil);
                }
                ++i;
lbl56:
                // 2 sources

            } while (i < files.length);
            if (toBeRemoved.size() > 0) {
                it2 = toBeRemoved.iterator();
                while (it2.hasNext()) {
                    this.removeFile(((CacheFile)it2.next()).getName(), false);
                }
            }
            this.setAppliedLevel(3);
            var9_11 = isOk;
            var12_13 = null;
            if (in == null) return var9_11;
            ** try [egrp 2[TRYBLOCK] [2 : 270->277)] { 
lbl68:
            // 1 sources

            in.close();
            break block17;
lbl70:
            // 1 sources

            catch (IOException exc) {
                // empty catch block
            }
        }
        in = null;
        return var9_11;
    }

    public boolean readFromDisk() {
        return this.readFromDisk(null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean readFromDisk(Object locker) {
        block18: {
            block15: {
                isOk = false;
                cacheFile = new File(this.getCacheNewFileName());
                if (!cacheFile.exists() || !cacheFile.canRead()) break block15;
                in = null;
                try {
                    try {
                        in = new BufferedReader(new FileReader(cacheFile));
                        line = null;
                        processedList = new LinkedList<CacheFile>();
                        handler = CacheHandler.getInstance();
                        while (true) {
                            block16: {
                                if ((line = in.readLine()) != null) break block16;
                                in.close();
                                isOk = true;
                                files = this.getFiles();
                                toBeRemoved = new LinkedList<CvsCacheFile>();
                                i = 0;
                                if (true) ** GOTO lbl63
                            }
                            file = CvsCacheFile.readFileCache(line, this);
                            if (file == null || !(file instanceof CvsCacheFile)) continue;
                            processedList.add(file);
                            handler.addCacheLocker(locker, file);
                        }
                    }
                    catch (IOException e) {
                        var14_17 = null;
                        if (in == null) return isOk;
                        try {
                            in.close();
                        }
                        catch (IOException exc) {
                            // empty catch block
                        }
                        in = null;
                        return isOk;
                    }
                }
                catch (Throwable var13_22) {
                    block17: {
                        var14_18 = null;
                        if (in == null) throw var13_22;
                        ** try [egrp 2[TRYBLOCK] [2 : 288->296)] { 
lbl43:
                        // 1 sources

                        in.close();
                        break block17;
lbl45:
                        // 1 sources

                        catch (IOException exc) {
                            // empty catch block
                        }
                    }
                    in = null;
                    throw var13_22;
                }
            }
            oldStorage = new File(this.getCacheFileName());
            if (oldStorage.exists() && oldStorage.canRead()) {
                this.readFromDisk_Old();
                return isOk;
            }
            this.setAppliedLevel(3);
            return isOk;
            do {
                if (!processedList.contains((Object)(fil = (CvsCacheFile)files[i])) && !(f = new File(fil.getAbsolutePath())).exists()) {
                    toBeRemoved.add(fil);
                }
                ++i;
lbl63:
                // 2 sources

            } while (i < files.length);
            if (toBeRemoved.size() > 0) {
                it2 = toBeRemoved.iterator();
                while (it2.hasNext()) {
                    this.removeFile(((CacheFile)it2.next()).getName(), false);
                }
            }
            this.setAppliedLevel(3);
            var11_14 = isOk;
            var14_16 = null;
            if (in == null) return var11_14;
            ** try [egrp 2[TRYBLOCK] [2 : 288->296)] { 
lbl75:
            // 1 sources

            in.close();
            break block18;
lbl77:
            // 1 sources

            catch (IOException exc) {
                // empty catch block
            }
        }
        in = null;
        return var11_14;
    }

    /*
     * Loose catch block
     */
    protected CacheFile readFileFromDisk(String name) {
        CvsCacheFile file;
        block12: {
            file = null;
            File cacheFile = new File(this.getCacheNewFileName());
            if (cacheFile.exists() && cacheFile.canRead()) {
                BufferedReader in = null;
                in = new BufferedReader(new FileReader(cacheFile));
                String line = null;
                while ((line = in.readLine()) != null) {
                    CacheFile rfile = CvsCacheFile.readFileCache(line, this.getCacheName(), this.dirFile);
                    if (!name.equals(rfile.getName())) continue;
                    file = rfile;
                }
                in.close();
                Object var8_8 = null;
                if (in == null) break block12;
                try {
                    in.close();
                }
                catch (IOException exc) {
                    // empty catch block
                }
                in = null;
                {
                    break block12;
                    catch (IOException e) {
                        Object var8_9 = null;
                        if (in == null) break block12;
                        try {
                            in.close();
                        }
                        catch (IOException exc) {
                            // empty catch block
                        }
                        in = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException exc) {
                            // empty catch block
                        }
                        in = null;
                    }
                    throw throwable;
                }
            }
        }
        if (file == null) {
            file = new CvsCacheFile(this.getCacheName(), name);
        }
        return file;
    }

    protected CacheDir readDirFromDisk(String name) {
        return new CvsCacheDir(this.getCacheName(), new File(this.dirFile, name));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean readVirtualsFromDisk() {
        block18: {
            block15: {
                isOk = false;
                cacheFile = new File(this.getCacheVirtualsFileName());
                if (!cacheFile.exists() || !cacheFile.canRead() || cacheFile.length() <= 0L) break block15;
                in = null;
                try {
                    try {
                        in = new BufferedReader(new InputStreamReader(new FileInputStream(cacheFile)));
                        line = null;
                        processedList = new LinkedList<CacheFile>();
                        while (true) {
                            block16: {
                                if ((line = in.readLine()) != null) break block16;
                                in.close();
                                isOk = true;
                                files = this.getFiles();
                                toBeRemoved = new LinkedList<CvsCacheFile>();
                                i = 0;
                                if (true) ** GOTO lbl62
                            }
                            fil = this.getFile(line);
                            if (fil == null) {
                                fil = new CvsCacheFile("javacvs", line);
                                this.addFile(fil, false);
                            }
                            processedList.add(fil);
                        }
                    }
                    catch (IOException e) {
                        var12_15 = null;
                        if (in == null) return isOk;
                        try {
                            in.close();
                        }
                        catch (IOException exc) {
                            // empty catch block
                        }
                        in = null;
                        return isOk;
                    }
                }
                catch (Throwable var11_20) {
                    block17: {
                        var12_16 = null;
                        if (in == null) throw var11_20;
                        ** try [egrp 2[TRYBLOCK] [2 : 293->300)] { 
lbl43:
                        // 1 sources

                        in.close();
                        break block17;
lbl45:
                        // 1 sources

                        catch (IOException exc) {
                            // empty catch block
                        }
                    }
                    in = null;
                    throw var11_20;
                }
            }
            oldStorage = new File(this.getCacheFileName());
            if (oldStorage.exists() == false) return isOk;
            if (oldStorage.canRead() == false) return isOk;
            this.readFromDisk_Old();
            return isOk;
            do {
                if (!processedList.contains((Object)(fil = (CvsCacheFile)files[i])) && !(f = new File(fil.getAbsolutePath())).exists()) {
                    toBeRemoved.add(fil);
                }
                ++i;
lbl62:
                // 2 sources

            } while (i < files.length);
            if (toBeRemoved.size() > 0) {
                it2 = toBeRemoved.iterator();
                while (it2.hasNext()) {
                    this.removeFile(((CacheFile)it2.next()).getName(), false);
                }
            }
            var9_12 = isOk;
            var12_14 = null;
            if (in == null) return var9_12;
            ** try [egrp 2[TRYBLOCK] [2 : 293->300)] { 
lbl73:
            // 1 sources

            in.close();
            break block18;
lbl75:
            // 1 sources

            catch (IOException exc) {
                // empty catch block
            }
        }
        in = null;
        return var9_12;
    }

    public void checkServer(Object locker) {
    }

    public void checkServerRecursive(Object locker) {
    }

    public synchronized String[] getDirContentNames(boolean hideShadow) {
        String[] fileNames;
        String[] dirNames = this.getSubDirNames();
        int dirSize = dirNames.length + (fileNames = this.getFileNames()).length;
        if (dirSize == 0) {
            return null;
        }
        LinkedList<String> list = new LinkedList<String>();
        int i = 0;
        while (i < dirNames.length) {
            if (!dirNames[i].equalsIgnoreCase("CVS")) {
                list.add(dirNames[i]);
            }
            ++i;
        }
        boolean hasHidden = false;
        int i2 = 0;
        while (i2 < fileNames.length) {
            if (hideShadow) {
                File file = new File(this.getFile(fileNames[i2]).getAbsolutePath());
                if (file.exists()) {
                    list.add(fileNames[i2]);
                } else {
                    hasHidden = true;
                }
            } else {
                list.add(fileNames[i2]);
            }
            ++i2;
        }
        if (hasHidden) {
            this.setStatus("HiddenFiles");
        } else {
            this.setStatus(" ");
        }
        String[] content = new String[list.size()];
        content = list.toArray(content);
        return content;
    }

    public void rename(File newLocation) {
        super.rename(newLocation);
        this.setStatus("Local");
    }

    protected String getCacheFileName() {
        return this.dirFile.getAbsolutePath() + CACHE_FILENAME;
    }

    protected String getCacheNewFileName() {
        return this.dirFile.getAbsolutePath() + CACHE_NEW_FILENAME;
    }

    protected String getCacheVirtualsFileName() {
        return this.dirFile.getAbsolutePath() + CACHE_VIRTUAL_FILENAME;
    }

    public String getStatus() {
        File cvsDir = new File(this.getAbsolutePath() + File.separator + "CVS");
        if (!cvsDir.exists()) {
            this.setStatus("Local");
        }
        return super.getStatus();
    }

    public String writeLineToDisk() {
        StringBuffer buff = new StringBuffer("D/");
        buff.append(this.getName());
        buff.append("/");
        buff.append(this.getStatus());
        buff.append("/");
        buff.append(this.getLocker() == null ? " " : this.getLocker());
        buff.append("/");
        buff.append(this.getRevision() == null ? " " : this.getRevision());
        buff.append("/");
        buff.append(this.getSticky() == null ? " " : this.getSticky());
        buff.append("/");
        buff.append(this.getAttr() == null ? " " : this.getAttr());
        buff.append("/");
        buff.append(this.getSize());
        buff.append("/");
        buff.append(this.getDate() == null ? " " : this.getDate());
        buff.append("/");
        buff.append(this.getTime() == null ? " " : this.getTime());
        return buff.toString();
    }

    public void addFile(CacheFile fl, boolean fireEvent) {
        CvsCacheDir cvsCacheDir = this;
        synchronized (cvsCacheDir) {
            if (this.getSubDir(fl.getName()) != null) {
                System.out.println("ERROR: attempting to add a file with same name as directory =" + fl.getName());
                Thread.dumpStack();
                return;
            }
            super.addFile(fl, fireEvent);
        }
    }

    public void removeChildDir(String subdirName, boolean fireEvent) {
        CvsCacheDir cvsCacheDir = this;
        synchronized (cvsCacheDir) {
            super.removeChildDir(subdirName, fireEvent);
        }
    }

    public CacheDir addChildDir(CacheDir subDir, boolean fireEvent) {
        CvsCacheDir cvsCacheDir = this;
        synchronized (cvsCacheDir) {
            CacheDir cacheDir = super.addChildDir(subDir, fireEvent);
            return cacheDir;
        }
    }

    public void removeAll(boolean recursively) {
        CvsCacheDir cvsCacheDir = this;
        synchronized (cvsCacheDir) {
            super.removeAll(recursively);
        }
    }

    public void renameChildDirs(CacheDir newParent, boolean fireEvent) {
        CvsCacheDir cvsCacheDir = this;
        synchronized (cvsCacheDir) {
            super.renameChildDirs(newParent, fireEvent);
        }
    }

    public void removeFile(String flName, boolean fireEvent) {
        CvsCacheDir cvsCacheDir = this;
        synchronized (cvsCacheDir) {
            super.removeFile(flName, fireEvent);
        }
    }
}

