/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacvs.caching;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import org.netbeans.modules.javacvs.caching.CvsCacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;

public class CvsCacheFile
extends CacheFile {
    public CvsCacheFile(String memberOfCache) {
        super(memberOfCache, (CacheFile.PersistentData)new CvsPersistentData(false));
        this.setStatusNonModifying("Local");
    }

    public CvsCacheFile(String memberOfCache, String name) {
        super(memberOfCache, name, (CacheFile.PersistentData)new CvsPersistentData(false));
        this.setStatusNonModifying("Local");
    }

    CvsCacheFile(String memberOfCache, CacheFile.PersistentData data) {
        super(memberOfCache, data);
    }

    public void setLocal(boolean local) {
        ((CvsPersistentData)this.getPersistentData()).setLocal(local);
    }

    public boolean isLocal() {
        return ((CvsPersistentData)this.getPersistentData()).isLocal();
    }

    public static final CacheFile readFileCache(String line, String cacheName, File parent) {
        boolean isJavaCvsCache = cacheName.equals("javacvs");
        StringTokenizer token = new StringTokenizer(line, "/", false);
        boolean newBehaviour = false;
        if (token.countTokens() >= 9) {
            newBehaviour = true;
        }
        if (!line.startsWith("/")) {
            System.out.println("ERROR : Bad cache disk format (CvsCacheFile)");
            return null;
        }
        if (token.countTokens() < 2) {
            return null;
        }
        String name = token.nextToken();
        CvsCacheFile newFile = new CvsCacheFile(cacheName, name);
        String status = token.nextToken().intern();
        boolean isNew = false;
        if (!new File(parent, name).exists()) {
            isNew = true;
            if (isJavaCvsCache) {
                if (cacheName.equals("javacvs")) {
                    if (status.equals("LRemoved") || status.equals("Local") || status.equals("Unknown")) {
                        newFile.setStatusNonModifying(status);
                    } else {
                        newFile.setStatusNonModifying("NCheckout");
                    }
                } else {
                    newFile.setStatusNonModifying(status);
                }
            } else {
                newFile.setStatusNonModifying(status);
            }
        } else {
            newFile.setStatusNonModifying(status);
        }
        if (newBehaviour) {
            String tokenStr = token.nextToken();
            newFile.setLocker(tokenStr.equals(" ") ? null : tokenStr.intern());
            tokenStr = token.nextToken();
            newFile.setRevision(tokenStr.equals(" ") ? null : tokenStr.intern());
            tokenStr = token.nextToken();
            newFile.setSticky(tokenStr.equals(" ") ? null : tokenStr.intern());
            tokenStr = token.nextToken();
            newFile.setAttr(tokenStr.equals(" ") ? null : new String(tokenStr));
            tokenStr = token.nextToken();
            int size = 0;
            try {
                size = Integer.parseInt(tokenStr);
            }
            catch (NumberFormatException exc) {
                size = 0;
            }
            newFile.setSize(size);
            tokenStr = token.nextToken();
            newFile.setDate(tokenStr.equals(" ") ? null : new String(tokenStr));
            tokenStr = token.nextToken();
            newFile.setTime(tokenStr.equals(" ") ? null : new String(tokenStr));
        } else if (token.hasMoreTokens()) {
            String tokenStr = token.nextToken();
            newFile.setRevision(tokenStr.equals("") ? null : tokenStr.intern());
        }
        return newFile;
    }

    public static final CacheFile readFileCache(String line, CvsCacheDir par) {
        String tokenStr;
        boolean isJavaCvsCache = par.getCacheName().equals("javacvs");
        StringTokenizer token = new StringTokenizer(line, "/", false);
        boolean newBehaviour = false;
        if (token.countTokens() >= 9) {
            newBehaviour = true;
        }
        if (line.startsWith("D")) {
            String name = token.nextToken();
            name = token.nextToken();
            CvsCacheDir newFile = (CvsCacheDir)par.getSubDir(name);
            if (newFile == null) {
                return newFile;
            }
            if (!token.hasMoreTokens()) {
                return newFile;
            }
            String stat = token.nextToken();
            newFile.setStatus(stat.intern());
            if (newBehaviour) {
                String tokenStr2 = token.nextToken();
                newFile.setLocker(tokenStr2.equals(" ") ? null : tokenStr2.intern());
                tokenStr2 = token.nextToken();
                newFile.setRevision(tokenStr2.equals(" ") ? null : tokenStr2.intern());
                tokenStr2 = token.nextToken();
                newFile.setSticky(tokenStr2.equals(" ") ? null : tokenStr2.intern());
                tokenStr2 = token.nextToken();
                newFile.setAttr(tokenStr2.equals(" ") ? null : new String(tokenStr2));
                tokenStr2 = token.nextToken();
                int size = 0;
                try {
                    size = Integer.parseInt(tokenStr2);
                }
                catch (NumberFormatException exc) {
                    size = 0;
                }
                newFile.setSize(size);
                if (token.hasMoreTokens()) {
                    tokenStr2 = token.nextToken();
                    newFile.setDate(tokenStr2.equals(" ") ? null : new String(tokenStr2));
                }
                if (token.hasMoreTokens()) {
                    tokenStr2 = token.nextToken();
                    newFile.setTime(tokenStr2.equals(" ") ? null : new String(tokenStr2));
                }
            }
            return newFile;
        }
        if (!line.startsWith("/")) {
            System.out.println("ERROR : Bad cache disk format (CvsCacheFile)");
            return null;
        }
        if (token.countTokens() < 2) {
            return null;
        }
        String name = token.nextToken();
        CvsCacheFile newFile = (CvsCacheFile)par.getFile(name);
        String status = token.nextToken().intern();
        boolean isNew = false;
        if (newFile == null) {
            CvsCacheFile file = new CvsCacheFile(par.getCacheName(), name);
            isNew = true;
            newFile = file;
            if (isJavaCvsCache) {
                if (par.getCacheName().equals("javacvs")) {
                    if (status.equals("LRemoved") || status.equals("Local") || status.equals("Unknown")) {
                        newFile.setStatusNonModifying(status);
                    } else {
                        newFile.setStatusNonModifying("NCheckout");
                    }
                } else {
                    newFile.setStatusNonModifying(status);
                }
            } else {
                newFile.setStatusNonModifying(status);
            }
        } else {
            newFile.setStatusNonModifying(status);
        }
        if (newBehaviour) {
            tokenStr = token.nextToken();
            newFile.setLocker(tokenStr.equals(" ") ? null : tokenStr.intern());
            tokenStr = token.nextToken();
            newFile.setRevision(tokenStr.equals(" ") ? null : tokenStr.intern());
            tokenStr = token.nextToken();
            newFile.setSticky(tokenStr.equals(" ") ? null : tokenStr.intern());
            tokenStr = token.nextToken();
            newFile.setAttr(tokenStr.equals(" ") ? null : new String(tokenStr));
            tokenStr = token.nextToken();
            int size = 0;
            try {
                size = Integer.parseInt(tokenStr);
            }
            catch (NumberFormatException exc) {
                size = 0;
            }
            newFile.setSize(size);
            tokenStr = token.nextToken();
            newFile.setDate(tokenStr.equals(" ") ? null : new String(tokenStr));
            tokenStr = token.nextToken();
            newFile.setTime(tokenStr.equals(" ") ? null : new String(tokenStr));
        } else if (token.hasMoreTokens()) {
            tokenStr = token.nextToken();
            newFile.setRevision(tokenStr.equals("") ? null : tokenStr.intern());
        }
        if (!isJavaCvsCache || isNew && (newFile.getStatus().equals("NCheckout") || newFile.getStatus().equals("LRemoved"))) {
            par.addFile(newFile, false);
        }
        return newFile;
    }

    public void setStatus(String stat) {
        String status = this.getStatus();
        if ("LAdded".equals(status) && "LMod".equals(stat)) {
            return;
        }
        status = "NPatch".equals(status) && "LMod".equals(stat) ? "NMerge" : stat;
        super.setStatus(status);
    }

    public void setStatusNonModifying(String stat) {
        this.setStatus(stat);
    }

    public String toString() {
        return "CvsCacheFile[name='" + this.getName() + "'" + "]";
    }

    protected static class CvsPersistentData
    extends CacheFile.PersistentData {
        public CvsPersistentData(boolean directory) {
            super(directory);
            this.setLocal(true);
            this.setStatus(null);
            this.setLocker(null);
            this.setRevision(null);
            this.setSticky(null);
            this.setAttr(null);
            this.setDate(null);
            this.setTime(null);
        }

        public String writeLineToDisk() {
            StringBuffer buff = new StringBuffer("/");
            buff.append(this.getName());
            buff.append("/");
            buff.append(this.getStatus());
            buff.append("/");
            buff.append(this.getLocker() == null ? " " : this.getLocker());
            buff.append("/");
            buff.append(this.getRevision() == null ? " " : this.getRevision());
            buff.append("/");
            buff.append(this.getSticky() == null ? " " : this.getSticky());
            buff.append("/");
            buff.append(this.getAttr() == null ? " " : this.getAttr());
            buff.append("/");
            buff.append(this.getSize());
            buff.append("/");
            buff.append(this.getDate() == null ? " " : this.getDate());
            buff.append("/");
            buff.append(this.getTime() == null ? " " : this.getTime());
            return buff.toString();
        }

        protected void doWriteToDisk() throws IOException {
        }
    }
}

