/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacvs.caching;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.util.Vector;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.modules.javacvs.JavaCvsFileSystem;
import org.netbeans.modules.javacvs.caching.CommandLocker;
import org.netbeans.modules.javacvs.caching.CvsCacheDir;
import org.netbeans.modules.javacvs.caching.CvsCacheFile;
import org.netbeans.modules.javacvs.caching.JavaCvsCache;
import org.netbeans.modules.javacvs.commands.CvsStatus;
import org.netbeans.modules.javacvs.commands.FileSystemCommand;
import org.netbeans.modules.javacvs.commands.FileSystemCommandImpl;
import org.netbeans.modules.javacvs.commands.JavaCvsStatusManager;
import org.netbeans.modules.javacvs.events.CommandDisplayerListener;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.CachedFileSystem;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.WeakListener;

public class CvsFsCache
implements CachedFileSystem {
    private static CommandLocker refreshLocker = new CommandLocker();
    private static String OLD_CACHEFILE = "CVS/netbeans.cache";
    private static String NEW_CACHEFILE = "CVS/javacvs.cache";
    protected AbstractFileSystem cvsfs;
    private PropertyChangeListener list;
    protected boolean offLine;
    protected boolean hideShadowFiles;
    protected int autoRefresh;
    protected File fsRootFile;

    public CvsFsCache(AbstractFileSystem fs, File homeDirectory) {
        this.cvsfs = fs;
        this.list = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                CvsFsCache.this.propertiesChanged(event.getPropertyName(), event.getOldValue(), event.getNewValue());
            }
        };
        fs.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.list, (Object)fs));
    }

    public void setOffLine(boolean offLine) {
        this.offLine = offLine;
    }

    public void setAutoRefresh(int refresh) {
        this.autoRefresh = refresh;
    }

    public void setHideShadowFiles(boolean hide) {
        this.hideShadowFiles = hide;
    }

    public void setFsRootFile(File fsRoot) {
        this.fsRootFile = fsRoot;
    }

    public static JavaCvsCache getCacheObject() {
        FileSystemCache cache = CacheHandler.getInstance().getCache("javacvs");
        JavaCvsCache cacheObject = cache == null ? new JavaCvsCache() : (JavaCvsCache)cache;
        return cacheObject;
    }

    protected JavaCvsStatusManager getStatusManager() {
        return JavaCvsStatusManager.getInstance();
    }

    private void propertiesChanged(String propName, Object oldValue, Object newValue) {
        Boolean off;
        if (propName == null) {
            return;
        }
        if (propName.equals("offLine")) {
            off = (Boolean)newValue;
            this.offLine = off;
        }
        if (propName.equals("autoRefresh")) {
            Integer in = (Integer)newValue;
            this.autoRefresh = in;
        }
        if (propName.equals("hideShadowFiles")) {
            off = (Boolean)newValue;
            this.hideShadowFiles = off;
        }
        if (propName.equals("root")) {
            File rootFile;
            FileObject foRoot = (FileObject)newValue;
            this.fsRootFile = rootFile = FileSystemCommand.toFile(foRoot);
        }
    }

    protected int adjustStrategy(int reqStrategy) {
        if (reqStrategy > 3 && this.offLine) {
            return 3;
        }
        return reqStrategy;
    }

    protected boolean permitAction(int reqStrategy) {
        return reqStrategy <= 3 || !this.offLine;
    }

    protected void checkDirectoryAutorefresh(File directory, boolean waitForRefresh) {
        File cacheDir = new File(directory.getPath(), "CVS");
        File cacheFile = new File(directory.getPath(), OLD_CACHEFILE);
        File newCacheFile = new File(directory.getPath(), NEW_CACHEFILE);
        if (cacheDir.exists() && !cacheFile.exists() && !newCacheFile.exists()) {
            try {
                newCacheFile.createNewFile();
                this.doRefresh(new File[]{directory}, false, waitForRefresh);
            }
            catch (IOException exc) {
                // empty catch block
            }
        }
    }

    public String getFileStatusOnly(Vector importantFiles) {
        File fl;
        String name;
        int currentStrategy = 3;
        int len = importantFiles.size();
        CacheFile file = null;
        if (len < 1) {
            return "Unknown";
        }
        if (this.autoRefresh == 1) {
            name = (String)importantFiles.elementAt(0);
            fl = new File(this.fsRootFile.getPath(), name);
            if (fl.getParent() != null) {
                fl = fl.getParentFile();
                this.checkDirectoryAutorefresh(fl, false);
            }
        }
        if (len == 1) {
            name = (String)importantFiles.elementAt(0);
            fl = new File(this.fsRootFile.getPath(), name);
            if (fl != null) {
                file = CacheHandler.getInstance().getCacheFile(fl, this.adjustStrategy(currentStrategy), (CachedFileSystem)this);
            }
            String stat = file != null ? file.getStatus() : "";
            return stat;
        }
        String result = "NotInSynch";
        name = (String)importantFiles.elementAt(0);
        File fl2 = new File(this.fsRootFile.getPath(), name);
        if (fl2 != null) {
            file = CacheHandler.getInstance().getCacheFile(fl2, this.adjustStrategy(currentStrategy), (CachedFileSystem)this);
        }
        String stat = file != null ? file.getStatus() : "";
        int i = 1;
        while (i < len) {
            String stat1;
            String name1 = (String)importantFiles.elementAt(i);
            File fl22 = new File(this.fsRootFile.getPath(), name1);
            if (fl22 != null) {
                file = CacheHandler.getInstance().getCacheFile(fl22, this.adjustStrategy(currentStrategy), (CachedFileSystem)this);
            }
            if (!(stat1 = file != null ? file.getStatus() : "").equals(stat)) {
                return result;
            }
            ++i;
        }
        return stat;
    }

    public String getFileStatusOnly(String name) {
        int currentStrategy = 3;
        CacheFile file = null;
        File fl = new File(this.fsRootFile.getPath(), name);
        if (this.autoRefresh == 1 && fl.getParent() != null) {
            this.checkDirectoryAutorefresh(fl.getParentFile(), true);
        }
        file = CacheHandler.getInstance().getCacheFile(fl, this.adjustStrategy(currentStrategy), (CachedFileSystem)this);
        String stat = file.getStatus();
        return stat;
    }

    public String getStatus(String nodeName, Vector importantFiles) {
        File fl;
        String name;
        int currentStrategy = 3;
        String status = "";
        int len = importantFiles.size();
        CacheFile file = null;
        if (len < 1) {
            return this.getStatusManager().getStatus("Unknown");
        }
        if (this.autoRefresh == 1) {
            name = (String)importantFiles.elementAt(0);
            fl = new File(this.fsRootFile.getPath(), name);
            if (fl.getParent() != null) {
                fl = fl.getParentFile();
                this.checkDirectoryAutorefresh(fl, false);
            }
        }
        if (len == 1) {
            name = (String)importantFiles.elementAt(0);
            fl = new File(this.fsRootFile.getPath(), name);
            if (fl != null) {
                file = CacheHandler.getInstance().getCacheFile(fl, this.adjustStrategy(currentStrategy), (CachedFileSystem)this);
            }
            String stat = file != null ? this.getStatusManager().getStatus(file.getStatus()) : "";
            return stat;
        }
        String result = this.getStatusManager().getStatus("NotInSynch");
        name = (String)importantFiles.elementAt(0);
        File fl2 = new File(this.fsRootFile.getPath(), name);
        if (fl2 != null) {
            file = CacheHandler.getInstance().getCacheFile(fl2, this.adjustStrategy(currentStrategy), (CachedFileSystem)this);
        }
        String stat = file != null ? this.getStatusManager().getStatus(file.getStatus()) : "";
        int i = 1;
        while (i < len) {
            String stat1;
            String name1 = (String)importantFiles.elementAt(i);
            File fl22 = new File(this.fsRootFile.getPath(), name1);
            if (fl22 != null) {
                file = CacheHandler.getInstance().getCacheFile(fl22, this.adjustStrategy(currentStrategy), (CachedFileSystem)this);
            }
            if (!(stat1 = file != null ? this.getStatusManager().getStatus(file.getStatus()) : "").equals(stat)) {
                return result;
            }
            ++i;
        }
        return stat;
    }

    public String[] getDirContent(File dir) {
        CvsCacheDir cacheDir = (CvsCacheDir)CacheHandler.getInstance().getCacheFile(dir, 0, (CachedFileSystem)this);
        if (cacheDir != null) {
            return cacheDir.getDirContentNames(this.hideShadowFiles);
        }
        return null;
    }

    public void addToCache(File newFile) {
        File parent = newFile.getParentFile();
        CvsCacheDir parentCache = (CvsCacheDir)CacheHandler.getInstance().getCacheFile(parent, 0, (CachedFileSystem)this);
        if (parentCache == null) {
            return;
        }
    }

    public void removeFromCache(File deletedFile, boolean wasDirectory) {
        File parent = deletedFile.getParentFile();
        CvsCacheDir parentCache = (CvsCacheDir)CacheHandler.getInstance().getCacheFile(parent, 0, (CachedFileSystem)this);
        if (parentCache == null) {
            CvsCacheDir deletedCache = (CvsCacheDir)CacheHandler.getInstance().getCacheFile(deletedFile, 0, (CachedFileSystem)this);
            CacheHandler.getInstance().getCache((CachedFileSystem)this).unregisterDir((CacheDir)deletedCache);
            return;
        }
        if (wasDirectory) {
            parentCache.removeChildDir(deletedFile.getName(), true);
        } else {
            parentCache.removeFile(deletedFile.getName(), true);
        }
    }

    public void removeFromCache(CacheFile file) {
        CacheDir parentCache = file.getParent();
        if (file instanceof CacheDir) {
            if (parentCache == null) {
                CacheDir dir = (CacheDir)file;
                CacheHandler.getInstance().getCache((CachedFileSystem)this).unregisterDir(dir);
                return;
            }
            parentCache.removeChildDir(file.getName(), true);
        } else if (parentCache != null) {
            parentCache.removeFile(file.getName(), true);
        }
    }

    public void renameTo(File oldFile, File newFile) {
        File parent = oldFile.getParentFile();
        CacheDir parentCache = (CacheDir)CacheHandler.getInstance().getCacheFile(parent, 0, (CachedFileSystem)this);
        if (parentCache == null) {
            return;
        }
        if (!newFile.isDirectory()) {
            parentCache.removeFile(oldFile.getName(), true);
            CvsCacheFile newCache = new CvsCacheFile(this.getCacheId(), newFile.getName());
            parentCache.addFile((CacheFile)newCache, true);
            return;
        }
        CacheDir renamedCache = parentCache.getSubDir(oldFile.getName());
        parentCache.removeChildDir(renamedCache.getName(), false);
        renamedCache.rename(new File(parentCache.getFilePath() + File.separator + newFile.getName()));
        parentCache.addChildDir(renamedCache, false);
        renamedCache.renameChildDirs(renamedCache, false);
        parentCache.setModifiedContent(true);
        parentCache.writeToDisk();
    }

    public String getLocker(Vector importantFiles) {
        return "";
    }

    public void saveToDisk() {
        if (!CacheHandler.getInstance().getCache((CachedFileSystem)this).isWrittenToDisk()) {
            CacheHandler.getInstance().getCache((CachedFileSystem)this).writeAllToDisk();
        }
    }

    public void saveToDiskFromNode(String path) {
        File fl = new File(this.fsRootFile.getPath(), path);
        CacheDir dir = (CacheDir)CacheHandler.getInstance().getCacheFile(fl, -1, (CachedFileSystem)this);
        if (dir != null) {
            dir.writeToDiskRecursively();
        }
    }

    public void fileModified(File modified, boolean fireEvent) {
        CacheFile cFile = CacheHandler.getInstance().getCacheFile(modified, -1, (CachedFileSystem)this);
        if (cFile != null) {
            String oldStatus = cFile.getStatus();
            if (oldStatus.equals("Local") || oldStatus.equals("Unknown") || oldStatus.equals("LRemoved") || oldStatus.equals("NMerge")) {
                return;
            }
            if (oldStatus.equals("NPatch")) {
                cFile.setStatus("NMerge");
            } else {
                cFile.setStatus("LMod");
            }
            cFile.getParent().writeToDisk();
            if (fireEvent) {
                CvsFsCache.getCacheObject().fireCacheHandlerEvent(2, cFile);
            }
        }
    }

    public void addRefreshDisplayers(CvsStatus comm) {
    }

    public void doRefresh(File[] files, boolean recursive) {
        JavaCvsFileSystem fs = (JavaCvsFileSystem)this.cvsfs;
        if (fs == null) {
            return;
        }
        FileSystemCommandImpl statusComImpl = (FileSystemCommandImpl)((Object)fs.createRefresh());
        CvsStatus com = (CvsStatus)statusComImpl.getOuterClassInstance();
        com.setRecursive(recursive);
        com.setRefreshing(false);
        if (files != null && files.length > 0 && files[0].isDirectory()) {
            com.setRefreshing(true);
        }
        com.setFiles(files);
        this.addRefreshDisplayers(com);
        refreshLocker.addToQueueAndRun(com);
    }

    public void doRefresh(File[] files, boolean recursive, boolean waitToFinish) {
        JavaCvsFileSystem fs = (JavaCvsFileSystem)this.cvsfs;
        if (fs == null) {
            return;
        }
        FileSystemCommandImpl statusComImpl = (FileSystemCommandImpl)((Object)fs.createRefresh());
        CvsStatus com = (CvsStatus)statusComImpl.getOuterClassInstance();
        com.setRecursive(recursive);
        com.setRefreshing(false);
        if (files != null && files.length > 0 && files[0].isDirectory()) {
            com.setRefreshing(true);
        }
        com.setFiles(files);
        final Object finishLock = new Object();
        if (waitToFinish) {
            com.addDisplayerListener(new CommandDisplayerListener(){

                public void showBeforeEachExecute(Command currentCommand) {
                }

                public void showAfterEachExecute() {
                }

                public void showExecutionFailed(Exception exception) {
                    Object object = finishLock;
                    synchronized (object) {
                        finishLock.notifyAll();
                    }
                }

                public void showFileInfoGenerated(FileInfoContainer info) {
                }

                public void showFinishedCommand() {
                    Object object = finishLock;
                    synchronized (object) {
                        finishLock.notifyAll();
                    }
                }

                public void showStartCommand() {
                }

                public void messageGenerated(MessageEvent message) {
                }
            });
        }
        this.addRefreshDisplayers(com);
        refreshLocker.addToQueueAndRun(com);
        if (waitToFinish) {
            Object object = finishLock;
            synchronized (object) {
                try {
                    finishLock.wait();
                }
                catch (InterruptedException intex) {
                    // empty catch block
                }
            }
        }
    }

    public String getCacheId() {
        return "javacvs";
    }

    public Reference createReference(FileObject fo) {
        File file = new File(this.fsRootFile.getPath(), fo.getPackageNameExt(File.separatorChar, '.'));
        return CacheHandler.getInstance().createReference((Object)fo, file, this.getCacheId());
    }

    public void removeNotify() {
        CvsFsCache.getCacheObject().unregisterFileSystem((FileSystem)this.cvsfs);
        this.list = null;
        this.cvsfs = null;
    }

    public void addNotify(AbstractFileSystem fs) {
        if (this.cvsfs == null) {
            this.cvsfs = fs;
            this.list = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    CvsFsCache.this.propertiesChanged(event.getPropertyName(), event.getOldValue(), event.getNewValue());
                }
            };
            fs.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.list, (Object)fs));
            CvsFsCache.getCacheObject().registerFileSystem((FileSystem)this.cvsfs);
        }
    }
}

