/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacvs.caching;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.modules.javacvs.caching.CvsCacheDir;
import org.netbeans.modules.javacvs.commands.CvsStatus;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.openide.filesystems.FileSystem;

public class JavaCvsCache
extends FileSystemCache {
    public static final int STRAT_COMMANDS = 6;
    public static final String JAVA_CACHE_NAME = "javacvs";
    private HashMap cacheDirs = new HashMap(50);
    private HashMap fileSystems = new HashMap();
    private Client cacheClient;

    public JavaCvsCache() {
        super(JAVA_CACHE_NAME);
    }

    public CacheFile getCacheFile(File toFind, int strategy, Object locker) {
        String parentDir = toFind.isDirectory() && toFind.getParentFile() == null ? toFind.getPath() : (toFind.isDirectory() && strategy <= 0 ? toFind.getPath() : toFind.getParentFile().getPath());
        CacheDir cacheDir = this.getDir(parentDir);
        if (cacheDir == null) {
            cacheDir = this.initCacheDir(new File(parentDir), strategy);
        }
        this.loadDir(cacheDir, strategy, locker);
        if (cacheDir == null) {
            return null;
        }
        if (toFind.isDirectory()) {
            if (toFind.getParentFile() == null || strategy <= 0) {
                return cacheDir;
            }
            return cacheDir.getSubDir(toFind.getName());
        }
        return cacheDir.getFile(toFind.getName());
    }

    private CacheDir initCacheDir(File toInit, int strategy) {
        File parDir = toInit.getParentFile();
        CacheDir parentDir = null;
        if (parDir != null) {
            parentDir = this.getDir(parDir.getPath());
        }
        CvsCacheDir initDir = null;
        if (parentDir == null || parentDir.getAppliedLevel() == -1) {
            initDir = new CvsCacheDir(this.getId(), toInit);
            if (strategy != -1) {
                this.registerDir(initDir);
            }
        } else {
            initDir = parentDir.getSubDir(toInit.getName());
            if (initDir == null) {
                initDir = new CvsCacheDir(this.getId(), toInit);
                parentDir.addChildDir((CacheDir)initDir, false);
                if (strategy == -1) {
                    this.unregisterDir(initDir);
                }
            }
        }
        return initDir;
    }

    public CacheDir getDir(String fullName) {
        CacheDir cacheDir = (CacheDir)this.cacheDirs.get(fullName);
        return cacheDir;
    }

    public void addRefreshDisplayers(CvsStatus comm) {
    }

    public synchronized void writeAllToDisk() {
        Collection dirs = this.cacheDirs.values();
        Iterator it = dirs.iterator();
        while (it.hasNext()) {
            CacheDir oneDir = (CacheDir)it.next();
            oneDir.writeToDisk();
        }
    }

    public synchronized void registerDir(CacheDir dir) {
        this.cacheDirs.put(dir.getFilePath(), dir);
    }

    public synchronized void unregisterDir(CacheDir dir) {
        if (dir != null) {
            this.cacheDirs.remove(dir.getFilePath());
        }
    }

    public void registerFileSystem(FileSystem fs) {
        this.fileSystems.put(fs, fs);
    }

    public void unregisterFileSystem(FileSystem fs) {
        this.fileSystems.remove(fs);
        if (this.fileSystems.size() == 0) {
            CacheHandler.getInstance().unregistedType(JAVA_CACHE_NAME);
        }
    }

    protected void loadDir(CacheDir dir, int strategy, Object locker) {
        if (dir == null) {
            return;
        }
        boolean reload = false;
        if (dir.getAppliedLevel() > -1) {
            reload = true;
        }
        if (dir.isLocal() && strategy == 0) {
            dir.setAppliedLevel(-1);
        }
        super.loadDir(dir, strategy, locker);
        if (strategy == 0 && reload) {
            CvsCacheDir cvsDir = (CvsCacheDir)dir;
            cvsDir.repopulate();
            cvsDir.readVirtualsFromDisk();
        }
    }
}

