/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacvs.caching;

import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.javacvs.commands.ClientProvider;
import org.netbeans.modules.javacvs.commands.CvsStatus;

public class RefreshCommand
extends CvsStatus {
    public RefreshCommand(File[] filesToCheck, ClientProvider fs) {
        super(filesToCheck, fs);
        this.setRefreshing(true);
    }

    public RefreshCommand() {
        this.setRefreshing(true);
    }

    private File[] findRelevantDirs(File[] files) {
        LinkedList<File> localOnes = new LinkedList<File>();
        LinkedList<File> okFiles = new LinkedList<File>();
        if (files == null) {
            return null;
        }
        int index = 0;
        while (index < files.length) {
            File file = files[index];
            if (file.isDirectory()) {
                File[] cvsDir = file.listFiles(new FileFilter(){

                    public boolean accept(File f) {
                        return f.isDirectory() && f.getName().equalsIgnoreCase("CVS");
                    }
                });
                if (cvsDir.length == 0) {
                    localOnes.add(file);
                } else {
                    okFiles.add(file);
                }
            }
            ++index;
        }
        if (localOnes.size() == 0) {
            return files;
        }
        Iterator it = localOnes.iterator();
        while (it.hasNext()) {
            File main = (File)it.next();
            File[] toFind = main.listFiles();
            if (toFind.length <= 0 || (toFind = this.findRelevantDirs(toFind)).length <= 0) continue;
            int ind = 0;
            while (ind < toFind.length) {
                okFiles.add(toFind[ind]);
                ++ind;
            }
        }
        File[] toReturn = new File[okFiles.size()];
        toReturn = okFiles.toArray(toReturn);
        return toReturn;
    }

    public void setFiles(File[] fls) {
        super.setFiles(this.findRelevantDirs(fls));
    }
}

