/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacvs.commands;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.command.add.AddInformation;
import org.netbeans.lib.cvsclient.command.commit.CommitInformation;
import org.netbeans.lib.cvsclient.command.remove.RemoveInformation;
import org.netbeans.lib.cvsclient.command.status.StatusInformation;
import org.netbeans.lib.cvsclient.file.FileStatus;
import org.netbeans.modules.javacvs.caching.CvsCacheDir;
import org.netbeans.modules.javacvs.caching.CvsCacheFile;
import org.netbeans.modules.javacvs.caching.JavaCvsCache;
import org.netbeans.modules.javacvs.commands.ClientProvider;
import org.netbeans.modules.javacvs.commands.FileSystemCommand;
import org.netbeans.modules.javacvs.commands.JavaCvsStatusManager;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.openide.util.NbBundle;

public abstract class CacheUpdatingFsCommand
extends FileSystemCommand {
    public static final String UPD_CONFLICT = "C";
    public static final String UPD_MODIFIED = "M";
    public static final String UPD_ADDED = "A";
    public static final String UPD_REMOVE = "R";
    public static final String UPD_UPDATE = "U";
    public static final String UPD_PATCH = "P";
    public static final String UPD_UNKNOWN = "?";
    public static final String UPD_TAG = "T";
    public static final String UPD_DEL_TAG = "D";
    public static final String UPD_MERGED = "G";
    private static final String STATUS_NO_REVISION_CONTROL_FILE = "No revision control file";
    private HashMap dirs = new HashMap();
    private HashSet newAddedDirs = new HashSet();
    private boolean refreshing = false;
    private boolean fullEntriesUpdate;
    static /* synthetic */ Class class$org$netbeans$lib$cvsclient$command$DefaultFileInfoContainer;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CacheUpdatingFsCommand;

    public CacheUpdatingFsCommand() {
    }

    public CacheUpdatingFsCommand(ClientProvider provider) {
        this();
        this.setClientProvider(provider);
    }

    public void setRefreshing(boolean refreshing) {
        this.refreshing = refreshing;
    }

    public boolean isRefreshing() {
        return this.refreshing;
    }

    protected void updateCache(DefaultFileInfoContainer updInfo) {
        if (updInfo == null || updInfo.getFile() == null) {
            return;
        }
        HashMap dir = this.getDirMap(updInfo.getFile().getParentFile());
        String type = updInfo.getType();
        String status = "";
        if (type.equals(UPD_TAG) || type.equals(UPD_DEL_TAG)) {
            return;
        }
        if (type.equals(UPD_UPDATE) || type.equals(UPD_PATCH)) {
            status = "Upd";
        } else if (type.equals(UPD_ADDED)) {
            status = "LAdded";
        } else if (type.equals(UPD_REMOVE)) {
            status = "LRemoved";
        } else if (type.equals(UPD_MODIFIED)) {
            status = "LMod";
        } else if (type.equals(UPD_CONFLICT)) {
            status = "Conflict";
        } else if (type.equals(UPD_UNKNOWN)) {
            status = "Unknown";
        } else if (type.equals(UPD_MERGED)) {
            status = "LMod";
        } else if (type.equals("Y")) {
            status = null;
        }
        dir.put(updInfo, status);
    }

    private HashMap getDirMap(File parentFile) {
        HashMap dir = (HashMap)this.dirs.get(parentFile);
        if (dir == null) {
            dir = new HashMap(20);
            this.dirs.put(parentFile, dir);
        }
        return dir;
    }

    protected void prepareCache(File[] files, boolean recursive) {
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File dir = null;
                dir = files[i].isDirectory() ? files[i] : files[i].getParentFile();
                this.createDirMap(dir, recursive);
                ++i;
            }
        }
    }

    private void createDirMap(File dir, boolean recursive) {
        File[] subs;
        this.getDirMap(dir);
        if (recursive && (subs = dir.listFiles()) != null && subs.length > 0) {
            int i = 0;
            while (i < subs.length) {
                if (subs[i].isDirectory()) {
                    this.createDirMap(subs[i], recursive);
                }
                ++i;
            }
        }
    }

    protected void updateCache(AddInformation addInfo) {
        HashMap dir = this.getDirMap(addInfo.getFile().getParentFile());
        if (addInfo.isDirectory()) {
            String cacheFilePath = addInfo.getFile() + File.separator + "CVS" + File.separator + "netbeans.cache";
            File emptyCacheFile = new File(cacheFilePath);
            try {
                emptyCacheFile.createNewFile();
            }
            catch (IOException exc) {
                // empty catch block
            }
            String status = " ";
            this.newAddedDirs.add(addInfo.getFile());
            return;
        }
        String type = addInfo.getType();
        String status = type.equals(UPD_UPDATE) ? "Upd" : "LAdded";
        dir.put(addInfo, status);
    }

    protected void updateCache(RemoveInformation removeInfo) {
        HashMap dir = this.getDirMap(removeInfo.getFile().getParentFile());
        if (removeInfo.isRemoved()) {
            String status = "LRemoved";
            dir.put(removeInfo, status);
        }
    }

    protected void updateCache(CommitInformation commitInfo) {
        HashMap dir = this.getDirMap(commitInfo.getFile().getParentFile());
        if (commitInfo.getType().equals("Removed")) {
            dir.put(commitInfo, null);
        } else {
            String status = "Upd";
            dir.put(commitInfo, status);
        }
    }

    protected void updateCache(StatusInformation info) {
        HashMap dir = this.getDirMap(info.getFile().getParentFile());
        if (STATUS_NO_REVISION_CONTROL_FILE.equals(info.getRepositoryRevision()) && !FileStatus.ADDED.equals(info.getStatus())) {
            dir.put(info, JavaCvsStatusManager.convertStatus(FileStatus.UNKNOWN));
            return;
        }
        dir.put(info, JavaCvsStatusManager.convertStatus(info.getStatus()));
    }

    protected void fireCacheEvents() {
        CacheFile dirCache;
        CacheHandler handler = CacheHandler.getInstance();
        JavaCvsCache cacheObject = (JavaCvsCache)handler.getCache("javacvs");
        HashSet<File> set = new HashSet<File>();
        File[] fls = this.getFiles();
        int index = 0;
        while (index < fls.length) {
            File file = fls[index];
            if (file != null) {
                if (file.isDirectory()) {
                    set.add(file);
                } else {
                    set.add(file.getParentFile());
                }
            }
            ++index;
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            File dir = (File)it.next();
            dirCache = handler.getCacheFile(dir, -1, "javacvs");
            if (dirCache == null) continue;
            cacheObject.fireCacheHandlerEvent(0, dirCache);
        }
        if (this.newAddedDirs.size() == 0) {
            return;
        }
        Iterator itDir = this.newAddedDirs.iterator();
        while (itDir.hasNext()) {
            dirCache = handler.getCacheFile((File)itDir.next(), -1, "javacvs");
            if (dirCache == null) continue;
            dirCache.setStatus(" ");
            cacheObject.fireCacheHandlerEvent(0, dirCache);
        }
    }

    protected void fireUpdateCache() {
        CacheHandler handler = CacheHandler.getInstance();
        JavaCvsCache cacheObject = (JavaCvsCache)handler.getCache("javacvs");
        CacheHandler.getInstance().registerCacheType("JavaCvs_Refreshing", (FileSystemCache)new JavaCvsCache());
        TreeSet drs = new TreeSet(this.dirs.keySet());
        Iterator it = drs.iterator();
        StandardAdminHandler adminHandler = new StandardAdminHandler();
        while (it.hasNext()) {
            CvsCacheDir originalDir;
            File dir = (File)it.next();
            if (dir == null) continue;
            CvsCacheDir dirCache = new CvsCacheDir("JavaCvs_Refreshing", dir);
            if (!this.isRefreshing()) {
                boolean ok = dirCache.readFromDisk();
            }
            Entry[] entriesArray = null;
            try {
                entriesArray = adminHandler.getEntriesAsArray(dir);
                if (this.isFullEntriesUpdate()) {
                    this.updateFromEntries(dir, entriesArray, dirCache);
                }
            }
            catch (IOException exc) {
                entriesArray = new Entry[]{};
            }
            HashMap fileList = (HashMap)this.dirs.get(dir);
            Iterator innerIt = fileList.keySet().iterator();
            while (innerIt.hasNext()) {
                String status;
                FileInfoContainer info = (FileInfoContainer)innerIt.next();
                CvsCacheFile file = (CvsCacheFile)dirCache.getFile(info.getFile().getName());
                if (file != null) {
                    status = (String)fileList.get(info);
                    file.setStatusNonModifying(status);
                    this.applyInfo((CacheFile)file, info, entriesArray);
                    if (status != null) continue;
                    dirCache.removeFile(info.getFile().getName(), false);
                    CacheFile f2 = CacheHandler.getInstance().getCacheFile(dir, -1, "javacvs");
                    if (f2 == null || !(f2 instanceof CvsCacheDir)) continue;
                    CvsCacheDir cd2 = (CvsCacheDir)f2;
                    cd2.removeFile(info.getFile().getName(), false);
                    continue;
                }
                file = new CvsCacheFile("JavaCvs_Refreshing", info.getFile().getName());
                status = (String)fileList.get(info);
                if (file == null || status == null) continue;
                dirCache.addFile(file, false);
                file.setStatusNonModifying(status);
                this.applyInfo((CacheFile)file, info, entriesArray);
            }
            dirCache.setAppliedLevel(3);
            dirCache.simpleWriteToDisk();
            CacheFile originalFile = handler.getCacheFile(dir, -1, "javacvs");
            if (originalFile == null || !(originalFile instanceof CvsCacheDir) || (originalDir = (CvsCacheDir)originalFile).getAppliedLevel() < 0) continue;
            originalDir.setAppliedLevel(0);
        }
        this.dirs = new HashMap();
        this.fireCacheEvents();
    }

    protected void updateFromEntries(File dir, Entry[] entries, CvsCacheDir cacheDir) {
        if (entries != null) {
            int i = 0;
            while (i < entries.length) {
                Entry entry = entries[i];
                if (!entry.isDirectory()) {
                    CvsCacheFile cFile = (CvsCacheFile)cacheDir.getFile(entry.getName());
                    if (cFile == null) {
                        cFile = new CvsCacheFile("JavaCvs_Refreshing", entry.getName());
                        cacheDir.addFile(cFile, false);
                    }
                    cFile.setRevision(entry.getRevision());
                    cFile.setSticky(entry.getStickyInformation());
                    if (!this.isRefreshing() && cFile.getStatus() == null || cFile.getStatus().equals("Local")) {
                        if (cFile.getRevision().startsWith("-")) {
                            cFile.setStatusNonModifying("LRemoved");
                        } else if (cFile.getRevision().equals("0")) {
                            cFile.setStatusNonModifying("LAdded");
                        } else if (entry.getLastModified() != null) {
                            long entryLast = entry.getLastModified().getTime() / 1000L;
                            File file = new File(cFile.getAbsolutePath());
                            if (!file.exists()) {
                                cFile.setStatusNonModifying("NCheckout");
                            } else {
                                long fileLast = file.lastModified() / 1000L;
                                if (entryLast == fileLast) {
                                    cFile.setStatusNonModifying("Upd");
                                } else {
                                    cFile.setStatusNonModifying("LMod");
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void applyInfo(CacheFile file, FileInfoContainer updInfo, Entry[] entries) {
        if (updInfo instanceof StatusInformation) {
            this.applyInfo(file, (StatusInformation)updInfo, entries);
            return;
        }
        if (updInfo.getClass().equals(class$org$netbeans$lib$cvsclient$command$DefaultFileInfoContainer == null ? (class$org$netbeans$lib$cvsclient$command$DefaultFileInfoContainer = CacheUpdatingFsCommand.class$("org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer")) : class$org$netbeans$lib$cvsclient$command$DefaultFileInfoContainer)) {
            this.applyInfo(file, (DefaultFileInfoContainer)updInfo, entries);
            return;
        }
        if (updInfo instanceof CommitInformation) {
            this.applyInfo(file, (CommitInformation)updInfo, entries);
            return;
        }
        if (updInfo instanceof AddInformation) {
            this.applyInfo(file, (AddInformation)updInfo, entries);
            return;
        }
        if (updInfo instanceof RemoveInformation) {
            this.applyInfo(file, (RemoveInformation)updInfo, entries);
            return;
        }
    }

    private void applyInfo(CacheFile file, DefaultFileInfoContainer updInfo, Entry[] entries) {
        Entry entry = null;
        int i = 0;
        while (i < entries.length) {
            if (file.getName().equals(entries[i].getName())) {
                entry = entries[i];
                break;
            }
            ++i;
        }
        if (entry != null) {
            file.setRevision(entry.getRevision());
            file.setSticky(entry.getStickyInformation());
        }
    }

    private void applyInfo(CacheFile file, AddInformation addInfo, Entry[] entries) {
        if (addInfo.isDirectory()) {
            return;
        }
        if (addInfo.getType().equals(UPD_ADDED)) {
            file.setRevision(NbBundle.getBundle((Class)(class$org$netbeans$modules$javacvs$commands$CacheUpdatingFsCommand == null ? (class$org$netbeans$modules$javacvs$commands$CacheUpdatingFsCommand = CacheUpdatingFsCommand.class$("org.netbeans.modules.javacvs.commands.CacheUpdatingFsCommand")) : class$org$netbeans$modules$javacvs$commands$CacheUpdatingFsCommand)).getString("CacheUpdatingFsCommand.newRevision"));
            return;
        }
        if (addInfo.getType().equals(UPD_MODIFIED)) {
            ((CvsCacheFile)file).setStatusNonModifying("LMod");
        }
        Entry entry = null;
        int i = 0;
        while (i < entries.length) {
            if (file.getName().equals(entries[i].getName())) {
                entry = entries[i];
                break;
            }
            ++i;
        }
        if (entry != null) {
            file.setRevision(entry.getRevision());
            file.setSticky(entry.getStickyInformation());
        }
    }

    private void applyInfo(CacheFile file, RemoveInformation removeInfo, Entry[] entries) {
        if (!(file instanceof CacheDir)) {
            Entry entry = null;
            int i = 0;
            while (i < entries.length) {
                if (file.getName().equals(entries[i].getName())) {
                    entry = entries[i];
                    break;
                }
                ++i;
            }
            if (entry != null) {
                file.setRevision(entry.getRevision());
            } else {
                file.setRevision("-");
            }
        }
    }

    private void applyInfo(CacheFile file, CommitInformation commitInfo, Entry[] entries) {
        String revision = commitInfo.getRevision();
        file.setRevision(revision);
        Entry entry = null;
        if (revision != null && revision.lastIndexOf(46) > 1) {
            int i = 0;
            while (i < entries.length) {
                if (file.getName().equals(entries[i].getName())) {
                    entry = entries[i];
                    if (entry.getStickyInformation() == null) break;
                    file.setSticky(entry.getStickyInformation());
                    break;
                }
                ++i;
            }
        }
    }

    private void applyInfo(CacheFile file, StatusInformation info, Entry[] entries) {
        String sticky;
        String rev = info.getWorkingRevision();
        if (rev != null && rev.length() == 0) {
            rev = null;
        }
        file.setRevision(rev);
        if (rev != null) {
            if ("New file!".equals(rev)) {
                file.setRevision(NbBundle.getBundle((Class)(class$org$netbeans$modules$javacvs$commands$CacheUpdatingFsCommand == null ? (class$org$netbeans$modules$javacvs$commands$CacheUpdatingFsCommand = CacheUpdatingFsCommand.class$("org.netbeans.modules.javacvs.commands.CacheUpdatingFsCommand")) : class$org$netbeans$modules$javacvs$commands$CacheUpdatingFsCommand)).getString("CacheUpdatingFsCommand.newRevision"));
            }
            if (rev.startsWith("No entry")) {
                file.setRevision(NbBundle.getBundle((Class)(class$org$netbeans$modules$javacvs$commands$CacheUpdatingFsCommand == null ? (class$org$netbeans$modules$javacvs$commands$CacheUpdatingFsCommand = CacheUpdatingFsCommand.class$("org.netbeans.modules.javacvs.commands.CacheUpdatingFsCommand")) : class$org$netbeans$modules$javacvs$commands$CacheUpdatingFsCommand)).getString("CacheUpdatingFsCommand.noWorkingEntry"));
            }
        }
        if ((sticky = info.getStickyTag()) != null && !sticky.equals("(none)")) {
            int index;
            if (sticky.charAt(0) == '(' && sticky.charAt(sticky.length()) == ')') {
                sticky = sticky.substring(1, sticky.length() - 1);
            }
            if ((index = sticky.indexOf(40)) > 0) {
                sticky = sticky.substring(0, index - 1);
            }
            file.setSticky(sticky);
        }
        if ((sticky = info.getStickyDate()) != null && !sticky.equals("(none)")) {
            if (sticky.charAt(0) == '(' && sticky.charAt(sticky.length()) == ')') {
                sticky = sticky.substring(1, sticky.length() - 1);
            }
            file.setSticky(sticky);
        }
    }

    public boolean isFullEntriesUpdate() {
        return this.fullEntriesUpdate;
    }

    public void setFullEntriesUpdate(boolean fullEntriesUpdate) {
        this.fullEntriesUpdate = fullEntriesUpdate;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

