/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacvs.commands;

import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.add.AddCommand;
import org.netbeans.lib.cvsclient.command.add.AddInformation;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.util.IgnoreFileFilter;
import org.netbeans.modules.javacvs.CvsCommand;
import org.netbeans.modules.javacvs.FsAdd;
import org.netbeans.modules.javacvs.FsGlobalOptions;
import org.netbeans.modules.javacvs.commands.CacheUpdatingFsCommand;
import org.netbeans.modules.javacvs.commands.ClientProvider;
import org.netbeans.modules.javacvs.commands.FileSystemCommand;
import org.netbeans.modules.javacvs.commands.FileSystemCommandImpl;
import org.netbeans.modules.javacvs.commands.FsGlobalOptionsImpl;
import org.netbeans.modules.javacvs.events.CommandDisplayerListener;
import org.netbeans.modules.javacvs.events.CommandErrorListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class CvsAdd
extends CacheUpdatingFsCommand {
    AddCommand command;
    private boolean recursive;
    private int removedFilesCommandIndex;
    private int currentCommandIndex;
    private String message;
    private KeywordSubstitutionOptions keywordSubst;
    private FsAdd addImpl;
    private File[] binaryFiles;
    private File[] textFiles;
    private List existingResurrectedFiles;
    static /* synthetic */ Class class$org$netbeans$lib$cvsclient$command$add$AddCommand;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsAdd;

    public CvsAdd() {
        this.setRecursive(false);
        this.addImpl = new AddImpl();
        this.binaryFiles = null;
    }

    public CvsCommand getImpl() {
        return this.addImpl;
    }

    public FsAdd getAddImpl() {
        return this.addImpl;
    }

    protected Class getMainCvsCommand() {
        return class$org$netbeans$lib$cvsclient$command$add$AddCommand == null ? (class$org$netbeans$lib$cvsclient$command$add$AddCommand = CvsAdd.class$("org.netbeans.lib.cvsclient.command.add.AddCommand")) : class$org$netbeans$lib$cvsclient$command$add$AddCommand;
    }

    public CvsAdd(File[] files, ClientProvider fs) {
        super(fs);
        this.setFiles(files);
        this.setRecursive(false);
        this.addImpl = new AddImpl();
        this.binaryFiles = null;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    private List processFiles(File[] files) {
        ArrayList list = new ArrayList();
        this.addFileArrayToList(list, files);
        return list;
    }

    private void addFileArrayToList(ArrayList list, File[] files) {
        int index = 0;
        while (index < files.length) {
            File current = files[index];
            if (current != null && !current.getName().equalsIgnoreCase("CVS")) {
                if (current.isDirectory()) {
                    list.add(current);
                    this.addFileArrayToList(list, current.listFiles());
                } else {
                    list.add(current);
                }
            }
            ++index;
        }
    }

    public String getName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$javacvs$commands$CvsAdd == null ? (class$org$netbeans$modules$javacvs$commands$CvsAdd = CvsAdd.class$("org.netbeans.modules.javacvs.commands.CvsAdd")) : class$org$netbeans$modules$javacvs$commands$CvsAdd)).getString("CvsAdd.name");
    }

    private LinkedList createBinaryAndOtherCommand(File[] normal, File[] binaryFiles, boolean isRunning) {
        File[] fls;
        LinkedList<AddCommand> list = new LinkedList<AddCommand>();
        if (binaryFiles != null) {
            this.command = new AddCommand();
            if (isRunning) {
                String localPath = this.libClient.getLocalPath();
                int i = 0;
                while (i < binaryFiles.length) {
                    if (binaryFiles[i].getAbsolutePath().equals(localPath)) {
                        this.libClient.setLocalPath(binaryFiles[i].getParentFile().getAbsolutePath());
                    }
                    ++i;
                }
            }
            this.command.setFiles(binaryFiles);
            this.command.setKeywordSubst(KeywordSubstitutionOptions.BINARY);
            this.command.setMessage(this.getMessage());
            list.add(this.command);
        }
        if ((fls = normal) != null) {
            this.command = new AddCommand();
            if (isRunning) {
                String localPath = this.libClient.getLocalPath();
                int i = 0;
                while (i < fls.length) {
                    if (fls[i].getAbsolutePath().equals(localPath)) {
                        this.libClient.setLocalPath(fls[i].getParentFile().getAbsolutePath());
                    }
                    ++i;
                }
            }
            this.command.setFiles(fls);
            this.setCommandArguments(this.command);
            list.add(this.command);
        }
        return list;
    }

    protected void initCommand(boolean commandIsRunning) {
        this.clearCommandList();
        boolean dirNum = false;
        this.toDoCommands.addAll(this.createBinaryAndOtherCommand(this.textFiles, this.binaryFiles, commandIsRunning));
        this.currentCommandIndex = 0;
        if (commandIsRunning) {
            this.existingResurrectedFiles = new LinkedList();
            if (this.isRecursive()) {
                File[] toTransform = this.textFiles;
                LinkedList list = new LinkedList();
                if (this.textFiles != null) {
                    list.addAll(this.processFiles(this.textFiles));
                }
                if (this.binaryFiles != null) {
                    list.addAll(this.processFiles(this.binaryFiles));
                }
                this.transform(list);
            }
            this.checkRemovedFiles();
        }
        super.initCommand(commandIsRunning);
    }

    protected void beforeEachExecute() {
        AddCommand add;
        File[] fls;
        if (this.removedFilesCommandIndex >= this.currentCommandIndex && (fls = (add = (AddCommand)this.getCurrentCommand()).getFiles()) != null && fls.length > 0) {
            this.libClient.setLocalPath(fls[0].getParentFile().getAbsolutePath());
        }
        ++this.currentCommandIndex;
        super.beforeEachExecute();
    }

    private void resurrectLocallyModifiedFiles() {
        if (this.existingResurrectedFiles != null && this.existingResurrectedFiles.size() > 0) {
            Iterator it = this.existingResurrectedFiles.iterator();
            while (it.hasNext()) {
                File originalFile = (File)it.next();
                File destDir = new File(originalFile.getParentFile(), "CVS");
                File backupFile = new File(destDir, originalFile.getName());
                if (!backupFile.exists()) continue;
                if (originalFile.exists()) {
                    originalFile.delete();
                }
                backupFile.renameTo(originalFile);
            }
        }
    }

    protected void finishedCommand() {
        this.resurrectLocallyModifiedFiles();
        this.fireUpdateCache();
        super.finishedCommand();
    }

    protected void executeFailed(Exception exc) {
        this.resurrectLocallyModifiedFiles();
        super.executeFailed(exc);
    }

    public void fileInfoGenerated(FileInfoEvent e) {
        FileInfoContainer fInfo = e.getInfoContainer();
        if (fInfo != null && fInfo instanceof AddInformation) {
            AddInformation info = (AddInformation)fInfo;
            if (this.existingResurrectedFiles.contains(info.getFile())) {
                info.setType("M");
            }
            this.updateCache(info);
        }
        super.fileInfoGenerated(e);
    }

    public void transform(List list) {
        int size = this.toDoCommands.size();
        this.toDoCommands.clear();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            if (!file.isDirectory()) continue;
            AddCommand add = new AddCommand();
            File[] commFiles = new File[]{file};
            add.setFiles(commFiles);
            this.setCommandArguments(add);
            this.toDoCommands.add(add);
            it.remove();
        }
        if (list.size() > 0) {
            IgnoreFileFilter ignoreFilter = this.getClientProvider().getIgnoreFilter();
            if (ignoreFilter != null) {
                Iterator it2 = list.iterator();
                while (it2.hasNext()) {
                    File ignoreFile = (File)it2.next();
                    if (!ignoreFilter.shouldBeIgnored(ignoreFile.getParentFile(), ignoreFile.getName())) continue;
                    it2.remove();
                }
            }
            LinkedList<File> binaryFiles = new LinkedList<File>();
            LinkedList<File> normalFiles = new LinkedList<File>();
            Iterator it2 = list.iterator();
            while (it2.hasNext()) {
                File file = (File)it2.next();
                boolean binary = this.isBinary(file);
                if (binary) {
                    binaryFiles.add(file);
                    continue;
                }
                normalFiles.add(file);
            }
            File[] normal = new File[normalFiles.size()];
            File[] binary = new File[binaryFiles.size()];
            if ((binary = binaryFiles.toArray(binary)).length == 0) {
                binary = null;
            }
            if ((normal = normalFiles.toArray(normal)).length == 0) {
                normal = null;
            }
            this.toDoCommands.addAll(this.createBinaryAndOtherCommand(normal, binary, true));
        }
    }

    private void checkRemovedFiles() {
        Iterator it = ((AbstractList)this.toDoCommands).iterator();
        LinkedList<AddCommand> toDoRemovedCommands = new LinkedList<AddCommand>();
        StandardAdminHandler adminHandler = new StandardAdminHandler();
        while (it.hasNext()) {
            HashMap<String, Vector<File>> removedList = new HashMap<String, Vector<File>>();
            AddCommand addCom = (AddCommand)it.next();
            File[] fls = addCom.getFiles();
            LinkedList<File> notRemovedList = new LinkedList<File>();
            int ind = 0;
            while (ind < fls.length) {
                Entry entry = null;
                try {
                    entry = adminHandler.getEntry(fls[ind]);
                }
                catch (IOException exc) {
                    entry = null;
                }
                if (entry != null && entry.getRevision().startsWith("-")) {
                    Vector<File> vecFiles;
                    if (fls[ind].exists()) {
                        File destDir = new File(fls[ind].getParentFile(), "CVS");
                        File destFile = new File(destDir, fls[ind].getName());
                        if (destDir.exists() && !destFile.exists() && fls[ind].renameTo(destFile)) {
                            this.existingResurrectedFiles.add(fls[ind]);
                        }
                    }
                    if ((vecFiles = (Vector<File>)removedList.get(fls[ind].getParentFile().getAbsolutePath())) == null) {
                        vecFiles = new Vector<File>();
                        removedList.put(fls[ind].getParentFile().getAbsolutePath(), vecFiles);
                    }
                    vecFiles.add(fls[ind]);
                } else {
                    notRemovedList.add(fls[ind]);
                }
                ++ind;
            }
            if (notRemovedList.size() == 0) {
                it.remove();
            }
            if (notRemovedList.size() == fls.length) continue;
            File[] newFls = new File[notRemovedList.size()];
            newFls = notRemovedList.toArray(newFls);
            addCom.setFiles(newFls);
            Iterator it2 = removedList.values().iterator();
            while (it2.hasNext()) {
                Vector vecFiles = (Vector)it2.next();
                AddCommand add = new AddCommand();
                File[] remFiles = new File[vecFiles.size()];
                remFiles = vecFiles.toArray(remFiles);
                add.setFiles(remFiles);
                this.setCommandArguments(add);
                add.setKeywordSubst(addCom.getKeywordSubst());
                toDoRemovedCommands.add(add);
            }
        }
        if (toDoRemovedCommands.size() > 0) {
            this.removedFilesCommandIndex = this.toDoCommands.size();
            this.toDoCommands.addAll(toDoRemovedCommands);
        } else {
            this.removedFilesCommandIndex = -1;
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public KeywordSubstitutionOptions getKeywordSubst() {
        return this.keywordSubst;
    }

    public void setKeywordSubst(KeywordSubstitutionOptions keywordSubst) {
        this.keywordSubst = keywordSubst;
    }

    public String getCvsrcEntry() {
        String message = this.getMessage();
        this.setMessage(null);
        String retValue = super.getCvsrcEntry();
        this.setMessage(message);
        return retValue;
    }

    public boolean setCommandArguments(Command command) {
        super.setCommandArguments(command);
        return true;
    }

    public boolean getCommandArguments(Command command) {
        super.getCommandArguments(command);
        return true;
    }

    public boolean copySwitchesFrom(FileSystemCommand com) {
        boolean retValue = super.copySwitchesFrom(com);
        if (com instanceof CvsAdd) {
            CvsAdd addCom = (CvsAdd)com;
            this.setRecursive(addCom.isRecursive());
        }
        return retValue;
    }

    private boolean isBinary(File file) {
        String ext = FileUtil.getExtension((String)file.getName());
        String mime = FileUtil.getMIMEType((String)ext);
        if (mime != null) {
            boolean text = mime.startsWith("content/unknown") || mime.startsWith("text/");
            return !text;
        }
        return false;
    }

    public void setFiles(File[] files) {
        super.setFiles(files);
        if (files != null) {
            LinkedList<File> binaryFiles = new LinkedList<File>();
            LinkedList<File> normalFiles = new LinkedList<File>();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                boolean binary = this.isBinary(file);
                if (binary) {
                    binaryFiles.add(files[i]);
                } else {
                    normalFiles.add(files[i]);
                }
                ++i;
            }
            Collections.sort(binaryFiles);
            Collections.sort(normalFiles);
            File[] normal = new File[normalFiles.size()];
            File[] binary = new File[binaryFiles.size()];
            binary = binaryFiles.toArray(binary);
            normal = normalFiles.toArray(normal);
            this.setTextFiles(normal);
            this.setBinaryFiles(binary);
        }
    }

    public void setBinaryFiles(File[] files) {
        this.binaryFiles = files;
    }

    public void setTextFiles(File[] files) {
        this.textFiles = files;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class AddImpl
    extends FsAdd
    implements FileSystemCommandImpl {
        public FileSystemCommand getOuterClassInstance() {
            return CvsAdd.this;
        }

        public void setFileObjects(FileObject[] fileObjects) {
            CvsAdd.this.setFileObjects(fileObjects);
        }

        public KeywordSubstitutionOptions getKeywordSubst() {
            return CvsAdd.this.getKeywordSubst();
        }

        public void setRecursive(boolean recursive) {
            CvsAdd.this.setRecursive(recursive);
        }

        public void addCommandErrorListener(CommandErrorListener commErrListener) {
            CvsAdd.this.addCommandErrorListener(commErrListener);
        }

        public boolean isRecursive() {
            return CvsAdd.this.isRecursive();
        }

        public void setKeywordSubst(KeywordSubstitutionOptions keywordSubst) {
            CvsAdd.this.setKeywordSubst(keywordSubst);
        }

        public String getMessage() {
            return CvsAdd.this.getMessage();
        }

        public void addDisplayerListener(CommandDisplayerListener listener) {
            CvsAdd.this.addDisplayerListener(listener);
        }

        public void removeDisplayerListener(CommandDisplayerListener listener) {
            CvsAdd.this.removeDisplayerListener(listener);
        }

        public void removeCommandErrorListener(CommandErrorListener commErrListener) {
            CvsAdd.this.removeCommandErrorListener(commErrListener);
        }

        public void setMessage(String message) {
            CvsAdd.this.setMessage(message);
        }

        public void startCommand() {
            CvsAdd.this.startCommand();
        }

        public FsGlobalOptions getGlobalOptions() {
            FsGlobalOptionsImpl retValue = new FsGlobalOptionsImpl(CvsAdd.this.getGlobalOptions());
            return retValue;
        }
    }
}

