/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacvs.commands;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.commandLine.GetOpt;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.event.CVSAdapter;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.modules.javacvs.CvsCommand;
import org.netbeans.modules.javacvs.commands.ClientCreationException;
import org.netbeans.modules.javacvs.commands.ClientProvider;
import org.netbeans.modules.javacvs.commands.FileSystemCommand;
import org.netbeans.modules.javacvs.events.AfterEachCommandDisplayerEvent;
import org.netbeans.modules.javacvs.events.BeforeEachCommandDisplayerEvent;
import org.netbeans.modules.javacvs.events.CommandDisplayerEvent;
import org.netbeans.modules.javacvs.events.CommandDisplayerListener;
import org.netbeans.modules.javacvs.events.CommandErrorEvent;
import org.netbeans.modules.javacvs.events.CommandErrorListener;
import org.netbeans.modules.javacvs.events.FailedDisplayerEvent;
import org.netbeans.modules.javacvs.events.FinishDisplayerEvent;
import org.netbeans.modules.javacvs.events.InfoGeneratedDisplayerEvent;
import org.netbeans.modules.javacvs.events.MessageGeneratedDisplayerEvent;
import org.netbeans.modules.javacvs.events.ServerErrorException;
import org.netbeans.modules.javacvs.events.StartDisplayerEvent;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public abstract class FileSystemCommand
extends CVSAdapter
implements Runnable,
Cloneable {
    private LinkedList stdErrList;
    private LinkedList stdOutList;
    private Thread thread;
    protected Client libClient;
    protected GlobalOptions globalOptions;
    private EventManager eventManager;
    private boolean dispWasSet;
    private String root;
    private Command currCommand;
    private ArrayList errListeners;
    private boolean stopCommand;
    private File[] files;
    private Object[] paramOptions;
    private Object[] paramClosingOptions;
    private boolean defaultSettings;
    private boolean serverError = false;
    protected Vector toDoCommands;
    private boolean running;
    private ClientProvider provider;
    private CommandDisplayerListener[] displayListeners;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$FileSystemCommand;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

    public FileSystemCommand() {
        this.initInternals();
        this.initializeCommandList();
    }

    public FileSystemCommand(ClientProvider provider) {
        this();
        this.setClientProvider(provider);
    }

    private void initInternals() {
        this.setRunning(false);
        this.stopCommand = false;
        this.thread = null;
        this.serverError = false;
        this.setFiles(null);
    }

    public Object clone() throws CloneNotSupportedException {
        FileSystemCommand com = (FileSystemCommand)super.clone();
        com.initInternals();
        return com;
    }

    public CvsCommand getImpl() {
        return new CvsCommand();
    }

    public void setClientProvider(ClientProvider prov) {
        this.provider = prov;
        this.setGlobalOptions(this.provider.getGlobalOptions());
    }

    public void setFiles(File[] fls) {
        this.files = fls;
    }

    public File[] getFiles() {
        return this.files;
    }

    public void setFileObjects(FileObject[] fileObjects) {
        this.saveFiles(fileObjects);
        this.setFiles(this.convertFileObjects(fileObjects));
    }

    public synchronized void stopCommand() {
        this.stopCommand = true;
    }

    public synchronized void hardCommandStop() {
        this.libClient.abort();
        this.stopCommand = true;
    }

    public synchronized boolean isStopped() {
        return this.stopCommand;
    }

    public ClientProvider getClientProvider() {
        return this.provider;
    }

    public void setGlobalOptions(GlobalOptions glOpt) {
        this.globalOptions = glOpt;
    }

    public GlobalOptions getGlobalOptions() {
        return this.globalOptions;
    }

    private EventManager getEventManager() throws ClientCreationException {
        if (this.libClient == null) {
            this.libClient = this.createClient();
        }
        return this.libClient.getEventManager();
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    private synchronized void setRunning(boolean run) {
        if (!run) {
            if (this.errListeners != null) {
                this.errListeners.clear();
            }
            if (this.displayListeners != null) {
                this.displayListeners = null;
            }
            if (this.libClient != null) {
                try {
                    Connection conn = this.libClient.getConnection();
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.libClient = null;
            }
            if (this.eventManager != null) {
                this.eventManager.removeCVSListener(this);
                this.eventManager = null;
            }
            if (this.toDoCommands != null) {
                this.toDoCommands.clear();
                this.toDoCommands = null;
            }
        }
        this.running = run;
    }

    protected Command getCurrentCommand() {
        return this.currCommand;
    }

    private void setCurrentCommand(Command comm) {
        this.currCommand = comm;
    }

    protected Command loadCommand(Class type) {
        Command comm = null;
        try {
            comm = (Command)type.newInstance();
            return comm;
        }
        catch (Exception exception) {
            return comm;
        }
    }

    public void startCommand() {
        this.setRunning(true);
        this.thread = new Thread((Runnable)this, "JavaCvsFileSystem.CVSCommand");
        this.thread.start();
    }

    public abstract String getName();

    protected void initializeCommandList() {
        this.toDoCommands = new Vector(2);
    }

    protected void clearCommandList() {
        this.toDoCommands.clear();
    }

    protected void initCommand(boolean commandIsRunning) {
        this.fireDisplayerEvent(new StartDisplayerEvent(this));
    }

    protected void finishedCommand() {
        this.fireDisplayerEvent(new FinishDisplayerEvent(this));
    }

    protected void beforeEachExecute() {
        this.fireDisplayerEvent(new BeforeEachCommandDisplayerEvent(this, this.getCurrentCommand()));
    }

    protected void afterEachExecute() {
        this.fireDisplayerEvent(new AfterEachCommandDisplayerEvent(this));
    }

    protected void executeFailed(Exception exc) {
        this.fireDisplayerEvent(new FailedDisplayerEvent(this, exc));
    }

    public void fileInfoGenerated(FileInfoEvent e) {
        FileInfoContainer fInfo = e.getInfoContainer();
        this.fireDisplayerEvent(new InfoGeneratedDisplayerEvent(this, fInfo));
    }

    private Client createClient() throws ClientCreationException {
        ClientProvider prov = this.getClientProvider();
        if (prov == null) {
            throw new ClientCreationException("", NbBundle.getBundle((Class)(class$org$netbeans$modules$javacvs$commands$FileSystemCommand == null ? (class$org$netbeans$modules$javacvs$commands$FileSystemCommand = FileSystemCommand.class$("org.netbeans.modules.javacvs.commands.FileSystemCommand")) : class$org$netbeans$modules$javacvs$commands$FileSystemCommand)).getString("FileSystemCommand.noClientAvailable"));
        }
        return prov.createClient(prov.getCvsRootString());
    }

    public void run() {
        try {
            if (this.libClient == null) {
                this.libClient = this.createClient();
            }
            this.eventManager = this.libClient.getEventManager();
        }
        catch (ClientCreationException exc) {
            this.executeFailed(exc);
            this.fireCommandErrorListener(true);
            this.setRunning(false);
            return;
        }
        this.eventManager.addCVSListener(this);
        this.initCommand(true);
        if (this.isStopped()) {
            this.executeFailed(null);
            this.fireCommandErrorListener(true);
            this.setRunning(false);
            return;
        }
        Iterator it = ((AbstractList)this.toDoCommands).iterator();
        while (it.hasNext()) {
            Command comm = (Command)it.next();
            this.setCurrentCommand(comm);
            this.beforeEachExecute();
            if (this.isStopped()) {
                this.executeFailed(null);
                this.fireCommandErrorListener(true);
                this.setRunning(false);
                return;
            }
            try {
                this.provider.openConnection(this.libClient, this.provider.getCvsRootString());
                this.libClient.executeCommand(comm, this.globalOptions);
                this.libClient.getConnection().close();
                if (this.serverError) {
                    throw new ServerErrorException();
                }
            }
            catch (Exception exc) {
                this.executeFailed(exc);
                this.fireCommandErrorListener(true);
                this.stopCommand();
                this.setRunning(false);
                return;
            }
            this.afterEachExecute();
            if (!this.isStopped()) continue;
            this.executeFailed(null);
            this.fireCommandErrorListener(true);
            this.setRunning(false);
            return;
        }
        this.finishedCommand();
        this.setRunning(false);
    }

    public void addCommandErrorListener(CommandErrorListener commErrListener) {
        if (this.errListeners == null) {
            this.errListeners = new ArrayList();
        }
        this.errListeners.add(commErrListener);
    }

    public void removeCommandErrorListener(CommandErrorListener commErrListener) {
        if (this.errListeners != null) {
            ((AbstractCollection)this.errListeners).remove(commErrListener);
        }
    }

    private void fireCommandErrorListener(boolean wasError) {
        ArrayList list;
        FileSystemCommand fileSystemCommand = this;
        synchronized (fileSystemCommand) {
            if (this.errListeners == null) {
                return;
            }
            list = (ArrayList)this.errListeners.clone();
        }
        CommandErrorEvent event = new CommandErrorEvent(this, wasError);
        int i = 0;
        while (i < list.size()) {
            ((CommandErrorListener)list.get(i)).errorGenerated(event);
            ++i;
        }
    }

    public void messageSent(MessageEvent e) {
        this.fireDisplayerEvent(new MessageGeneratedDisplayerEvent(this, e));
    }

    public synchronized void addDisplayerListener(CommandDisplayerListener listener) {
        if (this.displayListeners == null || this.displayListeners.length == 0) {
            this.displayListeners = new CommandDisplayerListener[1];
        } else {
            CommandDisplayerListener[] l = new CommandDisplayerListener[this.displayListeners.length + 1];
            int i = 0;
            while (i < this.displayListeners.length) {
                l[i] = this.displayListeners[i];
                ++i;
            }
            this.displayListeners = l;
        }
        this.displayListeners[this.displayListeners.length - 1] = listener;
    }

    public synchronized void removeDisplayerListener(CommandDisplayerListener listener) {
        if (this.displayListeners.length == 1) {
            this.displayListeners = null;
        } else {
            CommandDisplayerListener[] l = new CommandDisplayerListener[this.displayListeners.length - 1];
            int i = 0;
            while (i < l.length) {
                if (this.displayListeners[i] == listener) {
                    int j = i + 1;
                    while (j < this.displayListeners.length) {
                        l[j - 1] = this.displayListeners[j];
                        ++j;
                    }
                    break;
                }
                l[i] = this.displayListeners[i];
                ++i;
            }
            this.displayListeners = l;
        }
    }

    private void fireDisplayerEvent(CommandDisplayerEvent event) {
        if (this.displayListeners == null || this.displayListeners.length == 0) {
            return;
        }
        CommandDisplayerListener[] l = null;
        CommandDisplayerListener[] commandDisplayerListenerArray = this.displayListeners;
        synchronized (commandDisplayerListenerArray) {
            l = new CommandDisplayerListener[this.displayListeners.length];
            System.arraycopy(this.displayListeners, 0, l, 0, l.length);
        }
        int i = 0;
        while (i < l.length) {
            event.fireEvent(l[i]);
            ++i;
        }
    }

    public boolean setCommandArguments(Command command) {
        boolean ok = true;
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(this.getImpl().getClass());
        }
        catch (IntrospectionException exc) {
            return false;
        }
        if (info != null) {
            PropertyDescriptor[] desc = info.getPropertyDescriptors();
            int i = 0;
            while (i < desc.length) {
                PropertyDescriptor descriptor = desc[i];
                Method beanGetter = descriptor.getReadMethod();
                Method beanSetter = descriptor.getWriteMethod();
                Method commandSetter = null;
                Object value = null;
                try {
                    commandSetter = command.getClass().getMethod(beanSetter.getName(), beanSetter.getParameterTypes());
                    value = beanGetter.invoke((Object)this.getImpl(), null);
                    if (commandSetter != null) {
                        commandSetter.invoke((Object)command, value);
                    }
                }
                catch (Exception e) {
                    ok = false;
                }
                ++i;
            }
        }
        return ok;
    }

    public boolean getCommandArguments(Command command) {
        boolean ok = true;
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(this.getImpl().getClass());
        }
        catch (IntrospectionException exc) {
            return false;
        }
        if (info != null) {
            PropertyDescriptor[] desc = info.getPropertyDescriptors();
            int i = 0;
            while (i < desc.length) {
                PropertyDescriptor descriptor = desc[i];
                Method beanGetter = descriptor.getReadMethod();
                Method beanSetter = descriptor.getWriteMethod();
                Method commandGetter = null;
                try {
                    commandGetter = command.getClass().getMethod(beanGetter.getName(), beanGetter.getParameterTypes());
                    Object value = commandGetter.invoke((Object)command, null);
                    beanSetter.invoke((Object)this.getImpl(), value);
                }
                catch (Exception e) {
                    ok = false;
                }
                ++i;
            }
        }
        return ok;
    }

    protected abstract Class getMainCvsCommand();

    public String getCVSArguments() {
        Command comm = this.loadCommand(this.getMainCvsCommand());
        boolean ok = this.setCommandArguments(comm);
        return comm.getCVSArguments();
    }

    public String getCVSCommand() {
        Command comm = this.loadCommand(this.getMainCvsCommand());
        boolean ok = this.setCommandArguments(comm);
        return comm.getCVSCommand();
    }

    public void clearAllSwitches() {
        Command comm = this.loadCommand(this.getMainCvsCommand());
        comm.resetCVSCommand();
        this.getCommandArguments(comm);
    }

    public boolean copySwitchesFrom(FileSystemCommand com) {
        boolean ok = false;
        if (!com.getClass().equals(this.getClass())) {
            return ok;
        }
        Command comm = this.loadCommand(this.getMainCvsCommand());
        ok = com.setCommandArguments(comm);
        if (!ok) {
            return ok;
        }
        ok = this.getCommandArguments(comm);
        return ok;
    }

    public String getCVSEquivalent() {
        if (this.isRunning()) {
            return "";
        }
        this.initCommand(false);
        StringBuffer buff = new StringBuffer();
        Iterator it = ((AbstractList)this.toDoCommands).iterator();
        while (it.hasNext()) {
            Command comm = (Command)it.next();
            buff.append("cvs " + this.getGlobalOptions().getCVSCommand() + " ");
            String commandMess = comm.getCVSCommand();
            commandMess = commandMess.replace('\n', ' ');
            buff.append(commandMess + "\n");
        }
        this.clearCommandList();
        return buff.toString();
    }

    public String getCvsrcEntry() {
        Command comm = this.loadCommand(this.getMainCvsCommand());
        boolean ok = this.setCommandArguments(comm);
        if (ok) {
            return comm.getCVSCommand();
        }
        return "";
    }

    public void parseCvsArguments(String arguments) {
        Command comm = this.loadCommand(this.getMainCvsCommand());
        StringTokenizer tokens = new StringTokenizer(arguments, " \"", true);
        boolean withinString = false;
        LinkedList<String> stringList = new LinkedList<String>();
        while (tokens.hasMoreTokens()) {
            String tok = tokens.nextToken();
            if (tok.equals("\"")) {
                String param = "";
                while (tokens.hasMoreTokens()) {
                    String toke2 = tokens.nextToken();
                    if (toke2.equals("\"")) break;
                    param = param + toke2;
                }
                stringList.add(param);
                continue;
            }
            if (tok.equals(" ")) continue;
            stringList.add(tok);
        }
        String[] args = new String[stringList.size()];
        args = stringList.toArray(args);
        comm.resetCVSCommand();
        String getOptString = comm.getOptString();
        GetOpt go = new GetOpt(args, getOptString);
        int ch = -1;
        go.optIndexSet(0);
        boolean usagePrint = false;
        while ((ch = go.getopt()) != -1) {
            boolean ok = comm.setCVSCommand((char)ch, go.optArgGet());
        }
        this.getCommandArguments(comm);
    }

    private void saveFiles(FileObject[] fileObjects) {
        if (fileObjects == null) {
            return;
        }
        LinkedList<FileObject> folders = new LinkedList<FileObject>();
        int i = 0;
        while (i < fileObjects.length) {
            DataObject dobj = null;
            try {
                dobj = DataObject.find((FileObject)fileObjects[i]);
            }
            catch (DataObjectNotFoundException exc) {
                // empty catch block
            }
            if (fileObjects[i].isFolder()) {
                folders.add(fileObjects[i]);
            }
            if (dobj != null && dobj.isModified()) {
                Node.Cookie cake = dobj.getCookie(class$org$openide$cookies$SaveCookie == null ? FileSystemCommand.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie);
                try {
                    if (cake != null) {
                        ((SaveCookie)cake).save();
                    }
                }
                catch (IOException exc) {
                    ErrorManager.getDefault().notify((Throwable)exc);
                }
            }
            ++i;
        }
        if (!folders.isEmpty()) {
            DataObject[] modified = DataObject.getRegistry().getModified();
            int i2 = 0;
            while (i2 < modified.length) {
                Set files;
                DataObject dobj = modified[i2];
                SaveCookie sc = (SaveCookie)dobj.getCookie(class$org$openide$cookies$SaveCookie == null ? FileSystemCommand.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie);
                if (sc != null && FileSystemCommand.isAFileInAFolder(folders, files = dobj.files())) {
                    try {
                        sc.save();
                    }
                    catch (IOException exc) {
                        ErrorManager.getDefault().notify((Throwable)exc);
                    }
                }
                ++i2;
            }
        }
    }

    private static boolean isAFileInAFolder(Collection foldersCollection, Collection filesCollection) {
        boolean isIn = false;
        FileObject[] folders = foldersCollection.toArray(new FileObject[foldersCollection.size()]);
        FileObject[] files = filesCollection.toArray(new FileObject[filesCollection.size()]);
        boolean canBeIn = true;
        while (!isIn && canBeIn) {
            canBeIn = false;
            int i = 0;
            while (i < folders.length && !isIn) {
                int j = 0;
                while (j < files.length) {
                    if (files[j] != null) {
                        files[j] = files[j].getParent();
                        if (files[j] != null) {
                            if (folders[i].equals(files[j])) {
                                isIn = true;
                                break;
                            }
                            if (files[j].getPath().startsWith(folders[i].getPath())) {
                                canBeIn = true;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return isIn;
    }

    protected File[] convertFileObjects(FileObject[] fileObjects) {
        if (fileObjects == null) {
            return null;
        }
        File[] files = new File[fileObjects.length];
        int index = 0;
        while (index < fileObjects.length) {
            FileObject fo = fileObjects[index];
            File file = FileSystemCommand.toFile(fo);
            if (file != null) {
                files[index] = file;
            }
            ++index;
        }
        return files;
    }

    public static File toFile(FileObject fo) {
        String pne = fo.getPackageNameExt(File.separatorChar, '.');
        final class Env
        extends FileSystem.Environment {
            public File found;
            private final /* synthetic */ String val$pne;

            Env(String val$pne) {
                this.val$pne = val$pne;
            }

            public void addClassPath(String element) {
                File f;
                if (this.found != null) {
                    return;
                }
                File p = new File(element);
                if (!p.isDirectory()) {
                    return;
                }
                this.found = f = new File(p, this.val$pne);
            }
        }
        Env env = new Env(pne);
        try {
            fo.getFileSystem().prepareEnvironment((FileSystem.Environment)env);
            return env.found;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public void commandTerminated(TerminationEvent e) {
        super.commandTerminated(e);
        this.serverError = e.isError();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

