/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacvs.passwd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.PServerConnection;
import org.netbeans.lib.cvsclient.connection.Scrambler;
import org.netbeans.lib.cvsclient.connection.StandardScrambler;
import org.netbeans.modules.javacvs.commands.ClientCreationException;
import org.netbeans.modules.javacvs.passwd.PasswdEntry;
import org.netbeans.modules.javacvs.util.Debug;
import org.openide.util.NbBundle;

public class CVSPasswd {
    private Debug E;
    private Debug D;
    PrintWriter bf;
    public static final String STD_FILE = ".cvspass";
    private LinkedList entries;
    private PasswdEntry lastEntry;
    private File passFile;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$passwd$CVSPasswd;

    private CVSPasswd(File fil) {
        this.D = this.E = new Debug("CVSPasswd", true);
        this.entries = new LinkedList();
        this.passFile = null;
        this.passFile = fil;
    }

    public CVSPasswd(String dir, String fileName) {
        this.D = this.E = new Debug("CVSPasswd", true);
        this.entries = new LinkedList();
        this.passFile = null;
        String sep = File.separator;
        this.passFile = new File(dir, fileName);
    }

    public CVSPasswd(String dirAndFile) {
        this(new File(dirAndFile));
    }

    public boolean loadPassFile() throws ClientCreationException {
        ClientCreationException exc2;
        this.entries = new LinkedList();
        if (!this.passFile.exists()) {
            try {
                this.passFile.createNewFile();
            }
            catch (IOException exc) {
                exc2 = new ClientCreationException("Error creating .cvspass file", NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$passwd$CVSPasswd == null ? (class$org$netbeans$modules$javacvs$passwd$CVSPasswd = CVSPasswd.class$("org.netbeans.modules.javacvs.passwd.CVSPasswd")) : class$org$netbeans$modules$javacvs$passwd$CVSPasswd), (String)"CVSPasswd.errorCreatingPass", (Object)this.passFile.getAbsolutePath()));
            }
        }
        try {
            String line;
            BufferedReader bf = new BufferedReader(new FileReader(this.passFile.getAbsolutePath()));
            do {
                PasswdEntry entr;
                boolean ok;
                line = bf.readLine();
                this.D.deb("cvspass line=" + line);
                if (line == null || !(ok = (entr = new PasswdEntry()).setEntry(line))) continue;
                this.entries.add(entr);
            } while (line != null);
            bf.close();
        }
        catch (IOException exc) {
            exc2 = new ClientCreationException("Error reading .cvspass file", NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$passwd$CVSPasswd == null ? (class$org$netbeans$modules$javacvs$passwd$CVSPasswd = CVSPasswd.class$("org.netbeans.modules.javacvs.passwd.CVSPasswd")) : class$org$netbeans$modules$javacvs$passwd$CVSPasswd), (String)"CVSPasswd.errorReadingPass", (Object)this.passFile.getAbsolutePath()));
            this.D.deb(".cvspass reading error");
            if (this.bf != null) {
                this.bf.close();
            }
            throw exc2;
        }
        return true;
    }

    public boolean savePassFile() throws ClientCreationException {
        try {
            this.bf = new PrintWriter(new BufferedWriter(new FileWriter(this.passFile.getAbsolutePath(), false)));
            ListIterator it = this.entries.listIterator();
            while (it.hasNext()) {
                PasswdEntry ent = (PasswdEntry)it.next();
                this.bf.println(ent.getEntry(true));
            }
            this.bf.close();
        }
        catch (IOException exc) {
            ClientCreationException exc2 = new ClientCreationException("Error writing .cvspass file", NbBundle.getMessage((Class)(class$org$netbeans$modules$javacvs$passwd$CVSPasswd == null ? (class$org$netbeans$modules$javacvs$passwd$CVSPasswd = CVSPasswd.class$("org.netbeans.modules.javacvs.passwd.CVSPasswd")) : class$org$netbeans$modules$javacvs$passwd$CVSPasswd), (String)"CVSPasswd.errorWritingPass", (Object)this.passFile.getAbsolutePath()));
            this.D.deb(".cvspass writing error:" + this.passFile.getAbsolutePath());
            if (this.bf != null) {
                this.bf.close();
            }
            throw exc2;
        }
        return true;
    }

    public boolean remove(String entry) {
        PasswdEntry old = this.find(entry);
        if (old != null) {
            return this.entries.remove(old);
        }
        return true;
    }

    public PasswdEntry add(String entry, String passwd) {
        PasswdEntry psw = new PasswdEntry();
        Scrambler scr = StandardScrambler.getInstance();
        boolean ok = psw.setEntry(entry + " " + scr.scramble(passwd));
        if (ok) {
            PasswdEntry old = this.find(entry);
            if (old != null) {
                this.entries.remove(old);
            }
            this.entries.add(psw);
            return psw;
        }
        return null;
    }

    public PasswdEntry add(String type, String user, String server, String root, int port, String passwd) {
        if (port != 2401) {
            String ent = ":" + type + ":" + user + "@" + server + ":" + port + root;
            return this.add(ent, passwd);
        }
        String ent = ":" + type + ":" + user + "@" + server + ":" + root;
        return this.add(ent, passwd);
    }

    public PasswdEntry find(String current) {
        this.D.deb("current=" + current);
        ListIterator it = this.entries.listIterator();
        PasswdEntry ent = null;
        Object toReturn = null;
        while (it.hasNext()) {
            ent = (PasswdEntry)it.next();
            if (!ent.matchToCurrent(current)) continue;
            return ent;
        }
        return null;
    }

    public Collection getAllEntries() {
        return this.entries;
    }

    public boolean checkServer(PasswdEntry toCheck, int port) throws AuthenticationException {
        PServerConnection c = new PServerConnection();
        c.setUserName(toCheck.getUser());
        c.setEncodedPassword(toCheck.getPasswd());
        c.setHostName(toCheck.getServer());
        c.setRepository(toCheck.getRoot());
        c.setPort(port);
        c.verify();
        return true;
    }

    public static String scramble(String unScrambled) {
        Scrambler scr = StandardScrambler.getInstance();
        return scr.scramble(unScrambled);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

