/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.netbeans.updater.ModuleUpdate;
import org.netbeans.updater.UpdateTracking;
import org.netbeans.updater.UpdaterFrame;

public class ModuleUpdater
extends Thread {
    ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/updater/Bundle");
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final String UPDATE_DIR = "update";
    private static final String DOWNLOAD_DIR = "update" + FILE_SEPARATOR + "download";
    private static final String BACKUP_DIR = "update" + FILE_SEPARATOR + "backup";
    private static final String NB_LIB_DIR = "lib";
    private static final String EXT_DIR = "ext";
    private static final String JAVA_LIB_EXT_DIR = "lib" + FILE_SEPARATOR + "ext";
    public static final String UPDATE_NETBEANS_DIR = "netbeans";
    public static final String UPDATE_JAVA_EXT_DIR = "java_ext";
    public static final String UPDATE_MAIN_DIR = "main";
    private static final String JVM_PARAMS_FILE = "main.properties";
    private static final String NBM_EXTENSION = "nbm";
    public static final String LOG_FILE_NAME = "update.log";
    public static final String LATER_FILE_NAME = "install_later.xml";
    public static final char SPACE = ' ';
    public static final char QUOTE = '\"';
    private static File downloadDirectory = null;
    private static File backupDirectory = null;
    private static File netbeansDirectory = null;
    private static File nbLibDirectory = null;
    private static File javaLibExtDirectory = null;
    private static File updateDirectory = null;
    private static File mainDirectory = null;
    private File[] nbmFiles = null;
    private static Boolean singleMode = null;
    private volatile boolean stop = false;
    private volatile boolean suspend = false;
    private long totalLength;
    private static int instCount = 0;
    private static boolean fromInstall = false;

    public void run() {
        instCount = 0;
        ModuleUpdater.getDownloadDirectory();
        this.checkStop();
        if (downloadDirectory == null) {
            this.endRun();
        }
        this.checkStop();
        if (this.nbmFiles == null) {
            this.nbmFiles = ModuleUpdater.getNBMFiles();
        } else {
            this.sortNBMFiles();
        }
        if (this.nbmFiles == null || this.nbmFiles.length == 0) {
            this.endRun();
        }
        this.checkStop();
        this.totalLength();
        this.checkStop();
        this.unpack();
        if (!UpdaterFrame.isFromIDE()) {
            this.deleteInstall_Later();
        }
        UpdaterFrame.getUpdaterFrame().unpackingFinished();
    }

    private void deleteInstall_Later() {
        File later = null;
        if (ModuleUpdater.isMultiuser() && (later = new File(System.getProperty("netbeans.user") + FILE_SEPARATOR + DOWNLOAD_DIR + FILE_SEPARATOR + LATER_FILE_NAME)).exists()) {
            later.delete();
        }
        if ((later = new File(System.getProperty("netbeans.home") + FILE_SEPARATOR + DOWNLOAD_DIR + FILE_SEPARATOR + LATER_FILE_NAME)).exists()) {
            later.delete();
        }
    }

    void endRun() {
        this.stop = true;
    }

    private void checkStop() {
        if (this.suspend) {
            while (this.suspend) {
            }
        }
        if (this.stop) {
            System.exit(0);
        }
    }

    static File[] getNBMFiles() {
        instCount = 0;
        File[] instList = null;
        if (ModuleUpdater.isMultiuser() && (instList = ModuleUpdater.getInstallDownloadDirectory().listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(ModuleUpdater.NBM_EXTENSION);
            }
        })) != null) {
            instCount = instList.length;
        }
        int userCount = 0;
        File[] userList = downloadDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(ModuleUpdater.NBM_EXTENSION);
            }
        });
        if (userList != null) {
            userCount = userList.length;
        }
        File[] dirList = new File[instCount + userCount];
        if (instCount > 0) {
            int i = 0;
            while (i < instCount) {
                dirList[i] = instList[i];
                ++i;
            }
        }
        int i = 0;
        while (i < userCount) {
            dirList[ModuleUpdater.instCount + i] = userList[i];
            ++i;
        }
        return dirList;
    }

    private void sortNBMFiles() {
        instCount = 0;
        ArrayList<File> sorted = new ArrayList<File>();
        int i = 0;
        while (i < this.nbmFiles.length) {
            if (this.nbmFiles[i].getParentFile().equals(ModuleUpdater.getInstallDownloadDirectory())) {
                ++instCount;
                sorted.add(0, this.nbmFiles[i]);
            } else {
                sorted.add(this.nbmFiles[i]);
            }
            ++i;
        }
        this.nbmFiles = sorted.toArray(this.nbmFiles);
    }

    void setNBMFiles(File[] files) {
        this.nbmFiles = files;
    }

    /*
     * Loose catch block
     */
    private void totalLength() {
        this.totalLength = 0L;
        UpdaterFrame.setLabel(this.bundle.getString("CTL_PreparingUnpack"));
        UpdaterFrame.setProgressRange(0L, this.nbmFiles.length);
        int i = 0;
        while (i < this.nbmFiles.length) {
            block13: {
                ZipFile jarFile = null;
                UpdaterFrame.setProgressValue(i + 1);
                jarFile = new JarFile(this.nbmFiles[i]);
                Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    this.checkStop();
                    if (!entry.getName().startsWith(UPDATE_NETBEANS_DIR) && !entry.getName().startsWith(UPDATE_JAVA_EXT_DIR) && !entry.getName().startsWith(UPDATE_MAIN_DIR) || entry.isDirectory()) continue;
                    this.totalLength += entry.getSize();
                }
                Object var6_6 = null;
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                    break block13;
                }
                catch (IOException e2) {}
                break block13;
                {
                    catch (IOException e) {
                        var6_6 = null;
                        try {
                            if (jarFile != null) {
                                jarFile.close();
                            }
                            break block13;
                        }
                        catch (IOException e2) {}
                    }
                }
                catch (Throwable throwable) {
                    var6_6 = null;
                    try {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            ++i;
        }
    }

    /*
     * Loose catch block
     */
    void unpack() {
        long bytesRead = 0L;
        UpdaterFrame.setLabel("");
        UpdaterFrame.setProgressRange(0L, this.totalLength);
        fromInstall = true;
        UpdateTracking tracking = new UpdateTracking();
        UpdateTracking.Module modtrack = null;
        UpdateTracking.Version version = null;
        HashMap<ModuleUpdate, UpdateTracking.Version> l10ns = new HashMap<ModuleUpdate, UpdateTracking.Version>();
        int i = 0;
        while (i < this.nbmFiles.length) {
            ModuleUpdate mu;
            block31: {
                JarFile jarFile;
                block29: {
                    MainConfig mconfig;
                    if (i > instCount - 1 && fromInstall) {
                        if (i > 0) {
                            updateDirectory = null;
                            downloadDirectory = null;
                            backupDirectory = null;
                            netbeansDirectory = null;
                            mainDirectory = null;
                            nbLibDirectory = null;
                        }
                        fromInstall = false;
                    }
                    if ((mu = new ModuleUpdate(this.nbmFiles[i], fromInstall)).isL10n()) {
                        version = tracking.createVersion("0");
                        l10ns.put(mu, version);
                    } else {
                        modtrack = tracking.readModuleTracking(!fromInstall, mu.getCodenamebase(), true);
                        version = modtrack.addNewVersion(mu.getSpecification_version());
                    }
                    System.gc();
                    boolean hasMainClass = false;
                    UpdaterFrame.setLabel(this.bundle.getString("CTL_UnpackingFile") + "  " + this.nbmFiles[i].getName());
                    UpdaterFrame.setProgressValue(bytesRead);
                    jarFile = null;
                    jarFile = new JarFile(this.nbmFiles[i]);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        File destFile;
                        JarEntry entry = entries.nextElement();
                        this.checkStop();
                        if (entry.getName().startsWith(UPDATE_NETBEANS_DIR)) {
                            if (entry.isDirectory()) {
                                File newBckDir;
                                File newDir = new File(ModuleUpdater.getNetbeansDirectory(), entry.getName().substring(UPDATE_NETBEANS_DIR.length()));
                                if (!newDir.isDirectory()) {
                                    newDir.mkdirs();
                                }
                                if ((newBckDir = new File(ModuleUpdater.getBackupDirectory(), entry.getName())).isDirectory()) continue;
                                newBckDir.mkdirs();
                                continue;
                            }
                            String pathTo = entry.getName().substring(9);
                            if (mu.isL10n()) {
                                version.addL10NFileWithCrc(pathTo, Long.toString(entry.getCrc()), mu.getSpecification_version());
                            } else {
                                version.addFileWithCrc(pathTo, Long.toString(entry.getCrc()));
                            }
                            File destFile2 = new File(ModuleUpdater.getNetbeansDirectory(), entry.getName().substring(UPDATE_NETBEANS_DIR.length()));
                            if (destFile2.exists()) {
                                File bckFile = new File(ModuleUpdater.getBackupDirectory(), entry.getName());
                                bckFile.getParentFile().mkdirs();
                                this.copyStreams(new FileInputStream(destFile2), new FileOutputStream(bckFile), -1L);
                            } else {
                                destFile2.getParentFile().mkdirs();
                            }
                            bytesRead = this.copyStreams(jarFile.getInputStream(entry), new FileOutputStream(destFile2), bytesRead);
                            UpdaterFrame.setProgressValue(bytesRead);
                            continue;
                        }
                        if (entry.getName().startsWith(UPDATE_JAVA_EXT_DIR) && !entry.isDirectory()) {
                            destFile = new File(ModuleUpdater.getJavaLibExtDirectory(), entry.getName().substring(UPDATE_JAVA_EXT_DIR.length()));
                            if (destFile.exists()) {
                                File bckFile = new File(ModuleUpdater.getBackupDirectory(), UPDATE_JAVA_EXT_DIR + FILE_SEPARATOR + entry.getName().substring(UPDATE_NETBEANS_DIR.length()));
                                bckFile.getParentFile().mkdirs();
                                this.copyStreams(new FileInputStream(destFile), new FileOutputStream(bckFile), -1L);
                            } else {
                                destFile.getParentFile().mkdirs();
                            }
                            bytesRead = this.copyStreams(jarFile.getInputStream(entry), new FileOutputStream(destFile), bytesRead);
                            UpdaterFrame.setProgressValue(bytesRead);
                            continue;
                        }
                        if (!entry.getName().startsWith(UPDATE_MAIN_DIR) || entry.isDirectory()) continue;
                        destFile = new File(ModuleUpdater.getMainDirectory(), entry.getName().substring(UPDATE_MAIN_DIR.length() + 1));
                        destFile.getParentFile().mkdirs();
                        hasMainClass = true;
                        bytesRead = this.copyStreams(jarFile.getInputStream(entry), new FileOutputStream(destFile), bytesRead);
                        UpdaterFrame.setProgressValue(bytesRead);
                    }
                    if (!hasMainClass || !(mconfig = new MainConfig(ModuleUpdater.getMainDirString() + FILE_SEPARATOR + JVM_PARAMS_FILE)).isValid()) break block29;
                    String java_path = System.getProperty("java.home") + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "java";
                    java_path = ModuleUpdater.quoteString(java_path);
                    String torun = java_path + " -cp " + ModuleUpdater.quoteString(ModuleUpdater.getMainDirString() + mconfig.getClasspath()) + mconfig.getCommand();
                    this.startCommand(torun);
                    this.deleteDir(ModuleUpdater.getMainDirectory());
                }
                Object var17_16 = null;
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                this.nbmFiles[i].delete();
                {
                    break block31;
                    catch (IOException e) {
                        e.printStackTrace();
                        var17_16 = null;
                        try {
                            if (jarFile != null) {
                                jarFile.close();
                            }
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        this.nbmFiles[i].delete();
                    }
                }
                catch (Throwable throwable) {
                    var17_16 = null;
                    try {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    this.nbmFiles[i].delete();
                    throw throwable;
                }
            }
            if (!mu.isL10n()) {
                modtrack.write();
            }
            ++i;
        }
        Iterator it = l10ns.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ModuleUpdate mod = (ModuleUpdate)entry.getKey();
            version = (UpdateTracking.Version)entry.getValue();
            modtrack = tracking.readModuleTracking(!mod.isFromInstall(), mod.getCodenamebase(), true);
            modtrack.addL10NVersion(version);
            modtrack.write();
        }
        tracking.deleteUnusedFiles();
    }

    public static File getUpdateDirectory() {
        if (updateDirectory == null && !(updateDirectory = ModuleUpdater.isMultiuser() ? new File(System.getProperty("netbeans.user") + FILE_SEPARATOR + UPDATE_DIR) : new File(System.getProperty("netbeans.home") + FILE_SEPARATOR + UPDATE_DIR)).isDirectory()) {
            updateDirectory.mkdirs();
        }
        return updateDirectory;
    }

    private static File getInstallDownloadDirectory() {
        File idir = new File(System.getProperty("netbeans.home") + FILE_SEPARATOR + DOWNLOAD_DIR);
        if (!idir.isDirectory()) {
            idir.mkdirs();
        }
        return idir;
    }

    public static File getDownloadDirectory() {
        if (downloadDirectory == null && !(downloadDirectory = ModuleUpdater.isMultiuser() ? new File(System.getProperty("netbeans.user") + FILE_SEPARATOR + DOWNLOAD_DIR) : new File(System.getProperty("netbeans.home") + FILE_SEPARATOR + DOWNLOAD_DIR)).isDirectory()) {
            downloadDirectory.mkdirs();
        }
        return downloadDirectory;
    }

    private void startCommand(String torun) {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process proces;
            final Process proc2 = proces = runtime.exec(ModuleUpdater.parseParameters(torun));
            new Thread(){

                public void run() {
                    try {
                        String vystup;
                        InputStreamReader stream = new InputStreamReader(proc2.getErrorStream());
                        BufferedReader reader = new BufferedReader(stream);
                        do {
                            if ((vystup = reader.readLine()) == null) continue;
                            System.out.println(vystup);
                        } while (vystup != null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            int x = proces.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File getBackupDirectory() {
        if (backupDirectory == null && !(backupDirectory = ModuleUpdater.isMultiuser() ? new File(System.getProperty("netbeans.user") + FILE_SEPARATOR + BACKUP_DIR) : new File(System.getProperty("netbeans.home") + FILE_SEPARATOR + BACKUP_DIR)).isDirectory()) {
            backupDirectory.mkdirs();
        }
        return backupDirectory;
    }

    public static File getNetbeansDirectory() {
        if (netbeansDirectory == null) {
            netbeansDirectory = ModuleUpdater.isMultiuser() ? new File(System.getProperty("netbeans.user")) : new File(System.getProperty("netbeans.home"));
        }
        return netbeansDirectory;
    }

    private static File getMainDirectory() {
        if (mainDirectory == null) {
            mainDirectory = ModuleUpdater.isMultiuser() ? new File(System.getProperty("netbeans.user") + FILE_SEPARATOR + UPDATE_DIR + FILE_SEPARATOR + UPDATE_MAIN_DIR) : new File(System.getProperty("netbeans.home") + FILE_SEPARATOR + UPDATE_DIR + FILE_SEPARATOR + UPDATE_MAIN_DIR);
        }
        return mainDirectory;
    }

    private static String getMainDirString() {
        return ModuleUpdater.getMainDirectory().getPath();
    }

    public static final String quoteString(String s) {
        if (s.indexOf(32) > -1) {
            StringBuffer sb = new StringBuffer(s);
            int i = 0;
            while (i < sb.length()) {
                if (sb.charAt(i) == '\"') {
                    sb.deleteCharAt(i);
                    continue;
                }
                ++i;
            }
            sb.insert(0, '\"');
            sb.append('\"');
            return sb.toString();
        }
        return s;
    }

    public static File getNbLibDirectory() {
        File nbLibExt;
        if (nbLibDirectory == null) {
            nbLibDirectory = ModuleUpdater.isMultiuser() ? new File(System.getProperty("netbeans.user") + FILE_SEPARATOR + NB_LIB_DIR) : new File(System.getProperty("netbeans.home") + FILE_SEPARATOR + NB_LIB_DIR);
        }
        if (!(nbLibExt = new File(nbLibDirectory, EXT_DIR)).isDirectory()) {
            nbLibExt.mkdirs();
        }
        return nbLibDirectory;
    }

    public static File getJavaLibExtDirectory() {
        if (javaLibExtDirectory == null) {
            javaLibExtDirectory = new File(System.getProperty("java.home") + FILE_SEPARATOR + JAVA_LIB_EXT_DIR);
        }
        if (ModuleUpdater.canWrite(javaLibExtDirectory, true)) {
            return javaLibExtDirectory;
        }
        return ModuleUpdater.getNbLibDirectory();
    }

    private static boolean isMultiuser() {
        if (fromInstall) {
            return false;
        }
        return !ModuleUpdater.singleMode();
    }

    private static boolean singleMode() {
        if (singleMode == null) {
            singleMode = Boolean.FALSE;
            if (System.getProperty("netbeans.user") == null) {
                singleMode = Boolean.TRUE;
            } else {
                File instDir;
                File userDir = new File(System.getProperty("netbeans.user"));
                if (userDir.equals(instDir = new File(System.getProperty("netbeans.home")))) {
                    singleMode = Boolean.TRUE;
                } else {
                    try {
                        if (userDir.getCanonicalPath().equals(instDir.getCanonicalPath())) {
                            singleMode = Boolean.TRUE;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return singleMode;
    }

    /*
     * WARNING - void declaration
     */
    private long copyStreams(InputStream src, OutputStream dest, long progressVal) throws IOException {
        BufferedInputStream bsrc = new BufferedInputStream(src);
        BufferedOutputStream bdest = new BufferedOutputStream(dest);
        int count = 0;
        try {
            int c;
            while ((c = bsrc.read()) != -1) {
                void var8_7;
                bdest.write((int)var8_7);
                if (++count <= 8500) continue;
                if (progressVal >= 0L) {
                    UpdaterFrame.setProgressValue(progressVal += (long)count);
                }
                count = 0;
                this.checkStop();
            }
            if (progressVal >= 0L) {
                progressVal += (long)count;
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            bsrc.close();
            bdest.close();
            throw throwable;
        }
        bsrc.close();
        bdest.close();
        return progressVal;
    }

    private static boolean canWrite(File dir, boolean create) {
        if (!dir.exists() && create) {
            dir.mkdirs();
        }
        if (!dir.isDirectory() || !dir.canWrite()) {
            return false;
        }
        File tmp = null;
        try {
            tmp = File.createTempFile("test", "access", dir);
        }
        catch (IOException e) {
            return false;
        }
        if (tmp == null) {
            return false;
        }
        boolean cw = tmp.canWrite();
        if (cw) {
            tmp.delete();
        }
        return cw;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getBranding() {
        String s;
        BufferedReader in;
        block8: {
            in = null;
            s = null;
            File brandf = new File(System.getProperty("netbeans.home") + FILE_SEPARATOR + NB_LIB_DIR + FILE_SEPARATOR + "branding");
            in = new BufferedReader(new FileReader(brandf));
            if (!in.ready()) break block8;
            s = in.readLine();
        }
        Object var4_4 = null;
        if (in == null) return s;
        try {
            in.close();
            return s;
        }
        catch (IOException e2) {}
        return s;
        {
            catch (IOException e) {
                Object var4_5 = null;
                if (in == null) return s;
                try {
                    in.close();
                    return s;
                }
                catch (IOException e2) {}
                return s;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void deleteDir(File dir) {
        File[] files = dir.listFiles();
        int j = 0;
        while (j < files.length) {
            if (files[j].isDirectory()) {
                this.deleteDir(files[j]);
            }
            files[j].delete();
            ++j;
        }
    }

    private String getLogPath() {
        return ModuleUpdater.getUpdateDirectory().getPath() + FILE_SEPARATOR + LOG_FILE_NAME;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String[] parseParameters(String s) {
        int NULL = 0;
        int INPARAM = 1;
        int INPARAMPENDING = 2;
        int STICK = 4;
        int STICKPENDING = 8;
        Vector<String> params = new Vector<String>(5, 5);
        int state = NULL;
        StringBuffer buff = new StringBuffer(20);
        int slength = s.length();
        int i = 0;
        while (i < slength) {
            block25: {
                char c;
                block34: {
                    block36: {
                        block35: {
                            block29: {
                                block33: {
                                    block32: {
                                        block30: {
                                            block31: {
                                                block26: {
                                                    block28: {
                                                        block27: {
                                                            c = s.charAt(i);
                                                            if (!Character.isWhitespace(c)) break block26;
                                                            if (state != NULL) break block27;
                                                            if (buff.length() > 0) {
                                                                params.addElement(buff.toString());
                                                                buff.setLength(0);
                                                            }
                                                            break block25;
                                                        }
                                                        if (state != STICK) break block28;
                                                        params.addElement(buff.toString());
                                                        buff.setLength(0);
                                                        state = NULL;
                                                        break block25;
                                                    }
                                                    if (state == STICKPENDING) {
                                                        buff.append('\\');
                                                        params.addElement(buff.toString());
                                                        buff.setLength(0);
                                                        state = NULL;
                                                        break block25;
                                                    } else if (state == INPARAMPENDING) {
                                                        state = INPARAM;
                                                        buff.append('\\');
                                                        buff.append(c);
                                                        break block25;
                                                    } else {
                                                        buff.append(c);
                                                    }
                                                    break block25;
                                                }
                                                if (c != '\\') break block29;
                                                if (state != NULL) break block30;
                                                if (++i >= slength) break block31;
                                                char cc = s.charAt(i);
                                                if (cc == '\"' || cc == '\\') {
                                                    buff.append(cc);
                                                    break block25;
                                                } else if (Character.isWhitespace(cc)) {
                                                    buff.append(c);
                                                    --i;
                                                    break block25;
                                                } else {
                                                    buff.append(c);
                                                    buff.append(cc);
                                                }
                                                break block25;
                                            }
                                            buff.append('\\');
                                            break;
                                        }
                                        if (state != INPARAM) break block32;
                                        state = INPARAMPENDING;
                                        break block25;
                                    }
                                    if (state != INPARAMPENDING) break block33;
                                    buff.append('\\');
                                    state = INPARAM;
                                    break block25;
                                }
                                if (state == STICK) {
                                    state = STICKPENDING;
                                    break block25;
                                } else if (state == STICKPENDING) {
                                    buff.append('\\');
                                    state = STICK;
                                }
                                break block25;
                            }
                            if (c != '\"') break block34;
                            if (state != NULL) break block35;
                            state = INPARAM;
                            break block25;
                        }
                        if (state != INPARAM) break block36;
                        state = STICK;
                        break block25;
                    }
                    if (state == STICK) {
                        state = INPARAM;
                        break block25;
                    } else if (state == STICKPENDING) {
                        buff.append('\"');
                        state = STICK;
                        break block25;
                    } else {
                        buff.append('\"');
                        state = INPARAM;
                    }
                    break block25;
                }
                if (state == INPARAMPENDING) {
                    buff.append('\\');
                    state = INPARAM;
                } else if (state == STICKPENDING) {
                    buff.append('\\');
                    state = STICK;
                }
                buff.append(c);
            }
            ++i;
        }
        if (state == INPARAM) {
            params.addElement(buff.toString());
        } else if ((state & (INPARAMPENDING | STICKPENDING)) != 0) {
            buff.append('\\');
            params.addElement(buff.toString());
        } else if (buff.length() != 0) {
            params.addElement(buff.toString());
        }
        Object[] ret = new String[params.size()];
        params.copyInto(ret);
        return ret;
    }

    static /* synthetic */ String access$000() {
        return PATH_SEPARATOR;
    }

    class MainConfig {
        private final String PAR_MAIN = "mainClass";
        private final String PAR_RELCP = "relativeClassPath";
        private final String PAR_JVMPAR = "jvm.parameters";
        private final String PAR_MAINARGS = "mainClass.arguments";
        private final String VAR_IDE_HOME = "%IDE_HOME%";
        private final String VAR_IDE_USER = "%IDE_USER%";
        private final String VAR_FILE_SEPARATOR = "%FS%";
        private final String VAR_JAVA_HOME = "%JAVA_HOME%";
        private final String VAR_ICON_ROOT = "%ICON_ROOT%";
        private final String ICON_ROOT = "Forte for Java";
        private final String VAR_LOGFILE = "%UPDATE_LOGFILE%";
        private String parameters = "";
        private String classpath = "";
        private boolean valid = false;

        public MainConfig(String spath) {
            this.valid = this.readParms(spath);
        }

        public String getCommand() {
            return this.parameters;
        }

        public String getClasspath() {
            return this.classpath;
        }

        public boolean isValid() {
            return this.valid;
        }

        /*
         * Unable to fully structure code
         */
        private boolean readParms(String spath) {
            block16: {
                details = new Properties();
                fis = null;
                try {
                    fis = new FileInputStream(spath);
                    details.load(fis);
                    var7_4 = null;
                    ** if (fis == null) goto lbl-1000
                }
                catch (Throwable var6_14) {
                    var7_6 = null;
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    throw var6_14;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block16;
                    catch (IOException e) {
                        var5_12 = false;
                        var7_5 = null;
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        return var5_12;
                    }
                }
            }
            if ((relpath = details.getProperty("relativeClassPath", null)) != null) {
                relpath = this.replaceVars(relpath);
                token = new StringTokenizer(relpath, ModuleUpdater.access$000(), false);
                while (token.hasMoreTokens()) {
                    this.classpath = this.classpath + ModuleUpdater.access$000() + this.changeRelative(token.nextToken());
                }
            }
            this.parameters = "";
            jvmparms = details.getProperty("jvm.parameters", null);
            if (jvmparms != null) {
                this.parameters = this.parameters + " " + jvmparms;
            }
            if ((mainclass = details.getProperty("mainClass", null)) == null) {
                return false;
            }
            this.parameters = this.parameters + " " + mainclass;
            mainargs = details.getProperty("mainClass.arguments", null);
            if (mainargs != null) {
                this.parameters = this.parameters + " " + mainargs;
            }
            this.parameters = this.replaceVars(this.parameters);
            return true;
        }

        private String replaceVars(String original) {
            original = this.replaceAll(original, "%IDE_HOME%", new File(System.getProperty("netbeans.home")).getPath());
            original = this.replaceAll(original, "%IDE_USER%", ModuleUpdater.getNetbeansDirectory().getPath());
            original = this.replaceAll(original, "%FS%", FILE_SEPARATOR);
            original = this.replaceAll(original, "%JAVA_HOME%", System.getProperty("java.home"));
            original = this.replaceAll(original, "%ICON_ROOT%", this.getIconRoot());
            original = this.replaceAll(original, "%UPDATE_LOGFILE%", ModuleUpdater.this.getLogPath());
            return original;
        }

        private String changeRelative(String path) {
            if (new File(path).isAbsolute()) {
                return path;
            }
            return ModuleUpdater.getMainDirString() + FILE_SEPARATOR + path;
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String getIconRoot() {
            String ret;
            FileInputStream fis;
            block8: {
                Properties prop = new Properties();
                fis = null;
                File propf = new File(System.getProperty("netbeans.home") + FILE_SEPARATOR + "system" + FILE_SEPARATOR + "product.properties");
                fis = new FileInputStream(propf);
                prop.load(fis);
                ret = prop.getProperty("start.menu.icon.root");
                if (ret != null) break block8;
                ret = this.getDefaultIconRoot();
            }
            Object var6_6 = null;
            if (fis == null) return '\"' + ret + '\"';
            try {
                fis.close();
                return '\"' + ret + '\"';
            }
            catch (IOException e2) {}
            return '\"' + ret + '\"';
            {
                catch (IOException e) {
                    ret = this.getDefaultIconRoot();
                    Object var6_7 = null;
                    if (fis == null) return '\"' + ret + '\"';
                    try {
                        fis.close();
                        return '\"' + ret + '\"';
                    }
                    catch (IOException e2) {}
                    return '\"' + ret + '\"';
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (fis == null) throw throwable;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        private String getDefaultIconRoot() {
            String s = ModuleUpdater.getBranding();
            String ext = "";
            if (s != null) {
                if (s.indexOf("_ce") > 0) {
                    ext = " CE";
                } else if (s.indexOf("_ie") > 0) {
                    ext = " IE";
                } else if (s.indexOf("_ee") > 0) {
                    ext = " EE";
                }
            }
            return "Forte for Java" + ext;
        }

        private String replaceAll(String sin, String what, String repl) {
            StringBuffer sb = new StringBuffer(sin);
            int i = sb.toString().indexOf(what);
            int len = what.length();
            while (i > -1) {
                sb.replace(i, i + len, repl);
                i = sb.toString().indexOf(what, i + 1);
            }
            return sb.toString();
        }
    }
}

