/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import org.netbeans.updater.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class UpdateTracking {
    private static final String ELEMENT_MODULES = "installed_modules";
    private static final String ELEMENT_MODULE = "module";
    private static final String ATTR_CODENAMEBASE = "codename";
    private static final String ELEMENT_VERSION = "module_version";
    private static final String ATTR_VERSION = "specification_version";
    private static final String ATTR_ORIGIN = "origin";
    private static final String ATTR_LAST = "last";
    private static final String ATTR_INSTALL = "install_time";
    private static final String ELEMENT_FILE = "file";
    private static final String ATTR_FILE_NAME = "name";
    private static final String ATTR_CRC = "crc";
    private static final String NBM_ORIGIN = "nbm";
    private static final String INST_ORIGIN = "installer";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String LOCALE_DIR = FILE_SEPARATOR + "locale" + FILE_SEPARATOR;
    private static final String TRACKING_FILE_NAME = "update_tracking";
    private static final String XML_EXT = ".xml";
    private List modules = new ArrayList();
    private boolean userDirScanned = false;
    private boolean homeDirScanned = false;
    private List trackingFiles = new ArrayList();
    private boolean pError = false;
    private static UpdateTracking trackingHome;
    private static UpdateTracking trackingUser;
    private boolean fromUser = false;
    private File trackingFile = null;
    private String origin = "nbm";

    static UpdateTracking getTracking(boolean fromuser) {
        if (fromuser) {
            if (trackingUser == null) {
                UpdateTracking.readTracking(fromuser);
            }
            return trackingUser;
        }
        if (trackingHome == null) {
            UpdateTracking.readTracking(fromuser);
        }
        return trackingHome;
    }

    public UpdateTracking() {
    }

    public UpdateTracking(String nbPath) {
        this.trackingFile = new File(nbPath + FILE_SEPARATOR + TRACKING_FILE_NAME);
        this.origin = INST_ORIGIN;
    }

    static void readTracking(boolean fromuser) {
        if (fromuser) {
            trackingUser = new UpdateTracking();
            UpdateTracking.trackingUser.fromUser = true;
            trackingUser.read();
        } else {
            trackingHome = new UpdateTracking();
            UpdateTracking.trackingHome.fromUser = false;
            trackingHome.read();
        }
    }

    private File getTrackingFile(boolean fromUserDir) {
        if (this.trackingFile == null) {
            String dir = fromUserDir && UpdateTracking.isMultiuser() ? System.getProperty("netbeans.user") : System.getProperty("netbeans.home");
            this.trackingFile = new File(dir + FILE_SEPARATOR + TRACKING_FILE_NAME + XML_EXT);
        }
        return this.trackingFile;
    }

    private static boolean isMultiuser() {
        return System.getProperty("netbeans.user") != null && !System.getProperty("netbeans.home").equals(System.getProperty("netbeans.user"));
    }

    private void read() {
        Document document;
        try {
            File file = this.getTrackingFile(this.fromUser);
            if (!file.exists()) {
                return;
            }
            FileInputStream is = new FileInputStream(file);
            InputSource xmlInputSource = new InputSource(is);
            document = XMLUtil.parse(xmlInputSource, false, false, new ErrorCatcher(), XMLUtil.createAUResolver());
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (SAXException e) {
            System.out.println("Bad update_tracking");
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            System.out.println("Missing update_tracking");
            e.printStackTrace();
            return;
        }
        Element element = document.getDocumentElement();
        if (element != null && element.getTagName().equals(ELEMENT_MODULES)) {
            this.scanElement_installed_modules(element, this.fromUser);
        }
    }

    void scanElement_installed_modules(Element element, boolean fromuser) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Element nodeElement;
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && (nodeElement = (Element)node).getTagName().equals(ELEMENT_MODULE)) {
                this.modules.add(this.scanElement_module(nodeElement, fromuser));
            }
            ++i;
        }
    }

    Module scanElement_module(Element element, boolean fromuser) {
        Module module = new Module(fromuser);
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().startsWith(ATTR_CODENAMEBASE)) {
                module.setCodenamebase(attr.getValue());
            }
            ++i;
        }
        NodeList nodes = element.getChildNodes();
        int i2 = 0;
        while (i2 < nodes.getLength()) {
            Element nodeElement;
            Node node = nodes.item(i2);
            if (node.getNodeType() == 1 && (nodeElement = (Element)node).getTagName().equals(ELEMENT_VERSION)) {
                this.scanElement_module_version(nodeElement, module);
            }
            ++i2;
        }
        this.modules.add(module);
        return module;
    }

    void scanElement_module_version(Element element, Module module) {
        Version version = new Version();
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals(ATTR_VERSION)) {
                version.setVersion(attr.getValue());
            }
            if (attr.getName().equals(ATTR_ORIGIN)) {
                version.setOrigin(attr.getValue());
            }
            if (attr.getName().equals(ATTR_LAST)) {
                version.setLast(Boolean.valueOf(attr.getValue()));
            }
            if (attr.getName().equals(ATTR_INSTALL)) {
                long li = 0L;
                try {
                    li = Long.parseLong(attr.getValue());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                version.setInstall_time(li);
            }
            ++i;
        }
        NodeList nodes = element.getChildNodes();
        int i2 = 0;
        while (i2 < nodes.getLength()) {
            Element nodeElement;
            Node node = nodes.item(i2);
            if (node.getNodeType() == 1 && (nodeElement = (Element)node).getTagName().equals(ELEMENT_FILE)) {
                this.scanElement_file(nodeElement, version);
            }
            ++i2;
        }
        module.addOldVersion(version);
    }

    void scanElement_file(Element element, Version version) {
        ModuleFile file = new ModuleFile();
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals(ATTR_FILE_NAME)) {
                file.setName(attr.getValue());
            }
            if (attr.getName().equals(ATTR_CRC)) {
                file.setCrc(attr.getValue());
            }
            if (attr.getName().equals(ATTR_VERSION)) {
                file.setLocaleversion(attr.getValue());
            }
            ++i;
        }
        version.addFile(file);
    }

    Module readModuleTracking(boolean fromuser, String codename, boolean create) {
        String dir = fromuser && UpdateTracking.isMultiuser() ? System.getProperty("netbeans.user") : System.getProperty("netbeans.home");
        new File(dir + FILE_SEPARATOR + TRACKING_FILE_NAME).mkdirs();
        File file = new File(dir + FILE_SEPARATOR + TRACKING_FILE_NAME + FILE_SEPARATOR + UpdateTracking.getTrackingName(codename) + XML_EXT);
        if (!file.exists()) {
            if (create) {
                return new Module(codename, file, fromuser);
            }
            return null;
        }
        return this.readModuleFromFile(file, codename, fromuser, create);
    }

    Version createVersion(String specversion) {
        Version ver = new Version();
        ver.setVersion(specversion);
        return ver;
    }

    private Module readModuleFromFile(File file, String codename, boolean fromuser, boolean create) {
        Document document;
        try {
            FileInputStream is = new FileInputStream(file);
            InputSource xmlInputSource = new InputSource(is);
            document = XMLUtil.parse(xmlInputSource, false, false, new ErrorCatcher(), XMLUtil.createAUResolver());
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (SAXException e) {
            System.out.println("Bad update_tracking");
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            if (create) {
                return new Module(codename, file, fromuser);
            }
            return null;
        }
        Element element = document.getDocumentElement();
        if (element != null && element.getTagName().equals(ELEMENT_MODULE)) {
            Module m = this.scanElement_module(element, fromuser);
            m.setFile(file);
            this.trackingFiles.add(file);
            return m;
        }
        if (create) {
            return new Module(codename, file, fromuser);
        }
        return null;
    }

    private static String getTrackingName(String codename) {
        String trackingName = codename;
        int pos = trackingName.indexOf(47);
        if (pos > -1) {
            trackingName = trackingName.substring(0, pos);
        }
        return trackingName.replace('.', '-');
    }

    public static void convertOldFormat(File oldfile, String path, boolean fromUserDir) {
        new File(path + FILE_SEPARATOR + TRACKING_FILE_NAME).mkdirs();
        UpdateTracking track = UpdateTracking.getTracking(fromUserDir);
        Iterator it = track.modules.iterator();
        while (it.hasNext()) {
            Module mod = (Module)it.next();
            File newfile = new File(path + FILE_SEPARATOR + TRACKING_FILE_NAME + FILE_SEPARATOR + UpdateTracking.getTrackingName(mod.getCodenamebase()) + XML_EXT);
            mod.setFile(newfile);
            mod.write();
        }
        oldfile.delete();
    }

    public String getL10NSpecificationVersion(String codenamebase, boolean fromUserDir, String jarpath) {
        Module module = this.readModuleTracking(fromUserDir, codenamebase, false);
        if (module == null) {
            return null;
        }
        return module.getL10NSpecificationVersion(jarpath);
    }

    void deleteUnusedFiles() {
        ArrayList newModules = new ArrayList(this.modules);
        Iterator it = newModules.iterator();
        while (it.hasNext()) {
            Module mod = (Module)it.next();
            mod.deleteUnusedFiles();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long getFileCRC(File file) throws IOException {
        BufferedInputStream bsrc = null;
        CRC32 crc = new CRC32();
        try {
            int i;
            bsrc = new BufferedInputStream(new FileInputStream(file));
            byte[] bytes = new byte[1024];
            while ((i = bsrc.read()) != -1) {
                void var4_4;
                crc.update((byte)var4_4);
            }
            Object var6_5 = null;
            if (bsrc == null) return crc.getValue();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (bsrc == null) throw throwable;
            bsrc.close();
            throw throwable;
        }
        bsrc.close();
        return crc.getValue();
    }

    private void scanDir(boolean fromUser) {
        String dirname;
        if (fromUser) {
            if (this.userDirScanned) {
                return;
            }
            this.userDirScanned = true;
            dirname = System.getProperty("netbeans.user");
        } else {
            if (this.homeDirScanned) {
                return;
            }
            this.homeDirScanned = true;
            dirname = System.getProperty("netbeans.home");
        }
        File dir = new File(dirname + FILE_SEPARATOR + TRACKING_FILE_NAME);
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return !file.isDirectory() && file.getName().toUpperCase().endsWith(".XML");
            }
        });
        int i = 0;
        while (i < files.length) {
            if (!this.trackingFiles.contains(files[i])) {
                this.readModuleFromFile(files[i], null, fromUser, true);
            }
            ++i;
        }
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String level, SAXParseException e) {
            UpdateTracking.this.pError = true;
        }

        public void error(SAXParseException e) {
            UpdateTracking.this.pError = true;
        }

        public void warning(SAXParseException e) {
        }

        public void fatalError(SAXParseException e) {
            UpdateTracking.this.pError = true;
        }
    }

    class ModuleFile {
        private String name;
        private String crc;
        private String localeversion = null;

        ModuleFile() {
        }

        String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        String getCrc() {
            return this.crc;
        }

        void setCrc(String crc) {
            this.crc = crc;
        }

        public String getLocaleversion() {
            return this.localeversion;
        }

        public void setLocaleversion(String localeversion) {
            this.localeversion = localeversion;
        }
    }

    public class Version
    implements Comparable {
        private String version;
        private String origin;
        private boolean last;
        private long install_time = 0L;
        private List files = new ArrayList();

        String getVersion() {
            return this.version;
        }

        void setVersion(String version) {
            this.version = version;
        }

        String getOrigin() {
            return this.origin;
        }

        void setOrigin(String origin) {
            this.origin = origin;
        }

        boolean isLast() {
            return this.last;
        }

        void setLast(boolean last) {
            this.last = last;
        }

        long getInstall_time() {
            return this.install_time;
        }

        void setInstall_time(long install_time) {
            this.install_time = install_time;
        }

        List getFiles() {
            return this.files;
        }

        void addL10NFiles(List l10nfiles) {
            Iterator it = l10nfiles.iterator();
            while (it.hasNext()) {
                ModuleFile lf = (ModuleFile)it.next();
                String lname = lf.getName();
                int i = this.files.size() - 1;
                while (i >= 0) {
                    ModuleFile f = (ModuleFile)this.files.get(i);
                    if (f.getName().equals(lname)) {
                        this.files.remove(i);
                    }
                    --i;
                }
            }
            this.files.addAll(l10nfiles);
        }

        void addFile(ModuleFile file) {
            this.files.add(file);
        }

        public void addFileWithCrc(String filename, String crc) {
            ModuleFile file = new ModuleFile();
            file.setName(filename);
            file.setCrc(crc);
            this.files.add(file);
        }

        public void addL10NFileWithCrc(String filename, String crc, String specver) {
            ModuleFile file = new ModuleFile();
            file.setName(filename);
            file.setCrc(crc);
            file.setLocaleversion(specver);
            this.files.add(file);
        }

        boolean containsFile(ModuleFile file) {
            Iterator it = this.files.iterator();
            while (it.hasNext()) {
                ModuleFile f = (ModuleFile)it.next();
                if (!f.getName().equals(file.getName())) continue;
                return true;
            }
            return false;
        }

        ModuleFile findFile(String filename) {
            Iterator it = this.files.iterator();
            while (it.hasNext()) {
                ModuleFile f = (ModuleFile)it.next();
                if (!f.getName().equals(filename)) continue;
                return f;
            }
            return null;
        }

        String getLocaleVersion(String filename) {
            String locver = null;
            ModuleFile f = this.findFile(filename);
            if (f != null && (locver = f.getLocaleversion()) == null) {
                locver = this.version;
            }
            return locver;
        }

        public int compareTo(Object obj) {
            Version oth = (Version)obj;
            if (this.install_time < oth.getInstall_time()) {
                return 1;
            }
            if (this.install_time > oth.getInstall_time()) {
                return -1;
            }
            return 0;
        }
    }

    class Module {
        private String codenamebase;
        private List versions = new ArrayList();
        private File file = null;
        private boolean fromUser = true;
        private Version lastVersion = null;
        private Version newVersion = null;

        public Module() {
        }

        public Module(boolean fromUser) {
            this.fromUser = fromUser;
        }

        public Module(String codenamebase, File file, boolean fromUser) {
            this.codenamebase = codenamebase;
            this.file = file;
            this.fromUser = fromUser;
        }

        String getCodenamebase() {
            return this.codenamebase;
        }

        void setCodenamebase(String codenamebase) {
            this.codenamebase = codenamebase;
        }

        List getVersions() {
            return this.versions;
        }

        void setVersions(List versions) {
            this.versions = versions;
        }

        boolean isFromUser() {
            return this.fromUser;
        }

        void setFromUser(boolean fromUser) {
            this.fromUser = fromUser;
        }

        private Version getNewOrLastVersion() {
            if (this.newVersion != null) {
                return this.newVersion;
            }
            return this.lastVersion;
        }

        boolean hasNewVersion() {
            return this.newVersion != null;
        }

        void setFile(File file) {
            this.file = file;
        }

        public Version addNewVersion(String spec_version) {
            Version version;
            if (this.lastVersion != null) {
                this.lastVersion.setLast(false);
            }
            this.newVersion = version = new Version();
            version.setVersion(spec_version);
            version.setOrigin(UpdateTracking.this.origin);
            version.setLast(true);
            version.setInstall_time(System.currentTimeMillis());
            this.versions.add(version);
            return version;
        }

        void addOldVersion(Version version) {
            if (version.isLast()) {
                this.lastVersion = version;
            }
            this.versions.add(version);
        }

        void addL10NVersion(Version l_version) {
            if (this.lastVersion != null) {
                this.lastVersion.addL10NFiles(l_version.getFiles());
            } else {
                l_version.setOrigin(UpdateTracking.this.origin);
                l_version.setLast(true);
                l_version.setInstall_time(System.currentTimeMillis());
                this.versions.add(l_version);
            }
        }

        void write() {
            Document document = XMLUtil.createDocument(UpdateTracking.ELEMENT_MODULE);
            Element e_module = document.getDocumentElement();
            Element e_version = null;
            Element e_file = null;
            e_module.setAttribute(UpdateTracking.ATTR_CODENAMEBASE, this.getCodenamebase());
            Iterator it2 = this.getVersions().iterator();
            while (it2.hasNext()) {
                Version ver = (Version)it2.next();
                e_version = document.createElement(UpdateTracking.ELEMENT_VERSION);
                if (ver.getVersion() != null) {
                    e_version.setAttribute(UpdateTracking.ATTR_VERSION, ver.getVersion());
                }
                e_version.setAttribute(UpdateTracking.ATTR_ORIGIN, ver.getOrigin());
                e_version.setAttribute(UpdateTracking.ATTR_LAST, new Boolean(ver.isLast()).toString());
                e_version.setAttribute(UpdateTracking.ATTR_INSTALL, Long.toString(ver.getInstall_time()));
                e_module.appendChild(e_version);
                Iterator it3 = ver.getFiles().iterator();
                while (it3.hasNext()) {
                    ModuleFile file = (ModuleFile)it3.next();
                    e_file = document.createElement(UpdateTracking.ELEMENT_FILE);
                    e_file.setAttribute(UpdateTracking.ATTR_FILE_NAME, file.getName());
                    e_file.setAttribute(UpdateTracking.ATTR_CRC, file.getCrc());
                    if (file.getLocaleversion() != null) {
                        e_file.setAttribute(UpdateTracking.ATTR_VERSION, file.getLocaleversion());
                    }
                    e_version.appendChild(e_file);
                }
            }
            document.getDocumentElement().normalize();
            try {
                FileOutputStream os = new FileOutputStream(this.file);
                XMLUtil.write(document, os);
                ((OutputStream)os).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        void deleteUnusedFiles() {
            if (this.lastVersion == null || this.newVersion == null) {
                return;
            }
            Iterator it = this.lastVersion.getFiles().iterator();
            while (it.hasNext()) {
                ModuleFile modFile = (ModuleFile)it.next();
                if (this.newVersion.containsFile(modFile) || modFile.getName().indexOf(LOCALE_DIR) != -1) continue;
                this.safeDelete(modFile);
            }
        }

        private void safeDelete(ModuleFile modFile) {
            File f = new File(this.file.getParentFile().getParent() + FILE_SEPARATOR + modFile.getName());
            if (f.exists()) {
                try {
                    if (!Long.toString(UpdateTracking.getFileCRC(f)).equals(modFile.getCrc())) {
                        return;
                    }
                }
                catch (IOException ioe) {
                    return;
                }
                UpdateTracking.this.scanDir(this.fromUser);
                boolean found = false;
                Iterator it = UpdateTracking.this.modules.iterator();
                while (!found && it.hasNext()) {
                    Version v;
                    Module mod = (Module)it.next();
                    if (mod.equals(this) || (v = mod.getNewOrLastVersion()) == null || !v.containsFile(modFile)) continue;
                    found = true;
                }
                if (!found) {
                    f.delete();
                }
            }
        }

        String getL10NSpecificationVersion(String jarpath) {
            String localever = null;
            Collections.sort(this.versions);
            Iterator it = this.versions.iterator();
            while (it.hasNext()) {
                Version ver = (Version)it.next();
                localever = ver.getLocaleVersion(jarpath);
                if (localever == null) continue;
                return localever;
            }
            return null;
        }
    }
}

