/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.updater.ModuleUpdater;

public class UpdaterFrame
extends JPanel {
    public static final int OS_WIN = 1;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_OS2 = 1024;
    public static final int OS_OTHER = 65536;
    private static final String SPLASH_PATH = "org/netbeans/updater/resources/updatersplash";
    private static final String UNDERLINE = "_";
    private static UpdaterFrame panel;
    private static boolean bigBounds;
    private static ModuleUpdater mu;
    private static boolean fromIDE;
    private static Window splashWindow;
    private static boolean nongui;
    private JLabel textLabel;
    private JLabel jLabel3;
    private JProgressBar progressBar;
    private JTextArea jTextArea1;
    static /* synthetic */ Class class$org$netbeans$updater$UpdaterFrame;

    public UpdaterFrame() {
        this.initComponents();
        if (this.addBorder()) {
            this.setBorder(new LineBorder(new Color(0, 0, 0)));
        }
        this.loadSplash();
    }

    static final void center(Window c) {
        c.pack();
        GraphicsConfiguration gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Rectangle bounds = gconf.getBounds();
        Dimension dialogSize = c.getSize();
        ((Component)c).setLocation(bounds.x + (bounds.width - dialogSize.width) / 2, bounds.y + (bounds.height - dialogSize.height) / 2);
    }

    static String getMainWindowTitle() {
        return ResourceBundle.getBundle("org/netbeans/updater/Bundle").getString("UpdaterFrame.Form.title");
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jTextArea1 = new JTextArea();
        this.textLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.setBackground(this.stringToColor("UpdaterFrame.TextBackground", new Color(0, 33, 173)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setForeground(this.stringToColor("UpdaterFrame.TextForeground", Color.white));
        this.jTextArea1.setText(ResourceBundle.getBundle("org/netbeans/updater/Bundle").getString("UpdaterFrame.jTextArea1.text"));
        this.jTextArea1.setBackground(new Color(213, 204, 187));
        this.jTextArea1.setDisabledTextColor(Color.white);
        this.jTextArea1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 14, 0, 14);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.textLabel.setText(ResourceBundle.getBundle("org/netbeans/updater/Bundle").getString("UpdaterFrame.textLabel.text"));
        this.textLabel.setForeground(this.stringToColor("UpdaterFrame.TextForeground", Color.white));
        this.textLabel.setFont(new Font("Dialog", 1, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 14, 8, 14);
        this.add((Component)this.textLabel, gridBagConstraints);
        this.progressBar.setPreferredSize(new Dimension(300, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 14, 10, 14);
        this.add((Component)this.progressBar, gridBagConstraints);
    }

    private static void showSplash() {
        splashWindow = UpdaterFrame.getOperatingSystem() == 1 || UpdaterFrame.getOperatingSystem() == 8 || UpdaterFrame.getOperatingSystem() == 1024 || UpdaterFrame.getOperatingSystem() == 16 ? new SplashWindow() : new SplashFrame();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                splashWindow.show();
                splashWindow.toFront();
            }
        });
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("-nodisplay")) {
            nongui = true;
        } else {
            panel = new UpdaterFrame();
            UpdaterFrame.showSplash();
        }
        mu = new ModuleUpdater();
        mu.start();
    }

    public static void runFromIDE(File[] files, PropertyChangeListener listener) {
        fromIDE = true;
        panel = new UpdaterFrame();
        panel.addPropertyChangeListener(listener);
        UpdaterFrame.showSplash();
        mu = new ModuleUpdater();
        mu.setNBMFiles(files);
        mu.start();
    }

    void unpackingFinished() {
        this.runningFinished();
    }

    void runningFinished() {
        if (fromIDE) {
            this.firePropertyChange("FINISHED", null, null);
            splashWindow.dispose();
        } else {
            System.exit(0);
        }
    }

    static void setLabel(final String text) {
        if (nongui) {
            return;
        }
        final JLabel label = UpdaterFrame.panel.textLabel;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                label.setText(text);
            }
        });
    }

    static void setProgressRange(final long min, final long max) {
        if (nongui) {
            return;
        }
        bigBounds = max > 65535L;
        final JProgressBar progressBar = UpdaterFrame.panel.progressBar;
        final boolean bb = bigBounds;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                progressBar.setMinimum(bb ? (int)(min / 1024L) : (int)min);
                progressBar.setMaximum(bb ? (int)(max / 1024L) : (int)max);
            }
        });
    }

    static void setProgressValue(final long value) {
        if (nongui) {
            return;
        }
        final JProgressBar progressBar = UpdaterFrame.panel.progressBar;
        final boolean bb = bigBounds;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                progressBar.setValue(bb ? (int)(value / 1024L) : (int)value);
            }
        });
    }

    public static final int getOperatingSystem() {
        int operatingSystem = -1;
        String osName = System.getProperty("os.name");
        operatingSystem = osName != null && osName.startsWith("Windows") ? 1 : ("Solaris".equals(osName) ? 8 : (osName.startsWith("SunOS") ? 8 : ("Linux".equals(osName) ? 16 : ("OS/2".equals(osName) ? 1024 : 65536))));
        return operatingSystem;
    }

    static boolean isFromIDE() {
        return fromIDE;
    }

    static UpdaterFrame getUpdaterFrame() {
        return panel;
    }

    private Color stringToColor(String key, Color defcolor) {
        try {
            String str = this.getBrandingString(key + "_R");
            int re = Integer.parseInt(str);
            str = this.getBrandingString(key + "_G");
            int gr = Integer.parseInt(str);
            str = this.getBrandingString(key + "_B");
            int bl = Integer.parseInt(str);
            return new Color(re, gr, bl);
        }
        catch (Exception e) {
            return defcolor;
        }
    }

    private boolean addBorder() {
        return "true".equals(this.getBrandingString("UpdaterFrame.hasBorder"));
    }

    private String getBrandingString(String key) {
        try {
            return ResourceBundle.getBundle("org/netbeans/updater/resources/Branding").getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadSplash() {
        URL lookup = null;
        ArrayList<String> brandingSequence = new ArrayList<String>();
        String branding = ModuleUpdater.getBranding();
        if (branding != null) {
            int pos;
            brandingSequence.add("org/netbeans/updater/resources/updatersplash_" + branding);
            while ((pos = branding.lastIndexOf(UNDERLINE)) > -1) {
                void var4_4;
                branding = branding.substring(0, (int)var4_4);
                brandingSequence.add("org/netbeans/updater/resources/updatersplash_" + branding);
            }
        }
        brandingSequence.add(SPLASH_PATH);
        Iterator it = ((AbstractList)brandingSequence).iterator();
        while (it.hasNext()) {
            String path = (String)it.next() + ".gif";
            lookup = (class$org$netbeans$updater$UpdaterFrame == null ? UpdaterFrame.class$("org.netbeans.updater.UpdaterFrame") : class$org$netbeans$updater$UpdaterFrame).getClassLoader().getResource(path);
            if (lookup != null) break;
        }
        if (lookup != null) {
            this.jLabel3.setIcon(new ImageIcon(lookup));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        bigBounds = false;
        mu = null;
        fromIDE = false;
        nongui = false;
    }

    static class SplashWindow
    extends Window {
        public SplashWindow() {
            super(new Frame());
            this.setLayout(new BorderLayout());
            this.add((Component)panel, "Center");
            UpdaterFrame.center(this);
        }

        public Dimension getPreferredSize() {
            return new Dimension(400, 280);
        }
    }

    static class SplashFrame
    extends JFrame {
        public SplashFrame() {
            super(UpdaterFrame.getMainWindowTitle());
            this.setDefaultCloseOperation(0);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.getContentPane().add(panel);
            UpdaterFrame.center(this);
        }

        public Dimension getPreferredSize() {
            return new Dimension(400, 280);
        }
    }
}

