/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLUtil {
    static /* synthetic */ Class class$java$io$Writer;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$w3c$dom$Document;

    public static Document parse(InputSource input, boolean validate, boolean namespaceAware, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validate);
        factory.setNamespaceAware(namespaceAware);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException("Cannot create parser satisfying configuration parameters", ex);
        }
        if (errorHandler != null) {
            builder.setErrorHandler(errorHandler);
        }
        if (entityResolver != null) {
            builder.setEntityResolver(entityResolver);
        }
        return builder.parse(input);
    }

    public static Document createDocument(String rootQName) throws DOMException {
        DOMImplementation impl = XMLUtil.getDOMImplementation();
        return impl.createDocument(null, rootQName, null);
    }

    private static DOMImplementation getDOMImplementation() throws DOMException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            return factory.newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException ex) {
            throw new DOMException(9, "Cannot create parser satisfying configuration parameters");
        }
    }

    static void write(Document doc, OutputStream out) throws IOException {
        XMLUtil.write(doc, out, null);
    }

    private static void write(Document doc, Object out, String encoding) throws IOException {
        Class<?> dock = doc.getClass();
        try {
            if ("com.sun.xml.tree.XmlDocument".equals(dock.getName()) || "org.apache.crimson.tree.XmlDocument".equals(dock.getName())) {
                Method write = out instanceof Writer ? dock.getDeclaredMethod("write", class$java$io$Writer == null ? (class$java$io$Writer = XMLUtil.class$("java.io.Writer")) : class$java$io$Writer) : dock.getDeclaredMethod("write", class$java$io$OutputStream == null ? (class$java$io$OutputStream = XMLUtil.class$("java.io.OutputStream")) : class$java$io$OutputStream);
                write.invoke((Object)doc, out);
            } else {
                Class<?> serka = Class.forName("org.apache.xml.serialize.XMLSerializer");
                Class<?> forka = Class.forName("org.apache.xml.serialize.OutputFormat");
                Object serin = serka.newInstance();
                Object forin = forka.newInstance();
                Method setmet = null;
                setmet = forka.getMethod("setMethod", class$java$lang$String == null ? (class$java$lang$String = XMLUtil.class$("java.lang.String")) : class$java$lang$String);
                setmet.invoke(forin, "xml");
                setmet = forka.getMethod("setIndenting", Boolean.TYPE);
                setmet.invoke(forin, Boolean.TRUE);
                setmet = forka.getMethod("setLineWidth", Integer.TYPE);
                setmet.invoke(forin, new Integer(0));
                String detectedEncoding = null;
                if (out instanceof OutputStream) {
                    Method init = serka.getMethod("setOutputByteStream", class$java$io$OutputStream == null ? (class$java$io$OutputStream = XMLUtil.class$("java.io.OutputStream")) : class$java$io$OutputStream);
                    init.invoke(serin, out);
                    detectedEncoding = encoding;
                } else if (out instanceof Writer) {
                    Method init = serka.getMethod("setOutputCharStream", class$java$io$Writer == null ? (class$java$io$Writer = XMLUtil.class$("java.io.Writer")) : class$java$io$Writer);
                    init.invoke(serin, out);
                    if (out instanceof OutputStreamWriter) {
                        detectedEncoding = ((OutputStreamWriter)out).getEncoding();
                        detectedEncoding = null;
                    } else {
                        detectedEncoding = null;
                    }
                } else {
                    throw new ClassCastException("OutputStream or Writer expected.");
                }
                Method setenc = forka.getMethod("setEncoding", class$java$lang$String == null ? (class$java$lang$String = XMLUtil.class$("java.lang.String")) : class$java$lang$String);
                setenc.invoke(forin, detectedEncoding);
                Method setout = serka.getMethod("setOutputFormat", forka);
                setout.invoke(serin, forin);
                Method asDOM = serka.getMethod("asDOMSerializer", new Class[0]);
                Object impl = asDOM.invoke(serin, new Object[0]);
                Method serialize = impl.getClass().getMethod("serialize", class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = XMLUtil.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document);
                serialize.invoke(impl, doc);
            }
        }
        catch (IllegalAccessException ex) {
            XMLUtil.handleImplementationException(ex);
        }
        catch (InstantiationException ex) {
            XMLUtil.handleImplementationException(ex);
        }
        catch (IllegalArgumentException ex) {
            XMLUtil.handleImplementationException(ex);
        }
        catch (NoSuchMethodException ex) {
            XMLUtil.handleImplementationException(ex);
        }
        catch (ClassNotFoundException ex) {
            XMLUtil.handleImplementationException(ex);
        }
        catch (InvocationTargetException ex) {
            XMLUtil.handleTargetException(ex);
        }
    }

    private static void handleTargetException(InvocationTargetException ex) throws IOException {
        Throwable t = ex.getTargetException();
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
    }

    private static void handleImplementationException(Exception ex) throws IOException {
        StringWriter wr = new StringWriter();
        ex.printStackTrace(new PrintWriter(wr));
        throw new IOException("Unsupported DOM Document implementation!\n" + wr.toString());
    }

    public static EntityResolver createAUResolver() {
        return new EntityResolver(){
            static /* synthetic */ Class class$org$netbeans$updater$XMLUtil;

            public InputSource resolveEntity(String publicID, String systemID) throws IOException, SAXException {
                if ("-//NetBeans//DTD Autoupdate Catalog 1.0//EN".equals(publicID)) {
                    return new InputSource((class$org$netbeans$updater$XMLUtil == null ? (class$org$netbeans$updater$XMLUtil = 1.class$("org.netbeans.updater.XMLUtil")) : class$org$netbeans$updater$XMLUtil).getResource("resources/autoupdate-catalog-1_0.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 1.0//EN".equals(publicID)) {
                    return new InputSource((class$org$netbeans$updater$XMLUtil == null ? (class$org$netbeans$updater$XMLUtil = 1.class$("org.netbeans.updater.XMLUtil")) : class$org$netbeans$updater$XMLUtil).getResource("resources/autoupdate-info-1_0.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Catalog 2.0//EN".equals(publicID)) {
                    return new InputSource((class$org$netbeans$updater$XMLUtil == null ? (class$org$netbeans$updater$XMLUtil = 1.class$("org.netbeans.updater.XMLUtil")) : class$org$netbeans$updater$XMLUtil).getResource("resources/autoupdate-catalog-2_0.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 2.0//EN".equals(publicID)) {
                    return new InputSource((class$org$netbeans$updater$XMLUtil == null ? (class$org$netbeans$updater$XMLUtil = 1.class$("org.netbeans.updater.XMLUtil")) : class$org$netbeans$updater$XMLUtil).getResource("resources/autoupdate-info-2_0.dtd").toString());
                }
                return null;
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

