/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javamake;

import com.sun.tools.javamake.PCDContainer;
import com.sun.tools.javamake.PCDManager;
import com.sun.tools.javamake.PrivateException;
import com.sun.tools.javamake.PublicExceptions;
import com.sun.tools.javamake.Utils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class Main {
    static final String DEFAULT_STORE_NAME = "javamake.pdb";
    static final String VERSION = "1.2.12";
    private String pdbFileName = null;
    private ArrayList allProjectJavaFileNamesList = new ArrayList(100);
    private String[] allProjectJavaFileNames;
    private String[] addedJavaFileNames;
    private String[] removedJavaFileNames;
    private String[] updatedJavaFileNames;
    private String destDir = "";
    private ArrayList javacAddArgs = new ArrayList();
    private String jcPath;
    private String jcMainClass;
    private String jcMethod;
    private String jcExecApp;
    boolean controlledExecution = false;
    Object externalApp = null;
    Method externalCompileSourceFilesMethod = null;
    private PCDManager pcdm;
    private static final String[] optNames = new String[]{"-h", "-help", "-d", "-pdb", "-C", "-jcpath", "-jcmainclass", "-jcmethod", "-jcexec", "-Xtiming", "-version", "-warnlimit"};
    private static final int[] optArgs = new int[]{0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1};
    private static final int OPT_H = 0;
    private static final int OPT_HELP = 1;
    private static final int OPT_D = 2;
    private static final int OPT_STORE = 3;
    private static final int OPT_JAVAC_OPT = 4;
    private static final int OPT_JCPATH = 5;
    private static final int OPT_JCMAINCLASS = 6;
    private static final int OPT_JCMETHOD = 7;
    private static final int OPT_JCEXEC = 8;
    private static final int OPT_TIMING = 9;
    private static final int OPT_VERSION = 10;
    private static final int OPT_WARNLIMIT = 11;
    private static final String ERR_IS_INVALID_OPTION = " is an invalid option or argument.";
    private static final String ERR_NO_TWO_COMPILER_OPTIONS = "You may not specify both compiler class and compiler executable application";

    private static int inOptions(String string) {
        if (string.startsWith(optNames[4])) {
            return 4;
        }
        int n = 0;
        while (n < optNames.length) {
            if (string.equals(optNames[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static final int getNoOfArgs(int n) {
        return optArgs[n];
    }

    private void processCommandLine(String[] stringArray) {
        if (stringArray.length == 0 || stringArray.length == 1 && stringArray[0].equals(optNames[1])) {
            Main.printUsage();
            throw new PrivateException(new PublicExceptions.NoActionRequestedException());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            arrayList.add(stringArray[n]);
            ++n;
        }
        int n2 = 0;
        block16: while (n2 < arrayList.size()) {
            String string;
            if ((string = (String)arrayList.get(n2++)).charAt(0) == '-') {
                int n3 = Main.inOptions(string);
                if (n3 != -1) {
                    if (n2 + optArgs[n3] > arrayList.size()) {
                        Main.optRequiresArg("\"" + optNames[n3] + "\"");
                    }
                } else {
                    Main.bailOut(string + ERR_IS_INVALID_OPTION);
                }
                switch (n3) {
                    case 0: 
                    case 1: {
                        Main.printUsage();
                        throw new PrivateException(new PublicExceptions.NoActionRequestedException());
                    }
                    case 2: {
                        this.destDir = (String)arrayList.get(n2);
                        this.javacAddArgs.add("-d");
                        this.javacAddArgs.add((String)arrayList.get(n2));
                        ++n2;
                        break;
                    }
                    case 3: {
                        this.pdbFileName = (String)arrayList.get(n2++);
                        break;
                    }
                    case 4: {
                        this.javacAddArgs.add(((String)arrayList.get(n2 - 1)).substring(2));
                        break;
                    }
                    case 5: {
                        if (this.jcExecApp != null) {
                            Main.bailOut(ERR_NO_TWO_COMPILER_OPTIONS);
                        }
                        this.jcPath = (String)arrayList.get(n2++);
                        break;
                    }
                    case 6: {
                        if (this.jcExecApp != null) {
                            Main.bailOut(ERR_NO_TWO_COMPILER_OPTIONS);
                        }
                        this.jcMainClass = (String)arrayList.get(n2++);
                        break;
                    }
                    case 7: {
                        if (this.jcExecApp != null) {
                            Main.bailOut(ERR_NO_TWO_COMPILER_OPTIONS);
                        }
                        this.jcMethod = (String)arrayList.get(n2++);
                        break;
                    }
                    case 8: {
                        if (this.jcPath != null || this.jcMainClass != null || this.jcMethod != null) {
                            Main.bailOut(ERR_NO_TWO_COMPILER_OPTIONS);
                        }
                        this.jcExecApp = (String)arrayList.get(n2++);
                        break;
                    }
                    case 9: {
                        Utils.setTimingOn();
                        break;
                    }
                    case 10: {
                        Utils.printInfoMessage("Javamake version 1.2.12");
                        throw new PrivateException(new PublicExceptions.NoActionRequestedException());
                    }
                    case 11: {
                        try {
                            Utils.warningLimit = Integer.parseInt((String)arrayList.get(n2++));
                        }
                        catch (NumberFormatException numberFormatException) {
                            Main.bailOut((String)arrayList.get(n2) + ERR_IS_INVALID_OPTION);
                        }
                        continue block16;
                    }
                    default: {
                        Main.bailOut(string + ERR_IS_INVALID_OPTION);
                        break;
                    }
                }
                continue;
            }
            if (string.length() > 1 && string.charAt(0) == '@') {
                if ((string = string.substring(1)).charAt(0) == '@') {
                    this.allProjectJavaFileNamesList.add(string);
                    continue;
                }
                this.loadCmdFile(string, arrayList);
                continue;
            }
            this.allProjectJavaFileNamesList.add(string);
        }
    }

    private void loadCmdFile(String string, ArrayList arrayList) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.resetSyntax();
            streamTokenizer.wordChars(32, 255);
            streamTokenizer.whitespaceChars(0, 32);
            streamTokenizer.commentChar(35);
            streamTokenizer.quoteChar(34);
            streamTokenizer.quoteChar(39);
            while (streamTokenizer.nextToken() != -1) {
                arrayList.add(streamTokenizer.sval);
            }
            ((Reader)bufferedReader).close();
        }
        catch (IOException iOException) {
            throw new PrivateException(new PublicExceptions.CommandFileReadException(string + ":\n" + iOException.getMessage()));
        }
    }

    public void mainProgrammatic(String[] stringArray) throws PublicExceptions.NoActionRequestedException, PublicExceptions.InvalidCmdOptionException, PublicExceptions.PDBCorruptedException, PublicExceptions.CommandFileReadException, PublicExceptions.CompilerInteractionException, PublicExceptions.ClassFileParseException, PublicExceptions.ClassNameMismatchException, FileNotFoundException, IOException, PublicExceptions.InternalException {
        block12: {
            try {
                Utils.printInfoMessage("Javamake version 1.2.12");
                if (!this.controlledExecution) {
                    this.processCommandLine(stringArray);
                    this.allProjectJavaFileNames = this.allProjectJavaFileNamesList.toArray(new String[this.allProjectJavaFileNamesList.size()]);
                }
                Utils.startTiming(1);
                PCDContainer pCDContainer = PCDContainer.load(this.pdbFileName);
                Utils.stopAndPrintTiming("DB read", 1);
                this.pcdm = new PCDManager(pCDContainer, this.allProjectJavaFileNames, this.addedJavaFileNames, this.removedJavaFileNames, this.updatedJavaFileNames, this.destDir, this.javacAddArgs);
                this.pcdm.initializeCompiler(this.jcExecApp, this.jcPath, this.jcMainClass, this.jcMethod, this.externalApp, this.externalCompileSourceFilesMethod);
                this.pcdm.run();
            }
            catch (PrivateException privateException) {
                Throwable throwable = privateException.getOriginalException();
                if (throwable instanceof PublicExceptions.NoActionRequestedException) {
                    throw (PublicExceptions.NoActionRequestedException)throwable;
                }
                if (throwable instanceof PublicExceptions.InvalidCmdOptionException) {
                    throw (PublicExceptions.InvalidCmdOptionException)throwable;
                }
                if (throwable instanceof PublicExceptions.CommandFileReadException) {
                    throw (PublicExceptions.CommandFileReadException)throwable;
                }
                if (throwable instanceof PublicExceptions.PDBCorruptedException) {
                    throw (PublicExceptions.PDBCorruptedException)throwable;
                }
                if (throwable instanceof PublicExceptions.CompilerInteractionException) {
                    throw (PublicExceptions.CompilerInteractionException)throwable;
                }
                if (throwable instanceof PublicExceptions.ClassFileParseException) {
                    throw (PublicExceptions.ClassFileParseException)throwable;
                }
                if (throwable instanceof PublicExceptions.ClassNameMismatchException) {
                    throw (PublicExceptions.ClassNameMismatchException)throwable;
                }
                if (throwable instanceof FileNotFoundException) {
                    throw (FileNotFoundException)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (!(throwable instanceof PublicExceptions.InternalException)) break block12;
                throw (PublicExceptions.InternalException)throwable;
            }
        }
    }

    public int mainExternal(String[] stringArray) {
        try {
            this.mainProgrammatic(stringArray);
        }
        catch (PublicExceptions.NoActionRequestedException noActionRequestedException) {
        }
        catch (PublicExceptions.InvalidCmdOptionException invalidCmdOptionException) {
            Utils.printErrorMessage(invalidCmdOptionException.getMessage());
            return -1;
        }
        catch (PublicExceptions.CommandFileReadException commandFileReadException) {
            Utils.printErrorMessage("Error parsing command file:");
            Utils.printErrorMessage(commandFileReadException.getMessage());
            return -2;
        }
        catch (PublicExceptions.PDBCorruptedException pDBCorruptedException) {
            Utils.printErrorMessage("Project database corrupted: " + pDBCorruptedException.getMessage());
            return -3;
        }
        catch (PublicExceptions.CompilerInteractionException compilerInteractionException) {
            if (compilerInteractionException.getOriginalException() != null) {
                Utils.printErrorMessage("Error interacting with the compiler: ");
                Utils.printErrorMessage(compilerInteractionException.getMessage());
                Utils.printErrorMessage("Original exception:");
                Utils.printErrorMessage(compilerInteractionException.getOriginalException().getMessage());
                return -4;
            }
            return -5;
        }
        catch (PublicExceptions.ClassFileParseException classFileParseException) {
            Utils.printErrorMessage(classFileParseException.getMessage());
            return -6;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utils.printErrorMessage(fileNotFoundException.getMessage());
            return -7;
        }
        catch (IOException iOException) {
            Utils.printErrorMessage(iOException.getMessage());
            return -8;
        }
        catch (PublicExceptions.InternalException internalException) {
            Utils.printErrorMessage("Internal javamake exception detected:");
            Utils.printErrorMessage(internalException.getMessage());
            Utils.printErrorMessage("Please report this problem to Mikhail.Dmitriev@sun.com");
            Utils.printErrorMessage("The stack trace is as follows:");
            internalException.printStackTrace();
            return -9;
        }
        catch (PublicExceptions.ClassNameMismatchException classNameMismatchException) {
            Utils.printErrorMessage(classNameMismatchException.getMessage());
            return -10;
        }
        catch (InternalError internalError) {
            Utils.printErrorMessage("Internal Java error: " + internalError);
            Utils.printErrorMessage("Consult the following stack trace for more info:");
            internalError.printStackTrace();
            return -20;
        }
        catch (RuntimeException runtimeException) {
            Utils.printErrorMessage("Internal Java exception: " + runtimeException);
            Utils.printErrorMessage("Consult the following stack trace for more info:");
            runtimeException.printStackTrace();
            return -30;
        }
        return 0;
    }

    public void mainProgrammaticControlled(String[] stringArray, String string, String string2, Object object, Method method) throws PublicExceptions.NoActionRequestedException, PublicExceptions.InvalidCmdOptionException, PublicExceptions.PDBCorruptedException, PublicExceptions.CommandFileReadException, PublicExceptions.CompilerInteractionException, PublicExceptions.ClassFileParseException, PublicExceptions.ClassNameMismatchException, FileNotFoundException, IOException, PublicExceptions.InternalException {
        this.controlledExecution = true;
        this.pdbFileName = string2;
        this.destDir = string;
        this.allProjectJavaFileNames = stringArray;
        this.externalApp = object;
        this.externalCompileSourceFilesMethod = method;
        this.mainProgrammatic(null);
    }

    public int mainExternalControlled(String[] stringArray, String string, String string2, Object object, Method method) {
        this.controlledExecution = true;
        this.pdbFileName = string2;
        this.destDir = string;
        this.allProjectJavaFileNames = stringArray;
        this.externalApp = object;
        this.externalCompileSourceFilesMethod = method;
        return this.mainExternal(null);
    }

    public void mainProgrammaticControlled(String[] stringArray, String[] stringArray2, String[] stringArray3, String string, String string2, Object object, Method method) throws PublicExceptions.NoActionRequestedException, PublicExceptions.InvalidCmdOptionException, PublicExceptions.PDBCorruptedException, PublicExceptions.CommandFileReadException, PublicExceptions.CompilerInteractionException, PublicExceptions.ClassFileParseException, PublicExceptions.ClassNameMismatchException, FileNotFoundException, IOException, PublicExceptions.InternalException {
        this.controlledExecution = true;
        this.pdbFileName = string2;
        this.destDir = string;
        this.addedJavaFileNames = stringArray;
        this.removedJavaFileNames = stringArray2;
        this.updatedJavaFileNames = stringArray3;
        this.externalApp = object;
        this.externalCompileSourceFilesMethod = method;
        this.mainProgrammatic(null);
    }

    public int mainExternalControlled(String[] stringArray, String[] stringArray2, String[] stringArray3, String string, String string2, Object object, Method method) {
        this.controlledExecution = true;
        this.pdbFileName = string2;
        this.destDir = string;
        this.addedJavaFileNames = stringArray;
        this.removedJavaFileNames = stringArray2;
        this.updatedJavaFileNames = stringArray3;
        this.externalApp = object;
        this.externalCompileSourceFilesMethod = method;
        return this.mainExternal(null);
    }

    public static void main(String[] stringArray) {
        Utils.startTiming(0);
        Main main = new Main();
        int n = main.mainExternal(stringArray);
        Utils.stopAndPrintTiming("Total", 0);
        System.exit(n);
    }

    public static void setOutputStreams(PrintStream printStream, PrintStream printStream2, PrintStream printStream3) {
        Utils.setOutputStreams(printStream, printStream2, printStream3);
    }

    public static void customizeOutput(boolean bl, boolean bl2, boolean bl3) {
        Utils.customizeOutput(bl, bl2, bl3);
    }

    public String[] getUpdatedClasses() {
        return this.pcdm.getAllUpdatedClassesAsStringArray();
    }

    public static String getVersion() {
        return VERSION;
    }

    private static void bailOut(String string) {
        throw new PrivateException(new PublicExceptions.InvalidCmdOptionException(string + "\nRun \"javamake -h\" for help."));
    }

    private static void optRequiresArg(String string) {
        Main.bailOut("The " + string + " option requires an argument.");
    }

    private static void printUsage() {
        Utils.printInfoMessage("Usage: javamake [options] [.java files] [@files]");
        Utils.printInfoMessage("");
        Utils.printInfoMessage("where <options> include:");
        Utils.printInfoMessage("  -h, -help      print this help message");
        Utils.printInfoMessage("  -version       print the product version number");
        Utils.printInfoMessage("  -pdb <project database file name>");
        Utils.printInfoMessage("                 specify the file to be used to store project information");
        Utils.printInfoMessage("                 (default is javamake.pdb)");
        Utils.printInfoMessage("  -d <directory> specify the directory to place generated class files");
        Utils.printInfoMessage("  -C<compiler option>");
        Utils.printInfoMessage("                 pass a specified option to the Java compiler used by javamake");
        Utils.printInfoMessage("                 (note this option's arguments should also be preceded by -C)");
        Utils.printInfoMessage("  -jcpath <directory or .jar file>");
        Utils.printInfoMessage("                 specify the class path for the Java compiler used by javamake");
        Utils.printInfoMessage("                 (default is <JAVAHOME>/lib/tools.jar)");
        Utils.printInfoMessage("  -jcmainclass <class name>");
        Utils.printInfoMessage("                 specify the main class for the Java compiler used by javamake");
        Utils.printInfoMessage("                 (default is com.sun.tools.javac.Main)");
        Utils.printInfoMessage("  -jcmetod <method name>");
        Utils.printInfoMessage("                 specify the method to call in the Java compiler class");
        Utils.printInfoMessage("                 (default is \"compile\")");
        Utils.printInfoMessage("  -jcexec <compiler application path>");
        Utils.printInfoMessage("                 specify the executable Java compiler application");
        Utils.printInfoMessage("  -warnlimit <maximum number of warnings>");
        Utils.printInfoMessage("                 specify the maximum number of warnings that javamake can print");
        Utils.printInfoMessage("                 (default value is 20)");
        Utils.printInfoMessage("");
        Utils.printInfoMessage("Examples:");
        Utils.printInfoMessage("  javamake -d classes -Cclasspath -C.;mylib.jar X.java Y.java Z.java");
        Utils.printInfoMessage("  javamake -pdb myproject.pdb -jcexec c:\\java\\jikes\\jikes.exe @myproject.src");
    }
}

