/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javamake;

import com.sun.tools.javamake.BinaryFileReader;
import com.sun.tools.javamake.ClassInfo;
import com.sun.tools.javamake.PCDEntry;
import com.sun.tools.javamake.PrivateException;
import com.sun.tools.javamake.PublicExceptions;
import com.sun.tools.javamake.Utils;
import java.util.Hashtable;

public class ProjectDatabaseReader
extends BinaryFileReader {
    private String[] stringTable;
    private Hashtable pcd;
    private int nOfEntries;

    public Hashtable readProjectDatabase(byte[] byArray, String string) {
        this.initBuf(byArray, string);
        this.readPreamble();
        this.readStringTable();
        this.pcd = new Hashtable(this.nOfEntries * 4 / 3);
        int n = 0;
        while (n < this.nOfEntries) {
            PCDEntry pCDEntry = this.readPCDEntry();
            this.pcd.put(pCDEntry.className, pCDEntry);
            ++n;
        }
        this.stringTable = null;
        return this.pcd;
    }

    private void readPreamble() {
        int n;
        if (this.buf.length < Utils.MAGIC.length + 8) {
            this.pdbCorruptedException("file too short");
        }
        int n2 = 0;
        while (n2 < Utils.MAGIC.length) {
            if (this.buf[n2] != Utils.MAGIC[n2]) {
                this.pdbCorruptedException("wrong project database header");
            }
            ++n2;
        }
        this.curBufPos += Utils.MAGIC.length;
        int n3 = this.nextInt();
        if (n3 != 1) {
            this.pdbCorruptedException("wrong version number");
        }
        if (this.buf.length != Utils.MAGIC.length + 8 + (n = this.nextInt())) {
            this.pdbCorruptedException("file size does not match stored value");
        }
        this.nOfEntries = this.nextInt();
    }

    private void readStringTable() {
        int n = this.nextInt();
        this.stringTable = new String[n];
        int n2 = 0;
        while (n2 < n) {
            this.stringTable[n2] = this.nextString();
            ++n2;
        }
    }

    private PCDEntry readPCDEntry() {
        String string = this.nextStringRef();
        String string2 = this.nextStringRef();
        long l = this.nextLong();
        long l2 = this.nextLong();
        ClassInfo classInfo = this.readClassInfo();
        return new PCDEntry(string, string2, l, l2, classInfo);
    }

    private ClassInfo readClassInfo() {
        Object[] objectArray;
        Object[] objectArray2;
        int n;
        Object[] objectArray3;
        ClassInfo classInfo = new ClassInfo();
        classInfo.name = this.nextStringRef();
        int n2 = this.nextChar();
        if (n2 > 0) {
            objectArray3 = new String[n2];
            n = 0;
            while (n < n2) {
                objectArray3[n] = this.nextStringRef();
                ++n;
            }
            classInfo.cpoolRefsToClasses = objectArray3;
            objectArray2 = new boolean[n2];
            n = 0;
            while (n < n2) {
                objectArray2[n] = this.buf[this.curBufPos++] != 0;
                ++n;
            }
            classInfo.isRefClassArray = objectArray2;
        }
        if ((n2 = this.nextChar()) > 0) {
            objectArray3 = new String[n2];
            n = 0;
            while (n < n2) {
                objectArray3[n] = this.nextStringRef();
                ++n;
            }
            classInfo.cpoolRefsToFieldClasses = objectArray3;
            objectArray2 = new String[n2];
            n = 0;
            while (n < n2) {
                objectArray2[n] = this.nextStringRef();
                ++n;
            }
            classInfo.cpoolRefsToFieldNames = (String[])objectArray2;
            objectArray = new String[n2];
            n = 0;
            while (n < n2) {
                objectArray[n] = this.nextStringRef();
                ++n;
            }
            classInfo.cpoolRefsToFieldSignatures = objectArray;
        }
        if ((n2 = this.nextChar()) > 0) {
            objectArray3 = new String[n2];
            n = 0;
            while (n < n2) {
                objectArray3[n] = this.nextStringRef();
                ++n;
            }
            classInfo.cpoolRefsToMethodClasses = objectArray3;
            objectArray2 = new String[n2];
            n = 0;
            while (n < n2) {
                objectArray2[n] = this.nextStringRef();
                ++n;
            }
            classInfo.cpoolRefsToMethodNames = (String[])objectArray2;
            objectArray = new String[n2];
            n = 0;
            while (n < n2) {
                objectArray[n] = this.nextStringRef();
                ++n;
            }
            classInfo.cpoolRefsToMethodSignatures = objectArray;
        }
        classInfo.accessFlags = this.nextChar();
        classInfo.isNonMemberNestedClass = this.buf[this.curBufPos++] != 0;
        classInfo.superName = this.nextStringRef();
        n2 = this.nextChar();
        if (n2 > 0) {
            objectArray3 = new String[n2];
            n = 0;
            while (n < n2) {
                objectArray3[n] = this.nextStringRef();
                ++n;
            }
            classInfo.interfaces = objectArray3;
        }
        if ((n2 = (int)this.nextChar()) > 0) {
            objectArray3 = new String[n2];
            n = 0;
            while (n < n2) {
                objectArray3[n] = this.nextStringRef();
                ++n;
            }
            classInfo.fieldNames = objectArray3;
            objectArray2 = new String[n2];
            n = 0;
            while (n < n2) {
                objectArray2[n] = this.nextStringRef();
                ++n;
            }
            classInfo.fieldSignatures = (String[])objectArray2;
            objectArray = new char[n2];
            n = 0;
            while (n < n2) {
                objectArray[n] = (String)this.nextChar();
                ++n;
            }
            classInfo.fieldAccessFlags = (char[])objectArray;
        }
        if ((n2 = (int)this.nextChar()) > 0) {
            objectArray3 = new Object[n2];
            n = 0;
            while (n < n2) {
                byte by = this.buf[this.curBufPos++];
                switch (by) {
                    case 1: {
                        objectArray3[n] = this.nextStringRef();
                        break;
                    }
                    case 2: {
                        objectArray3[n] = new Integer(this.nextInt());
                        break;
                    }
                    case 3: {
                        objectArray3[n] = new Long(this.nextLong());
                        break;
                    }
                    case 4: {
                        objectArray3[n] = new Float(this.nextFloat());
                        break;
                    }
                    case 5: {
                        objectArray3[n] = new Double(this.nextDouble());
                        break;
                    }
                }
                ++n;
            }
            classInfo.primitiveConstantInitValues = objectArray3;
        }
        if ((n2 = (int)this.nextChar()) > 0) {
            objectArray3 = new String[n2];
            n = 0;
            while (n < n2) {
                objectArray3[n] = this.nextStringRef();
                ++n;
            }
            classInfo.methodNames = objectArray3;
            String[] stringArray = new String[n2];
            n = 0;
            while (n < n2) {
                stringArray[n] = this.nextStringRef();
                ++n;
            }
            classInfo.methodSignatures = stringArray;
            objectArray = new char[n2];
            n = 0;
            while (n < n2) {
                objectArray[n] = (String)this.nextChar();
                ++n;
            }
            classInfo.methodAccessFlags = (char[])objectArray;
        }
        if ((n2 = (int)this.nextChar()) > 0) {
            objectArray3 = new String[n2][];
            n = 0;
            while (n < n2) {
                int n3 = this.nextChar();
                if (n3 > 0) {
                    objectArray3[n] = new String[n3];
                    int n4 = 0;
                    while (n4 < n3) {
                        objectArray3[n][n4] = this.nextStringRef();
                        ++n4;
                    }
                }
                ++n;
            }
            classInfo.checkedExceptions = objectArray3;
        }
        if ((n2 = (int)this.nextChar()) > 0) {
            objectArray3 = new String[n2];
            n = 0;
            while (n < n2) {
                objectArray3[n] = this.nextStringRef();
                ++n;
            }
            classInfo.nestedClasses = objectArray3;
        }
        classInfo.initializeImmediateTransientFields();
        return classInfo;
    }

    private String nextString() {
        char c = this.nextChar();
        if (this.buf.length < this.curBufPos + c) {
            this.pdbCorruptedException("data error");
        }
        String string = new String(this.buf, this.curBufPos, (int)c).intern();
        this.curBufPos += c;
        return string;
    }

    private String nextStringRef() {
        return this.stringTable[this.nextInt()];
    }

    private void pdbCorruptedException(String string) {
        throw new PrivateException(new PublicExceptions.PDBCorruptedException(string));
    }
}

