/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javamake;

import com.sun.tools.javamake.PrivateException;
import com.sun.tools.javamake.PublicExceptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class Utils {
    static final String REPORT_PROBLEM = "Please report this problem to Mikhail.Dmitriev@sun.com";
    static final byte[] MAGIC = new byte[]{74, 97, 118, 97, 109, 97, 107, 101, 32, 80, 114, 111, 106, 101, 99, 116, 32, 68, 97, 116, 97, 98, 97, 115, 101, 32, 70, 105, 108, 101};
    static int warningLimit = 20;
    static final int TIMING_TOTAL = 0;
    static final int TIMING_PDBREAD = 1;
    static final int TIMING_SYNCHRO = 2;
    static final int TIMING_SYNCHRO_CHECK_JAVA_FILES = 3;
    static final int TIMING_FIND_UPDATED_JAVA_FILES = 4;
    static final int TIMING_CLASS_FILE_OBSOLETE_OR_DELETED = 5;
    static final int TIMING_COMPILE = 6;
    static final int TIMING_FIND_UPDATED_CLASSES = 7;
    static final int TIMING_CHECK_UPDATED_CLASSES = 8;
    static final int TIMING_PDBWRITE = 9;
    static final int TIMING_SYNCHRO_CHECK_TMP = 10;
    static final int TIMING_CLASS_FILE_OBSOLETE_TMP = 11;
    static final int TIMING_PDBUPDATE = 12;
    static final int TIMING_ARRAY_LENGTH = 13;
    private static long[] timings = new long[13];
    private static boolean timingOn = false;
    private static PrintStream out = System.out;
    private static PrintStream warn = System.out;
    private static PrintStream err = System.err;
    private static boolean printInfoMessages = true;
    private static boolean printWarningMessages = true;
    private static boolean printErrorMessages = true;
    private static int warningNo;

    public static String getPackageName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n).intern();
    }

    public static String getDirectlyEnclosingClass(String string) {
        int n = string.lastIndexOf(36);
        if (n == -1) {
            return "";
        }
        int n2 = string.lastIndexOf(36, n - 1);
        if (n2 == -1 || !Character.isDigit(string.charAt(n2 + 1))) {
            return string.substring(0, n).intern();
        }
        return string.substring(0, n2).intern();
    }

    public static String getTopLevelEnclosingClass(String string) {
        int n = string.indexOf(36);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n).intern();
    }

    public static String getClassFileFullPathForNestedClass(String string, String string2) {
        String string3 = string;
        int n = string3.lastIndexOf(File.separatorChar);
        string3 = string3.substring(0, n + 1);
        n = string2.lastIndexOf(47);
        String string4 = n < 0 ? string2 : string2.substring(n + 1);
        return string3 + string4 + ".class";
    }

    public static File checkFileForName(String string) {
        File file = new File(string);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static File checkOrCreateDirForName(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new PrivateException(new PublicExceptions.InternalException(file + " is not a directory."));
            }
            return file;
        }
        return null;
    }

    public static void readAndPrintBytesFromStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = inputStream.available();
        if (n > 0) {
            byte[] byArray = new byte[n];
            int n2 = inputStream.read(byArray);
            outputStream.write(byArray, 0, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delay(int n) {
        Object object;
        Object object2 = object = new Object();
        synchronized (object2) {
            try {
                object.wait(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void setOutputStreams(PrintStream printStream, PrintStream printStream2, PrintStream printStream3) {
        out = printStream;
        warn = printStream2;
        err = printStream3;
    }

    public static void customizeOutput(boolean bl, boolean bl2, boolean bl3) {
        printInfoMessages = bl;
        printWarningMessages = bl2;
        printErrorMessages = bl3;
    }

    public static void printInfoMessage(String string) {
        if (printInfoMessages) {
            out.println(string);
        }
    }

    public static void printInfoMessageNoEOL(String string) {
        if (printInfoMessages) {
            out.print(string);
        }
    }

    public static void printWarningMessage(String string) {
        if (!printWarningMessages) {
            return;
        }
        if (warningNo < warningLimit) {
            warn.println(string);
        } else if (warningNo == warningLimit) {
            warn.println("More than " + warningLimit + " warnings.");
        }
        ++warningNo;
    }

    public static void printErrorMessage(String string) {
        if (printErrorMessages) {
            err.println(string);
        }
    }

    public static void setTimingOn() {
        timingOn = true;
    }

    public static void startTiming(int n) {
        Utils.timings[n] = System.currentTimeMillis();
    }

    public static void stopAndPrintTiming(String string, int n) {
        if (timingOn) {
            long l = System.currentTimeMillis() - timings[n];
            Utils.printInfoMessage("========== " + string + " time = " + l);
        }
    }

    public static void printTiming(String string, int n) {
        if (timingOn) {
            Utils.printInfoMessage("========== " + string + " time = " + timings[n]);
        }
    }

    public static void stopAndAddTiming(int n, int n2) {
        if (timingOn) {
            long l = System.currentTimeMillis() - timings[n];
            int n3 = n2;
            timings[n3] = timings[n3] + l;
        }
    }
}

