/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.input;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.input.InputRequest;
import org.apache.tools.ant.input.MultipleChoiceInputRequest;

public class DefaultInputHandler
implements InputHandler {
    public void handleInput(InputRequest request) throws BuildException {
        String prompt = this.getPrompt(request);
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getInputStream()));
        do {
            System.err.println(prompt);
            try {
                String input = in.readLine();
                request.setInput(input);
            }
            catch (IOException e) {
                throw new BuildException("Failed to read input from Console.", e);
            }
        } while (!request.isInputValid());
    }

    protected String getPrompt(InputRequest request) {
        String prompt = request.getPrompt();
        if (request instanceof MultipleChoiceInputRequest) {
            StringBuffer sb = new StringBuffer(prompt);
            sb.append("(");
            Enumeration enumeration = ((MultipleChoiceInputRequest)request).getChoices().elements();
            boolean first = true;
            while (enumeration.hasMoreElements()) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(enumeration.nextElement());
                first = false;
            }
            sb.append(")");
            prompt = sb.toString();
        }
        return prompt;
    }

    protected InputStream getInputStream() {
        return System.in;
    }
}

