/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.starteam;

import com.starbase.starteam.Server;
import com.starbase.starteam.StarTeamFinder;
import com.starbase.starteam.User;
import com.starbase.starteam.View;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class StarTeamTask
extends Task {
    private String userName;
    private String password;
    private String servername;
    private String serverport;
    private String projectname;
    private String viewname;
    private Server server = null;

    public void setServername(String servername) {
        this.servername = servername;
    }

    public String getServername() {
        return this.servername;
    }

    public void setServerport(String serverport) {
        this.serverport = serverport;
    }

    public String getServerport() {
        return this.serverport;
    }

    public void setProjectname(String projectname) {
        this.projectname = projectname;
    }

    public String getProjectname() {
        return this.projectname;
    }

    public void setViewname(String viewname) {
        this.viewname = viewname;
    }

    public String getViewname() {
        return this.viewname;
    }

    public void setURL(String url) {
        String unpw;
        int pos;
        StringTokenizer t = new StringTokenizer(url, "/");
        if (t.hasMoreTokens() && (pos = (unpw = t.nextToken()).indexOf(":")) > 0) {
            this.servername = unpw.substring(0, pos);
            this.serverport = unpw.substring(pos + 1);
            if (t.hasMoreTokens()) {
                this.projectname = t.nextToken();
                if (t.hasMoreTokens()) {
                    this.viewname = t.nextToken();
                }
            }
        }
    }

    public String getURL() {
        return this.servername + ":" + this.serverport + "/" + this.projectname + "/" + (null == this.viewname ? "" : this.viewname);
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    protected Server getServer() {
        return this.server;
    }

    protected abstract View createSnapshotView(View var1);

    protected View openView() throws BuildException {
        View view = StarTeamFinder.openView((String)(this.getUserName() + ":" + this.getPassword() + "@" + this.getURL()));
        if (null == view) {
            throw new BuildException("Cannot find view" + this.getURL() + " in repository()");
        }
        View snapshot = this.createSnapshotView(view);
        this.server = snapshot.getServer();
        return snapshot;
    }

    protected String getUserName(int userID) {
        User u = this.server.getUser(userID);
        if (null == u) {
            return "";
        }
        return u.getName();
    }
}

