/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.vss;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.optional.vss.MSVSS;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class MSVSSCHECKIN
extends MSVSS {
    private String m_LocalPath = null;
    private boolean m_Recursive = false;
    private boolean m_Writable = false;
    private String m_AutoResponse = null;
    private String m_Comment = "-";

    public void execute() throws BuildException {
        Commandline commandLine = new Commandline();
        int result = 0;
        if (this.getVsspath() == null) {
            String msg = "vsspath attribute must be set!";
            throw new BuildException(msg, this.location);
        }
        commandLine.setExecutable(this.getSSCommand());
        commandLine.createArgument().setValue("Checkin");
        commandLine.createArgument().setValue(this.getVsspath());
        this.getLocalpathCommand(commandLine);
        this.getAutoresponse(commandLine);
        this.getRecursiveCommand(commandLine);
        this.getWritableCommand(commandLine);
        this.getLoginCommand(commandLine);
        commandLine.createArgument().setValue("-C" + this.getComment());
        result = this.run(commandLine);
        if (result != 0) {
            String msg = "Failed executing: " + commandLine.toString();
            throw new BuildException(msg, this.location);
        }
    }

    public void setLocalpath(Path localPath) {
        this.m_LocalPath = localPath.toString();
    }

    public void getLocalpathCommand(Commandline cmd) {
        if (this.m_LocalPath == null) {
            return;
        }
        File dir = ((ProjectComponent)this).project.resolveFile(this.m_LocalPath);
        if (!dir.exists()) {
            boolean done = dir.mkdirs();
            if (!done) {
                String msg = "Directory " + this.m_LocalPath + " creation was not " + "succesful for an unknown reason";
                throw new BuildException(msg, this.location);
            }
            ((ProjectComponent)this).project.log("Created dir: " + dir.getAbsolutePath());
        }
        cmd.createArgument().setValue("-GL" + this.m_LocalPath);
    }

    public void setRecursive(boolean recursive) {
        this.m_Recursive = recursive;
    }

    public void getRecursiveCommand(Commandline cmd) {
        if (!this.m_Recursive) {
            return;
        }
        cmd.createArgument().setValue("-R");
    }

    public final void setWritable(boolean argWritable) {
        this.m_Writable = argWritable;
    }

    public void getWritableCommand(Commandline cmd) {
        if (!this.m_Writable) {
            return;
        }
        cmd.createArgument().setValue("-W");
    }

    public void setAutoresponse(String response) {
        this.m_AutoResponse = response.equals("") || response.equals("null") ? null : response;
    }

    public void getAutoresponse(Commandline cmd) {
        if (this.m_AutoResponse == null) {
            cmd.createArgument().setValue("-I-");
        } else if (this.m_AutoResponse.equalsIgnoreCase("Y")) {
            cmd.createArgument().setValue("-I-Y");
        } else if (this.m_AutoResponse.equalsIgnoreCase("N")) {
            cmd.createArgument().setValue("-I-N");
        } else {
            cmd.createArgument().setValue("-I-");
        }
    }

    public void setComment(String comment) {
        this.m_Comment = comment.equals("") || comment.equals("null") ? "-" : comment;
    }

    public String getComment() {
        return this.m_Comment;
    }
}

