/*
 * Decompiled with CFR 0.152.
 */
package com.sun.resolver.tools;

import com.sun.resolver.Catalog;
import com.sun.resolver.helpers.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class CatalogResolver
implements EntityResolver {
    public boolean namespaceAware = true;
    public boolean validating = false;
    private static Catalog staticCatalog = null;
    private Catalog catalog = null;

    public CatalogResolver() {
        this.initializeCatalogs(false, true);
    }

    public CatalogResolver(boolean pref) {
        this.initializeCatalogs(false, pref);
    }

    private void initializeCatalogs(boolean privateCatalog, boolean pref) {
        if (this.catalog == null) {
            try {
                this.catalog = new Catalog(pref);
                this.catalog.setupReaders();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public String getResolvedEntity(String publicId, String systemId) {
        String resolved = null;
        if (this.catalog == null) {
            Debug.message(1, "Catalog resolution attempted with null catalog; ignored");
            return null;
        }
        if (systemId != null) {
            try {
                resolved = this.catalog.resolveSystem(systemId);
            }
            catch (MalformedURLException me) {
                Debug.message(1, "Malformed URL exception trying to resolve", publicId);
                resolved = null;
            }
            catch (IOException ie) {
                Debug.message(1, "I/O exception trying to resolve", publicId);
                resolved = null;
            }
        }
        if (resolved == null) {
            if (publicId != null) {
                try {
                    resolved = this.catalog.resolvePublic(publicId, systemId);
                }
                catch (MalformedURLException me) {
                    Debug.message(1, "Malformed URL exception trying to resolve", publicId);
                }
                catch (IOException ie) {
                    Debug.message(1, "I/O exception trying to resolve", publicId);
                }
            }
            if (resolved != null) {
                Debug.message(2, "Resolved public", publicId, resolved);
            }
        } else {
            Debug.message(2, "Resolved system", systemId, resolved);
        }
        return resolved;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        String resolved = this.getResolvedEntity(publicId, systemId);
        if (resolved != null) {
            try {
                InputSource iSource = new InputSource(resolved);
                iSource.setPublicId(publicId);
                URL url = new URL(resolved);
                InputStream iStream = url.openStream();
                iSource.setByteStream(iStream);
                return iSource;
            }
            catch (Exception e) {
                Debug.message(1, "Failed to create InputSource", resolved);
                return null;
            }
        }
        return null;
    }
}

