/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DDLException;
import org.openide.util.NbBundle;

public class DatabaseConnection
implements DBConnection {
    static final ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
    static final long serialVersionUID = 4554639187416958735L;
    private String drv;
    private String drvname;
    private String db;
    private String usr;
    private String schema;
    private String pwd = "";
    private Boolean rpwd = Boolean.FALSE;
    private PropertyChangeSupport propertySupport;
    private String name;
    private static final String SUPPORT = "_schema_support";
    public static final String PROP_DRIVER = "driver";
    public static final String PROP_DATABASE = "database";
    public static final String PROP_USER = "user";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_SCHEMA = "schema";
    public static final String PROP_DRIVERNAME = "drivername";
    public static final String PROP_NAME = "name";

    public DatabaseConnection() {
        this.propertySupport = new PropertyChangeSupport(this);
    }

    public DatabaseConnection(String driver, String database, String user, String password) {
        this.drv = driver;
        this.db = database;
        this.usr = user;
        this.pwd = password;
        this.name = null;
        this.name = this.getName();
    }

    public String getDriver() {
        return this.drv;
    }

    public void setDriver(String driver) {
        if (driver == null || driver.equals(this.drv)) {
            return;
        }
        String olddrv = this.drv;
        this.drv = driver;
        this.propertySupport.firePropertyChange(PROP_DRIVER, olddrv, this.drv);
    }

    public String getDriverName() {
        return this.drvname;
    }

    public void setDriverName(String name) {
        if (name == null || name.equals(this.drvname)) {
            return;
        }
        String olddrv = this.drvname;
        this.drvname = name;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_DRIVERNAME, olddrv, this.drvname);
        }
    }

    public String getDatabase() {
        if (this.db == null) {
            this.db = new String();
        }
        return this.db;
    }

    public void setDatabase(String database) {
        if (database == null || database.equals(this.db)) {
            return;
        }
        String olddb = this.db;
        this.db = database;
        this.name = null;
        this.name = this.getName();
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_DATABASE, olddb, this.db);
        }
    }

    public String getUser() {
        if (this.usr == null) {
            this.usr = new String();
        }
        return this.usr;
    }

    public void setUser(String user) {
        if (user == null || user.equals(this.usr)) {
            return;
        }
        String oldusr = this.usr;
        this.usr = user;
        this.name = null;
        this.name = this.getName();
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_USER, oldusr, this.usr);
        }
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getSchema() == null || this.getSchema().length() == 0 ? MessageFormat.format(bundle.getString("ConnectionNodeUniqueName"), this.getDatabase(), this.getUser(), bundle.getString("SchemaIsNotSet")) : MessageFormat.format(bundle.getString("ConnectionNodeUniqueName"), this.getDatabase(), this.getUser(), this.getSchema());
        }
        return this.name;
    }

    public void setName(String value) {
        if (this.name == null || this.name.equals(value)) {
            return;
        }
        String old = this.name;
        this.name = value;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_NAME, old, this.name);
        }
    }

    public String getSchema() {
        if (this.schema == null) {
            this.schema = new String();
        }
        return this.schema;
    }

    public void setSchema(String schema_name) {
        if (schema_name == null || schema_name.equals(this.schema)) {
            return;
        }
        String oldschema = this.schema;
        this.schema = schema_name;
        this.name = null;
        this.name = this.getName();
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_SCHEMA, oldschema, this.schema);
        }
    }

    public boolean rememberPassword() {
        return this.rpwd.equals(Boolean.TRUE);
    }

    public void setRememberPassword(boolean flag) {
        this.rpwd = flag ? Boolean.TRUE : Boolean.FALSE;
    }

    public String getPassword() {
        return this.pwd;
    }

    public void setPassword(String password) {
        if (password == null || password.equals(this.pwd)) {
            return;
        }
        String oldpwd = this.pwd;
        this.pwd = password;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_PASSWORD, oldpwd, this.pwd);
        }
    }

    public Connection createJDBCConnection() throws DDLException {
        if (this.drv == null || this.db == null || this.usr == null || this.pwd == null) {
            throw new DDLException(bundle.getString("EXC_InsufficientConnInfo"));
        }
        Properties dbprops = new Properties();
        ((Hashtable)dbprops).put(PROP_USER, this.usr);
        ((Hashtable)dbprops).put(PROP_PASSWORD, this.pwd);
        try {
            Class.forName(this.drv);
            Connection connection = DriverManager.getConnection(this.db, dbprops);
            return connection;
        }
        catch (SQLException e) {
            String message = MessageFormat.format(bundle.getString("EXC_CannotEstablishConnection"), this.db, this.drv, e.getMessage());
            if (this.drv.equals("com.pointbase.jdbc.jdbcUniversalDriver") && e.getErrorCode() == 86024) {
                message = MessageFormat.format(bundle.getString("EXC_PointbaseServerRejected"), message, this.db);
            }
            throw new DDLException(message);
        }
        catch (Exception exc) {
            String message = MessageFormat.format(bundle.getString("EXC_CannotEstablishConnection"), this.db, this.drv, exc.getMessage());
            throw new DDLException(message);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.removePropertyChangeListener(l);
    }

    public int hashCode() {
        return this.drv.hashCode() + this.db.hashCode() + this.usr.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DBConnection) {
            DBConnection con = (DBConnection)obj;
            return this.toString().equals(con.toString());
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.drv = (String)in.readObject();
        this.db = (String)in.readObject();
        this.usr = (String)in.readObject();
        this.schema = (String)in.readObject();
        this.rpwd = Boolean.FALSE;
        this.name = (String)in.readObject();
        if (this.name == null || !this.name.equals(SUPPORT)) {
            this.schema = null;
        }
        this.name = null;
        this.name = this.getName();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.drv);
        out.writeObject(this.db);
        out.writeObject(this.usr);
        out.writeObject(this.schema);
        out.writeObject(SUPPORT);
    }

    public String toString() {
        return "Driver:" + this.drv + "Database:" + this.db.toLowerCase() + "User:" + this.usr.toLowerCase() + "Schema:" + this.schema.toLowerCase();
    }
}

