/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.PointbasePlus;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.nodes.DatabaseNode;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class DatabaseNodeChildren
extends Children.Array {
    protected Collection initCollection() {
        DatabaseNodeInfo nodeinfo = ((DatabaseNode)this.getNode()).getInfo();
        Map nodeord = (Map)nodeinfo.get("children_ordering");
        boolean sort = !nodeinfo.getName().equals("Drivers");
        TreeSet<Node> children = new TreeSet<Node>(new NodeComparator(nodeord, sort));
        try {
            Vector chlist = nodeinfo.getChildren();
            int i = 0;
            while (i < chlist.size()) {
                Object snode = null;
                Object sinfo = chlist.elementAt(i);
                if (sinfo instanceof DatabaseNodeInfo) {
                    DatabaseNodeInfo dni = (DatabaseNodeInfo)sinfo;
                    snode = this.createNode(dni);
                } else if (sinfo instanceof Node) {
                    snode = (Node)sinfo;
                }
                if (snode != null) {
                    children.add((Node)snode);
                }
                ++i;
            }
            if (this.getNode() instanceof RootNode) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            PointbasePlus.addOrConnectAccordingToOption();
                        }
                        catch (Exception ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            children.clear();
        }
        return children;
    }

    public DatabaseNode createNode(DatabaseNodeInfo info) {
        String ncode = (String)info.get("code");
        String nclass = (String)info.get("class");
        DatabaseNode node = null;
        try {
            node = (DatabaseNode)((Object)Class.forName(nclass).newInstance());
            node.setInfo(info);
            node.getInfo().setNode(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return node;
    }

    public DatabaseNode createSubnode(DatabaseNodeInfo info, boolean addToChildrenFlag) throws DatabaseException {
        DatabaseNode subnode = this.createNode(info);
        if (subnode != null && addToChildrenFlag) {
            DatabaseNodeInfo ninfo = ((DatabaseNode)this.getNode()).getInfo();
            ninfo.getChildren().add(info);
            this.getNodes();
            if (this.isInitialized()) {
                this.add(new Node[]{subnode});
            }
        }
        return subnode;
    }

    private void createPointbaseConnection() {
        try {
            Class<?> settings = Class.forName("com.sun.forte4j.pointbase.PointBaseSettings", false, ((Object)((Object)this)).getClass().getClassLoader());
            Class<?> restore = Class.forName("com.sun.forte4j.pointbase.util.CreatorConnection", false, ((Object)((Object)this)).getClass().getClassLoader());
            Method addOrConnectMethod = restore.getMethod("addOrConnectPointbase", null);
            addOrConnectMethod.invoke(restore.newInstance(), null);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InstantiationException e) {
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    class NodeComparator
    implements Comparator {
        private Map map = null;
        private boolean sort;

        public NodeComparator(Map map, boolean sort) {
            this.map = map;
            this.sort = sort;
        }

        public int compare(Object o1, Object o2) {
            Integer o2i;
            int o2val;
            if (!this.sort) {
                return 1;
            }
            if (!(o1 instanceof DatabaseNode)) {
                return -1;
            }
            if (!(o2 instanceof DatabaseNode)) {
                return 1;
            }
            Integer o1i = (Integer)this.map.get(o1.getClass().getName());
            int o1val = o1i != null ? o1i : Integer.MAX_VALUE;
            int diff = o1val - (o2val = (o2i = (Integer)this.map.get(o2.getClass().getName())) != null ? o2i : Integer.MAX_VALUE);
            if (diff == 0) {
                return ((DatabaseNode)((Object)o1)).getInfo().getName().compareTo(((DatabaseNode)((Object)o2)).getInfo().getName());
            }
            return diff;
        }
    }
}

