/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import org.netbeans.modules.db.explorer.DatabaseDriver;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.nodes.ConnectionNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;

public class DatabaseOption
extends SystemOption {
    static final ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
    private static boolean debugMode;
    private static Vector drivers;
    private static Vector connections;
    private static int fetchlimit;
    private static int fetchstep;
    private static boolean autoConn;
    public static final String PROP_DEBUG_MODE = "debugMode";
    public static final String PROP_FETCH_LIMIT = "fetchLimit";
    public static final String PROP_FETCH_STEP = "fetchStep";
    public static final String PROP_AUTO_CONNECTION = "autoConn";
    static final long serialVersionUID = -13629330831657810L;

    public DatabaseOption() {
        drivers = new Vector();
        connections = new Vector();
        debugMode = false;
    }

    public Vector getAvailableDrivers() {
        if (drivers.size() == 0) {
            Map xxx = (Map)DatabaseNodeInfo.getGlobalNodeInfo("driverlist");
            drivers = this.createDrivers(xxx);
        }
        return drivers;
    }

    public boolean getDebugMode() {
        return debugMode;
    }

    public void setDebugMode(boolean flag) {
        if (debugMode == flag) {
            return;
        }
        debugMode = flag;
        this.firePropertyChange(PROP_DEBUG_MODE, !debugMode ? Boolean.TRUE : Boolean.FALSE, debugMode ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setAvailableDrivers(Vector c) {
        drivers = c;
    }

    public Vector getConnections() {
        if (connections == null) {
            connections = new Vector();
        }
        return connections;
    }

    public void setConnections(Vector c) {
        connections = c;
    }

    public int getFetchLimit() {
        return fetchlimit;
    }

    public void setFetchLimit(int limit) {
        int old = fetchlimit;
        if (old == limit) {
            return;
        }
        fetchlimit = limit;
        this.firePropertyChange(PROP_FETCH_LIMIT, new Integer(old), new Integer(limit));
    }

    public int getFetchStep() {
        return fetchstep;
    }

    public void setFetchStep(int limit) {
        int old = fetchstep;
        if (old == limit) {
            return;
        }
        fetchstep = limit;
        this.firePropertyChange(PROP_FETCH_STEP, new Integer(old), new Integer(limit));
    }

    public boolean isAutoConn() {
        return autoConn;
    }

    public void setAutoConn(boolean newAutoConn) {
        boolean old = autoConn;
        if (old == newAutoConn) {
            return;
        }
        autoConn = newAutoConn;
        this.firePropertyChange(PROP_AUTO_CONNECTION, !autoConn ? Boolean.TRUE : Boolean.FALSE, autoConn ? Boolean.TRUE : Boolean.FALSE);
    }

    public void save() {
        this.firePropertyChange(null, null, null);
    }

    public String displayName() {
        return bundle.getString("OptionName");
    }

    public String toString() {
        return drivers.size() + " drivers, " + connections.size() + " connections";
    }

    private void closeConnections() {
        try {
            DataFolder df;
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("UI/Runtime");
            try {
                df = (DataFolder)DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException exc) {
                return;
            }
            Node[] n = df.getNodeDelegate().getChildren().findChild("Databases").getChildren().getNodes();
            int i = 0;
            while (i < n.length) {
                if (n[i] instanceof ConnectionNode) {
                    ((ConnectionNodeInfo)((ConnectionNode)n[i]).getInfo()).disconnect();
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.getAvailableDrivers());
        out.writeObject(this.getConnections());
        out.writeInt(fetchlimit);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        drivers = (Vector)in.readObject();
        drivers = this.checkDrivers(drivers);
        connections = (Vector)in.readObject();
        fetchlimit = in.readInt();
    }

    private Vector checkDrivers(Vector old) {
        Map xxx = (Map)DatabaseNodeInfo.readInfo().get("driverlist");
        Vector plistDrv = this.createDrivers(xxx);
        int i = 0;
        while (i < plistDrv.size()) {
            if (!old.contains(plistDrv.get(i))) {
                old.add(plistDrv.get(i));
            }
            ++i;
        }
        return old;
    }

    private Vector createDrivers(Map drvMap) {
        Vector def = (Vector)drvMap.get("defaultdriverlist");
        Vector rvec = null;
        if (def != null && def.size() > 0) {
            rvec = new Vector(def.size());
            Enumeration defe = def.elements();
            while (defe.hasMoreElements()) {
                String adaptor;
                String prefix;
                String drv;
                Object rit = defe.nextElement();
                String name = (String)((Map)rit).get("name");
                if ((rit = new DatabaseDriver(name, drv = (String)((Map)rit).get("driver"), prefix = (String)((Map)rit).get("prefix"), adaptor = (String)((Map)rit).get("adaptor"))) == null) continue;
                rvec.add(rit);
            }
        } else {
            rvec = new Vector();
        }
        return rvec;
    }

    static {
        fetchlimit = 100;
        fetchstep = 200;
        autoConn = true;
    }
}

