/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.PointbasePlus;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.ConnectPanel;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public class ConnectAction
extends DatabaseAction {
    static final long serialVersionUID = -6822218300035053411L;
    ConnectionDialog dlg = null;
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo;

    protected boolean enable(Node[] activatedNodes) {
        DatabaseNodeInfo nfo;
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        Node node = activatedNodes[0];
        DatabaseNodeInfo info = (DatabaseNodeInfo)node.getCookie(class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo == null ? (class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo = ConnectAction.class$("org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo")) : class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo);
        if (info != null && (nfo = info.getParent("connection")) != null) {
            return nfo.getConnection() == null;
        }
        return false;
    }

    protected int mode() {
        return 4;
    }

    public void performAction(Node[] activatedNodes) {
        boolean remember;
        if (activatedNodes == null || activatedNodes.length <= 0) {
            return;
        }
        Node node = activatedNodes[0];
        DatabaseNodeInfo info = (DatabaseNodeInfo)node.getCookie(class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo == null ? (class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo = ConnectAction.class$("org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo")) : class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo);
        final ConnectionNodeInfo nfo = (ConnectionNodeInfo)info.getParent("connection");
        Connection connection = nfo.getConnection();
        if (connection != null) {
            return;
        }
        String user = nfo.getUser();
        String pwd = nfo.getPassword();
        Boolean rpwd = (Boolean)nfo.get("rememberpwd");
        boolean bl = remember = rpwd != null ? rpwd : false;
        if (user == null || pwd == null || !remember) {
            try {
                PointbasePlus.addOrConnectAccordingToOption();
                user = nfo.getUser();
                pwd = nfo.getPassword();
                rpwd = (Boolean)nfo.get("rememberpwd");
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        if (user == null || pwd == null || !remember) {
            final ConnectPanel basePanel = new ConnectPanel(user);
            final SchemaPanel schemaPanel = new SchemaPanel(new Vector(), user);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (event.getSource() == NotifyDescriptor.OK_OPTION) {
                        ConnectAction.this.dlg.setException(null);
                        String oldUser = nfo.getUser();
                        String oldSchema = nfo.getSchema();
                        nfo.setUser(basePanel.getUser());
                        nfo.setPassword(basePanel.getPassword());
                        if (basePanel.rememberPassword()) {
                            nfo.put("rememberpwd", Boolean.TRUE);
                        }
                        try {
                            if (schemaPanel.getSchema() == null) {
                                ConnectAction.this.dlg.setSelectedComponent(schemaPanel);
                            }
                            if (ConnectAction.this.dlg.isException()) {
                                return;
                            }
                            nfo.setSchema(schemaPanel.getSchema());
                            nfo.connect();
                            if (ConnectAction.this.dlg != null) {
                                ConnectAction.this.dlg.close();
                            }
                        }
                        catch (Exception exc) {
                            nfo.setUser(oldUser);
                            nfo.setSchema(oldSchema);
                            String message = MessageFormat.format(DatabaseAction.bundle.getString("ERR_UnableToConnect"), exc.getMessage());
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                        }
                    }
                }
            };
            ChangeListener changeTabListener = new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    block10: {
                        if (((JTabbedPane)e.getSource()).getSelectedComponent().equals(schemaPanel)) {
                            nfo.setUser(basePanel.getUser());
                            nfo.setPassword(basePanel.getPassword());
                            DBConnection con = nfo.getDatabaseConnection();
                            try {
                                Connection connection2 = con.createJDBCConnection();
                                if (connection2 == null) break block10;
                                Vector<String> items = new Vector<String>();
                                try {
                                    ResultSet rs = connection2.getMetaData().getSchemas();
                                    while (rs.next()) {
                                        items.add(rs.getString(1).trim());
                                    }
                                    rs.close();
                                }
                                catch (SQLException exc) {
                                    // empty catch block
                                }
                                connection2.close();
                                schemaPanel.setSchemas(items, nfo.getSchema());
                            }
                            catch (SQLException exc) {
                                String message = MessageFormat.format(DatabaseAction.bundle.getString("ERR_UnableObtainSchemas"), exc.getMessage());
                                if (con.getDriver().equals("com.pointbase.jdbc.jdbcUniversalDriver") && exc.getErrorCode() == 86024) {
                                    message = MessageFormat.format(DatabaseAction.bundle.getString("EXC_PointbaseServerRejected"), message, con.getDatabase());
                                }
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                                ConnectAction.this.dlg.setSelectedComponent(basePanel);
                                ConnectAction.this.dlg.setException(new DatabaseException("Unable to obtain schema. " + exc.getMessage()));
                            }
                            catch (Exception exc) {
                                String message = MessageFormat.format(DatabaseAction.bundle.getString("ERR_UnableObtainSchemas"), exc.getMessage());
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                                ConnectAction.this.dlg.setSelectedComponent(basePanel);
                                ConnectAction.this.dlg.setException(new DatabaseException("Unable to obtain schema. " + exc.getMessage()));
                            }
                        } else if (schemaPanel.getSchema() != null) {
                            nfo.setSchema(schemaPanel.getSchema());
                        }
                    }
                }
            };
            this.dlg = new ConnectionDialog(basePanel, schemaPanel, basePanel.getTitle(), actionListener, changeTabListener);
            this.dlg.setVisible(true);
        } else {
            try {
                nfo.connect();
            }
            catch (Exception exc) {
                String message = MessageFormat.format(DatabaseAction.bundle.getString("ERR_UnableToConnect"), exc.getMessage());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

