/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Set;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.actions.ConnectAction;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.ConnectAsPanel;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public class ConnectAsAction
extends ConnectAction {
    static final long serialVersionUID = -4698745426544151857L;
    ConnectionDialog dlg = null;
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo;

    public void performAction(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length <= 0) {
            return;
        }
        Node node = activatedNodes[0];
        DatabaseNodeInfo info = (DatabaseNodeInfo)node.getCookie(class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo == null ? (class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo = ConnectAsAction.class$("org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo")) : class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo);
        final ConnectionNodeInfo nfo = (ConnectionNodeInfo)info.getParent("connection");
        Connection connection = nfo.getConnection();
        if (connection != null) {
            return;
        }
        Object dbsys = null;
        String drvurl = (String)nfo.get("driver");
        String dburl = (String)nfo.get("db");
        String user = nfo.getUser();
        String pwd = nfo.getPassword();
        Set sdbs = (Set)nfo.get("suppdbs");
        String productName = (String)nfo.get("dbproduct");
        final ConnectAsPanel basePanel = new ConnectAsPanel(user, sdbs.toArray(new String[0]), productName);
        final SchemaPanel schemaPanel = new SchemaPanel(new Vector(), user);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (event.getSource() == NotifyDescriptor.OK_OPTION) {
                    ConnectAsAction.this.dlg.setException(null);
                    String oldUser = nfo.getUser();
                    String oldSchema = nfo.getSchema();
                    nfo.setUser(basePanel.getUser());
                    nfo.setPassword(basePanel.getPassword());
                    try {
                        if (schemaPanel.getSchema() == null) {
                            ConnectAsAction.this.dlg.setSelectedComponent(schemaPanel);
                        }
                        if (ConnectAsAction.this.dlg.isException()) {
                            return;
                        }
                        nfo.setSchema(schemaPanel.getSchema());
                        nfo.connect(basePanel.getSelectedDatabaseProduct());
                        if (ConnectAsAction.this.dlg != null) {
                            ConnectAsAction.this.dlg.close();
                        }
                    }
                    catch (Exception exc) {
                        nfo.setUser(oldUser);
                        nfo.setSchema(oldSchema);
                        String message = MessageFormat.format(DatabaseAction.bundle.getString("ERR_UnableToConnect"), exc.getMessage(), nfo.getDatabase());
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                    }
                }
            }
        };
        ChangeListener changeTabListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                block10: {
                    if (((JTabbedPane)e.getSource()).getSelectedComponent().equals(schemaPanel)) {
                        nfo.setUser(basePanel.getUser());
                        nfo.setPassword(basePanel.getPassword());
                        DBConnection con = nfo.getDatabaseConnection();
                        try {
                            Connection connection2 = con.createJDBCConnection();
                            if (connection2 == null) break block10;
                            Vector<String> items = new Vector<String>();
                            try {
                                ResultSet rs = connection2.getMetaData().getSchemas();
                                while (rs.next()) {
                                    items.add(rs.getString(1).trim());
                                }
                                rs.close();
                            }
                            catch (SQLException exc) {
                                // empty catch block
                            }
                            connection2.close();
                            schemaPanel.setSchemas(items, nfo.getSchema());
                        }
                        catch (SQLException exc) {
                            String message = MessageFormat.format(DatabaseAction.bundle.getString("ERR_UnableObtainSchemas"), exc.getMessage());
                            if (con.getDriver().equals("com.pointbase.jdbc.jdbcUniversalDriver") && exc.getErrorCode() == 86024) {
                                message = MessageFormat.format(DatabaseAction.bundle.getString("EXC_PointbaseServerRejected"), message);
                            }
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                            ConnectAsAction.this.dlg.setSelectedComponent(basePanel);
                            ConnectAsAction.this.dlg.setException(new DatabaseException("Unable to obtain schema. " + exc.getMessage()));
                        }
                        catch (Exception exc) {
                            String message = MessageFormat.format(DatabaseAction.bundle.getString("ERR_UnableObtainSchemas"), exc.getMessage());
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                            ConnectAsAction.this.dlg.setSelectedComponent(basePanel);
                            ConnectAsAction.this.dlg.setException(new DatabaseException("Unable to obtain schema. " + exc.getMessage()));
                        }
                    } else if (schemaPanel.getSchema() != null) {
                        nfo.setSchema(schemaPanel.getSchema());
                    }
                }
            }
        };
        this.dlg = new ConnectionDialog(basePanel, schemaPanel, basePanel.getTitle(), actionListener, changeTabListener);
        this.dlg.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

