/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.NewConnectionPanel;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.netbeans.modules.db.explorer.infos.ConnectionOwnerOperations;
import org.netbeans.modules.db.explorer.infos.DriverNodeInfo;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public class ConnectUsingDriverAction
extends DatabaseAction {
    static final long serialVersionUID = 8245005834483564671L;
    ConnectionDialog dlg = null;
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo;

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes != null && activatedNodes.length == 1;
    }

    public void performAction(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length <= 0) {
            return;
        }
        Node node = activatedNodes[0];
        DriverNodeInfo info = (DriverNodeInfo)node.getCookie(class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo == null ? (class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo = ConnectUsingDriverAction.class$("org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo")) : class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo);
        final ConnectionOwnerOperations nfo = (ConnectionOwnerOperations)((Object)info.getParent(this.nodename));
        Vector drvs = RootNode.getOption().getAvailableDrivers();
        DatabaseConnection cinfo = new DatabaseConnection();
        cinfo.setDriverName(info.getName());
        cinfo.setDriver(info.getURL());
        final NewConnectionPanel basePanel = new NewConnectionPanel(drvs, cinfo);
        final SchemaPanel schemaPanel = new SchemaPanel(new Vector(), new String());
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (event.getSource() == NotifyDescriptor.OK_OPTION) {
                    ConnectUsingDriverAction.this.dlg.setException(null);
                    basePanel.setConnectionInfo();
                    try {
                        Class.forName(basePanel.getDriver());
                        if (schemaPanel.getSchema() == null) {
                            ConnectUsingDriverAction.this.dlg.setSelectedComponent(schemaPanel);
                        }
                        if (ConnectUsingDriverAction.this.dlg.isException()) {
                            schemaPanel.setComment(DatabaseAction.bundle.getString("MSG_SchemaPanelWarning"));
                            return;
                        }
                        basePanel.getConnection().setSchema(schemaPanel.getSchema());
                        nfo.addConnection(basePanel.getConnection());
                        if (ConnectUsingDriverAction.this.dlg != null) {
                            ConnectUsingDriverAction.this.dlg.close();
                        }
                    }
                    catch (ClassNotFoundException exc) {
                        String message = MessageFormat.format(DatabaseAction.bundle.getString("EXC_ClassNotFound"), exc.getMessage());
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                    }
                    catch (Exception exc) {
                        String message = MessageFormat.format(DatabaseAction.bundle.getString("ERR_UnableToAddConnection"), exc.getMessage());
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                    }
                }
            }
        };
        ChangeListener changeTabListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                block11: {
                    String schemaTemp = schemaPanel.getSchema() != null ? schemaPanel.getSchema() : basePanel.getUser();
                    if (((JTabbedPane)e.getSource()).getSelectedComponent().equals(schemaPanel)) {
                        basePanel.setConnectionInfo();
                        DBConnection con = basePanel.getConnection();
                        try {
                            Class.forName(basePanel.getDriver());
                            Connection connection = con.createJDBCConnection();
                            if (connection == null) break block11;
                            Vector<String> items = new Vector<String>();
                            try {
                                ResultSet rs = connection.getMetaData().getSchemas();
                                while (rs.next()) {
                                    items.add(rs.getString(1).trim());
                                }
                                rs.close();
                            }
                            catch (SQLException exc) {
                                // empty catch block
                            }
                            connection.close();
                            if (!schemaPanel.setSchemas(items, schemaTemp)) {
                                ConnectUsingDriverAction.this.dlg.setException(new DDLException("User name is not in the list of accessible schemas"));
                            }
                        }
                        catch (SQLException exc) {
                            String message = MessageFormat.format(DatabaseAction.bundle.getString("ERR_UnableObtainSchemas"), exc.getMessage());
                            if (con.getDriver().equals("com.pointbase.jdbc.jdbcUniversalDriver") && exc.getErrorCode() == 86024) {
                                message = MessageFormat.format(DatabaseAction.bundle.getString("EXC_PointbaseServerRejected"), message, con.getDatabase());
                            }
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                            ConnectUsingDriverAction.this.dlg.setSelectedComponent(basePanel);
                            ConnectUsingDriverAction.this.dlg.setException(new DatabaseException("Unable to obtain schema. " + exc.getMessage()));
                        }
                        catch (Exception exc) {
                            String message = MessageFormat.format(DatabaseAction.bundle.getString("ERR_UnableObtainSchemas"), exc.getMessage());
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                            ConnectUsingDriverAction.this.dlg.setSelectedComponent(basePanel);
                            ConnectUsingDriverAction.this.dlg.setException(new DatabaseException("Unable to obtain schema. " + exc.getMessage()));
                        }
                    } else if (schemaPanel.getSchema() != null) {
                        String string = schemaPanel.getSchema();
                    }
                }
            }
        };
        this.dlg = new ConnectionDialog(basePanel, schemaPanel, basePanel.getTitle(), actionListener, changeTabListener);
        this.dlg.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

