/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.lib.ddl.impl.CreateTable;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.infos.ColumnNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.windows.WindowManager;

public class GrabTableAction
extends DatabaseAction {
    static final long serialVersionUID = -7685449970256732671L;
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo;

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes != null && activatedNodes.length == 1;
    }

    public void performAction(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return;
        }
        Node node = activatedNodes[0];
        try {
            DatabaseNodeInfo info = (DatabaseNodeInfo)node.getCookie(class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo == null ? (class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo = GrabTableAction.class$("org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo")) : class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo);
            DatabaseNodeInfo nfo = info.getParent(this.nodename);
            Specification spec = (Specification)nfo.getSpecification();
            String tablename = (String)nfo.get("table");
            CreateTable cmd = spec.createCommandCreateTable(tablename);
            Enumeration enu = nfo.getChildren().elements();
            while (enu.hasMoreElements()) {
                Object element = enu.nextElement();
                if (!(element instanceof ColumnNodeInfo)) continue;
                cmd.getColumns().add(((ColumnNodeInfo)element).getColumnSpecification());
            }
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogType(1);
            chooser.setDialogTitle(DatabaseAction.bundle.getString("GrabTableFileSaveDialogTitle"));
            chooser.setSelectedFile(new File(tablename + ".grab"));
            chooser.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".grab");
                }

                public String getDescription() {
                    return DatabaseAction.bundle.getString("GrabTableFileTypeDescription");
                }
            });
            Frame par = WindowManager.getDefault().getMainWindow();
            boolean noResult = true;
            File file = null;
            while (noResult) {
                if (chooser.showSaveDialog(par) == 0) {
                    file = chooser.getSelectedFile();
                    if (file == null) continue;
                    if (file.exists()) {
                        JButton yesOption = new JButton(DatabaseAction.bundle.getString("Yes"));
                        JButton noOption = new JButton(DatabaseAction.bundle.getString("No"));
                        Object result = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)MessageFormat.format(DatabaseAction.bundle.getString("MSG_ReplaceFileOrNot"), file.getName()), DatabaseAction.bundle.getString("GrabTableFileSaveDialogTitle"), 0, 3, new Object[]{yesOption, noOption}, (Object)yesOption));
                        if (!result.equals(yesOption)) continue;
                        noResult = false;
                        continue;
                    }
                    noResult = false;
                    continue;
                }
                return;
            }
            FileOutputStream fstream = new FileOutputStream(file);
            ObjectOutputStream ostream = new ObjectOutputStream(fstream);
            cmd.setSpecification(null);
            ostream.writeObject(cmd);
            ostream.flush();
            ostream.close();
        }
        catch (Exception exc) {
            String message = MessageFormat.format(DatabaseAction.bundle.getString("ERR_UnableToGrabTable"), exc.getMessage());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

