/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dataview.DataViewWindow;
import org.netbeans.modules.db.explorer.dlg.LabeledTextFieldDialog;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableListNodeInfo;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.windows.WindowManager;

public class RecreateTableAction
extends DatabaseAction {
    static final long serialVersionUID = 6992569917995229492L;
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo;

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes != null && activatedNodes.length == 1;
    }

    public void performAction(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return;
        }
        Node node = activatedNodes[0];
        try {
            File file;
            DatabaseNodeInfo info = (DatabaseNodeInfo)node.getCookie(class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo == null ? (class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo = RecreateTableAction.class$("org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo")) : class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo);
            TableListNodeInfo nfo = (TableListNodeInfo)info.getParent(this.nodename);
            Specification spec = (Specification)nfo.getSpecification();
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogType(0);
            chooser.setDialogTitle(DatabaseAction.bundle.getString("RecreateTableFileOpenDialogTitle"));
            chooser.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".grab");
                }

                public String getDescription() {
                    return DatabaseAction.bundle.getString("GrabTableFileTypeDescription");
                }
            });
            Frame par = WindowManager.getDefault().getMainWindow();
            if (chooser.showOpenDialog(par) == 0) {
                file = chooser.getSelectedFile();
                if (file == null || !file.isFile()) {
                    return;
                }
            } else {
                return;
            }
            FileInputStream fstream = new FileInputStream(file);
            ObjectInputStream istream = new ObjectInputStream(fstream);
            AbstractCommand cmd = (AbstractCommand)istream.readObject();
            istream.close();
            cmd.setSpecification(spec);
            String newtab = cmd.getObjectName();
            String msg = MessageFormat.format(DatabaseAction.bundle.getString("RecreateTableRenameNotes"), cmd.getCommand());
            msg = cmd.getCommand();
            LabeledTextFieldDialog dlg = new LabeledTextFieldDialog(DatabaseAction.bundle.getString("RecreateTableRenameTable"), DatabaseAction.bundle.getString("RecreateTableNewName"), msg);
            dlg.setStringValue(newtab);
            boolean noResult = true;
            while (noResult) {
                if (dlg.run()) {
                    try {
                        if (!dlg.isEditable()) {
                            newtab = dlg.getStringValue();
                            cmd.setObjectName(newtab);
                            cmd.setObjectOwner((String)info.get("schema"));
                            try {
                                cmd.execute();
                                nfo.addTable(newtab);
                            }
                            catch (DDLException exc) {
                                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                                    exc.printStackTrace();
                                }
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)exc.getMessage(), 0));
                                continue;
                            }
                            catch (DatabaseException exc) {
                                ErrorManager.getDefault().notify(1, (Throwable)exc);
                                continue;
                            }
                            noResult = false;
                            continue;
                        }
                        DataViewWindow win = new DataViewWindow(info, dlg.getEditedCommand());
                        if (!win.executeCommand()) continue;
                        noResult = false;
                    }
                    catch (Exception exc) {
                        if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                            exc.printStackTrace();
                        }
                        String message = MessageFormat.format(DatabaseAction.bundle.getString("ERR_UnableToRecreateTable"), exc.getMessage());
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                    }
                    continue;
                }
                noResult = false;
            }
        }
        catch (Exception exc) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                exc.printStackTrace();
            }
            String message = MessageFormat.format(DatabaseAction.bundle.getString("ERR_UnableToRecreateTable"), exc.getMessage());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

