/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.DatabaseProductNotFoundException;
import org.netbeans.lib.ddl.DatabaseSpecification;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.SpecificationFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.TestDriverDialog;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.windows.IOProvider;

public class TestDriverAction
extends DatabaseAction {
    static final long serialVersionUID = -7201887208073852066L;
    private String message;
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$ConnectionNodeInfo;
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo;

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        Node node = activatedNodes[0];
        ConnectionNodeInfo info = (ConnectionNodeInfo)node.getCookie(class$org$netbeans$modules$db$explorer$infos$ConnectionNodeInfo == null ? (class$org$netbeans$modules$db$explorer$infos$ConnectionNodeInfo = TestDriverAction.class$("org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo")) : class$org$netbeans$modules$db$explorer$infos$ConnectionNodeInfo);
        if (info != null) {
            return info.getConnection() != null;
        }
        return true;
    }

    protected int mode() {
        return 4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void performAction(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length <= 0) {
            return;
        }
        Node node = activatedNodes[0];
        try {
            DatabaseNodeInfo info = (DatabaseNodeInfo)node.getCookie(class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo == null ? (class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo = TestDriverAction.class$("org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo")) : class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo);
            Connection conn = info.getConnection();
            String user = info.getUser();
            boolean testok = false;
            if (conn == null) {
                DatabaseConnection cinfo = new DatabaseConnection();
                String driver = (String)info.get("url");
                cinfo.setDriver(driver);
                cinfo.setDriverName((String)info.get("name"));
                cinfo.setDatabase((String)info.get("prefix"));
                TestDriverDialog cdlg = new TestDriverDialog(cinfo);
                if (!cdlg.run()) return;
                conn = cdlg.getConnection();
                if (conn == null) {
                    throw new SQLException(DatabaseAction.bundle.getString("EXC_UnableToGetTheConnection"));
                }
                testok = this.performTest(info, conn, user, driver);
                conn.close();
            } else {
                String driver = info.getDriver();
                testok = this.performTest(info, conn, user, driver);
            }
            String testmsg = DatabaseAction.bundle.getString(testok ? "TestDriverActionOK" : "TestDriverActionError");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)testmsg));
            return;
        }
        catch (Exception exc) {
            this.message = MessageFormat.format(DatabaseAction.bundle.getString("ERR_UnableToPerformAction"), exc.getMessage());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)this.message, 0));
        }
    }

    private boolean performTest(DatabaseNodeInfo info, Connection dbcon, String user, String driver) throws SQLException {
        boolean ok = true;
        Object ow = IOProvider.getDefault().getStdOut();
        if (ow == null) {
            ow = new PrintWriter(System.out);
        }
        String tab = null;
        String view = null;
        String proc = null;
        DatabaseSpecification spec = info.getSpecification();
        DriverSpecification drvSpec = info.getDriverSpecification();
        try {
            if (spec == null) {
                SpecificationFactory fac = new SpecificationFactory();
                spec = fac.createSpecification(dbcon, "GenericDatabaseSystem");
                drvSpec = fac.createDriverSpecification(spec.getMetaData().getDriverName().trim());
                drvSpec.setMetaData(spec.getMetaData());
                drvSpec.setCatalog(dbcon.getCatalog());
                drvSpec.setSchema(spec.getMetaData().getUserName());
            }
        }
        catch (DDLException ex) {
        }
        catch (DatabaseProductNotFoundException ex) {
            // empty catch block
        }
        this.message = MessageFormat.format(DatabaseAction.bundle.getString("MSG_TestingDriver"), driver);
        ((PrintWriter)ow).println("\n\n" + this.message + "\n\n");
        String[] filter = new String[]{"TABLE"};
        drvSpec.getTables("%", filter);
        int counter = 0;
        ResultSet rs = drvSpec.getResultSet();
        HashMap rset = new HashMap();
        if (rs != null) {
            while (rs.next()) {
                if (tab == null) {
                    rset = drvSpec.getRow();
                    tab = (String)rset.get(new Integer(3));
                    rset.clear();
                }
                ++counter;
            }
            rs.close();
        }
        if (tab != null) {
            Object[] objectArray = new String[2];
            objectArray[0] = "getTables()";
            new String();
            objectArray[1] = String.valueOf(counter);
            this.message = MessageFormat.format(DatabaseAction.bundle.getString("MSG_TestTables"), objectArray);
            ((PrintWriter)ow).println(this.message);
            drvSpec.getColumns(tab, "%");
            rs = drvSpec.getResultSet();
            counter = 0;
            if (rs != null) {
                while (rs.next()) {
                    ++counter;
                }
                if (counter > 0) {
                    Object[] objectArray2 = new String[3];
                    objectArray2[0] = "getColumns()";
                    objectArray2[1] = tab;
                    new String();
                    objectArray2[2] = String.valueOf(counter);
                    this.message = MessageFormat.format(DatabaseAction.bundle.getString("MSG_TestColumns"), objectArray2);
                    ((PrintWriter)ow).println(this.message);
                } else {
                    this.message = MessageFormat.format(DatabaseAction.bundle.getString("MSG_NoColumns"), tab);
                    ((PrintWriter)ow).println(this.message);
                    ok = false;
                }
                rs.close();
            }
            drvSpec.getPrimaryKeys(tab);
            rs = drvSpec.getResultSet();
            counter = 0;
            if (rs != null) {
                while (rs.next()) {
                    ++counter;
                }
                if (counter > 0) {
                    Object[] objectArray3 = new String[3];
                    objectArray3[0] = "getPrimaryKeys()";
                    objectArray3[1] = tab;
                    new String();
                    objectArray3[2] = String.valueOf(counter);
                    this.message = MessageFormat.format(DatabaseAction.bundle.getString("MSG_TestPrimaryKeys"), objectArray3);
                    ((PrintWriter)ow).println(this.message);
                } else {
                    this.message = MessageFormat.format(DatabaseAction.bundle.getString("MSG_NoPrimaryKeys"), tab);
                    ((PrintWriter)ow).println(this.message);
                    ok = false;
                }
                rs.close();
            }
            drvSpec.getIndexInfo(tab, false, false);
            rs = drvSpec.getResultSet();
            counter = 0;
            if (rs != null) {
                while (rs.next()) {
                    ++counter;
                }
                if (counter > 0) {
                    Object[] objectArray4 = new String[3];
                    objectArray4[0] = "getIndexInfo()";
                    objectArray4[1] = tab;
                    new String();
                    objectArray4[2] = String.valueOf(counter);
                    this.message = MessageFormat.format(DatabaseAction.bundle.getString("MSG_TestIndexes"), objectArray4);
                    ((PrintWriter)ow).println(this.message);
                } else {
                    this.message = MessageFormat.format(DatabaseAction.bundle.getString("MSG_NoIndexes"), tab);
                    ((PrintWriter)ow).println(this.message);
                    ok = false;
                }
                rs.close();
            }
        } else {
            ((PrintWriter)ow).println(DatabaseAction.bundle.getString("MSG_NoTables"));
            ok = false;
        }
        filter = new String[]{"VIEW"};
        if (drvSpec.areViewsSupported()) {
            drvSpec.getTables("%", filter);
            rs = drvSpec.getResultSet();
            counter = 0;
            if (rs != null) {
                while (rs.next()) {
                    if (view == null) {
                        rset = drvSpec.getRow();
                        view = (String)rset.get(new Integer(3));
                        rset.clear();
                    }
                    ++counter;
                }
                if (view != null) {
                    Object[] objectArray = new String[2];
                    objectArray[0] = "getTables()";
                    new String();
                    objectArray[1] = String.valueOf(counter);
                    this.message = MessageFormat.format(DatabaseAction.bundle.getString("MSG_TestViews"), objectArray);
                    ((PrintWriter)ow).println(this.message);
                } else {
                    ((PrintWriter)ow).println(DatabaseAction.bundle.getString("MSG_NoViews"));
                    ok = false;
                }
                rs.close();
            } else {
                ((PrintWriter)ow).println(DatabaseAction.bundle.getString("MSG_NoViews"));
                ok = false;
            }
        }
        drvSpec.getProcedures("%");
        rs = drvSpec.getResultSet();
        counter = 0;
        if (rs != null) {
            while (rs.next()) {
                if (proc == null) {
                    rset = drvSpec.getRow();
                    proc = (String)rset.get(new Integer(3));
                    rset.clear();
                }
                ++counter;
            }
            rs.close();
            if (proc != null) {
                Object[] objectArray = new String[2];
                objectArray[0] = "getProcedures()";
                new String();
                objectArray[1] = String.valueOf(counter);
                this.message = MessageFormat.format(DatabaseAction.bundle.getString("MSG_TestProcedures"), objectArray);
                ((PrintWriter)ow).println(this.message);
                drvSpec.getProcedureColumns(proc, "%");
                rs = drvSpec.getResultSet();
                counter = 0;
                if (rs != null) {
                    while (rs.next()) {
                        ++counter;
                    }
                    if (counter > 0) {
                        Object[] objectArray5 = new String[3];
                        objectArray5[0] = "getProcedureColumns()";
                        objectArray5[1] = proc;
                        new String();
                        objectArray5[2] = String.valueOf(counter);
                        this.message = MessageFormat.format(DatabaseAction.bundle.getString("MSG_TestProcedureColumns"), objectArray5);
                        ((PrintWriter)ow).println(this.message);
                    } else {
                        ((PrintWriter)ow).println(DatabaseAction.bundle.getString("MSG_NoProcedureColumns"));
                        ok = false;
                    }
                    rs.close();
                }
            } else {
                ((PrintWriter)ow).println(DatabaseAction.bundle.getString("MSG_NoProcedures"));
                ok = false;
            }
        } else {
            ((PrintWriter)ow).println(DatabaseAction.bundle.getString("MSG_NoProcedures"));
            ok = false;
        }
        return ok;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

