/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dataview;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ObjectStreamException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.MutableComboBoxModel;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.infos.ColumnNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.nodes.ConnectionNode;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.SplittedPanel;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.windows.TopComponent;

public class DataViewWindow
extends TopComponent {
    private JTextArea queryarea;
    private JTable jtable;
    private DataModel dbadaptor;
    private JComboBox rcmdscombo;
    private String schema;
    private ResourceBundle bundle;
    private Node node;
    static final long serialVersionUID = 6855188441469780252L;
    static int tstrg = 0;
    static int gtcmd = 0;

    public DataViewWindow(DatabaseNodeInfo info, String query) throws SQLException {
        this.schema = info.getUser();
        this.node = info.getNode();
        try {
            this.bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
            this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_DataViewWindowA11yDesc"));
            Node tempNode = this.node;
            while (!(tempNode instanceof ConnectionNode)) {
                tempNode = tempNode.getParentNode();
            }
            this.setName(this.bundle.getString("CommandEditorTitle") + " " + tempNode.getDisplayName());
            ((JComponent)((Object)this)).setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints con = new GridBagConstraints();
            ((Container)((Object)this)).setLayout(layout);
            this.dbadaptor = new DataModel(info);
            JPanel subpane = new JPanel();
            GridBagLayout sublayout = new GridBagLayout();
            GridBagConstraints subcon = new GridBagConstraints();
            subpane.setLayout(sublayout);
            subcon.fill = 1;
            subcon.weightx = 1.0;
            subcon.weighty = 1.0;
            subcon.gridx = 0;
            subcon.gridwidth = 2;
            subcon.gridy = 0;
            subcon.insets = new Insets(0, 0, 5, 0);
            this.queryarea = new JTextArea(query, 3, 70);
            this.queryarea.setLineWrap(true);
            this.queryarea.setWrapStyleWord(true);
            this.queryarea.setDropTarget(new DropTarget(this.queryarea, new ViewDropTarget()));
            this.queryarea.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_DataViewTextAreaA11yName"));
            this.queryarea.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_DataViewTextAreaA11yDesc"));
            this.queryarea.setToolTipText(this.bundle.getString("ACS_DataViewTextAreaA11yDesc"));
            JScrollPane scrollpane = new JScrollPane(this.queryarea);
            sublayout.setConstraints(scrollpane, subcon);
            subpane.add(scrollpane);
            subcon.fill = 2;
            subcon.weightx = 1.0;
            subcon.weighty = 0.0;
            subcon.gridx = 0;
            subcon.gridy = 1;
            subcon.gridwidth = 1;
            subcon.insets = new Insets(0, 0, 5, 5);
            subcon.anchor = 15;
            this.rcmdscombo = new JComboBox(new ComboModel());
            this.rcmdscombo.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_DataViewComboBoxA11yName"));
            this.rcmdscombo.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_DataViewComboBoxA11yDesc"));
            this.rcmdscombo.setToolTipText(this.bundle.getString("ACS_DataViewComboBoxA11yDesc"));
            sublayout.setConstraints(this.rcmdscombo, subcon);
            subpane.add(this.rcmdscombo);
            this.rcmdscombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JComboBox source = (JComboBox)e.getSource();
                    RecentCommand cmd = (RecentCommand)source.getSelectedItem();
                    if (cmd != null) {
                        DataViewWindow.this.setCommand(cmd.getCommand());
                    }
                }
            });
            subcon.gridx = 1;
            subcon.gridy = 1;
            subcon.weightx = 0.0;
            subcon.weighty = 0.0;
            subcon.insets = new Insets(0, 0, 5, 0);
            subcon.fill = 2;
            subcon.anchor = 15;
            JButton fetchbtn = new JButton(this.bundle.getString("ExecuteButton"));
            fetchbtn.setToolTipText(this.bundle.getString("ACS_ExecuteButtonA11yDesc"));
            fetchbtn.setMnemonic(this.bundle.getString("ExecuteButton_Mnemonic").charAt(0));
            sublayout.setConstraints(fetchbtn, subcon);
            subpane.add(fetchbtn);
            fetchbtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DataViewWindow.this.executeCommand();
                }
            });
            this.jtable = new JTable(this.dbadaptor);
            this.jtable.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_DataViewTableA11yName"));
            this.jtable.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_DataViewTableA11yDesc"));
            this.jtable.setToolTipText(this.bundle.getString("ACS_DataViewTableA11yDesc"));
            this.jtable.setAutoResizeMode(0);
            scrollpane = new JScrollPane(this.jtable);
            con.weightx = 1.0;
            con.weighty = 1.0;
            con.fill = 1;
            con.gridx = 0;
            con.gridwidth = 1;
            con.gridy = 1;
            SplittedPanel split = new SplittedPanel();
            split.setSplitType(1);
            split.setSplitTypeChangeEnabled(false);
            split.setSplitAbsolute(false);
            split.setSplitPosition(20);
            split.add((Component)subpane, SplittedPanel.ADD_LEFT);
            split.add((Component)scrollpane, SplittedPanel.ADD_RIGHT);
            layout.setConstraints((Component)split, con);
            ((Container)((Object)this)).add((Component)split);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public String getCommand() {
        return this.queryarea.getText();
    }

    public void setCommand(String command) {
        this.queryarea.setText(command);
    }

    public boolean executeCommand() {
        try {
            String command = this.queryarea.getText().trim();
            this.dbadaptor.execute(command);
            RecentCommand rcmd = new RecentCommand(command);
            ((ComboModel)this.rcmdscombo.getModel()).addElement(rcmd);
            return true;
        }
        catch (Exception e) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(this.bundle.getString("DataViewFetchErrorPrefix") + e.getMessage()), 0));
            return false;
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        return null;
    }

    class DataModel
    extends AbstractTableModel {
        DatabaseNodeInfo node_info;
        Vector coldef;
        Vector data;
        boolean editable = false;
        static final long serialVersionUID = 7729426847826999963L;
        static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$java$lang$Boolean;
        static /* synthetic */ Class class$java$lang$Integer;
        static /* synthetic */ Class class$java$lang$Long;
        static /* synthetic */ Class class$java$lang$Double;
        static /* synthetic */ Class class$java$sql$Date;
        static /* synthetic */ Class class$java$lang$Object;

        public DataModel(DatabaseNodeInfo node_info) throws SQLException {
            this.node_info = node_info;
        }

        public void execute(String command) throws Exception {
            Statement stat;
            if (command.length() == 0) {
                return;
            }
            try {
                Connection con = this.node_info.getConnection();
                stat = con.createStatement();
            }
            catch (Exception exc) {
                String message = MessageFormat.format(DataViewWindow.this.bundle.getString("EXC_ConnectionIsBroken"), exc.getMessage());
                throw new DatabaseException(message);
            }
            if (command.toLowerCase().startsWith("select")) {
                ResultSet rs = stat.executeQuery(command);
                ResultSetMetaData mdata = rs.getMetaData();
                Object gschema = null;
                int cols = mdata.getColumnCount();
                this.coldef = new Vector(cols);
                int column = 1;
                while (column <= cols) {
                    boolean writable;
                    try {
                        writable = mdata.isWritable(column);
                    }
                    catch (SQLException exc) {
                        writable = false;
                    }
                    ColDef cd = new ColDef(mdata.getColumnLabel(column), writable);
                    cd.setDataType(mdata.getColumnType(column));
                    this.coldef.add(cd);
                    ++column;
                }
                int rcounter = 0;
                int limit = RootNode.getOption().getFetchLimit();
                int step = RootNode.getOption().getFetchStep();
                this.data = new Vector();
                while (rs.next()) {
                    Vector<Object> row = new Vector<Object>(cols);
                    int column2 = 1;
                    while (column2 <= cols) {
                        row.add(rs.getObject(column2));
                        ++column2;
                    }
                    this.data.addElement(row);
                    if (++rcounter < limit) continue;
                    Object[] arr = new String[]{new Integer(rcounter).toString(), new Integer(step).toString()};
                    String cancel = DataViewWindow.this.bundle.getString("DataViewCancelButton");
                    String nextset = DataViewWindow.this.bundle.getString("DataViewNextFetchButton");
                    String allset = DataViewWindow.this.bundle.getString("DataViewAllFetchButton");
                    String message = MessageFormat.format(DataViewWindow.this.bundle.getString("DataViewMessage"), arr);
                    NotifyDescriptor ndesc = new NotifyDescriptor((Object)message, DataViewWindow.this.bundle.getString("FetchDataTitle"), 1, 3, new Object[]{nextset, allset, cancel}, NotifyDescriptor.CANCEL_OPTION);
                    String retv = (String)DialogDisplayer.getDefault().notify(ndesc);
                    if (retv.equals(allset)) {
                        limit = Integer.MAX_VALUE;
                        continue;
                    }
                    if (!retv.equals(nextset)) break;
                    limit += step;
                }
                rs.close();
                this.fireTableChanged(null);
            } else {
                if (command.toLowerCase().startsWith("delete") || command.toLowerCase().startsWith("insert") || command.toLowerCase().startsWith("update")) {
                    stat.executeUpdate(command);
                } else {
                    stat.execute(command);
                    while (!(DataViewWindow.this.node instanceof ConnectionNode)) {
                        DataViewWindow.this.node = DataViewWindow.this.node.getParentNode();
                    }
                    Enumeration nodes = DataViewWindow.this.node.getChildren().nodes();
                    while (nodes.hasMoreElements()) {
                        ((DatabaseNodeInfo)((Node)nodes.nextElement()).getCookie(class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo == null ? DataModel.class$("org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo") : class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo)).refreshChildren();
                    }
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)DataViewWindow.this.bundle.getString("CommandExecuted"), 1));
            }
            stat.close();
        }

        public String getColumnName(int column) {
            if (column < this.coldef.size()) {
                String cname = ((ColDef)this.coldef.elementAt(column)).getName();
                return cname;
            }
            return "";
        }

        public Class getColumnClass(int column) {
            if (column < this.coldef.size()) {
                int coltype = ((ColDef)this.coldef.elementAt(column)).getDataType();
                switch (coltype) {
                    case -1: 
                    case 1: 
                    case 12: {
                        return class$java$lang$String == null ? (class$java$lang$String = DataModel.class$("java.lang.String")) : class$java$lang$String;
                    }
                    case -7: {
                        return class$java$lang$Boolean == null ? (class$java$lang$Boolean = DataModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                    }
                    case -6: 
                    case 4: 
                    case 5: {
                        return class$java$lang$Integer == null ? (class$java$lang$Integer = DataModel.class$("java.lang.Integer")) : class$java$lang$Integer;
                    }
                    case -5: {
                        return class$java$lang$Long == null ? (class$java$lang$Long = DataModel.class$("java.lang.Long")) : class$java$lang$Long;
                    }
                    case 6: 
                    case 8: {
                        return class$java$lang$Double == null ? (class$java$lang$Double = DataModel.class$("java.lang.Double")) : class$java$lang$Double;
                    }
                    case 91: {
                        return class$java$sql$Date == null ? (class$java$sql$Date = DataModel.class$("java.sql.Date")) : class$java$sql$Date;
                    }
                }
            }
            return class$java$lang$Object == null ? (class$java$lang$Object = DataModel.class$("java.lang.Object")) : class$java$lang$Object;
        }

        public boolean isCellEditable(int row, int column) {
            if (!this.editable) {
                return false;
            }
            if (column < this.coldef.size()) {
                return ((ColDef)this.coldef.elementAt(column)).isWritable();
            }
            return false;
        }

        public int getColumnCount() {
            if (this.coldef == null) {
                return 0;
            }
            return this.coldef.size();
        }

        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        public Object getValueAt(int aRow, int aColumn) {
            Vector row = null;
            if (aRow < this.data.size()) {
                row = (Vector)this.data.elementAt(aRow);
            }
            if (row != null && aColumn < row.size()) {
                return row.elementAt(aColumn);
            }
            return null;
        }

        private String format(Object value, int type) {
            if (value == null) {
                return "null";
            }
            switch (type) {
                case 4: 
                case 6: 
                case 8: {
                    return value.toString();
                }
                case -7: {
                    return (Boolean)value != false ? "1" : "0";
                }
                case 91: {
                    return value.toString();
                }
            }
            return "\"" + value.toString() + "\"";
        }

        public void setValueAt(Object value, int row, int column) {
            int enucol = 0;
            StringBuffer where = new StringBuffer();
            HashMap map = new HashMap();
            Enumeration enu = this.coldef.elements();
            while (enu.hasMoreElements()) {
                ColDef cd = (ColDef)enu.nextElement();
                if (cd.isBestRowIdentifierColumn()) {
                    String key = cd.getName();
                    String val = this.format(this.getValueAt(row, enucol), cd.getDataType());
                    if (where.length() > 0) {
                        where.append(" and ");
                    }
                    where.append(key + " = " + val);
                }
                ++enucol;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    class ViewDropTarget
    implements DropTargetListener {
        static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo;
        static /* synthetic */ Class class$org$openide$util$datatransfer$ExTransferable;

        ViewDropTarget() {
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            dtde.acceptDrag(dtde.getDropAction());
        }

        public void dragOver(DropTargetDragEvent dtde) {
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        public void dragExit(DropTargetEvent dte) {
        }

        private ColumnNodeInfo getNodeInfo(Transferable t) {
            Node n = NodeTransfer.node((Transferable)t, (int)6);
            if (n != null) {
                return (ColumnNodeInfo)n.getCookie(class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo == null ? (class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo = ViewDropTarget.class$("org.netbeans.modules.db.explorer.infos.ColumnNodeInfo")) : class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo);
            }
            n = NodeTransfer.node((Transferable)t, (int)1);
            if (n != null) {
                return (ColumnNodeInfo)n.getCookie(class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo == null ? (class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo = ViewDropTarget.class$("org.netbeans.modules.db.explorer.infos.ColumnNodeInfo")) : class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo);
            }
            return null;
        }

        public void drop(DropTargetDropEvent dtde) {
            String query = null;
            Object obj = null;
            Transferable t = dtde.getTransferable();
            StringBuffer buff = new StringBuffer();
            try {
                DataFlavor multiFlavor = new DataFlavor(NbBundle.getBundle((Class)(class$org$openide$util$datatransfer$ExTransferable == null ? (class$org$openide$util$datatransfer$ExTransferable = ViewDropTarget.class$("org.openide.util.datatransfer.ExTransferable")) : class$org$openide$util$datatransfer$ExTransferable)).getString("MultiNodeMimeType"), NbBundle.getBundle((Class)(class$org$openide$util$datatransfer$ExTransferable == null ? (class$org$openide$util$datatransfer$ExTransferable = ViewDropTarget.class$("org.openide.util.datatransfer.ExTransferable")) : class$org$openide$util$datatransfer$ExTransferable)).getString("transferFlavorsMultiFlavorName"));
                if (t.isDataFlavorSupported(multiFlavor)) {
                    MultiTransferObject mobj = (MultiTransferObject)t.getTransferData(ExTransferable.multiFlavor);
                    int count = mobj.getCount();
                    int tabidx = 0;
                    HashMap<String, Integer> tabidxmap = new HashMap<String, Integer>();
                    int i = 0;
                    while (i < count) {
                        ColumnNodeInfo nfo = this.getNodeInfo(mobj.getTransferableAt(i));
                        if (nfo != null) {
                            String tablename = nfo.getTable();
                            Integer tableidx = (Integer)tabidxmap.get(tablename);
                            if (tableidx == null) {
                                tableidx = new Integer(tabidx++);
                                tabidxmap.put(tablename, tableidx);
                            }
                            if (buff.length() > 0) {
                                buff.append(", ");
                            }
                            buff.append("t" + tableidx + "." + nfo.getName());
                        }
                        ++i;
                    }
                    StringBuffer frombuff = new StringBuffer();
                    Iterator iter = tabidxmap.keySet().iterator();
                    while (iter.hasNext()) {
                        String tab = (String)iter.next();
                        if (frombuff.length() > 0) {
                            frombuff.append(", ");
                        }
                        frombuff.append(tab + " t" + tabidxmap.get(tab));
                    }
                    query = "select " + buff.toString() + " from " + frombuff.toString();
                } else {
                    ColumnNodeInfo nfo = this.getNodeInfo(t);
                    if (nfo != null) {
                        query = "select " + nfo.getName() + " from " + nfo.getTable();
                    }
                }
                if (query != null) {
                    DataViewWindow.this.setCommand(query);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    class ComboModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        Vector commands;
        Object selected;
        static final long serialVersionUID = -5831993904798984334L;

        public ComboModel() {
            this(new Vector(1));
        }

        public ComboModel(Vector elems) {
            this.commands = elems;
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        public void setSelectedItem(Object anItem) {
            this.selected = anItem;
            this.fireContentsChanged(this, -1, -1);
        }

        public void addElement(Object obj) {
            if (!this.commands.contains(obj)) {
                this.commands.add(obj);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void removeElement(Object obj) {
            this.commands.removeElement(obj);
            this.fireContentsChanged(this, -1, -1);
        }

        public void insertElementAt(Object obj, int index) {
            if (!this.commands.contains(obj)) {
                this.commands.insertElementAt(obj, index);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void removeElementAt(int index) {
            this.commands.removeElementAt(index);
            this.fireContentsChanged(this, -1, -1);
        }

        public int getSize() {
            return this.commands.size();
        }

        public Object getElementAt(int index) {
            return this.commands.get(index);
        }
    }

    class RecentCommand {
        private String command;
        private String shortCommand;

        public RecentCommand(String cmd) {
            this.command = cmd;
            this.shortCommand = this.getShortCommand();
        }

        public String toString() {
            return this.shortCommand;
        }

        public String getCommand() {
            return this.command;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RecentCommand) {
                return ((RecentCommand)obj).getShortCommand().equals(this.shortCommand);
            }
            return super.equals(obj);
        }

        private String getShortCommand() {
            StringTokenizer tokenizer = new StringTokenizer(this.command);
            StringBuffer buffer = new StringBuffer();
            while (tokenizer.hasMoreElements()) {
                buffer.append(tokenizer.nextElement());
                buffer.append(" ");
            }
            return buffer.toString();
        }
    }

    class ColDef {
        private String name;
        private boolean writable;
        private boolean bric;
        int datatype;

        public ColDef(String name, boolean flag) {
            this.name = name;
            this.writable = flag;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getDataType() {
            return this.datatype;
        }

        public void setDataType(int type) {
            this.datatype = type;
        }

        public boolean isWritable() {
            return this.writable;
        }

        public void setWritable(boolean flag) {
            this.writable = flag;
        }

        public boolean isBestRowIdentifierColumn() {
            return this.bric;
        }

        public void setBestRowIdentifierColumn(boolean flag) {
            this.bric = flag;
        }
    }
}

