/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.InputStream;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.lib.ddl.impl.CreateIndex;
import org.netbeans.lib.ddl.impl.CreateTable;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.util.CommandBuffer;
import org.netbeans.lib.ddl.util.PListReader;
import org.netbeans.modules.db.explorer.dlg.ColumnItem;
import org.netbeans.modules.db.explorer.dlg.DataModel;
import org.netbeans.modules.db.explorer.dlg.TypeElement;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.util.TextFieldValidator;
import org.netbeans.modules.db.util.ValidableTextField;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class CreateTableDialog {
    boolean result = false;
    Dialog dialog = null;
    JTextField dbnamefield;
    JTextField dbownerfield;
    JTable table;
    JComboBox ownercombo;
    JButton addbtn;
    JButton delbtn;
    Specification spec;
    private Vector ttab;
    private static Map dlgtab = null;
    private static final String filename = "org/netbeans/modules/db/resources/CreateTableDialog.plist";
    private static ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$dlg$CreateTableDialog;
    static /* synthetic */ Class class$java$lang$String;

    public static final Map getProperties() {
        if (dlgtab == null) {
            try {
                ClassLoader cl = (class$org$netbeans$modules$db$explorer$dlg$CreateTableDialog == null ? (class$org$netbeans$modules$db$explorer$dlg$CreateTableDialog = CreateTableDialog.class$("org.netbeans.modules.db.explorer.dlg.CreateTableDialog")) : class$org$netbeans$modules$db$explorer$dlg$CreateTableDialog).getClassLoader();
                InputStream stream = cl.getResourceAsStream(filename);
                if (stream == null) {
                    String message = MessageFormat.format(bundle.getString("EXC_UnableToOpenStream"), filename);
                    throw new Exception(message);
                }
                PListReader reader = new PListReader(stream);
                dlgtab = reader.getData();
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                dlgtab = null;
            }
        }
        return dlgtab;
    }

    public CreateTableDialog(Specification spe, DatabaseNodeInfo nfo) throws SQLException {
        this.spec = spe;
        try {
            JPanel pane = new JPanel();
            pane.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints constr = new GridBagConstraints();
            pane.setLayout(layout);
            pane.setMinimumSize(new Dimension(200, 100));
            pane.setPreferredSize(new Dimension(502, 200));
            JLabel label = new JLabel(bundle.getString("CreateTableName"));
            label.setDisplayedMnemonic(bundle.getString("CreateTableName_Mnemonic").charAt(0));
            label.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_CreateTableNameA11yDesc"));
            constr.anchor = 17;
            constr.weightx = 0.0;
            constr.weighty = 0.0;
            constr.fill = 0;
            constr.insets = new Insets(2, 2, 2, 2);
            constr.gridx = 0;
            constr.gridy = 0;
            layout.setConstraints(label, constr);
            pane.add(label);
            constr.fill = 2;
            constr.weightx = 1.0;
            constr.weighty = 0.0;
            constr.gridx = 1;
            constr.gridy = 0;
            constr.insets = new Insets(2, 2, 2, 2);
            this.dbnamefield = new JTextField(bundle.getString("CreateTableUntitledName"), 50);
            this.dbnamefield.setToolTipText(bundle.getString("ACS_CreateTableNameTextFieldA11yDesc"));
            this.dbnamefield.getAccessibleContext().setAccessibleName(bundle.getString("ACS_CreateTableNameTextFieldA11yName"));
            label.setLabelFor(this.dbnamefield);
            layout.setConstraints(this.dbnamefield, constr);
            pane.add(this.dbnamefield);
            label = new JLabel(bundle.getString("CreateTableOwner"));
            label.setDisplayedMnemonic(bundle.getString("CreateTableOwner_Mnemonic").charAt(0));
            label.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_CreateTableOwnerA11yDesc"));
            constr.anchor = 17;
            constr.weightx = 0.0;
            constr.weighty = 0.0;
            constr.fill = 0;
            constr.insets = new Insets(2, 10, 2, 2);
            constr.gridx = 2;
            constr.gridy = 0;
            layout.setConstraints(label, constr);
            pane.add(label);
            Vector<String> users = new Vector<String>();
            String schema = nfo.getDriverSpecification().getSchema();
            if (schema != null) {
                users.add(schema);
            } else {
                users.add("");
            }
            constr.fill = 2;
            constr.weightx = 0.0;
            constr.weighty = 0.0;
            constr.gridx = 3;
            constr.gridy = 0;
            constr.insets = new Insets(2, 2, 2, 2);
            this.ownercombo = new JComboBox(users);
            this.ownercombo.setSelectedIndex(0);
            this.ownercombo.setToolTipText(bundle.getString("ACS_CreateTableOwnerComboBoxA11yDesc"));
            this.ownercombo.getAccessibleContext().setAccessibleName(bundle.getString("ACS_CreateTableOwnerComboBoxA11yName"));
            label.setLabelFor(this.ownercombo);
            layout.setConstraints(this.ownercombo, constr);
            pane.add(this.ownercombo);
            constr.fill = 1;
            constr.weightx = 1.0;
            constr.weighty = 1.0;
            constr.gridx = 0;
            constr.gridy = 1;
            constr.gridwidth = 4;
            constr.gridheight = 3;
            constr.insets = new Insets(2, 2, 2, 2);
            this.table = new DataTable(new DataModel());
            this.table.setAutoResizeMode(0);
            this.table.setToolTipText(bundle.getString("ACS_CreateTableColumnTableA11yDesc"));
            this.table.getAccessibleContext().setAccessibleName(bundle.getString("ACS_CreateTableColumnTableA11yName"));
            this.table.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_CreateTableColumnTableA11yDesc"));
            JScrollPane scrollpane = new JScrollPane(this.table);
            scrollpane.setBorder(new BevelBorder(1));
            scrollpane.setPreferredSize(new Dimension(300, 150));
            layout.setConstraints(scrollpane, constr);
            pane.add(scrollpane);
            Map tmap = this.spec.getTypeMap();
            this.ttab = new Vector(tmap.size());
            Iterator iter = tmap.keySet().iterator();
            while (iter.hasNext()) {
                String iterkey = (String)iter.next();
                String iterval = (String)tmap.get(iterkey);
                this.ttab.add(new TypeElement(iterkey, iterval));
            }
            JComboBox combo = new JComboBox(this.ttab);
            combo.setSelectedIndex(0);
            this.table.setDefaultEditor(class$java$lang$String == null ? (class$java$lang$String = CreateTableDialog.class$("java.lang.String")) : class$java$lang$String, new DataCellEditor(new JTextField()));
            this.table.getColumn("type").setCellEditor(new DefaultCellEditor(combo));
            this.table.getColumn("size").setCellEditor(new DataCellEditor(new ValidableTextField(new TextFieldValidator.integer())));
            this.table.getColumn("scale").setCellEditor(new DataCellEditor(new ValidableTextField(new TextFieldValidator.integer())));
            constr.fill = 2;
            constr.anchor = 11;
            constr.weightx = 0.0;
            constr.weighty = 0.0;
            constr.gridx = 4;
            constr.gridy = 1;
            constr.insets = new Insets(2, 8, 2, 2);
            JPanel btnpane = new JPanel();
            GridLayout btnlay = new GridLayout(2, 1, 0, 5);
            btnpane.setLayout(btnlay);
            layout.setConstraints(btnpane, constr);
            pane.add(btnpane);
            this.addbtn = new JButton(bundle.getString("CreateTableAddButtonTitle"));
            this.addbtn.setMnemonic(bundle.getString("CreateTableAddButtonTitle_Mnemonic").charAt(0));
            this.addbtn.setToolTipText(bundle.getString("ACS_CreateTableAddButtonTitleA11yDesc"));
            btnpane.add(this.addbtn);
            this.addbtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DataModel model = (DataModel)CreateTableDialog.this.table.getModel();
                    ColumnItem item = new ColumnItem();
                    item.setProperty("type", CreateTableDialog.this.ttab.elementAt(0));
                    model.addRow(item);
                }
            });
            this.delbtn = new JButton(bundle.getString("CreateTableRemoveButtonTitle"));
            this.delbtn.setMnemonic(bundle.getString("CreateTableRemoveButtonTitle_Mnemonic").charAt(0));
            this.delbtn.setToolTipText(bundle.getString("ACS_CreateTableRemoveButtonTitleA11yDesc"));
            btnpane.add(this.delbtn);
            this.delbtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    int idx = CreateTableDialog.this.table.getSelectedRow();
                    if (idx != -1) {
                        ((DataModel)CreateTableDialog.this.table.getModel()).removeRow(idx);
                    }
                }
            });
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (event.getSource() == NotifyDescriptor.OK_OPTION) {
                        CreateTableDialog.this.result = CreateTableDialog.this.validate();
                        CommandBuffer cbuff = new CommandBuffer();
                        Vector<CreateIndex> idxCommands = new Vector<CreateIndex>();
                        if (CreateTableDialog.this.result) {
                            try {
                                String tablename = CreateTableDialog.this.getTableName();
                                DataModel dataModel = (DataModel)CreateTableDialog.this.table.getModel();
                                Vector data = dataModel.getData();
                                Vector icols = new Vector();
                                CreateTable cmd = CreateTableDialog.this.spec.createCommandCreateTable(tablename);
                                cmd.setObjectOwner((String)CreateTableDialog.this.ownercombo.getSelectedItem());
                                org.netbeans.lib.ddl.impl.TableColumn cmdcol = null;
                                CreateIndex xcmd = null;
                                Enumeration enu = data.elements();
                                while (enu.hasMoreElements()) {
                                    ColumnItem enuele = (ColumnItem)enu.nextElement();
                                    String name = enuele.getName();
                                    cmdcol = enuele.isPrimaryKey() && !dataModel.isTablePrimaryKey() ? cmd.createPrimaryKeyColumn(name) : (enuele.isUnique() && !enuele.isPrimaryKey() ? cmd.createUniqueColumn(name) : cmd.createColumn(name));
                                    cmdcol.setColumnType(Specification.getType(enuele.getType().getType()));
                                    cmdcol.setColumnSize(enuele.getSize());
                                    cmdcol.setDecimalSize(enuele.getScale());
                                    cmdcol.setNullAllowed(enuele.allowsNull());
                                    String defval = enuele.getDefaultValue();
                                    if (defval != null && defval.length() > 0) {
                                        cmdcol.setDefaultValue(defval);
                                    }
                                    if (enuele.hasCheckConstraint()) {
                                        cmd.createCheckConstraint(name, enuele.getCheckConstraint());
                                    }
                                    if (!enuele.isIndexed() || enuele.isPrimaryKey() || enuele.isUnique()) continue;
                                    xcmd = CreateTableDialog.this.spec.createCommandCreateIndex(tablename);
                                    xcmd.setIndexName(tablename + "_" + name + "_idx");
                                    xcmd.setIndexType(new String());
                                    xcmd.setObjectOwner((String)CreateTableDialog.this.ownercombo.getSelectedItem());
                                    xcmd.specifyColumn(name);
                                    idxCommands.add(xcmd);
                                }
                                if (dataModel.isTablePrimaryKey()) {
                                    cmdcol = cmd.createPrimaryKeyConstraint(tablename);
                                    cmdcol.setTableConstraintColumns(dataModel.getTablePrimaryKeys());
                                    cmdcol.setColumnType(0);
                                    cmdcol.setColumnSize(0);
                                    cmdcol.setDecimalSize(0);
                                    cmdcol.setNullAllowed(true);
                                }
                                cbuff.add(cmd);
                                int i = 0;
                                while (i < idxCommands.size()) {
                                    cbuff.add((CreateIndex)idxCommands.elementAt(i));
                                    ++i;
                                }
                                cbuff.execute();
                                if (!cbuff.wasException()) {
                                    ((Component)CreateTableDialog.this.dialog).setVisible(false);
                                    CreateTableDialog.this.dialog.dispose();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            String msg = bundle.getString("EXC_InsufficientCreateTableInfo");
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
                        }
                    }
                }
            };
            pane.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_CreateTableDialogA11yDesc"));
            this.addbtn.doClick();
            DialogDescriptor descriptor = new DialogDescriptor((Object)pane, bundle.getString("CreateTableDialogTitle"), true, listener);
            Object[] closingOptions = new Object[]{NotifyDescriptor.CANCEL_OPTION};
            descriptor.setClosingOptions(closingOptions);
            this.dialog = DialogDisplayer.getDefault().createDialog(descriptor);
            this.dialog.setResizable(true);
        }
        catch (MissingResourceException ex) {
            ex.printStackTrace();
        }
    }

    public boolean run() {
        if (this.dialog != null) {
            ((Component)this.dialog).setVisible(true);
        }
        return this.result;
    }

    public String getTableName() {
        return this.dbnamefield.getText();
    }

    private boolean validate() {
        String tname = this.getTableName();
        if (tname == null || tname.length() < 1) {
            return false;
        }
        Vector cols = ((DataModel)this.table.getModel()).getData();
        Enumeration colse = cols.elements();
        while (colse.hasMoreElements()) {
            if (((ColumnItem)colse.nextElement()).validate()) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DataCellEditor
    extends DefaultCellEditor {
        static final long serialVersionUID = 3855371868128838794L;

        public DataCellEditor(JTextField x) {
            super(x);
            this.setClickCountToStart(1);
            x.addFocusListener(new FocusListener(this, x){
                private final /* synthetic */ JTextField val$x;
                private final /* synthetic */ DataCellEditor this$1;
                {
                    this.this$1 = this$1;
                    this.val$x = val$x;
                }

                public void focusGained(FocusEvent e) {
                    SwingUtilities.invokeLater(DataCellEditor.access$300(this.this$1).new FocusInvoker(this.val$x));
                }

                public void focusLost(FocusEvent e) {
                    DataCellEditor.access$300((DataCellEditor)this.this$1).table.setValueAt(this.val$x.getText(), DataCellEditor.access$300((DataCellEditor)this.this$1).table.getEditingRow(), DataCellEditor.access$300((DataCellEditor)this.this$1).table.getEditingColumn());
                }
            });
        }

        static /* synthetic */ CreateTableDialog access$300(DataCellEditor x0) {
            return x0.CreateTableDialog.this;
        }
    }

    class FocusInvoker
    implements Runnable {
        private JTextField xxx;

        public FocusInvoker(JTextField fld) {
            this.xxx = fld;
        }

        public void run() {
            this.xxx.selectAll();
        }
    }

    class DataTable
    extends JTable {
        static final long serialVersionUID = 1222037401669064863L;

        public DataTable(TableModel model) {
            super(model);
            TableColumnModel cmodel = this.getColumnModel();
            int ccount = model.getColumnCount();
            int i = 0;
            while (i < ccount) {
                TableColumn col = cmodel.getColumn(i);
                Map cmap = ColumnItem.getColumnProperty(i);
                col.setIdentifier((String)cmap.get("name"));
                if (cmap.containsKey("width")) {
                    col.setPreferredWidth((Integer)cmap.get("width"));
                }
                if (cmap.containsKey("minwidth")) {
                    col.setMinWidth((Integer)cmap.get("minwidth"));
                }
                ++i;
            }
        }
    }
}

